/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.recovery;

import java.io.File;
import java.io.FilenameFilter;
import java.io.RandomAccessFile;
import org.apache.ignite.Ignite;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.WALMode;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.internal.processors.cache.database.GridSnapshotEx;
import org.gridgain.grid.internal.processors.cache.database.recovery.GridPointInTimeRecoveryAbstractTest;
import org.gridgain.grid.internal.processors.cache.database.recovery.GridPointInTimeRecoveryLocalTest;
import org.junit.Test;

public class GridPointInTimeRecoveryLocalCompactionTest
extends GridPointInTimeRecoveryLocalTest {
    @Override
    protected IgniteConfiguration getConfiguration(String name) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(name);
        cfg.getDataStorageConfiguration().setWalCompactionEnabled(true).setWalSegmentSize(524288).setWalMode(WALMode.LOG_ONLY);
        return cfg;
    }

    @Test
    public void testRecoveryShouldFailIfCompressedWalIsBroken() throws Exception {
        File[] compressedSegments;
        int nodes = 2;
        this.startGrids(nodes);
        IgniteEx igClient = this.startClient(nodes);
        igClient.cluster().active(true);
        GridPointInTimeRecoveryAbstractTest.TestContext test = new GridPointInTimeRecoveryAbstractTest.TestContext((Ignite)igClient, "default");
        test.loadByTime(10000L);
        GridPointInTimeRecoveryAbstractTest.RecoveryPoint pnt = test.savePoint();
        test.removeByTime(1000L);
        GridGain gg = (GridGain)igClient.plugin("GridGain");
        GridSnapshotEx snp = (GridSnapshotEx)gg.snapshot();
        snp.createFullSnapshot(null, null).get();
        test.loadByTime(3000L);
        Thread.sleep(3000L);
        String nodeFolderName = this.ignite(0).context().pdsFolderResolver().resolveFolders().folderName();
        File storePath = U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)this.storePath(), (boolean)false);
        File archiveDir = new File(storePath, "archive");
        File nodeArchiveDir = new File(archiveDir, nodeFolderName);
        for (File f : compressedSegments = nodeArchiveDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".zip");
            }
        })) {
            try (RandomAccessFile raf = new RandomAccessFile(f, "rw");){
                for (int i = 0; i < 100; ++i) {
                    if (raf.length() <= (long)(i * 3)) continue;
                    raf.seek(i * 3);
                    int old = raf.read();
                    raf.seek(i * 3);
                    raf.write(old + 1);
                }
            }
        }
        try {
            snp.recoveryTo(pnt.time, pnt.msg).get();
            GridPointInTimeRecoveryLocalCompactionTest.fail();
        }
        catch (Exception e) {
            log.warning("Expected exception caught", (Throwable)e);
        }
    }
}

