/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.recovery;

import java.io.Serializable;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.configuration.distributed.DistributedChangeableProperty;
import org.apache.ignite.testframework.ListeningTestLogger;
import org.apache.ignite.testframework.LogListener;
import org.apache.ignite.testframework.junits.WithSystemProperty;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.internal.processors.cache.database.recovery.GridPointInTimeRecoveryAbstractTest;
import org.junit.Test;

public class GridPointInTimeRecoveryIsCompatibleWithExchangelessSnapshotsTest
extends GridPointInTimeRecoveryAbstractTest {
    private final LogListener lsnrMessageOnStart = LogListener.matches((String)"Creating exchangeless snapshots is disabled, will switch to legacy snapshots creation mode.").build();
    private final LogListener lsnrMessageOnTurnOff = LogListener.matches((String)"Creating exchangeless snapshots is enabled.").build();
    private final LogListener lsnrMessageOnSnapshotCreate = LogListener.matches((String)"Creating snapshot with exchange, because point-in-time recovery is enabled.").build();
    private final IgniteLogger testLog = new ListeningTestLogger(log, new LogListener[]{this.lsnrMessageOnStart, this.lsnrMessageOnTurnOff, this.lsnrMessageOnSnapshotCreate});

    @Override
    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        return super.getConfiguration(igniteInstanceName).setGridLogger(this.testLog);
    }

    @Override
    protected CacheConfiguration[] prepareCachesConfiguration() {
        return new CacheConfiguration[]{new CacheConfiguration("default").setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 10))};
    }

    @Test
    @WithSystemProperty(key="GG_EXCHANGELESS_POINT_IN_TIME_RECOVERY", value="false")
    public void test() throws Exception {
        IgniteEx ignite = this.startGrids(1);
        ignite.cluster().state(ClusterState.ACTIVE);
        GridPointInTimeRecoveryIsCompatibleWithExchangelessSnapshotsTest.assertTrue((boolean)this.lsnrMessageOnStart.check());
        try (IgniteDataStreamer streamer = ignite.dataStreamer("default");){
            for (int i = 0; i < 100; ++i) {
                streamer.addData((Object)i, (Object)i);
            }
        }
        this.createSnapshot(ignite, false);
        DistributedChangeableProperty prop = ignite.context().distributedConfiguration().property("pointInTimeRecoveryEnabled");
        prop.propagate((Serializable)Boolean.valueOf(false));
        GridPointInTimeRecoveryIsCompatibleWithExchangelessSnapshotsTest.assertTrue((boolean)this.lsnrMessageOnTurnOff.check());
        this.createSnapshot(ignite, true);
    }

    private void createSnapshot(IgniteEx ignite, boolean shouldBeExchangeless) {
        this.lsnrMessageOnSnapshotCreate.reset();
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        int beforeCreateVer = ignite.context().discovery().topologyVersionEx().minorTopologyVersion();
        gg.snapshot().createFullSnapshot(null, null).get();
        int afterCreateVer = ignite.context().discovery().topologyVersionEx().minorTopologyVersion();
        if (!shouldBeExchangeless) {
            GridPointInTimeRecoveryIsCompatibleWithExchangelessSnapshotsTest.assertTrue((boolean)this.lsnrMessageOnSnapshotCreate.check());
        }
        GridPointInTimeRecoveryIsCompatibleWithExchangelessSnapshotsTest.assertEquals((int)(beforeCreateVer + (shouldBeExchangeless ? 0 : 1)), (int)afterCreateVer);
    }
}

