/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.recovery;

import java.io.Serializable;
import org.apache.ignite.Ignite;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.metastorage.DistributedMetaStorage;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.internal.processors.cache.database.GridSnapshotEx;
import org.gridgain.grid.internal.processors.cache.database.recovery.GridPointInTimeRecoveryAbstractTest;
import org.junit.Test;

public class GridPointInTimeRecoveryDistributedMetastorageTest
extends GridPointInTimeRecoveryAbstractTest {
    @Override
    protected CacheConfiguration[] prepareCachesConfiguration() {
        CacheConfiguration ccfg = new CacheConfiguration("default");
        ccfg.setCacheMode(CacheMode.PARTITIONED);
        ccfg.setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL);
        ccfg.setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 8));
        ccfg.setBackups(3);
        return new CacheConfiguration[]{ccfg};
    }

    @Test
    public void testSimpleMetastorageReadsAfterPointInTimeRecovery() throws Exception {
        String beforeKey = "beforeKey";
        String inTheMiddleKey = "middleKey";
        String afterKey = "afterKey";
        String beforeKeyVal0 = "val0";
        String beforeKeyVal1 = "val1";
        String middleKeyVal0 = "val2";
        String afterKeyVal0 = "val3";
        IgniteEx ig = this.startGrids(2);
        ig.cluster().active(true);
        DistributedMetaStorage dms = ig.context().distributedMetastorage();
        dms.write(beforeKey, (Serializable)((Object)beforeKeyVal0));
        GridPointInTimeRecoveryAbstractTest.TestContext tCtx = new GridPointInTimeRecoveryAbstractTest.TestContext((Ignite)ig, "default");
        tCtx.loadByTime(1000L);
        GridPointInTimeRecoveryAbstractTest.RecoveryPoint pnt = tCtx.savePoint();
        dms.write(inTheMiddleKey, (Serializable)((Object)middleKeyVal0));
        tCtx.loadByTime(1000L);
        dms.write(afterKey, (Serializable)((Object)afterKeyVal0));
        dms.write(beforeKey, (Serializable)((Object)beforeKeyVal1));
        GridGain gg = (GridGain)ig.plugin("GridGain");
        GridSnapshotEx snap = (GridSnapshotEx)gg.snapshot();
        snap.recoveryTo(pnt.time, pnt.msg).get();
        dms = ig.context().distributedMetastorage();
        GridPointInTimeRecoveryDistributedMetastorageTest.assertEquals((String)beforeKeyVal1, (String)((String)((Object)dms.read(beforeKey))));
        GridPointInTimeRecoveryDistributedMetastorageTest.assertEquals((String)middleKeyVal0, (String)((String)((Object)dms.read(inTheMiddleKey))));
        GridPointInTimeRecoveryDistributedMetastorageTest.assertEquals((String)afterKeyVal0, (String)((String)((Object)dms.read(afterKey))));
    }
}

