/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.recovery;

import java.util.Arrays;
import java.util.concurrent.Callable;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.cluster.IgniteClusterEx;
import org.apache.ignite.testframework.GridTestSafeThreadFactory;
import org.apache.ignite.testframework.GridTestUtils;
import org.gridgain.grid.internal.processors.cache.database.recovery.GridPointInTimeRecoveryAbstractTest;
import org.junit.Test;

public class GridPointInTimeRecoveryDestroyCacheDuringSnapshotTest
extends GridPointInTimeRecoveryAbstractTest {
    protected CacheConfiguration<?, ?>[] prepareCachesConfiguration() {
        CacheConfiguration ccfg = new CacheConfiguration("default");
        ccfg.setCacheMode(CacheMode.PARTITIONED);
        ccfg.setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL);
        ccfg.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        ccfg.setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 32));
        ccfg.setBackups(3);
        return new CacheConfiguration[]{ccfg};
    }

    protected long getTestTimeout() {
        return 60000L;
    }

    @Test
    public void testDestroyCacheDuringSnapshot() throws Exception {
        int nodes = 3;
        this.startGrids(3);
        IgniteClusterEx cluster = this.grid(0).cluster();
        cluster.active(true);
        this.startGrid(3);
        IgniteCache cache = this.grid(0).cache("default");
        try (IgniteDataStreamer ds = this.grid(0).dataStreamer("default");){
            for (int i = 0; i < 10240; ++i) {
                ds.addData((Object)i, (Object)i);
            }
        }
        Callable<Object> setBlt = () -> {
            try {
                cluster.setBaselineTopology(cluster.topologyVersion());
            }
            catch (IgniteException e) {
                GridPointInTimeRecoveryDestroyCacheDuringSnapshotTest.assertTrue((String)e.getMessage(), (boolean)e.getMessage().contains("Snapshot operation has been cancelled"));
            }
            return null;
        };
        Callable<Object> destroyCache = () -> {
            GridPointInTimeRecoveryDestroyCacheDuringSnapshotTest.doSleep((long)100L);
            while (this.grid(1).context().state().clusterState().transition()) {
                GridPointInTimeRecoveryDestroyCacheDuringSnapshotTest.doSleep((long)1L);
            }
            cache.destroy();
            return null;
        };
        GridTestSafeThreadFactory threadFactory = new GridTestSafeThreadFactory(((Object)((Object)this)).getClass().getName(), false);
        GridTestUtils.runMultiThreaded(Arrays.asList(setBlt, destroyCache), (GridTestSafeThreadFactory)threadFactory);
    }
}

