/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.recovery;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.internal.processors.cache.database.GridSnapshotEx;
import org.gridgain.grid.internal.processors.cache.database.recovery.GridPointInTimeRecoveryAbstractTest;
import org.junit.Test;

public class GridPointInTimeRecoveryAtomicTest
extends GridPointInTimeRecoveryAbstractTest {
    @Override
    protected CacheConfiguration[] prepareCachesConfiguration() {
        CacheConfiguration ccfg = new CacheConfiguration("default");
        ccfg.setCacheMode(CacheMode.PARTITIONED);
        ccfg.setAtomicityMode(CacheAtomicityMode.ATOMIC);
        ccfg.setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 32));
        ccfg.setBackups(3);
        return new CacheConfiguration[]{ccfg};
    }

    @Test
    public void test() throws Exception {
        IgniteEx ig = this.startGrids(4);
        ig.cluster().active(true);
        GridGain gg = (GridGain)ig.plugin("GridGain");
        long initVal = 100L;
        long keys = 1000L;
        long total = initVal * keys;
        try (IgniteDataStreamer st = ig.dataStreamer("default");){
            st.allowOverwrite(true);
            for (long i = 0L; i < keys; ++i) {
                st.addData((Object)i, (Object)initVal);
            }
        }
        gg.snapshot().createFullSnapshot(null, null).get();
        IgniteCache cache = ig.cache("default");
        boolean plusNext = true;
        HashSet<Long> slicePoint = new HashSet<Long>(4);
        ArrayList<T2> points = new ArrayList<T2>(4);
        for (int i = 0; i < 4; ++i) {
            slicePoint.add(keys / 5L * (long)(i + 1));
        }
        for (long i = 0L; i < keys; ++i) {
            Long val = (Long)cache.get((Object)i);
            Long nextVal = val + 50L;
            cache.put((Object)i, (Object)nextVal);
            if (!slicePoint.contains(i)) continue;
            U.sleep((long)500L);
            points.add(new T2((Object)U.currentTimeMillis(), (Object)i));
            U.sleep((long)500L);
        }
        Collections.reverse(points);
        GridSnapshotEx rec = (GridSnapshotEx)gg.snapshot();
        for (T2 tup : points) {
            long time = (Long)tup.get1();
            System.err.println(">>> recovery to " + time);
            rec.recoveryTo(time, null).get();
            long sum = 0L;
            for (long i = 0L; i < keys; ++i) {
                Long val = (Long)cache.get((Object)i);
                sum += val.longValue();
            }
            long totalExp = total + (Long)tup.get2() * 50L;
            GridPointInTimeRecoveryAtomicTest.assertTrue((String)("Exp: " + totalExp + " Actl:" + sum), (Math.abs(totalExp - sum) <= 200L ? 1 : 0) != 0);
        }
    }
}

