/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database;

import java.nio.charset.Charset;
import java.security.SignatureException;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.gridgain.grid.persistentstore.SnapshotRegistryTransformer;

public class TestSnapshotRegistryTransformer
implements SnapshotRegistryTransformer {
    private static final String HMAC_ID = "HmacSHA512";
    private static final String errorText = "Authenticity verification failure";
    private final byte[] pwd;

    public TestSnapshotRegistryTransformer(String pwd) {
        this.pwd = pwd.getBytes(Charset.forName("UTF-8"));
    }

    public byte[] transform(byte[] data) throws Exception {
        if (data == null || data.length == 0) {
            return new byte[0];
        }
        Mac hmac = Mac.getInstance(HMAC_ID);
        SecretKeySpec keySpec = new SecretKeySpec(this.pwd, HMAC_ID);
        hmac.init(keySpec);
        return hmac.doFinal(data);
    }

    public void verify(byte[] data, byte[] verificationData) throws Exception {
        if (verificationData == null || verificationData.length == 0) {
            throw new SignatureException(errorText);
        }
        byte[] computed = this.transform(data);
        if (!Arrays.equals(computed, verificationData)) {
            throw new SignatureException(errorText);
        }
    }
}

