/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.persistence.partstate.GroupPartitionId;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.marshaller.jdk.JdkMarshaller;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.SystemPropertiesList;
import org.apache.ignite.testframework.junits.WithSystemProperty;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.internal.processors.cache.database.AbstractSnapshotTest;
import org.gridgain.grid.internal.processors.cache.database.GridSnapshotEx;
import org.gridgain.grid.internal.processors.cache.database.TestSnapshotRegistryTransformer;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CompressionOption;
import org.gridgain.grid.internal.processors.cache.database.snapshot.DatabaseSnapshotSpi;
import org.gridgain.grid.internal.processors.cache.database.snapshot.FutureTaskQueue;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridCacheSnapshotManager;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotDigestRegistry;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotEncryptionOptions;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotOperationContext;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotSession;
import org.gridgain.grid.internal.processors.cache.database.snapshot.VerifiableSnapshotDigestRegistry;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.FsSnapshotPath;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.SnapshotPath;
import org.gridgain.grid.persistentstore.MessageDigestFactory;
import org.gridgain.grid.persistentstore.SnapshotChainMode;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.gridgain.grid.persistentstore.SnapshotIssue;
import org.gridgain.grid.persistentstore.SnapshotRegistryTransformer;
import org.gridgain.grid.persistentstore.SnapshotSecurityLevel;
import org.gridgain.grid.persistentstore.SnapshotUpdateOperationParams;
import org.gridgain.grid.persistentstore.snapshot.file.FileDatabaseSnapshotSpi;
import org.gridgain.grid.persistentstore.snapshot.file.FileSnapshot;
import org.gridgain.grid.persistentstore.snapshot.file.FileSnapshotSession;
import org.gridgain.grid.persistentstore.snapshot.file.SnapshotOutputStreamFactory;
import org.jetbrains.annotations.Nullable;
import org.junit.Test;
import org.mockito.ArgumentMatcher;
import org.mockito.Matchers;
import org.mockito.Mockito;

@SystemPropertiesList(value={@WithSystemProperty(key="GG_SNAPSHOT_SECURITY_FEATURE", value="true"), @WithSystemProperty(key="IGNITE_DISTRIBUTED_META_STORAGE_FEATURE", value="true")})
public abstract class SnapshotSecurityLevelAbstractTest
extends AbstractSnapshotTest {
    public abstract SnapshotSecurityLevel getSnapshotSecurityLevel();

    @Override
    protected SnapshotRegistryTransformer getRegistryTransformer() {
        return new ErrorTransformer();
    }

    protected void beforeTestsStarted() throws Exception {
        this.stopAllGrids();
        this.cleanSnapshotDirs();
    }

    @Override
    protected void afterTest() throws Exception {
        this.stopAllGrids();
        this.cleanSnapshotDirs();
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        File f = Paths.get(U.defaultWorkDirectory(), "db").toFile();
        if (f.exists()) {
            System.out.println("FILE_EXISTS " + f.toPath().toString());
        }
    }

    @Test
    public void testCreateSnapshotErrorRunningTransformer() throws Exception {
        this.startGrids(2);
        IgniteEx client = this.startGrid("client");
        client.cluster().active(true);
        this.changeSecurityLevel(client, this.getSnapshotSecurityLevel());
        this.setErrorOnTransformer(this.grid(1), true);
        this.load((Ignite)this.grid(0));
        GridSnapshotEx db = this.getSnapshot(this.grid("client"));
        SnapshotFuture fut = db.createFullSnapshot(null, null);
        if (this.getSnapshotSecurityLevel() == SnapshotSecurityLevel.DISABLED) {
            fut.get(this.getTestTimeout(), TimeUnit.MILLISECONDS);
        } else {
            GridTestUtils.assertThrows((IgniteLogger)log, () -> (Void)fut.get(this.getTestTimeout(), TimeUnit.MILLISECONDS), IgniteException.class, (String)"Error computing verification code for snapshot digest registry, transformer failed.");
        }
    }

    @Test
    public void testCreateSnapshotErrorSavingRegistry() throws Exception {
        this.startGrid(0);
        GridCacheSnapshotManager.TEST_SNAPSHOT_SPI.set(new AbstractSnapshotTest.RestorePauseSnapshotSpiWrapper((DatabaseSnapshotSpi)new RegistryFailingSnapshotSpi()));
        this.startGrid(1);
        IgniteEx client = this.startGrid("client");
        client.cluster().active(true);
        this.changeSecurityLevel(client, this.getSnapshotSecurityLevel());
        this.load((Ignite)this.grid(0));
        GridSnapshotEx db = this.getSnapshot(this.grid("client"));
        SnapshotFuture fut = db.createFullSnapshot(null, null);
        if (this.getSnapshotSecurityLevel() == SnapshotSecurityLevel.DISABLED) {
            fut.get(this.getTestTimeout(), TimeUnit.MILLISECONDS);
        } else {
            GridTestUtils.assertThrows((IgniteLogger)log, () -> (Void)fut.get(this.getTestTimeout(), TimeUnit.MILLISECONDS), IgniteException.class, (String)"Error writing snapshot file registry.");
        }
    }

    @Test
    public void testRestoreLocalChainMissingRegistry() throws Exception {
        this.doRestoreLocalChain(id -> {
            new DeletingRegistryVisitor().visit((long)id, this.grid(0).localNode(), this.grid(1).localNode());
            return this.getSnapshotSecurityLevel().compareTo((Enum)SnapshotSecurityLevel.REQUIRE) < 0;
        }, IgniteException.class, "Snapshot digest registry is missing.");
    }

    @Test
    public void testRestoreLocalChainCorruptedRegistry() throws Exception {
        this.doRestoreLocalChain(id -> {
            new CorruptingRegistryVisitor().visit((long)id, this.grid(0).localNode());
            return this.getSnapshotSecurityLevel().compareTo((Enum)SnapshotSecurityLevel.IGNORE_MISSING) < 0;
        }, IgniteException.class, "Snapshot digest registry is corrupted.");
    }

    @Test
    public void testRestoreLocalChainRegistryVerifyFail() throws Exception {
        this.doRestoreLocalChain(id -> {
            this.setErrorOnTransformer(this.grid(1), true);
            return this.getSnapshotSecurityLevel().compareTo((Enum)SnapshotSecurityLevel.IGNORE_MISSING) < 0;
        }, IgniteException.class, "Snapshot digest registry authentication failure.");
    }

    @Test
    public void testRestoreMovedMissingRegistry() throws Exception {
        this.doRestoreMoved(path -> {
            new DeletingRegistryVisitor().visit((Path)path);
            return this.getSnapshotSecurityLevel().compareTo((Enum)SnapshotSecurityLevel.REQUIRE) < 0;
        }, IgniteException.class, "Snapshot digest registry is missing.");
    }

    @Test
    public void testRestoreMovedCorruptRegistry() throws Exception {
        this.doRestoreMoved(path -> {
            new CorruptingRegistryVisitor().visit((Path)path);
            return this.getSnapshotSecurityLevel().compareTo((Enum)SnapshotSecurityLevel.IGNORE_MISSING) < 0;
        }, IgniteException.class, "Snapshot digest registry is corrupted.");
    }

    @Test
    public void testRestoreMovedRegistryVerifyFail() throws Exception {
        this.doRestoreMoved(path -> {
            this.setErrorOnTransformer(this.grid(1), true);
            return this.getSnapshotSecurityLevel().compareTo((Enum)SnapshotSecurityLevel.IGNORE_MISSING) < 0;
        }, IgniteException.class, "Snapshot digest registry authentication failure.");
    }

    @Test
    public void testCheckLocalMissingRegistry() throws Exception {
        this.doCheckLocal(id -> {
            new DeletingRegistryVisitor().visit((long)id, this.grid(0).localNode());
            return this.getSnapshotSecurityLevel().compareTo((Enum)SnapshotSecurityLevel.REQUIRE) < 0;
        }, "Snapshot digest registry is missing.");
    }

    @Test
    public void testCheckLocalCorruptRegistry() throws Exception {
        this.doCheckLocal(id -> {
            new CorruptingRegistryVisitor().visit((long)id, this.grid(0).localNode());
            return this.getSnapshotSecurityLevel().compareTo((Enum)SnapshotSecurityLevel.IGNORE_MISSING) < 0;
        }, "Snapshot digest registry is corrupted.");
    }

    @Test
    public void testCheckLocalRegistryVerifyFail() throws Exception {
        this.doCheckLocal(id -> {
            this.setErrorOnTransformer(this.grid(1), true);
            return this.getSnapshotSecurityLevel().compareTo((Enum)SnapshotSecurityLevel.IGNORE_MISSING) < 0;
        }, "Snapshot digest registry authentication failure.");
    }

    @Test
    public void testRestoreLocalChainIncompatibleOuterRegistryVersion() throws Exception {
        this.doTestRestoreLocalChainIncompatibleRegistryVersion(true);
    }

    @Test
    public void testRestoreMovedIncompatibleOuterRegistryVersion() throws Exception {
        this.doTestRestoreMovedIncompatibleRegistryVersion(true);
    }

    @Test
    public void testCheckLocalIncompatibleOuterRegistryVersion() throws Exception {
        this.doTestCheckLocalIncompatibleRegistryVersion(true);
    }

    @Test
    public void testRestoreLocalChainIncompatibleInnerRegistryVersion() throws Exception {
        this.doTestRestoreLocalChainIncompatibleRegistryVersion(false);
    }

    @Test
    public void testRestoreMovedIncompatibleInnerRegistryVersion() throws Exception {
        this.doTestRestoreMovedIncompatibleRegistryVersion(false);
    }

    @Test
    public void testCheckLocalIncompatibleInnerRegistryVersion() throws Exception {
        this.doTestCheckLocalIncompatibleRegistryVersion(false);
    }

    @Test
    public void testSinglePartitionCopy() throws Exception {
        long snapshotId = this.createSnapshot();
        File moveDir = this.createOrCleanMoveDir();
        new DeletingRegistryVisitor().visit(snapshotId, this.grid(1).localNode());
        new CorruptingRegistryVisitor().visit(snapshotId, this.grid(0).localNode());
        GridSnapshotEx db = this.getSnapshot(this.grid("client"));
        SnapshotFuture copyFut = db.copySnapshot(snapshotId, moveDir, false, new SnapshotUpdateOperationParams.Builder().withChainMode(SnapshotChainMode.DEFAULT).withSingleFileCopy(Boolean.valueOf(true)).withDeleteSources(Boolean.valueOf(true)).build(), null);
        copyFut.get(this.getTestTimeout(), TimeUnit.MILLISECONDS);
    }

    @Test
    public void testFullCopy() throws Exception {
        long snapshotId = this.createSnapshot();
        File moveDir = this.createOrCleanMoveDir();
        new DeletingRegistryVisitor().visit(snapshotId, this.grid(1).localNode());
        new CorruptingRegistryVisitor().visit(snapshotId, this.grid(0).localNode());
        GridSnapshotEx db = this.getSnapshot(this.grid("client"));
        SnapshotFuture copyFut = db.copySnapshot(snapshotId, moveDir, false, new SnapshotUpdateOperationParams.Builder().withChainMode(SnapshotChainMode.DEFAULT).withDeleteSources(Boolean.valueOf(true)).build(), null);
        copyFut.get(this.getTestTimeout(), TimeUnit.MILLISECONDS);
    }

    @Test
    public void testChainCopy() throws Exception {
        long snapshotId = this.createIncrementalSnapshot();
        File moveDir = this.createOrCleanMoveDir();
        new DeletingRegistryVisitor().visit(snapshotId, this.grid(1).localNode());
        new CorruptingRegistryVisitor().visit(snapshotId, this.grid(0).localNode());
        GridSnapshotEx db = this.getSnapshot(this.grid("client"));
        SnapshotFuture copyFut = db.copySnapshot(snapshotId, moveDir, false, new SnapshotUpdateOperationParams.Builder().withChainMode(SnapshotChainMode.FROM_CURRENT_TO_LAST).withDeleteSources(Boolean.valueOf(true)).build(), null);
        copyFut.get(this.getTestTimeout(), TimeUnit.MILLISECONDS);
    }

    @Test
    public void testDeleteFullSnapshot() throws Exception {
        long snapshotId = this.createSnapshot();
        GridSnapshotEx db = this.getSnapshot(this.grid("client"));
        new DeletingRegistryVisitor().visit(snapshotId, this.grid(1).localNode());
        new CorruptingRegistryVisitor().visit(snapshotId, this.grid(0).localNode());
        SnapshotFuture delFut = db.deleteSnapshot(snapshotId, (SnapshotUpdateOperationParams)null, null);
        delFut.get(this.getTestTimeout(), TimeUnit.MILLISECONDS);
    }

    @Test
    public void testDeleteChainSnapshot() throws Exception {
        long snapshotId = this.createIncrementalSnapshot();
        GridSnapshotEx db = this.getSnapshot(this.grid("client"));
        new DeletingRegistryVisitor().visit(snapshotId, this.grid(1).localNode());
        new CorruptingRegistryVisitor().visit(snapshotId, this.grid(0).localNode());
        SnapshotFuture delFut = db.deleteSnapshot(snapshotId, new SnapshotUpdateOperationParams(SnapshotChainMode.FROM_CURRENT_TO_LAST), null);
        delFut.get(this.getTestTimeout(), TimeUnit.MILLISECONDS);
    }

    private void doTestRestoreLocalChainIncompatibleRegistryVersion(boolean outer) throws Exception {
        this.doRestoreLocalChain(id -> {
            new IncompatibleVersionOfRegistryVisitor(outer).visit((long)id, this.grid(0).localNode());
            return this.getSnapshotSecurityLevel().compareTo((Enum)SnapshotSecurityLevel.IGNORE_MISSING) < 0;
        }, IgniteException.class, "Incompatible version of snapshot digest registry.");
    }

    private void doTestRestoreMovedIncompatibleRegistryVersion(boolean outer) throws Exception {
        this.doRestoreMoved(path -> {
            new IncompatibleVersionOfRegistryVisitor(outer).visit((Path)path);
            return this.getSnapshotSecurityLevel().compareTo((Enum)SnapshotSecurityLevel.IGNORE_MISSING) < 0;
        }, IgniteException.class, "Incompatible version of snapshot digest registry.");
    }

    private void doTestCheckLocalIncompatibleRegistryVersion(boolean outer) throws Exception {
        this.doCheckLocal(id -> {
            new IncompatibleVersionOfRegistryVisitor(outer).visit((long)id, this.grid(0).localNode());
            return this.getSnapshotSecurityLevel().compareTo((Enum)SnapshotSecurityLevel.IGNORE_MISSING) < 0;
        }, "Incompatible version of snapshot digest registry.");
    }

    protected void doRestoreLocalChain(Predicate<Long> pred, Class<? extends Throwable> cls, String error) throws Exception {
        long snapshotId = this.createIncrementalSnapshot();
        boolean success = pred.test(snapshotId);
        GridSnapshotEx db = this.getSnapshot(this.grid("client"));
        SnapshotFuture restoreFut = db.restoreSnapshot(snapshotId, null, null);
        if (success) {
            restoreFut.get(this.getTestTimeout(), TimeUnit.MILLISECONDS);
        } else {
            GridTestUtils.assertThrows((IgniteLogger)log, () -> (Void)restoreFut.get(this.getTestTimeout(), TimeUnit.MILLISECONDS), cls, (String)error);
        }
    }

    protected void doRestoreMoved(Predicate<Path> pred, Class<? extends Throwable> cls, String error) throws Exception {
        long snapshotId = this.createSnapshot();
        GridSnapshotEx db = this.getSnapshot(this.grid("client"));
        File moveDir = this.createOrCleanMoveDir();
        SnapshotFuture copyFut = db.moveSnapshot(snapshotId, moveDir, false, new SnapshotUpdateOperationParams.Builder().withChainMode(SnapshotChainMode.DEFAULT).withDeleteSources(Boolean.valueOf(true)).build(), null);
        copyFut.get(this.getTestTimeout(), TimeUnit.MILLISECONDS);
        boolean success = pred.test(moveDir.toPath());
        SnapshotFuture restoreFut = db.restoreSnapshot(snapshotId, Collections.singletonList(moveDir), null, null);
        if (success) {
            restoreFut.get(this.getTestTimeout(), TimeUnit.MILLISECONDS);
        } else {
            GridTestUtils.assertThrows((IgniteLogger)log, () -> (Void)restoreFut.get(this.getTestTimeout(), TimeUnit.MILLISECONDS), cls, (String)error);
        }
    }

    protected void doCheckLocal(Predicate<Long> pred, String error) throws Exception {
        long snapshotId = this.createSnapshot();
        boolean success = pred.test(snapshotId);
        GridSnapshotEx db = this.getSnapshot(this.grid("client"));
        SnapshotFuture checkFut = db.checkSnapshot(snapshotId, null, false, null);
        List issues = (List)checkFut.get(this.getTestTimeout(), TimeUnit.MILLISECONDS);
        SnapshotSecurityLevelAbstractTest.assertNotNull((Object)issues);
        if (success) {
            SnapshotSecurityLevelAbstractTest.assertEquals((int)0, (int)issues.size());
        } else {
            SnapshotSecurityLevelAbstractTest.assertTrue((String)"Got no issues, unexpected", (!issues.isEmpty() ? 1 : 0) != 0);
            SnapshotSecurityLevelAbstractTest.assertTrue((String)("Unexpected issue : " + ((SnapshotIssue)issues.get(0)).getIssue()), (boolean)((SnapshotIssue)issues.get(0)).getIssue().contains(error));
        }
    }

    private long createSnapshot() throws Exception {
        this.startGrids(2);
        IgniteEx client = this.startGrid("client");
        client.cluster().active(true);
        this.changeSecurityLevel(client, this.getSnapshotSecurityLevel());
        GridSnapshotEx db = this.getSnapshot(this.grid("client"));
        this.load((Ignite)this.grid(0));
        SnapshotFuture fut = db.createFullSnapshot(null, null);
        fut.get(this.getTestTimeout(), TimeUnit.MILLISECONDS);
        return fut.snapshotOperation().snapshotId();
    }

    private long createIncrementalSnapshot() throws Exception {
        this.startGrids(2);
        IgniteEx client = this.startGrid("client");
        client.cluster().active(true);
        this.changeSecurityLevel(client, this.getSnapshotSecurityLevel());
        GridSnapshotEx db = this.getSnapshot(this.grid("client"));
        this.load((Ignite)this.grid(0));
        SnapshotFuture fut = db.createFullSnapshot(null, null);
        fut.get(this.getTestTimeout(), TimeUnit.MILLISECONDS);
        this.load((Ignite)this.grid(0), 10);
        SnapshotFuture fut2 = db.createSnapshot(null, null);
        fut2.get(this.getTestTimeout(), TimeUnit.MILLISECONDS);
        return fut2.snapshotOperation().snapshotId();
    }

    protected void setErrorOnTransformer(IgniteEx ignite, boolean error) {
        SnapshotRegistryTransformer transformer = ((GridCacheSnapshotManager)ignite.context().cache().context().snapshot()).config().getRegistryTransformer();
        if (transformer instanceof ErrorTransformer) {
            ((ErrorTransformer)transformer).setError(error);
        }
    }

    protected GridSnapshotEx getSnapshot(IgniteEx igniteEx) {
        GridGain gg = (GridGain)igniteEx.plugin("GridGain");
        GridSnapshotEx snapshot = (GridSnapshotEx)gg.snapshot();
        assert (snapshot != null);
        return snapshot;
    }

    protected void changeSecurityLevel(IgniteEx ignite, SnapshotSecurityLevel level) throws IgniteCheckedException {
        this.getSnapshot(ignite).updateSecurityLevel(level);
    }

    public static abstract class RegistryFilesVisitor {
        public void visit(long snapshotId, ClusterNode ... nodes) {
            try {
                for (ClusterNode node : nodes) {
                    IgniteEx igEx = (IgniteEx)G.ignite((UUID)node.id());
                    GridCacheSnapshotManager snapMgr = (GridCacheSnapshotManager)igEx.context().cache().context().snapshot();
                    FileSnapshot snapshot = (FileSnapshot)snapMgr.snapshotSpi().snapshot(snapshotId, null, null, false, null, false);
                    SnapshotPath consIdDir = snapshot.snapshotDirectory().resolve(U.maskForFileName((CharSequence)igEx.configuration().getConsistentId().toString()));
                    SnapshotSecurityLevelAbstractTest.assertTrue((boolean)consIdDir.exists());
                    this.processDir(((FsSnapshotPath)consIdDir).getFile().toPath(), "snapshot-registry.bin");
                }
            }
            catch (IOException e) {
                throw new IgniteException((Throwable)e);
            }
        }

        public void visit(Path ... dirs) {
            try {
                for (Path dir : dirs) {
                    this.processDir(dir, "snapshot-registry.bin");
                }
            }
            catch (IOException e) {
                throw new IgniteException((Throwable)e);
            }
        }

        private void processDir(Path dir, String fileName) throws IOException {
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir);){
                for (Path path : stream) {
                    if (Files.isRegularFile(path, new LinkOption[0])) {
                        if (!path.endsWith(fileName)) continue;
                        this.processFile(path);
                        continue;
                    }
                    if (!Files.isDirectory(path, new LinkOption[0])) continue;
                    this.processDir(path, fileName);
                }
            }
        }

        public abstract void processFile(Path var1) throws IOException;
    }

    public static class IncompatibleSnapshotDigestRegistry
    extends SnapshotDigestRegistry {
        public IncompatibleSnapshotDigestRegistry() {
            super(0L, 0, "", "");
            this.metadataDigest(new byte[0]);
        }

        public byte getProtocolVersion() {
            return 100;
        }
    }

    public static class IncompatibleVerifiableRegistry
    extends VerifiableSnapshotDigestRegistry {
        public byte getProtocolVersion() {
            return 100;
        }
    }

    public static class IncompatibleVersionOfRegistryVisitor
    extends RegistryFilesVisitor {
        private boolean outer;

        public IncompatibleVersionOfRegistryVisitor(boolean outer) {
            this.outer = outer;
        }

        @Override
        public void processFile(Path path) throws IOException {
            Files.delete(path);
            try (FileOutputStream stream = new FileOutputStream(path.toFile());){
                if (this.outer) {
                    new JdkMarshaller().marshal((Object)new IncompatibleVerifiableRegistry(), (OutputStream)stream);
                } else {
                    VerifiableSnapshotDigestRegistry verReg = new VerifiableSnapshotDigestRegistry();
                    verReg.prepareMarshal((SnapshotRegistryTransformer)new ErrorTransformer(), (SnapshotDigestRegistry)new IncompatibleSnapshotDigestRegistry());
                    new JdkMarshaller().marshal((Object)verReg, (OutputStream)stream);
                }
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException((Throwable)e);
            }
        }
    }

    public static class CorruptingRegistryVisitor
    extends RegistryFilesVisitor {
        @Override
        public void processFile(Path path) throws IOException {
            Files.delete(path);
            path.toFile().createNewFile();
        }
    }

    public static class DeletingRegistryVisitor
    extends RegistryFilesVisitor {
        @Override
        public void processFile(Path path) throws IOException {
            Files.delete(path);
        }
    }

    public static class RegistryFailingSnapshotSpi
    extends FileDatabaseSnapshotSpi {
        public SnapshotSession sessionForSnapshotCreation(long id, boolean fullSnapshot, File storePath, CompressionOption compression, int compressionLevel, FutureTaskQueue<GroupPartitionId> futureTaskQueue, SnapshotOperationContext snapshotOperationContext, @Nullable MessageDigestFactory msgDigestFactory, @Nullable SnapshotEncryptionOptions encryptionOptions) throws IgniteCheckedException {
            FileSnapshotSession fileSession = (FileSnapshotSession)super.sessionForSnapshotCreation(id, fullSnapshot, storePath, compression, compressionLevel, futureTaskQueue, snapshotOperationContext, msgDigestFactory, encryptionOptions);
            try {
                Field field = FileSnapshotSession.class.getDeclaredField("metadataStreamFactory");
                field.setAccessible(true);
                SnapshotOutputStreamFactory streamFactory = (SnapshotOutputStreamFactory)field.get(fileSession);
                streamFactory = (SnapshotOutputStreamFactory)Mockito.spy((Object)streamFactory);
                field.set(fileSession, streamFactory);
                ((SnapshotOutputStreamFactory)Mockito.doThrow((Throwable[])new Throwable[]{new IOException()}).when((Object)streamFactory)).makeOutputStream((FsSnapshotPath)Matchers.argThat((ArgumentMatcher)new ArgumentMatcher<FsSnapshotPath>(){

                    public boolean matches(FsSnapshotPath o) {
                        return o.toString().contains("snapshot-registry.bin");
                    }
                }));
            }
            catch (IOException | IllegalAccessException | NoSuchFieldException e) {
                SnapshotSecurityLevelAbstractTest.fail((String)e.getMessage());
            }
            return fileSession;
        }
    }

    public static class ErrorTransformer
    extends TestSnapshotRegistryTransformer {
        private volatile boolean error = false;

        public ErrorTransformer() {
            super("secret");
        }

        public void setError(boolean error) {
            this.error = error;
        }

        @Override
        public byte[] transform(byte[] data) throws Exception {
            if (this.error) {
                throw new Exception("BAD_TRANSFORM");
            }
            return super.transform(data);
        }

        @Override
        public void verify(byte[] data, byte[] verificationData) throws Exception {
            if (this.error) {
                throw new Exception("BAD_VERIFY");
            }
            super.verify(data, verificationData);
        }
    }
}

