/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database;

import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.internal.IgniteEx;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.internal.processors.cache.database.AbstractSnapshotTest;
import org.gridgain.grid.persistentstore.GridSnapshot;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.junit.Assert;
import org.junit.Test;

public class SnapshotCreationOnNodesWithDifferentSnapshotCountersTest
extends AbstractSnapshotTest {
    private static Set<String> caches = Stream.of("cache1", "cache2").collect(Collectors.toSet());

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.stopAllGrids();
        this.cleanPersistenceDir();
        this.cleanSnapshotDirs();
    }

    @Override
    protected void afterTest() throws Exception {
        super.afterTest();
        this.stopAllGrids();
        this.cleanPersistenceDir();
        this.cleanSnapshotDirs();
    }

    @Test
    public void testCreateIncrementalSnapshot() throws Exception {
        this.performTest(true);
    }

    @Test
    public void testCreateFullSnapshot() throws Exception {
        this.performTest(false);
    }

    public void performTest(boolean inc) throws Exception {
        IgniteEx ig = this.startGrids(2);
        ig.cluster().active(true);
        this.loadData((Ignite)ig);
        this.stopGrid(1, false);
        this.loadData((Ignite)ig);
        this.createSnapshot((Ignite)ig, true);
        this.startGrid(1);
        if (inc) {
            this.createSnapshot((Ignite)ig, false);
        } else {
            long snapId = this.createSnapshot((Ignite)ig, true);
            this.checkSnapshot((Ignite)ig, snapId);
        }
    }

    private void loadData(Ignite ig) {
        int keyCnt = 1000;
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        try (IgniteDataStreamer ds1 = ig.dataStreamer("cache1");
             IgniteDataStreamer ds2 = ig.dataStreamer("cache2");){
            ds1.allowOverwrite(true);
            ds2.allowOverwrite(true);
            for (int i = 0; i < 1000; ++i) {
                ds1.addData((Object)i, (Object)((Random)rnd).nextInt());
                ds2.addData((Object)i, (Object)new AbstractSnapshotTest.TestValue(i, ((Random)rnd).nextInt()));
            }
        }
    }

    private long createSnapshot(Ignite ig, boolean full) {
        GridGain gg = (GridGain)ig.plugin("GridGain");
        GridSnapshot gs = gg.snapshot();
        SnapshotFuture snapFut = full ? gs.createFullSnapshot(caches, "FULL SNAP") : gs.createSnapshot(caches, "INC SNAP");
        snapFut.get();
        return snapFut.snapshotOperation().snapshotId();
    }

    private void checkSnapshot(Ignite ig, long id) {
        GridGain gg = (GridGain)ig.plugin("GridGain");
        GridSnapshot gs = gg.snapshot();
        List issues = (List)gs.checkSnapshot(id, null, false, "").get();
        Assert.assertTrue((boolean)issues.isEmpty());
    }

    @Override
    protected int getBackupCount() {
        return 1;
    }
}

