/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.IgniteInternalCache;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.testframework.GridTestUtils;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.internal.processors.cache.database.AbstractSnapshotTest;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridCacheSnapshotManager;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotMetastoreCommonInformation;
import org.gridgain.grid.persistentstore.RestoreSnapshotParams;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.junit.Test;

public class SnapshotCreationInCaseNewCachesTest
extends AbstractSnapshotTest {
    private static final Consumer<SnapshotMetastoreCommonInformation> ASSERT_ZERO = commonInfo -> SnapshotCreationInCaseNewCachesTest.assertEquals((long)0L, (long)commonInfo.lastFullSnapshotIdForAllCaches());

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.stopAllGrids();
        this.cleanSnapshotDirs();
    }

    @Override
    protected void afterTest() throws Exception {
        super.afterTest();
        this.stopAllGrids();
        this.cleanSnapshotDirs();
    }

    @Test
    public void testCorrectMetaAfterRestart() throws Exception {
        IgniteEx n = this.startNodes(1);
        SnapshotFuture fullFut = this.fut(this.gg(n).snapshot().createFullSnapshot(null, null));
        this.checkCommonSnapshotInfo(n, this.commonInfoChecker(fullFut));
        this.stopGrid(0);
        n = this.startGrid(0);
        this.checkCommonSnapshotInfo(n, this.commonInfoChecker(fullFut));
    }

    @Test
    public void testUpdateMeta() throws Exception {
        IgniteEx n = this.startNodes(1);
        this.fut(this.gg(n).snapshot().createFullSnapshot(this.singleCacheName(n), null));
        this.checkCommonSnapshotInfo(n, ASSERT_ZERO);
        this.checkCommonSnapshotInfo(n, this.commonInfoChecker(this.fut(this.gg(n).snapshot().createFullSnapshot(null, null))));
        this.checkCommonSnapshotInfo(n, this.commonInfoChecker(this.fut(this.gg(n).snapshot().createFullSnapshot(null, null))));
        this.fut(this.gg(n).snapshot().createFullSnapshot(this.singleCacheName(n), null));
        this.checkCommonSnapshotInfo(n, ASSERT_ZERO);
    }

    @Test
    public void testCreateIncWithFullForAllCaches() throws Exception {
        IgniteEx n = this.startNodes(1);
        SnapshotFuture fullFut = this.fut(this.gg(n).snapshot().createFullSnapshot(null, null));
        this.checkErroOnCreateIncSnapshot(n, this.commonInfoChecker(fullFut), false);
        n.getOrCreateCache(String.join((CharSequence)"-", this.persistentCacheName(n)));
        this.checkErroOnCreateIncSnapshot(n, this.commonInfoChecker(fullFut), false, false);
    }

    @Test
    public void testErrCreateIncWithoutFullForAllCaches() throws Exception {
        IgniteEx n = this.startNodes(1);
        this.fut(this.gg(n).snapshot().createFullSnapshot(this.singleCacheName(n), null));
        this.checkErroOnCreateIncSnapshot(n, ASSERT_ZERO, false);
    }

    @Test
    public void testErrCreateIncSnapshotAfterNodeStart() throws Exception {
        IgniteEx n = this.startNodes(1);
        this.checkErroOnCreateIncSnapshot(n, commonInfo -> SnapshotCreationInCaseNewCachesTest.assertTrue((commonInfo == null || commonInfo.lastFullSnapshotIdForAllCaches() == 0L ? 1 : 0) != 0), false);
    }

    @Test
    public void testCorrectRestoreFromInc() throws Exception {
        IgniteEx n = this.startNodes(1);
        Map<String, List<Integer>> cacheValues0 = this.persistentCacheName(n).stream().collect(Collectors.toMap(Function.identity(), s -> this.randomValues(10)));
        this.putAll(n, cacheValues0);
        GridGain gg = this.gg(n);
        SnapshotFuture fullFut = this.fut(gg.snapshot().createFullSnapshot(null, null));
        this.checkCommonSnapshotInfo(n, this.commonInfoChecker(fullFut));
        n.getOrCreateCache(String.join((CharSequence)"-", cacheValues0.keySet()));
        Map<String, List<Integer>> cacheValues1 = this.persistentCacheName(n).stream().collect(Collectors.toMap(Function.identity(), s -> this.randomValues(10)));
        this.putAll(n, cacheValues1);
        SnapshotFuture incFut = this.fut(gg.snapshot().createSnapshot(null, null));
        this.checkCommonSnapshotInfo(n, this.commonInfoChecker(fullFut));
        this.clearAll(n);
        this.fut(gg.snapshot().restore(new RestoreSnapshotParams().snapshotId(incFut.snapshotOperation().snapshotId())));
        this.check(n, this.merge(cacheValues0, cacheValues1));
        this.checkCommonSnapshotInfo(n, ASSERT_ZERO);
        this.fut(gg.snapshot().restore(new RestoreSnapshotParams().snapshotId(fullFut.snapshotOperation().snapshotId())));
        this.check(n, cacheValues0);
        this.checkCommonSnapshotInfo(n, ASSERT_ZERO);
    }

    private void checkErroOnCreateIncSnapshot(IgniteEx n, Consumer<SnapshotMetastoreCommonInformation> act, Boolean ... expErr) throws Exception {
        SnapshotCreationInCaseNewCachesTest.assertNotNull((Object)expErr);
        SnapshotCreationInCaseNewCachesTest.assertTrue((expErr.length > 0 ? 1 : 0) != 0);
        this.checkCommonSnapshotInfo(n, act);
        GridGain gg = this.gg(n);
        List<Set> sets = Arrays.asList(this.persistentCacheName(n), null);
        List<Boolean> expErrs = Arrays.asList(expErr);
        if (expErrs.size() > 1) {
            SnapshotCreationInCaseNewCachesTest.assertEquals((int)sets.size(), (int)expErr.length);
        } else {
            expErrs = IntStream.range(0, sets.size()).mapToObj(i -> expErr[0]).collect(Collectors.toList());
        }
        for (int i2 = 0; i2 < sets.size(); ++i2) {
            int fi = i2;
            if (expErrs.get(i2).booleanValue()) {
                GridTestUtils.assertThrows((IgniteLogger)log, () -> (Void)gg.snapshot().createSnapshot((Set)sets.get(fi), null).get(1L, TimeUnit.MINUTES), IgniteException.class, (String)"Last snapshots are different on nodes for cache group");
            } else {
                gg.snapshot().createSnapshot(sets.get(i2), null).get(1L, TimeUnit.MINUTES);
            }
            this.checkCommonSnapshotInfo(n, act);
        }
    }

    private Consumer<SnapshotMetastoreCommonInformation> commonInfoChecker(SnapshotFuture<?> snapshotFut) {
        return commonInfo -> SnapshotCreationInCaseNewCachesTest.assertEquals((long)snapshotFut.snapshotOperation().snapshotId(), (long)commonInfo.lastFullSnapshotIdForAllCaches());
    }

    private void checkCommonSnapshotInfo(IgniteEx n, Consumer<SnapshotMetastoreCommonInformation> act) throws Exception {
        SnapshotMetastoreCommonInformation commonInfo = (SnapshotMetastoreCommonInformation)n.context().cache().context().database().metaStorage().read("snapshot-common-information");
        act.accept(commonInfo);
        GridCacheSnapshotManager snapMgr = (GridCacheSnapshotManager)n.context().cache().context().snapshot();
        commonInfo = new SnapshotMetastoreCommonInformation().lastFullSnapshotIdForAllCaches(((Long)U.field((Object)snapMgr, (String)"lastSuccessfulFullSnapshotIdForAllCaches")).longValue());
        act.accept(commonInfo);
    }

    private void check(IgniteEx n, Map<String, List<Integer>> cacheValues) throws Exception {
        for (Map.Entry<String, List<Integer>> e : cacheValues.entrySet()) {
            IgniteInternalCache cachex = n.cachex(e.getKey());
            SnapshotCreationInCaseNewCachesTest.assertEquals((String)e.getKey(), (int)e.getValue().size(), (int)cachex.size());
            for (Integer i : e.getValue()) {
                SnapshotCreationInCaseNewCachesTest.assertEquals((String)e.getKey(), (Object)i, (Object)cachex.get((Object)i));
            }
        }
    }

    private Set<String> persistentCacheName(IgniteEx n) {
        return n.cacheNames().stream().filter(s -> !"noPersistence".equals(s)).collect(Collectors.toSet());
    }

    private Map<String, List<Integer>> merge(Map<String, List<Integer>> ... maps) {
        SnapshotCreationInCaseNewCachesTest.assertFalse((boolean)F.isEmpty((Object[])maps));
        HashMap<String, List<Integer>> res = new HashMap<String, List<Integer>>();
        for (Map<String, List<Integer>> map : maps) {
            map.forEach((s, v) -> res.merge((String)s, (List<Integer>)v, (? super V v1, ? super V v2) -> {
                ArrayList ints = new ArrayList(v1);
                ints.addAll(v2);
                return ints;
            }));
        }
        return res;
    }

    private void clearAll(IgniteEx n) throws Exception {
        for (IgniteInternalCache cache : n.context().cache().caches()) {
            cache.clear();
            SnapshotCreationInCaseNewCachesTest.assertEquals((String)cache.name(), (int)0, (int)cache.size());
        }
    }

    private void putAll(IgniteEx n, Map<String, List<Integer>> cacheValues) {
        cacheValues.forEach((s, v) -> v.forEach(i -> n.cache(s).put(i, i)));
    }

    private List<Integer> randomValues(int size) {
        return ThreadLocalRandom.current().ints(size).boxed().collect(Collectors.toList());
    }

    private IgniteEx startNodes(int n) throws Exception {
        IgniteEx node = this.startGrids(n);
        node.cluster().state(ClusterState.ACTIVE);
        this.awaitPartitionMapExchange();
        return node;
    }

    private GridGain gg(IgniteEx n) {
        return (GridGain)n.plugin("GridGain");
    }

    private Set<String> singleCacheName(IgniteEx n) {
        return Collections.singleton(F.first(this.persistentCacheName(n)));
    }

    private <T> SnapshotFuture<T> fut(SnapshotFuture<T> snapshotFut) {
        snapshotFut.get(1L, TimeUnit.MINUTES);
        return snapshotFut;
    }
}

