/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database;

import java.io.Serializable;
import java.util.Collections;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite.Ignite;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.failure.FailureContext;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartitionSyncEviction;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionTopologyImpl;
import org.apache.ignite.internal.processors.resource.DependencyResolver;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.PluginConfiguration;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.configuration.SnapshotConfiguration;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.junit.Test;

public class RestoreDuringEvictionTest
extends GridCommonAbstractTest {
    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setRebalanceThreadPoolSize(4);
        cfg.setConsistentId((Serializable)((Object)igniteInstanceName));
        DataStorageConfiguration dsCfg = new DataStorageConfiguration().setWalSegmentSize(0x400000);
        dsCfg.getDefaultDataRegionConfiguration().setPersistenceEnabled(true).setMaxSize(0xC800000L);
        cfg.setDataStorageConfiguration(dsCfg);
        cfg.setCacheConfiguration(new CacheConfiguration[]{new CacheConfiguration("default").setBackups(1).setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 64))});
        cfg.setPluginConfigurations(new PluginConfiguration[]{new GridGainConfiguration().setSnapshotConfiguration(new SnapshotConfiguration())});
        return cfg;
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.cleanPersistenceDir();
    }

    protected void afterTest() throws Exception {
        super.afterTest();
        this.stopAllGrids();
        this.cleanPersistenceDir();
    }

    @Test
    public void testRestoreSnapshot() throws Exception {
        final AtomicInteger holder = new AtomicInteger();
        final CountDownLatch l1 = new CountDownLatch(1);
        final CountDownLatch l2 = new CountDownLatch(1);
        IgniteEx g0 = this.startGrid(0, new DependencyResolver(){

            public <T> T resolve(T instance) {
                if (instance instanceof GridDhtPartitionTopologyImpl) {
                    GridDhtPartitionTopologyImpl top = (GridDhtPartitionTopologyImpl)instance;
                    top.partitionFactory(new GridDhtPartitionTopologyImpl.PartitionFactory(){

                        public GridDhtLocalPartition create(GridCacheSharedContext ctx, CacheGroupContext grp, final int id, boolean recovery) {
                            return new GridDhtLocalPartitionSyncEviction(ctx, grp, id, recovery, 1, l1, l2){

                                protected void sync() {
                                    if (holder.get() == id) {
                                        super.sync();
                                    }
                                }
                            };
                        }
                    });
                }
                return instance;
            }
        });
        this.startGrid(1);
        g0.cluster().state(ClusterState.ACTIVE);
        int p0 = (Integer)this.evictingPartitionsAfterJoin((Ignite)g0, g0.cache("default"), 1).get(0);
        this.loadDataToPartition(p0, g0.name(), "default", 50000, 0, new int[]{3});
        GridGain gg = (GridGain)this.grid(0).plugin("GridGain");
        SnapshotFuture fut = gg.snapshot().createFullSnapshot(Collections.singleton("default"), null);
        fut.get();
        holder.set(p0);
        this.startGrid(2);
        this.resetBaselineTopology();
        RestoreDuringEvictionTest.assertTrue((boolean)U.await((CountDownLatch)l1, (long)30000L, (TimeUnit)TimeUnit.MILLISECONDS));
        RestoreDuringEvictionTest.doSleep((long)5000L);
        RestoreDuringEvictionTest.assertEquals((Object)GridDhtPartitionState.RENTING, (Object)g0.cachex("default").context().topology().localPartition(p0).state());
        IgniteInternalFuture fut2 = GridTestUtils.runAsync(() -> (Void)gg.snapshot().restoreSnapshot(fut.snapshotOperation().snapshotId(), Collections.singleton("default"), null).get());
        RestoreDuringEvictionTest.doSleep((long)2000L);
        l2.countDown();
        fut2.get();
        this.awaitPartitionMapExchange(true, true, null);
        FailureContext ctx = this.grid(0).context().failure().failureContext();
        RestoreDuringEvictionTest.assertNull((Object)ctx);
    }
}

