/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database;

import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.plugin.PluginConfiguration;
import org.apache.ignite.spi.encryption.EncryptionSpi;
import org.apache.ignite.spi.encryption.keystore.KeystoreEncryptionSpi;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.internal.processors.cache.database.IgniteDbSnapshotSameTopologyTest;
import org.gridgain.grid.internal.processors.cache.database.IgniteDbSnapshotSameTopologyWithEncryptionTest;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CompressionOption;
import org.gridgain.grid.persistentstore.SnapshotCreateParams;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.rules.ExpectedException;

public abstract class IgniteDbSnapshotSameTopologyTestWithCompression
extends IgniteDbSnapshotSameTopologyTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private final CompressionOption compressionOption;
    private final boolean encryptionEnabled;

    protected IgniteDbSnapshotSameTopologyTestWithCompression(CompressionOption option, boolean enabled) {
        this.encryptionEnabled = enabled;
        this.compressionOption = option;
    }

    @Override
    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(gridName);
        GridGainConfiguration ggCfg = null;
        for (PluginConfiguration pCfg : cfg.getPluginConfigurations()) {
            if (!(pCfg instanceof GridGainConfiguration)) continue;
            ggCfg = (GridGainConfiguration)pCfg;
            break;
        }
        assert (ggCfg != null);
        ggCfg.getSnapshotConfiguration().setCompressionOption(this.compressionOption);
        ggCfg.getSnapshotConfiguration().setCompressionLevel(this.compressionOption.defaultCompressionLevel());
        if (this.encryptionEnabled) {
            KeystoreEncryptionSpi encSpi = new KeystoreEncryptionSpi();
            encSpi.setKeyStorePath(IgniteDbSnapshotSameTopologyWithEncryptionTest.KEYSTORE_PATH);
            encSpi.setKeyStorePassword(IgniteDbSnapshotSameTopologyWithEncryptionTest.KEYSTORE_PASSWORD);
            encSpi.setMasterKeyName("ignite.master.key");
            cfg.setEncryptionSpi((EncryptionSpi)encSpi);
        }
        return cfg;
    }

    @Override
    protected CacheConfiguration<?, ?> getCacheConfig(String cacheName) {
        return super.getCacheConfig(cacheName).setEncryptionEnabled(!cacheName.equals("noPersistence") && this.encryptionEnabled);
    }

    @Override
    protected SnapshotCreateParams createSnapshotParams(CompressionOption compressionOption, int compressionLevel, int threshold) {
        if (this.encryptionEnabled) {
            return new SnapshotCreateParams(compressionOption, compressionLevel, threshold, IgniteSystemProperties.getBoolean((String)"GG_EXCHANGELESS_SNAPSHOT_CREATION", (boolean)true), null, "ignite.master.key");
        }
        return super.createSnapshotParams(compressionOption, compressionLevel, threshold);
    }

    @Override
    public void testChecking_ChecksumIssue() throws Exception {
        Assume.assumeFalse((String)"Corruption of CRC in encrypted partitions is not implemented in tests", (boolean)this.encryptionEnabled);
        super.testChecking_ChecksumIssue();
    }

    @Override
    public void testChecking_ChecksumIssue_WhenOneTargetCacheFileWasCorrupted() throws Exception {
        Assume.assumeFalse((String)"Corruption of CRC in encrypted partitions is not implemented in tests", (boolean)this.encryptionEnabled);
        super.testChecking_ChecksumIssue_WhenOneTargetCacheFileWasCorrupted();
    }

    @Override
    public void testChecking_CheckSnapshotByCacheName() throws Exception {
        Assume.assumeFalse((String)"Corruption of CRC in encrypted partitions is not implemented in tests", (boolean)this.encryptionEnabled);
        super.testChecking_CheckSnapshotByCacheName();
    }

    @Override
    public void testSnapshotMetricsMXBeanOnSnapshotCreate() throws Exception {
        Assume.assumeFalse((String)"Real compressed files have unpredictable sizes, test is unstable", (boolean)this.encryptionEnabled);
        super.testSnapshotMetricsMXBeanOnSnapshotCreate();
    }

    @Override
    public void testThatClientLeftDoesNotFailSnapshotRestore() throws Exception {
        Assume.assumeFalse((String)"https://ggsystems.atlassian.net/browse/GG-40376", (boolean)this.encryptionEnabled);
        super.testThatClientLeftDoesNotFailSnapshotRestore();
    }

    @Override
    public void testCreateSnapshotToSpecificPathCompression() throws Exception {
        this.createSnapshotToSpecificPathAndParallelism(8, this.compressionOption, Math.min(5, this.compressionOption.maxCompressionLevel()));
    }

    @Override
    public void testCreateSnapshotToSpecificPathCompressionAndParallelism() throws Exception {
        this.createSnapshotToSpecificPathAndParallelism(2, this.compressionOption, -1);
    }

    public static class SnappyEncrypted
    extends IgniteDbSnapshotSameTopologyTestWithCompression {
        public SnappyEncrypted() {
            super(CompressionOption.SNAPPY, true);
        }
    }

    public static class ZstdEncrypted
    extends IgniteDbSnapshotSameTopologyTestWithCompression {
        public ZstdEncrypted() {
            super(CompressionOption.ZSTD, true);
        }
    }

    public static class ZipEncrypted
    extends IgniteDbSnapshotSameTopologyTestWithCompression {
        public ZipEncrypted() {
            super(CompressionOption.ZIP, true);
        }
    }

    public static class Snappy
    extends IgniteDbSnapshotSameTopologyTestWithCompression {
        public Snappy() {
            super(CompressionOption.SNAPPY, false);
        }
    }

    public static class Lz4
    extends IgniteDbSnapshotSameTopologyTestWithCompression {
        public Lz4() {
            super(CompressionOption.LZ4, false);
        }
    }

    public static class Zstd
    extends IgniteDbSnapshotSameTopologyTestWithCompression {
        public Zstd() {
            super(CompressionOption.ZSTD, false);
        }
    }

    public static class Zip
    extends IgniteDbSnapshotSameTopologyTestWithCompression {
        public Zip() {
            super(CompressionOption.ZIP, false);
        }
    }
}

