/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.function.ToLongFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.cache.configuration.CompleteConfiguration;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteAtomicSequence;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCacheRestartingException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.Ignition;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.affinity.Affinity;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cluster.BaselineNode;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.pagemem.store.IgnitePageStoreManager;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheType;
import org.apache.ignite.internal.processors.cache.DynamicCacheDescriptor;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.GridCacheUtils;
import org.apache.ignite.internal.processors.cache.IgniteCacheOffheapManager;
import org.apache.ignite.internal.processors.cache.IgniteCacheProxy;
import org.apache.ignite.internal.processors.cache.IgniteInternalCache;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.IgniteCacheSnapshotManager;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.util.function.ThrowableFunction;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.future.IgniteFinishedFutureImpl;
import org.apache.ignite.internal.util.lang.GridAbsPredicate;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteFutureTimeoutException;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.marshaller.jdk.JdkMarshaller;
import org.apache.ignite.spi.discovery.tcp.internal.TcpDiscoveryNode;
import org.apache.ignite.spi.encryption.noop.NoopEncryptionSpi;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.transactions.Transaction;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.configuration.SnapshotConfiguration;
import org.gridgain.grid.internal.compression.SnapshotCompressionUtils;
import org.gridgain.grid.internal.processors.cache.database.AbstractSnapshotTest;
import org.gridgain.grid.internal.processors.cache.database.IgniteDbSnapshotSameTopologyTestInitiatorNotInBaseline;
import org.gridgain.grid.internal.processors.cache.database.IgniteDbSnapshotSameTopologyTestWithCompression;
import org.gridgain.grid.internal.processors.cache.database.SnapshotMetricsMXBeanImpl;
import org.gridgain.grid.internal.processors.cache.database.SnapshotOperationStage;
import org.gridgain.grid.internal.processors.cache.database.messages.CheckSnapshotMetadataMessage;
import org.gridgain.grid.internal.processors.cache.database.messages.ClusterWideSnapshotOperationStageFinishedMessage;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CacheSnapshotMetadata;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CompressionOption;
import org.gridgain.grid.internal.processors.cache.database.snapshot.DatabaseSnapshotSpi;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridCacheSnapshotManager;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridSnapshotOperationAttrs;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridSnapshotOperationEx;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridSnapshotOperationImpl;
import org.gridgain.grid.internal.processors.cache.database.snapshot.ResultOfOperationWithSnapshot;
import org.gridgain.grid.internal.processors.cache.database.snapshot.Snapshot;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotCheckFuture;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotInfoExtended;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotMetadataV2;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotOperationFuture;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotOperationInfoImpl;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotOutputStream;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotRestoreFuture;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotTestFuture;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotUtils;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.FsSnapshotPath;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.SnapshotPath;
import org.gridgain.grid.persistentstore.GridSnapshot;
import org.gridgain.grid.persistentstore.SnapshotChainMode;
import org.gridgain.grid.persistentstore.SnapshotCommonParams;
import org.gridgain.grid.persistentstore.SnapshotCreateParams;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.gridgain.grid.persistentstore.SnapshotInfo;
import org.gridgain.grid.persistentstore.SnapshotInfoEx;
import org.gridgain.grid.persistentstore.SnapshotIssue;
import org.gridgain.grid.persistentstore.SnapshotMetricsMXBean;
import org.gridgain.grid.persistentstore.SnapshotOperationType;
import org.gridgain.grid.persistentstore.SnapshotStatus;
import org.gridgain.grid.persistentstore.SnapshotUpdateOperationParams;
import org.gridgain.grid.persistentstore.snapshot.file.FileDatabaseSnapshotSpi;
import org.gridgain.grid.persistentstore.snapshot.file.FileSnapshot;
import org.gridgain.grid.persistentstore.snapshot.file.SnapshotOutputStreamFactory;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assume;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.Mockito;

public class IgniteDbSnapshotSameTopologyTest
extends AbstractSnapshotTest {
    protected static IgniteEx ignite;
    protected static IgniteEx dummyNode;
    protected static IgniteEx ignite2;
    protected static GridGain gg;
    private final int SNAPSHOT_MX_BEAN_HISTORY_SIZE = 5;
    private static final String ATOMIC_SEQUENCE_NAME = "explicitlySnapshotDatastructureCacheShouldWork";
    private static final String SYS_ATOMICS_CACHE_NAME = "ignite-sys-atomic-cache@default-ds-group";
    public static final String TEST_NESTED_PARAMS = "TEST_NESTED_PARAMS";

    protected void beforeTest() throws Exception {
        IgniteDbSnapshotSameTopologyTest.assertTrue((boolean)ignite.cluster().active());
        IgniteCache cache1 = ignite.getOrCreateCache(this.getOrCreateDefaultCacheName((Ignite)ignite));
        IgniteCache cache2 = ignite.getOrCreateCache(this.getCacheConfig("cache2"));
        IgniteCache cache3 = ignite.getOrCreateCache(this.getCacheConfig("localCache"));
        cache1.clear();
        cache2.clear();
        cache3.clear();
        this.load((Ignite)ignite);
        IgniteDbSnapshotSameTopologyTest.loadWithIntsAsync((Ignite)ignite, "localCache", 0, 1).get(this.getTestTimeout());
        IgniteDbSnapshotSameTopologyTest.assertEquals((String)"beforeTest", (int)300, (int)cache1.size(new CachePeekMode[0]));
        IgniteDbSnapshotSameTopologyTest.assertEquals((String)"beforeTest", (int)300, (int)cache2.size(new CachePeekMode[0]));
        IgniteDbSnapshotSameTopologyTest.assertEquals((String)"beforeTest", (int)300, (int)cache3.size(new CachePeekMode[0]));
    }

    @Override
    protected void afterTest() throws Exception {
        this.ensureCachesCreated();
        SnapshotStatus op = gg.snapshot().ongoingSnapshotOperation();
        if (op != null) {
            gg.snapshot().cancelSnapshotOperation(op.operationId(), "afterTest").get(this.getTestTimeout());
        }
        this.clearSnapshotNodeDir(this.snapshotFolders());
        IgniteDbSnapshotSameTopologyTest.assertEquals((String)ignite.cacheNames().toString(), (int)this.getExpectedCacheCountDuringTest(), (int)ignite.cacheNames().size());
    }

    protected int getExpectedCacheCountDuringTest() {
        return 15;
    }

    @NotNull
    protected List<String> getAllCacheNames() {
        return Arrays.asList("cache1", "cache2", "cache3", "cache4", "cache5_g1", "cache6_g1", "cache7_g1", "cache8_g2", "cache9_g2", "cache10_g2", "cache11", "cache12", "cache13");
    }

    @Override
    protected void afterTestsStopped() throws Exception {
        super.afterTestsStopped();
        System.clearProperty("GG_TEST_SKIP_SNAPSHOT_SYNC");
        System.clearProperty("GG_SNAPSHOT_METRICS_HISTORY_SIZE");
    }

    protected void beforeTestsStarted() throws Exception {
        this.stopAllGrids();
        this.cleanSnapshotDirs();
        this.setProperties();
        dummyNode = this.startGrid("dummy");
        ignite = this.startGrid(0);
        ignite2 = this.startGrid(1);
        dummyNode.active(true);
        gg = (GridGain)ignite.plugin("GridGain");
        this.load((Ignite)ignite);
        this.startGrid("client");
    }

    protected void setProperties() {
        System.setProperty("GG_TEST_SKIP_SNAPSHOT_SYNC", "true");
        System.setProperty("GG_SNAPSHOT_METRICS_HISTORY_SIZE", Integer.toString(5));
    }

    protected boolean clientStarted() {
        return true;
    }

    protected boolean dummyStarted() {
        return true;
    }

    protected int nodeCount() {
        return 2;
    }

    private SnapshotCreateParams createSnapshotParams(SnapshotConfiguration snapshotConfiguration) {
        return this.createSnapshotParams(snapshotConfiguration.getCompressionOption(), snapshotConfiguration.getCompressionLevel(), 0);
    }

    protected SnapshotCreateParams createSnapshotParams(CompressionOption compressionOption, int compressionLevel, int threshold) {
        return new SnapshotCreateParams(compressionOption, compressionLevel, threshold);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSnapshotNotAllPartitionsAreLoaded() throws Exception {
        CacheConfiguration cfg = this.getCacheConfig("cache1").setName("testSnapshotNotAllPartitionsAreLoaded").setBackups(this.getBackupCount());
        IgniteCache cache = ignite.getOrCreateCache(cfg);
        try {
            int i;
            HashSet<String> sn = new HashSet<String>();
            sn.add("testSnapshotNotAllPartitionsAreLoaded");
            SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
            gg.snapshot().createFullSnapshot(sn, null, createParams, "not_all").get(this.getTestTimeout());
            for (i = 1; i < 20; ++i) {
                cache.put((Object)ThreadLocalRandom.current().nextInt(32), (Object)i);
            }
            for (i = 1; i < 20; ++i) {
                cache.remove((Object)ThreadLocalRandom.current().nextInt(32));
            }
            gg.snapshot().createFullSnapshot(sn, null, createParams, "not_all").get(this.getTestTimeout());
            cache.put((Object)ThreadLocalRandom.current().nextInt(32), (Object)0);
            cache.remove((Object)ThreadLocalRandom.current().nextInt(32));
            gg.snapshot().createSnapshot(sn, null, createParams, "not_all").get(this.getTestTimeout());
        }
        finally {
            cache.destroy();
        }
    }

    @Test
    public void testListWithBrokenMetadata() throws Exception {
        int before = gg.snapshot().list().size();
        SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
        SnapshotFuture fut = gg.snapshot().createFullSnapshot(null, null, createParams, null);
        fut.get(this.getTestTimeout());
        long snapId = fut.snapshotOperation().snapshotId();
        IgniteDbSnapshotSameTopologyTest.assertEquals((int)(before + 1), (int)gg.snapshot().list().size());
        SnapshotInfoEx info = gg.snapshot().snapshot(snapId, null);
        this.corruptFile(this.getMetadataFile(ignite, snapId, null));
        try {
            int size = gg.snapshot().list().size();
            if (info.topology().size() > 1) {
                IgniteDbSnapshotSameTopologyTest.assertEquals((int)size, (int)(before + 1));
            } else {
                IgniteDbSnapshotSameTopologyTest.assertEquals((int)size, (int)before);
            }
        }
        catch (Exception e) {
            IgniteDbSnapshotSameTopologyTest.fail((String)"List is broken");
        }
    }

    @Test
    public void explicitlySnapshotDatastructureCacheShouldWork() {
        IgniteAtomicSequence work = ignite.atomicSequence(ATOMIC_SEQUENCE_NAME, -1L, true);
        work.incrementAndGet();
        try {
            SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
            gg.snapshot().createFullSnapshot(Collections.singleton(SYS_ATOMICS_CACHE_NAME), null, createParams, null).get(this.getTestTimeout());
        }
        finally {
            work.close();
            ignite.destroyCache(SYS_ATOMICS_CACHE_NAME);
        }
    }

    @Test
    public void testListWithDeletedMetadata() throws Exception {
        int before = gg.snapshot().list().size();
        SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
        SnapshotFuture fut = gg.snapshot().createFullSnapshot(null, null, createParams, null);
        fut.get(this.getTestTimeout());
        long snapId = fut.snapshotOperation().snapshotId();
        IgniteDbSnapshotSameTopologyTest.assertEquals((int)(before + 1), (int)gg.snapshot().list().size());
        SnapshotInfoEx info = gg.snapshot().snapshot(snapId, null);
        File file = this.getMetadataFile(this.getSnapshotCrdNode(), snapId, null);
        IgniteDbSnapshotSameTopologyTest.assertTrue((file != null && file.exists() ? 1 : 0) != 0);
        IgniteDbSnapshotSameTopologyTest.assertTrue((boolean)file.delete());
        try {
            int size = gg.snapshot().list().size();
            if (info.topology().size() > 1) {
                IgniteDbSnapshotSameTopologyTest.assertEquals((int)size, (int)(before + 1));
            } else {
                IgniteDbSnapshotSameTopologyTest.assertEquals((int)size, (int)before);
            }
        }
        catch (Exception e) {
            IgniteDbSnapshotSameTopologyTest.fail((String)"List is broken");
        }
    }

    @Test
    public void testListWithBrokenMetadataOnWholeCluster() throws Exception {
        int before = gg.snapshot().list().size();
        SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
        SnapshotFuture fut = gg.snapshot().createFullSnapshot(null, null, createParams, null);
        fut.get(this.getTestTimeout());
        long snapId = fut.snapshotOperation().snapshotId();
        IgniteDbSnapshotSameTopologyTest.assertEquals((int)(before + 1), (int)gg.snapshot().list().size());
        for (Ignite ign : Ignition.allGrids()) {
            if (ign.configuration().isClientMode().booleanValue() || ign.configuration().isDaemon()) continue;
            this.corruptFile(this.getMetadataFile((IgniteEx)ign, snapId, null));
        }
        try {
            int size = gg.snapshot().list().size();
            IgniteDbSnapshotSameTopologyTest.assertEquals((int)size, (int)before);
        }
        catch (Exception e) {
            IgniteDbSnapshotSameTopologyTest.fail((String)"List is broken");
        }
    }

    @Test
    public void testSimpleMove() throws Exception {
        File movedDir = this.createOrCleanMoveDir();
        SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
        SnapshotFuture fut = gg.snapshot().createFullSnapshot(null, null, createParams, null);
        fut.get(this.getTestTimeout());
        long snapId = fut.snapshotOperation().snapshotId();
        SnapshotFuture moveFut = gg.snapshot().moveSnapshot(snapId, movedDir, null);
        moveFut.get();
        this.verifySnapshotContent(movedDir, snapId, gg, (Ignite)ignite, false, null);
        Path snapshotDir = movedDir.toPath().resolve(FileDatabaseSnapshotSpi.generateSnapshotDirName((long)snapId, null));
        this.assertMetadataExists(snapshotDir.toFile(), CompressionOption.NONE);
    }

    @Test
    public void testSimpleCopy() throws Exception {
        this.testSimpleCopy(false, null);
    }

    @Test
    public void testCopySinglePartitionCopy() throws Exception {
        this.testSimpleCopy(true, null);
    }

    @Test
    public void testCopySinglePartitionCopyWithMinimalBatch() throws Exception {
        System.setProperty("GG_SNAPSHOT_COPY_MAX_WORK_BATCH_SIZE", Long.toString(Long.MAX_VALUE));
        try {
            this.testSimpleCopy(true, null);
        }
        finally {
            System.clearProperty("GG_SNAPSHOT_COPY_MAX_WORK_BATCH_SIZE");
        }
    }

    @Test
    public void testCopySinglePartitionCopyEmptySnapshot() throws Exception {
        IgniteCache cache = ignite.cache("cache3");
        IgniteDbSnapshotSameTopologyTest.assertNotNull((Object)cache);
        IgniteDbSnapshotSameTopologyTest.assertEquals((int)0, (int)cache.size(new CachePeekMode[0]));
        this.testSimpleCopy(true, (Set<String>)ImmutableSet.of((Object)"cache3"));
    }

    private void testSimpleCopy(boolean singleFileCopy, Set<String> cacheNames) throws IgniteCheckedException {
        File copyDir = this.createOrCleanMoveDir();
        int before = gg.snapshot().list().size();
        SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
        SnapshotFuture fut = gg.snapshot().createFullSnapshot(cacheNames, null, createParams, null);
        fut.get(this.getTestTimeout());
        long snapId = fut.snapshotOperation().snapshotId();
        SnapshotFuture copyFut = gg.snapshot().copySnapshot(snapId, copyDir, new SnapshotUpdateOperationParams(SnapshotChainMode.DEFAULT, false, singleFileCopy, null), null);
        copyFut.get();
        List infos = gg.snapshot().listSnapshots(Collections.singleton(copyDir));
        Optional<SnapshotInfo> info = infos.stream().filter(x -> x.snapshotId() == snapId).findAny();
        IgniteDbSnapshotSameTopologyTest.assertTrue((boolean)info.isPresent());
        IgniteDbSnapshotSameTopologyTest.assertEquals((int)2, (int)SnapshotUtils.getSnapshotFolders((Map)info.get().snapshotAttributes()).size());
        gg.snapshot().deleteSnapshot(snapId, new SnapshotUpdateOperationParams(SnapshotChainMode.SINGLE), null).get(this.getTestTimeout());
        if (!singleFileCopy) {
            this.verifySnapshotContent(copyDir, snapId, gg, (Ignite)ignite, false, null);
        }
        gg.snapshot().restoreSnapshot(snapId, Collections.singleton(copyDir), null, null).get(this.getTestTimeout());
    }

    @Test
    public void testRestoreIncrementalWithSingleCopyFullSnapshot() throws Exception {
        File moveDir = this.createOrCleanMoveDir();
        SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
        SnapshotFuture snapshot = gg.snapshot().createFullSnapshot(null, null, createParams, null);
        snapshot.get();
        IgniteDbSnapshotSameTopologyTest.loadWithIntsAsync((Ignite)ignite, this.getOrCreateDefaultCacheName((Ignite)ignite), 10, 1, 150).get(this.getTestTimeout());
        SnapshotFuture incSnapshot = gg.snapshot().createSnapshot(null, null, createParams, null);
        incSnapshot.get();
        gg.snapshot().copySnapshot(snapshot.snapshotOperation().snapshotId(), moveDir, new SnapshotUpdateOperationParams(SnapshotChainMode.SINGLE, true, true, null), null).get(this.getTestTimeout());
        ignite.cache(this.getOrCreateDefaultCacheName((Ignite)ignite)).clear();
        gg.snapshot().restoreSnapshot(incSnapshot.snapshotOperation().snapshotId(), Collections.singleton(moveDir), null, null).get(this.getTestTimeout());
        for (int i = 0; i < 300; ++i) {
            IgniteCache cache = ignite.cache(this.getOrCreateDefaultCacheName((Ignite)ignite));
            IgniteDbSnapshotSameTopologyTest.assertEquals((Object)cache.get((Object)i), (Object)(i < 150 ? i + 10 : i));
        }
    }

    @Test
    public void testIncrementalSnapshotIndexShouldBeIncremental() throws Exception {
        Assume.assumeTrue((((Object)((Object)this)).getClass() != IgniteDbSnapshotSameTopologyTestInitiatorNotInBaseline.class && ((Object)((Object)this)).getClass().getSuperclass() != IgniteDbSnapshotSameTopologyTestWithCompression.class ? 1 : 0) != 0);
        SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
        SnapshotFuture snapshot = gg.snapshot().createFullSnapshot(null, null, createParams, null);
        snapshot.get();
        IgniteDbSnapshotSameTopologyTest.loadWithIntsAsync((Ignite)ignite, this.getOrCreateDefaultCacheName((Ignite)ignite), 10, 1, 150).get(this.getTestTimeout());
        SnapshotFuture incSnapshot = gg.snapshot().createSnapshot(null, null, createParams, null);
        incSnapshot.get();
        GridCacheSnapshotManager snapMgr = (GridCacheSnapshotManager)ignite.context().cache().context().snapshot();
        DatabaseSnapshotSpi snapshotSpi = snapMgr.snapshotSpi();
        ToLongFunction<SnapshotFuture> idxSizeFun = snapshotFut -> {
            FileSnapshot fileSnapshot = (FileSnapshot)snapshotSpi.snapshot(snapshotFut.snapshotOperation().snapshotId(), null, null, false, snapMgr.resolveSecurityLevel(), false);
            String iId = U.maskForFileName((CharSequence)ignite.localNode().consistentId().toString());
            SnapshotPath nodeSnapshotDir = fileSnapshot.snapshotDirectory().resolve(iId);
            int cacheId = GridCacheUtils.cacheId((String)this.getOrCreateDefaultCacheName((Ignite)ignite));
            SnapshotPath nodeCacheSnapshotDir = nodeSnapshotDir.resolve(Integer.toString(cacheId));
            return nodeCacheSnapshotDir.resolveRegularOrCompressed("index.bin").length();
        };
        IgniteDbSnapshotSameTopologyTest.assertTrue((idxSizeFun.applyAsLong(snapshot) > idxSizeFun.applyAsLong(incSnapshot) ? 1 : 0) != 0);
    }

    @Test
    public void testMovedSnapshotListWithBrokenMetadata() throws Exception {
        File movedDir = this.createOrCleanMoveDir();
        int before = gg.snapshot().list().size();
        SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
        SnapshotFuture fut = gg.snapshot().createFullSnapshot(null, null, createParams, null);
        fut.get(this.getTestTimeout());
        long snapId = fut.snapshotOperation().snapshotId();
        SnapshotFuture moveFut = gg.snapshot().moveSnapshot(snapId, movedDir, null);
        moveFut.get();
        IgniteDbSnapshotSameTopologyTest.assertEquals((int)(before + 1), (int)gg.snapshot().listSnapshots(Collections.singleton(movedDir)).size());
        this.corruptFile(this.getMetadataFile(ignite, snapId, movedDir.toPath()));
        try {
            int size = gg.snapshot().listSnapshots(Collections.singleton(movedDir)).size();
            IgniteDbSnapshotSameTopologyTest.assertEquals((int)size, (int)(before + 1));
        }
        catch (Exception e) {
            IgniteDbSnapshotSameTopologyTest.fail((String)"List is broken");
        }
    }

    @Test
    public void testInfoWithBrokenMetadata() throws Exception {
        block2: {
            SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
            SnapshotFuture fut = gg.snapshot().createFullSnapshot(null, null, createParams, null);
            fut.get(this.getTestTimeout());
            long snapId = fut.snapshotOperation().snapshotId();
            SnapshotInfoEx info = gg.snapshot().snapshot(snapId, null);
            IgniteDbSnapshotSameTopologyTest.assertEquals((long)info.snapshotId(), (long)snapId);
            this.corruptFile(this.getMetadataFile(ignite, snapId, null));
            try {
                gg.snapshot().snapshot(snapId, null);
            }
            catch (Exception e) {
                if (info.topology().size() <= 1 && !F.isEmpty((String)e.getMessage()) && e.getMessage().contains("Snapshot does not exist [id=")) break block2;
                IgniteDbSnapshotSameTopologyTest.fail((String)"Snapshot info is broken");
            }
        }
    }

    @Test
    public void testFirstAnySnapshotShouldBeFull() throws Exception {
        int before = gg.snapshot().list().size();
        SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
        SnapshotFuture fut = gg.snapshot().createFullSnapshot(null, null, createParams, null);
        fut.get(this.getTestTimeout());
        SnapshotOperationInfoImpl snapOpImpl = (SnapshotOperationInfoImpl)fut.snapshotOperation();
        IgniteDbSnapshotSameTopologyTest.assertTrue((boolean)GridSnapshotOperationAttrs.getFullSnapshotParameter((GridSnapshotOperationEx)snapOpImpl.snapshotOperation()));
        List infos = gg.snapshot().list();
        IgniteDbSnapshotSameTopologyTest.assertEquals((int)(before + 1), (int)infos.size());
        SnapshotInfoEx info = gg.snapshot().snapshot(fut.snapshotOperation().snapshotId(), null);
        IgniteDbSnapshotSameTopologyTest.assertTrue((boolean)info.fullSnapshot());
    }

    @Test
    public void testSnapshotNoCaches() {
        ignite.destroyCaches(this.getAllCacheNames());
        SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
        GridTestUtils.assertThrows((IgniteLogger)log, () -> (Void)gg.snapshot().createFullSnapshot(null, null, createParams, null).get(this.getTestTimeout()), IgniteException.class, (String)"Snapshot creation with empty list of caches is requested");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRestoreSequences() throws Exception {
        long size = ignite.configuration().getAtomicConfiguration().getAtomicSequenceReserveSize();
        String seq1 = "seq1";
        String seq2 = "seq2";
        IgniteAtomicSequence sequence1 = ignite.atomicSequence(seq1, 0L, true);
        IgniteAtomicSequence sequence2 = ignite.atomicSequence(seq2, 1L, true);
        try {
            int i = 0;
            while ((long)i < size) {
                sequence1.incrementAndGet();
                sequence2.addAndGet(10L);
                ++i;
            }
            long seq1state = sequence1.get();
            long seq2state = sequence2.get();
            GridGain gg = (GridGain)ignite.plugin("GridGain");
            SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
            SnapshotFuture snapshotFuture = gg.snapshot().createFullSnapshot(null, null, createParams, null);
            snapshotFuture.get();
            int i2 = 0;
            while ((long)i2 < 5L * size) {
                sequence1.incrementAndGet();
                sequence2.addAndGet(10L);
                ++i2;
            }
            IgniteDbSnapshotSameTopologyTest.assertTrue((sequence1.get() != seq1state ? 1 : 0) != 0);
            IgniteDbSnapshotSameTopologyTest.assertTrue((sequence2.get() != seq2state ? 1 : 0) != 0);
            gg.snapshot().restoreSnapshot(snapshotFuture.snapshotOperation().snapshotId(), null, null).get(this.getTestTimeout());
            try {
                sequence1.get();
                sequence2.get();
            }
            catch (IgniteCacheRestartingException e) {
                e.restartFuture().get(this.getTestTimeout());
            }
            IgniteDbSnapshotSameTopologyTest.assertTrue((sequence1.get() < seq1state + 5L * size ? 1 : 0) != 0);
            IgniteDbSnapshotSameTopologyTest.assertTrue((sequence2.get() < seq2state + 5L * size * 10L ? 1 : 0) != 0);
        }
        finally {
            sequence1.close();
            sequence2.close();
            ignite.destroyCache(SYS_ATOMICS_CACHE_NAME);
        }
    }

    @Test
    public void testCreateSnapshotCancellation() throws Exception {
        SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
        SnapshotFuture fut = gg.snapshot().createFullSnapshot(null, null, createParams, null);
        IgniteUuid operationId = fut.snapshotOperation().operationId();
        fut.initFuture().get(this.getTestTimeout());
        IgniteFuture res = gg.snapshot().cancelSnapshotOperation(operationId, null);
        this.checkIsCanceledOrAlreadyDone(fut, (IgniteFuture<Boolean>)res);
    }

    @Test
    public void testMoveSnapshotCancellation() throws Exception {
        File movedDir = this.createOrCleanMoveDir();
        SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
        SnapshotFuture fut = gg.snapshot().createFullSnapshot(null, null, createParams, null);
        fut.get(this.getTestTimeout());
        long snapId = fut.snapshotOperation().snapshotId();
        fut = gg.snapshot().moveSnapshot(snapId, movedDir, null);
        fut.initFuture().get(this.getTestTimeout());
        IgniteUuid operationId1 = fut.snapshotOperation().operationId();
        IgniteFuture res1 = gg.snapshot().cancelSnapshotOperation(operationId1, null);
        this.checkIsCanceledOrAlreadyDone(fut, (IgniteFuture<Boolean>)res1);
        createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
        fut = gg.snapshot().createFullSnapshot(null, null, createParams, null);
        fut.get(this.getTestTimeout());
        snapId = fut.snapshotOperation().snapshotId();
        CountDownLatch latch = this.addWaitingStageFinishListener(SnapshotOperationStage.SECOND, this.getNonCoordinator(this.getSnapshotCrdNode()));
        fut = gg.snapshot().moveSnapshot(snapId, movedDir, null);
        IgniteUuid operationId = fut.snapshotOperation().operationId();
        IgniteDbSnapshotSameTopologyTest.assertTrue((boolean)latch.await(this.getTestTimeout(), TimeUnit.MILLISECONDS));
        IgniteFuture res = gg.snapshot().forceCancelSnapshotOperation(operationId, null);
        this.checkIsCanceledOrAlreadyDone(fut, (IgniteFuture<Boolean>)res);
    }

    @Test
    public void testCopySnapshotCancellation() throws Exception {
        this.testCopyCancellation(false);
    }

    @Test
    public void testCopySnapshotSingleFileCopyCancellation() throws Exception {
        this.testCopyCancellation(true);
    }

    private void testCopyCancellation(boolean singleFileCopy) throws IgniteCheckedException {
        File movedDir = this.createOrCleanMoveDir();
        SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
        SnapshotFuture fut = gg.snapshot().createFullSnapshot(null, null, createParams, null);
        fut.get(this.getTestTimeout());
        long snapId = fut.snapshotOperation().snapshotId();
        fut = gg.snapshot().copySnapshot(snapId, movedDir, new SnapshotUpdateOperationParams(SnapshotChainMode.SINGLE, false, singleFileCopy, null), null);
        fut.initFuture().get(this.getTestTimeout());
        IgniteUuid operationId1 = fut.snapshotOperation().operationId();
        IgniteFuture res1 = gg.snapshot().cancelSnapshotOperation(operationId1, null);
        boolean cancelled = this.checkIsCanceledOrAlreadyDone(fut, (IgniteFuture<Boolean>)res1);
        if (cancelled) {
            Object[] files = movedDir.listFiles();
            IgniteDbSnapshotSameTopologyTest.assertTrue((String)("movedDir.listFiles() = " + Arrays.toString(files)), (files != null && files.length == 0 ? 1 : 0) != 0);
        }
    }

    protected boolean checkIsCanceledOrAlreadyDone(SnapshotFuture opFuture, IgniteFuture<Boolean> cancelFuture) {
        boolean isCanceledOnMove = false;
        try {
            while (true) {
                try {
                    opFuture.get(10000L);
                }
                catch (IgniteFutureTimeoutException e) {
                    U.warn((IgniteLogger)log, (Object)"Timeout while waiting snapshot operation completion");
                    continue;
                }
                break;
            }
        }
        catch (IgniteException e) {
            String msg = this.getErrorMessage(e);
            isCanceledOnMove = msg != null && msg.contains("Snapshot operation has been cancelled");
        }
        IgniteDbSnapshotSameTopologyTest.assertTrue((String)("cancelFuture.get()=" + cancelFuture.get() + ", isCanceledOnMove=" + isCanceledOnMove), ((Boolean)cancelFuture.get() == isCanceledOnMove ? 1 : 0) != 0);
        return isCanceledOnMove;
    }

    private String getErrorMessage(Throwable th) {
        StringWriter writer = new StringWriter();
        th.printStackTrace(new PrintWriter(writer));
        return writer.toString();
    }

    @Test
    public void testDeleteSnapshotCancellation() throws Exception {
        SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
        SnapshotFuture fut = gg.snapshot().createFullSnapshot(null, null, createParams, null);
        fut.get(this.getTestTimeout());
        fut = gg.snapshot().deleteSnapshot(fut.snapshotOperation().snapshotId(), (SnapshotUpdateOperationParams)null, null);
        IgniteUuid operationId = fut.snapshotOperation().operationId();
        try {
            IgniteFuture res = gg.snapshot().cancelSnapshotOperation(operationId, null);
            IgniteDbSnapshotSameTopologyTest.assertFalse((boolean)((Boolean)res.get()));
            IgniteDbSnapshotSameTopologyTest.assertTrue((boolean)fut.isDone());
            return;
        }
        catch (Exception ex) {
            IgniteDbSnapshotSameTopologyTest.assertTrue((boolean)ex.getMessage().contains("Snapshot operation in non-cancelable state!"));
            gg.snapshot().forceCancelSnapshotOperation(operationId, null).get(this.getTestTimeout());
            IgniteDbSnapshotSameTopologyTest.assertTrue((boolean)fut.isDone());
            gg.snapshot().createFullSnapshot(null, null, createParams, null).get(this.getTestTimeout());
            return;
        }
    }

    @Test
    public void testThatForceCancelWorkAfterFailedNormalCancel() throws Exception {
        IgniteCacheSnapshotManager snapshot = ignite.context().cache().context().snapshot();
        IgniteDbSnapshotSameTopologyTest.assertTrue((boolean)(snapshot instanceof GridCacheSnapshotManager));
        GridCacheSnapshotManager mgr = (GridCacheSnapshotManager)snapshot;
        SnapshotFuture fut = mgr.startGlobalTestSnapshotOperation((Map)ImmutableMap.of((Object)"HANG_ON_FIRST_STAGE", (Object)true, (Object)"CANCELABLE", (Object)false), null);
        fut.initFuture().get(this.getTestTimeout());
        try {
            gg.snapshot().cancelSnapshotOperation(fut.operationId(), null).get(this.getTestTimeout());
            IgniteDbSnapshotSameTopologyTest.fail((String)"TEST OPERATION with current configuration should be not-cancellable");
        }
        catch (Exception exception) {
            // empty catch block
        }
        IgniteFuture cancelFut = gg.snapshot().forceCancelSnapshotOperation(fut.operationId(), null);
        IgniteDbSnapshotSameTopologyTest.assertTrue((boolean)((Boolean)cancelFut.get()));
        IgniteDbSnapshotSameTopologyTest.assertTrue((boolean)fut.isDone());
        SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
        gg.snapshot().createFullSnapshot(null, null, createParams, null).get(this.getTestTimeout());
    }

    @Test
    public void testCancelInfiniteOperation() throws Exception {
        IgniteCacheSnapshotManager snapshot = ignite.context().cache().context().snapshot();
        IgniteDbSnapshotSameTopologyTest.assertTrue((boolean)(snapshot instanceof GridCacheSnapshotManager));
        GridCacheSnapshotManager mgr = (GridCacheSnapshotManager)snapshot;
        SnapshotFuture fut = mgr.startGlobalTestSnapshotOperation((Map)ImmutableMap.of((Object)"HANG_ON_FIRST_STAGE", (Object)true), null);
        fut.initFuture().get(this.getTestTimeout());
        IgniteFuture cancelFut = gg.snapshot().cancelSnapshotOperation(fut.operationId(), null);
        IgniteDbSnapshotSameTopologyTest.assertTrue((boolean)((Boolean)cancelFut.get()));
        IgniteDbSnapshotSameTopologyTest.assertTrue((boolean)fut.isDone());
        SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
        gg.snapshot().createFullSnapshot(null, null, createParams, null).get(this.getTestTimeout());
    }

    @Test
    public void testRestoreSnapshotCancellation() throws Exception {
        SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
        SnapshotFuture fut = gg.snapshot().createFullSnapshot(null, null, createParams, null);
        fut.get(this.getTestTimeout());
        long snapId = fut.snapshotOperation().snapshotId();
        SnapshotFuture fut2 = gg.snapshot().restoreSnapshot(snapId, null, null);
        IgniteUuid operationId1 = fut2.snapshotOperation().operationId();
        fut2.initFuture().get(this.getTestTimeout());
        IgniteFuture res1 = gg.snapshot().cancelSnapshotOperation(operationId1, null);
        this.checkIsCanceledOrAlreadyDone(fut2, (IgniteFuture<Boolean>)res1);
        CountDownLatch latch = this.addWaitingStageFinishListener(SnapshotOperationStage.FIRST, this.getNonCoordinator(this.getSnapshotCrdNode()));
        SnapshotFuture fut1 = gg.snapshot().restoreSnapshot(snapId, null, null);
        IgniteUuid operationId = fut1.snapshotOperation().operationId();
        latch.await();
        IgniteFuture res = gg.snapshot().cancelSnapshotOperation(operationId, null);
        this.checkIsCanceledOrAlreadyDone(fut1, (IgniteFuture<Boolean>)res);
    }

    @Test
    public void testCacheStartAfterRestoreForciblyCancelled() throws Exception {
        IgniteCache cache = ignite.cache("cache1");
        IgniteDbSnapshotSameTopologyTest.assertNotNull((Object)cache);
        this.forciblyCancelRestoreWhenCacheAreStopped();
        IgniteDbSnapshotSameTopologyTest.assertNull((Object)ignite.cache("cache1"));
        ignite.getOrCreateCache(this.getCacheConfig("cache1"));
    }

    @Test
    public void testAnotherRestoreAfterRestoreForciblyCancelled() throws Exception {
        IgniteCache cache = ignite.cache("cache1");
        IgniteDbSnapshotSameTopologyTest.assertNotNull((Object)cache);
        long snapId = this.forciblyCancelRestoreWhenCacheAreStopped();
        gg.snapshot().restoreSnapshot(snapId, null, null).get(this.getTestTimeout());
    }

    private long forciblyCancelRestoreWhenCacheAreStopped() throws InterruptedException {
        SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
        SnapshotFuture fut = gg.snapshot().createFullSnapshot(null, null, createParams, null);
        fut.get(this.getTestTimeout());
        long snapId = fut.snapshotOperation().snapshotId();
        CountDownLatch latch = this.addWaitingStageFinishListener(SnapshotOperationStage.FIRST, this.getNonCoordinator(this.getSnapshotCrdNode()));
        SnapshotFuture fut1 = gg.snapshot().restoreSnapshot(snapId, null, null);
        IgniteUuid operationId = fut1.snapshotOperation().operationId();
        latch.await();
        IgniteDbSnapshotSameTopologyTest.assertTrue((boolean)((Boolean)gg.snapshot().forceCancelSnapshotOperation(operationId, null).get(this.getTestTimeout())));
        return snapId;
    }

    @Test
    public void testCheckSnapshotCancellation() throws Exception {
        SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
        SnapshotFuture fut = gg.snapshot().createFullSnapshot(null, null, createParams, null);
        fut.get(this.getTestTimeout());
        fut = gg.snapshot().checkSnapshot(fut.snapshotOperation().snapshotId(), null, false, null);
        IgniteUuid operationId = fut.snapshotOperation().operationId();
        fut.initFuture().get(this.getTestTimeout());
        IgniteFuture res = gg.snapshot().cancelSnapshotOperation(operationId, null);
        this.checkIsCanceledOrAlreadyDone(fut, (IgniteFuture<Boolean>)res);
    }

    @Test
    public void testSimpleSnapshotCreation() throws Exception {
        IgniteCache cache1 = ignite.cache(this.getOrCreateDefaultCacheName((Ignite)ignite));
        IgniteCache cache2 = ignite.cache("cache2");
        SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
        SnapshotFuture fut = gg.snapshot().createFullSnapshot(null, null, createParams, null);
        fut.get(this.getTestTimeout());
        cache1.destroy();
        cache2.destroy();
        gg.snapshot().restoreSnapshot(fut.snapshotOperation().snapshotId(), null, null).get(this.getTestTimeout());
        cache1 = ignite.cache(this.getOrCreateDefaultCacheName((Ignite)ignite));
        cache2 = ignite.cache("cache2");
        for (int i = 0; i < 300; ++i) {
            Integer val1 = (Integer)cache1.get((Object)i);
            IgniteDbSnapshotSameTopologyTest.assertNotNull((String)("index=" + i), (Object)val1);
            IgniteDbSnapshotSameTopologyTest.assertEquals((String)("index=" + i), (int)i, (int)val1);
            AbstractSnapshotTest.TestValue val2 = (AbstractSnapshotTest.TestValue)cache2.get((Object)i);
            IgniteDbSnapshotSameTopologyTest.assertNotNull((String)("index=" + i), (Object)val2);
            IgniteDbSnapshotSameTopologyTest.assertEquals((String)("index=" + i), (Object)new AbstractSnapshotTest.TestValue(i, i), (Object)val2);
        }
    }

    @Test
    public void testSnapshotSizeCalculation() throws Exception {
        SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
        SnapshotFuture fut = gg.snapshot().createFullSnapshot(null, null, createParams, null);
        fut.get(this.getTestTimeout());
        GridCacheSnapshotManager snapMgr = (GridCacheSnapshotManager)ignite.context().cache().context().snapshot();
        DatabaseSnapshotSpi spi = snapMgr.snapshotSpi();
        Snapshot snap = spi.snapshot(fut.snapshotOperation().snapshotId(), null, null, false, snapMgr.resolveSecurityLevel(), false);
        SnapshotMetadataV2 metadata = snap.metadata();
        int size = 0;
        for (CacheSnapshotMetadata snapshotMetadata : metadata.cacheGroupsMetadata().values()) {
            for (Map cntPerNodeForPartition : snapshotMetadata.partitionSizesPerNode().values()) {
                for (Integer cnt : cntPerNodeForPartition.values()) {
                    size += cnt.intValue();
                }
            }
        }
        IgniteDbSnapshotSameTopologyTest.assertEquals((long)size, (long)metadata.sizeOnlyDataInPages());
    }

    @Test
    public void testCancelSnapshotCleanup() throws Exception {
        long snapId;
        SnapshotCreateParams createParams;
        block2: {
            createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
            SnapshotFuture fut = gg.snapshot().createFullSnapshot(null, null, createParams, null);
            fut.get(this.getTestTimeout());
            fut = gg.snapshot().createSnapshot(null, null, createParams, null);
            GridCacheSnapshotManager snapMgr = (GridCacheSnapshotManager)this.grid(0).context().cache().context().snapshot();
            GridTestUtils.waitForCondition(() -> snapMgr.snapshotFuture() != null, (long)1000L);
            snapMgr.snapshotFuture().initFuture().get(this.getTestTimeout());
            snapId = fut.snapshotOperation().snapshotId();
            log.info("snapshot id " + snapId);
            IgniteFuture res = gg.snapshot().cancelSnapshotOperation(fut.snapshotOperation().operationId(), null);
            try {
                IgniteDbSnapshotSameTopologyTest.assertTrue((String)"Your system is too fast for our tests, isn't it?", (boolean)((Boolean)res.get()));
            }
            catch (IgniteException ex) {
                if (!"Snapshot operation in non-cancelable state!".equals(ex.getMessage())) break block2;
                fut.get(this.getTestTimeout());
                return;
            }
        }
        gg.snapshot().createFullSnapshot(Collections.singleton("cache1"), null, createParams, null).get(this.getTestTimeout());
        this.checkExistsSnapshotDirectory(ignite, snapId);
        this.checkExistsSnapshotDirectory(ignite2, snapId);
    }

    private void checkExistsSnapshotDirectory(IgniteEx ignite, long snapId) {
        GridCacheSnapshotManager snapMgr = (GridCacheSnapshotManager)ignite.context().cache().context().snapshot();
        DatabaseSnapshotSpi spi = snapMgr.snapshotSpi();
        FsSnapshotPath snapshotDir = spi.generateCurNodeSnapshotFolderPath(snapId);
        IgniteDbSnapshotSameTopologyTest.assertFalse((String)snapshotDir.toString(), (boolean)snapshotDir.exists());
        SnapshotPath parent = snapshotDir.getParent();
        IgniteDbSnapshotSameTopologyTest.assertFalse((String)parent.toString(), (boolean)parent.exists());
    }

    @Test
    public void testIncrementalWithoutFullDoesntFail() throws Exception {
        List infos;
        while (!(infos = gg.snapshot().list()).isEmpty()) {
            gg.snapshot().forceDeleteSnapshot(((SnapshotInfo)infos.get(0)).snapshotId(), null).get(this.getTestTimeout());
        }
        SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
        gg.snapshot().createSnapshot(null, null, createParams, null).get(this.getTestTimeout());
    }

    @Test
    public void testDeleteSnapshotWithStoppedCache() throws Exception {
        IgniteCache cache2 = ignite.cache("cache2");
        int before = gg.snapshot().list().size();
        SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
        SnapshotFuture fut = gg.snapshot().createFullSnapshot(null, null, createParams, null);
        fut.get(this.getTestTimeout());
        IgniteDbSnapshotSameTopologyTest.assertEquals((int)(before + 1), (int)gg.snapshot().list().size());
        cache2.destroy();
        SnapshotFuture future = gg.snapshot().deleteSnapshot(fut.snapshotOperation().snapshotId(), (SnapshotUpdateOperationParams)null, null);
        future.get();
        IgniteDbSnapshotSameTopologyTest.assertEquals((int)before, (int)gg.snapshot().list().size());
        ignite.getOrCreateCache(this.getCacheConfig("cache2"));
    }

    @Test
    public void testCheckOperationInfo() throws Exception {
        String msg = "test msg";
        HashSet caches = Sets.newHashSet((Object[])new String[]{this.getOrCreateDefaultCacheName((Ignite)ignite), "cache2"});
        SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
        SnapshotFuture fut1 = gg.snapshot().createFullSnapshot((Set)caches, null, createParams, msg);
        SnapshotOperationInfoImpl op = (SnapshotOperationInfoImpl)fut1.snapshotOperation();
        IgniteDbSnapshotSameTopologyTest.assertNotNull((Object)op);
        IgniteDbSnapshotSameTopologyTest.assertEquals((Object)caches, (Object)op.cacheNames());
        IgniteDbSnapshotSameTopologyTest.assertEquals((String)msg, (String)op.message());
        IgniteDbSnapshotSameTopologyTest.assertEquals((Object)SnapshotOperationType.CREATE, (Object)op.snapshotOperation().type());
        IgniteDbSnapshotSameTopologyTest.assertNotNull((Object)op.operationId());
        IgniteDbSnapshotSameTopologyTest.assertEquals((Object)ignite.localNode().id(), (Object)op.initiatorNodeId());
        HashSet exp = Sets.newHashSet();
        HashSet actl = Sets.newHashSet((Iterable)op.clusterNodes());
        for (ClusterNode node : ignite.cluster().nodes()) {
            if (node.isClient()) continue;
            exp.add(node);
        }
        IgniteDbSnapshotSameTopologyTest.assertEquals((int)exp.size(), (int)actl.size());
        for (ClusterNode node : exp) {
            IgniteDbSnapshotSameTopologyTest.assertTrue((boolean)actl.contains(new TcpDiscoveryNode(node)));
        }
        IgniteDbSnapshotSameTopologyTest.assertEquals((int)exp.size(), (int)actl.size());
        IgniteDbSnapshotSameTopologyTest.assertTrue((op.snapshotId() != 0L ? 1 : 0) != 0);
        fut1.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testThatWeRestoreOnlyGivenCaches() throws Exception {
        String defaultCacheName = this.getOrCreateDefaultCacheName((Ignite)ignite);
        IgniteCache cache1 = ignite.cache(defaultCacheName);
        IgniteCache cache2 = ignite.cache("cache2");
        SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
        SnapshotFuture fut = gg.snapshot().createFullSnapshot(null, null, createParams, null);
        fut.get(this.getTestTimeout());
        cache1.destroy();
        cache2.destroy();
        try {
            gg.snapshot().restoreSnapshot(fut.snapshotOperation().snapshotId(), null, Collections.singleton(defaultCacheName), true, null, null).get(this.getTestTimeout());
            cache1 = ignite.cache(defaultCacheName);
            cache2 = ignite.cache("cache2");
            IgniteDbSnapshotSameTopologyTest.assertNull((Object)cache2);
            for (int i = 0; i < 300; ++i) {
                Integer val1 = (Integer)cache1.get((Object)i);
                IgniteDbSnapshotSameTopologyTest.assertNotNull((String)("index=" + i), (Object)val1);
                IgniteDbSnapshotSameTopologyTest.assertEquals((String)("index=" + i), (int)i, (int)val1);
            }
        }
        finally {
            ignite.getOrCreateCache(this.getCacheConfig("cache2"));
        }
    }

    @Test
    public void testSnapshotWithOnlyInitializedPartitions() throws Exception {
        IgniteCacheProxy cache = (IgniteCacheProxy)ignite.cache("cache1");
        IgniteCacheOffheapManager offheap = cache.context().offheap();
        for (IgniteCacheOffheapManager.CacheDataStore store : offheap.cacheDataStores()) {
            store.updateCounter();
            IgniteDbSnapshotSameTopologyTest.assertNotNull((Object)store.rowStore());
        }
        SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
        SnapshotFuture snapshot = gg.snapshot().createFullSnapshot(null, null, createParams, null);
        snapshot.get();
        SnapshotFuture future = gg.snapshot().checkSnapshot(snapshot.snapshotOperation().snapshotId(), null, false, null);
        future.get();
        MatcherAssert.assertThat((Object)future.get(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }

    @Test
    public void testUpdateCachesFromClientAfterRestore() throws Exception {
        if (!this.clientStarted()) {
            System.out.println("Test is skipped - no clients in topology.");
            return;
        }
        IgniteCache cache1 = ignite.cache("cache1");
        IgniteDbSnapshotSameTopologyTest.loadWithIntsAsync((Ignite)ignite, "cache1", 0, 1).get(this.getTestTimeout());
        IgniteCache cache2 = ignite.cache("cache2");
        SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
        SnapshotFuture fut = gg.snapshot().createFullSnapshot(null, null, createParams, null);
        fut.get(this.getTestTimeout());
        gg.snapshot().restoreSnapshot(fut.snapshotOperation().snapshotId(), null, null).get(this.getTestTimeout());
        try (Transaction tx = ignite.transactions().txStart();){
            int i;
            IgniteDbSnapshotSameTopologyTest.assertFalse((boolean)tx.implicit());
            for (i = 0; i < 300; ++i) {
                Integer val1 = (Integer)cache1.get((Object)i);
                IgniteDbSnapshotSameTopologyTest.assertNotNull((String)("index=" + i), (Object)val1);
                IgniteDbSnapshotSameTopologyTest.assertEquals((String)("index=" + i), (int)i, (int)val1);
                AbstractSnapshotTest.TestValue val2 = (AbstractSnapshotTest.TestValue)cache2.get((Object)i);
                IgniteDbSnapshotSameTopologyTest.assertNotNull((String)("index=" + i), (Object)val2);
                IgniteDbSnapshotSameTopologyTest.assertEquals((String)("index=" + i), (Object)new AbstractSnapshotTest.TestValue(i, i), (Object)val2);
            }
            for (i = 300; i < 310; ++i) {
                cache1.put((Object)i, (Object)i);
                cache2.put((Object)i, (Object)new AbstractSnapshotTest.TestValue(i, i));
            }
            tx.commit();
        }
    }

    @Test
    public void testNotFullSnapshotSimple() throws Exception {
        int i;
        IgniteCache cache1 = ignite.cache(this.getOrCreateDefaultCacheName((Ignite)ignite));
        IgniteCache cache2 = ignite.cache("cache2");
        SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
        SnapshotFuture fut = gg.snapshot().createFullSnapshot(null, null, createParams, null);
        fut.get(this.getTestTimeout());
        cache1.destroy();
        cache2.destroy();
        gg.snapshot().restoreSnapshot(fut.snapshotOperation().snapshotId(), null, F.asSet((Object[])new String[]{this.getOrCreateDefaultCacheName((Ignite)ignite), "cache2"}), true, null, null).get(this.getTestTimeout());
        gg.snapshot().createFullSnapshot(null, null, createParams, null).get(this.getTestTimeout());
        cache1 = ignite.cache(this.getOrCreateDefaultCacheName((Ignite)ignite));
        cache2 = ignite.cache("cache2");
        for (i = 0; i < 300; ++i) {
            Integer val1 = (Integer)cache1.get((Object)i);
            IgniteDbSnapshotSameTopologyTest.assertNotNull((String)("index=" + i), (Object)val1);
            IgniteDbSnapshotSameTopologyTest.assertEquals((String)("index=" + i), (int)i, (int)val1);
            AbstractSnapshotTest.TestValue val2 = (AbstractSnapshotTest.TestValue)cache2.get((Object)i);
            IgniteDbSnapshotSameTopologyTest.assertNotNull((String)("index=" + i), (Object)val2);
            IgniteDbSnapshotSameTopologyTest.assertEquals((String)("index=" + i), (Object)new AbstractSnapshotTest.TestValue(i, i), (Object)val2);
        }
        for (i = 0; i < 300; ++i) {
            cache1.put((Object)i, (Object)(-i));
            cache2.put((Object)i, (Object)new AbstractSnapshotTest.TestValue(i, -i));
        }
        SnapshotFuture fut2 = gg.snapshot().createSnapshot(null, null, createParams, null);
        fut2.get();
        cache1.destroy();
        cache2.destroy();
        gg.snapshot().restoreSnapshot(fut2.snapshotOperation().snapshotId(), null, F.asSet((Object[])new String[]{this.getOrCreateDefaultCacheName((Ignite)ignite), "cache2"}), true, null, null).get(this.getTestTimeout());
        cache1 = ignite.cache(this.getOrCreateDefaultCacheName((Ignite)ignite));
        cache2 = ignite.cache("cache2");
        for (int i2 = 0; i2 < 300; ++i2) {
            Integer val1 = (Integer)cache1.get((Object)i2);
            IgniteDbSnapshotSameTopologyTest.assertNotNull((String)("index=" + i2), (Object)val1);
            IgniteDbSnapshotSameTopologyTest.assertEquals((String)("index=" + i2), (int)(-i2), (int)val1);
            AbstractSnapshotTest.TestValue val2 = (AbstractSnapshotTest.TestValue)cache2.get((Object)i2);
            IgniteDbSnapshotSameTopologyTest.assertNotNull((String)("index=" + i2), (Object)val2);
            IgniteDbSnapshotSameTopologyTest.assertEquals((String)("index=" + i2), (Object)new AbstractSnapshotTest.TestValue(i2, -i2), (Object)val2);
        }
    }

    @Test
    public void testCustomIndexRestored() throws Exception {
        File[] nodeDirs;
        IgniteCache cache = ignite.cache("cache2");
        for (int i = 0; i < 300; ++i) {
            cache.put((Object)i, (Object)new AbstractSnapshotTest.TestValue(-i, i));
        }
        SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
        SnapshotFuture fut = gg.snapshot().createFullSnapshot(Collections.singleton("cache2"), null, createParams, null);
        long snapshotId = fut.snapshotOperation().snapshotId();
        fut.get(this.getTestTimeout());
        for (File nodeDir : nodeDirs = this.getSnapshotNodeDirs("snapshot", snapshotId)) {
            File[] cacheDirs;
            for (File cacheDir : cacheDirs = nodeDir.listFiles()) {
                if (!cacheDir.isDirectory()) continue;
                this.assertIndexExists(cacheDir, gg.configuration().getSnapshotConfiguration().getCompressionOption());
            }
        }
        gg.snapshot().restoreSnapshot(snapshotId, null, null).get(this.getTestTimeout());
        cache = ignite.cache("cache2");
        cache.indexReadyFuture().get(this.getTestTimeout());
        for (int i = 0; i < this.nodeCount(); ++i) {
            IgniteEx iex = this.grid(i);
            this.info("Checking grid: " + i);
            iex.cache("cache2").indexReadyFuture().get(this.getTestTimeout());
            IgniteInternalCache internalCache = iex.context().cache().cache("cache2");
            IgniteDbSnapshotSameTopologyTest.assertEquals((int)0, (int)internalCache.context().cache().map().internalSize());
        }
        IgniteH2Indexing idx = (IgniteH2Indexing)ignite.context().query().getIndexing();
        GridH2Table tbl = idx.schemaManager().dataTable("cache2", "TESTVALUE");
        IgniteDbSnapshotSameTopologyTest.assertNotNull((Object)tbl);
        IgniteDbSnapshotSameTopologyTest.assertFalse((boolean)tbl.rebuildFromHashInProgress());
        IgniteDbSnapshotSameTopologyTest.assertEquals((int)300, (int)cache.query(new SqlFieldsQuery("select * from TestValue where v2 between 0 and ?").setArgs(new Object[]{300})).getAll().size());
        String plan = ((List)cache.query(new SqlFieldsQuery("explain select * from TestValue where v2 between 0 and ?").setArgs(new Object[]{300})).getAll().get(0)).get(0).toString();
        IgniteDbSnapshotSameTopologyTest.assertTrue((String)plan, (boolean)plan.toLowerCase().contains("testvalue_v2_idx"));
    }

    @Test
    public void testDynamicIndexForDynamicCacheRestoredWithRebuild() throws Exception {
        this.testDynamicIndexForCacheRestoredWithRebuild(false);
    }

    @Ignore(value="https://issues.apache.org/jira/browse/IGNITE-10478")
    @Test
    public void testDynamicIndexForStaticCacheRestoredWithRebuild() throws Exception {
        this.testDynamicIndexForCacheRestoredWithRebuild(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDynamicIndexForCacheRestoredWithRebuild(boolean staticCache) throws Exception {
        IgniteCache cache;
        if (staticCache) {
            cache = ignite.cache("cache2");
            Collection descs = ignite.context().cache().cacheDescriptors().values();
            List results = descs.stream().filter(DynamicCacheDescriptor::staticallyConfigured).map(DynamicCacheDescriptor::cacheName).filter(k -> k.equals("cache2")).limit(1L).collect(Collectors.toList());
            IgniteDbSnapshotSameTopologyTest.assertFalse((boolean)results.isEmpty());
        } else {
            cache = ignite.createCache(this.getCacheConfig("cache2").setName("DYN_CACHE_NAME").setGroupName("DYN_GROUP_NAME"));
        }
        String cacheName = cache.getName();
        try {
            File[] nodeDirs;
            cache.query(new SqlFieldsQuery("CREATE INDEX \"testvalue_v5_idx\" on TESTVALUE (v5)")).getAll();
            cache.query(new SqlFieldsQuery("CREATE INDEX \"testvalue_v5_IDX\" on TESTVALUE (v5)")).getAll();
            for (int i = 0; i < 300; ++i) {
                cache.put((Object)i, (Object)new AbstractSnapshotTest.TestValue(-i, i));
            }
            IgniteDbSnapshotSameTopologyTest.assertEquals((int)300, (int)cache.query(new SqlFieldsQuery("select * from TestValue where v5 between 0 and ?").setArgs(new Object[]{300})).getAll().size());
            String plan = ((List)cache.query(new SqlFieldsQuery("explain select * from TestValue where v5 between 0 and ?").setArgs(new Object[]{300})).getAll().get(0)).get(0).toString();
            IgniteDbSnapshotSameTopologyTest.assertTrue((String)plan, (boolean)plan.contains("testvalue_v5_idx"));
            SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
            SnapshotFuture fut = gg.snapshot().createFullSnapshot(Collections.singleton(cacheName), null, createParams, null);
            long snapshotId = fut.snapshotOperation().snapshotId();
            fut.get(this.getTestTimeout());
            for (File nodeDir : nodeDirs = this.getSnapshotNodeDirs("snapshot", snapshotId)) {
                File[] cacheDirs;
                for (File cacheDir : cacheDirs = nodeDir.listFiles()) {
                    if (!cacheDir.isDirectory()) continue;
                    this.assertIndexExists(cacheDir, gg.configuration().getSnapshotConfiguration().getCompressionOption());
                }
            }
            gg.snapshot().restoreSnapshot(snapshotId, null, null).get(this.getTestTimeout());
            cache = ignite.cache(cacheName);
            cache.indexReadyFuture().get(this.getTestTimeout());
            for (int i = 0; i < this.nodeCount(); ++i) {
                IgniteEx iex = this.grid(i);
                this.info("Checking grid: " + i);
                iex.cache(cacheName).indexReadyFuture().get(this.getTestTimeout());
                IgniteInternalCache internalCache = iex.context().cache().cache(cacheName);
                IgniteDbSnapshotSameTopologyTest.assertEquals((int)0, (int)internalCache.context().cache().map().internalSize());
            }
            IgniteH2Indexing idx = (IgniteH2Indexing)ignite.context().query().getIndexing();
            GridH2Table tbl = idx.schemaManager().dataTable(cacheName, "TESTVALUE");
            IgniteDbSnapshotSameTopologyTest.assertNotNull((Object)tbl);
            IgniteDbSnapshotSameTopologyTest.assertFalse((boolean)tbl.rebuildFromHashInProgress());
            IgniteDbSnapshotSameTopologyTest.assertEquals((int)300, (int)cache.query(new SqlFieldsQuery("select * from TestValue where v5 between 0 and ?").setArgs(new Object[]{300})).getAll().size());
            plan = ((List)cache.query(new SqlFieldsQuery("explain select * from TestValue where v5 between 0 and ?").setArgs(new Object[]{300})).getAll().get(0)).get(0).toString();
            IgniteDbSnapshotSameTopologyTest.assertTrue((String)plan, (boolean)plan.contains("testvalue_v5_idx"));
        }
        finally {
            if (cache != null) {
                cache.query(new SqlFieldsQuery("DROP INDEX IF EXISTS testvalue_v5_idx")).getAll();
            }
            if (!staticCache) {
                ignite.destroyCache(cacheName);
            }
        }
    }

    @Test
    public void testSnapshotCacheSubsets() throws Exception {
        this.testSnapshotCacheSubsets(Collections.singleton(this.getOrCreateDefaultCacheName((Ignite)ignite)), Collections.singletonList(this.getOrCreateDefaultCacheName((Ignite)ignite)));
        this.testSnapshotCacheSubsets(null, this.getAllCacheNames());
    }

    private void testSnapshotCacheSubsets(Set<String> input, Collection<String> expected) throws Exception {
        SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
        SnapshotFuture fut = gg.snapshot().createFullSnapshot(input, null, createParams, null);
        fut.get(this.getTestTimeout());
        List snapshotInfos = gg.snapshot().list();
        boolean exists = false;
        for (SnapshotInfo snapshotInfo : snapshotInfos) {
            if (snapshotInfo.snapshotId() != fut.snapshotOperation().snapshotId()) continue;
            exists = true;
            IgniteDbSnapshotSameTopologyTest.assertEquals((int)expected.size(), (int)snapshotInfo.cacheNames().size());
            IgniteDbSnapshotSameTopologyTest.assertTrue((boolean)snapshotInfo.cacheNames().containsAll(expected));
        }
        IgniteDbSnapshotSameTopologyTest.assertTrue((boolean)exists);
    }

    @Test
    public void testSnapshotFromClient() throws Exception {
        int i;
        if (!this.clientStarted()) {
            System.out.println("Test is skipped - no clients in topology.");
            return;
        }
        IgniteEx client = this.grid("client");
        GridGain ggClient = (GridGain)client.plugin("GridGain");
        IgniteCache cache1 = client.cache(this.getOrCreateDefaultCacheName((Ignite)ignite));
        IgniteCache cache2 = client.cache("cache2");
        cache1.clear();
        cache2.clear();
        this.load((Ignite)client);
        IgniteDbSnapshotSameTopologyTest.assertEquals((int)300, (int)cache1.size(new CachePeekMode[0]));
        IgniteDbSnapshotSameTopologyTest.assertEquals((int)300, (int)cache2.size(new CachePeekMode[0]));
        SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
        SnapshotFuture fullSnapshotFut = ggClient.snapshot().createFullSnapshot(null, null, createParams, null);
        fullSnapshotFut.get();
        for (int i2 = 0; i2 < 300; ++i2) {
            cache1.put((Object)i2, (Object)(-i2));
            cache2.put((Object)i2, (Object)new AbstractSnapshotTest.TestValue(-i2, i2));
            IgniteDbSnapshotSameTopologyTest.assertEquals((Object)(-i2), (Object)cache1.get((Object)i2));
            IgniteDbSnapshotSameTopologyTest.assertEquals((Object)new AbstractSnapshotTest.TestValue(-i2, i2), (Object)cache2.get((Object)i2));
        }
        SnapshotFuture incSnapshotFut = ggClient.snapshot().createSnapshot(null, null, createParams, null);
        incSnapshotFut.get();
        ggClient.snapshot().restoreSnapshot(fullSnapshotFut.snapshotOperation().snapshotId(), new HashSet(fullSnapshotFut.snapshotOperation().cacheNames()), null).get(this.getTestTimeout());
        cache1 = client.cache(this.getOrCreateDefaultCacheName((Ignite)ignite));
        cache2 = client.cache("cache2");
        IgniteDbSnapshotSameTopologyTest.assertEquals((int)300, (int)cache1.size(new CachePeekMode[0]));
        IgniteDbSnapshotSameTopologyTest.assertEquals((int)300, (int)cache2.size(new CachePeekMode[0]));
        for (i = 0; i < 300; ++i) {
            IgniteDbSnapshotSameTopologyTest.assertEquals((Object)i, (Object)cache1.get((Object)i));
            IgniteDbSnapshotSameTopologyTest.assertEquals((Object)new AbstractSnapshotTest.TestValue(i, i), (Object)cache2.get((Object)i));
        }
        ggClient.snapshot().restoreSnapshot(incSnapshotFut.snapshotOperation().snapshotId(), new HashSet(fullSnapshotFut.snapshotOperation().cacheNames()), null).get(this.getTestTimeout());
        cache1 = client.cache(this.getOrCreateDefaultCacheName((Ignite)ignite));
        cache2 = client.cache("cache2");
        IgniteDbSnapshotSameTopologyTest.assertEquals((int)300, (int)cache1.size(new CachePeekMode[0]));
        IgniteDbSnapshotSameTopologyTest.assertEquals((int)300, (int)cache2.size(new CachePeekMode[0]));
        for (i = 0; i < 300; ++i) {
            IgniteDbSnapshotSameTopologyTest.assertEquals((Object)(-i), (Object)cache1.get((Object)i));
            IgniteDbSnapshotSameTopologyTest.assertEquals((Object)new AbstractSnapshotTest.TestValue(-i, i), (Object)cache2.get((Object)i));
        }
        ggClient.snapshot().restoreSnapshot(fullSnapshotFut.snapshotOperation().snapshotId(), new HashSet(fullSnapshotFut.snapshotOperation().cacheNames()), null).get(this.getTestTimeout());
        IgniteDbSnapshotSameTopologyTest.assertEquals((int)300, (int)cache1.size(new CachePeekMode[0]));
        SnapshotFuture fut = ggClient.snapshot().restoreSnapshot(fullSnapshotFut.snapshotOperation().snapshotId(), new HashSet(fullSnapshotFut.snapshotOperation().cacheNames()), null);
        try {
            IgniteDbSnapshotSameTopologyTest.assertEquals((int)300, (int)cache1.size(new CachePeekMode[0]));
        }
        catch (IgniteCacheRestartingException e) {
            e.restartFuture().get(this.getTestTimeout());
            IgniteDbSnapshotSameTopologyTest.assertEquals((int)300, (int)cache1.size(new CachePeekMode[0]));
        }
        fut.get(this.getTestTimeout());
    }

    @Test
    public void testIncrementalSnapshotFromClient() throws Exception {
        if (!this.clientStarted()) {
            System.out.println("Test is skipped - no clients in topology.");
            return;
        }
        IgniteCache cache1 = ignite.cache(this.getOrCreateDefaultCacheName((Ignite)ignite));
        IgniteCache cache2 = ignite.cache("cache2");
        SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
        SnapshotFuture fut = gg.snapshot().createFullSnapshot(null, null, createParams, null);
        fut.get(this.getTestTimeout());
        SnapshotOperationInfoImpl snapOpImpl = (SnapshotOperationInfoImpl)fut.snapshotOperation();
        IgniteDbSnapshotSameTopologyTest.assertTrue((String)"First snapshot should be full", (boolean)GridSnapshotOperationAttrs.getFullSnapshotParameter((GridSnapshotOperationEx)snapOpImpl.snapshotOperation()));
        IgniteEx client = this.grid("client");
        GridGain ggClient = (GridGain)client.plugin("GridGain");
        for (int i = 0; i < 300; ++i) {
            cache1.put((Object)i, (Object)(-i));
            cache2.put((Object)i, (Object)new AbstractSnapshotTest.TestValue(-i, i));
        }
        SnapshotFuture incFut = ggClient.snapshot().createSnapshot(null, null, createParams, null);
        incFut.get();
        snapOpImpl = (SnapshotOperationInfoImpl)incFut.snapshotOperation();
        IgniteDbSnapshotSameTopologyTest.assertFalse((String)"Second snapshot started by new client should be incremental", (boolean)GridSnapshotOperationAttrs.getFullSnapshotParameter((GridSnapshotOperationEx)snapOpImpl.snapshotOperation()));
        ggClient.snapshot().restoreSnapshot(fut.snapshotOperation().snapshotId(), fut.snapshotOperation().cacheNames(), null).get(this.getTestTimeout());
        for (int i = 0; i < 300; ++i) {
            IgniteDbSnapshotSameTopologyTest.assertEquals((Object)i, (Object)cache1.get((Object)i));
            IgniteDbSnapshotSameTopologyTest.assertEquals((Object)new AbstractSnapshotTest.TestValue(i, i), (Object)cache2.get((Object)i));
        }
    }

    @Test
    public void testListAndCheckDuplicateCacheName() throws Exception {
        IgniteCache cache = ignite.cache(this.getOrCreateDefaultCacheName((Ignite)ignite));
        Set caches = F.asSet((Object[])new String[]{this.getOrCreateDefaultCacheName((Ignite)ignite), "cache2", this.getOrCreateDefaultCacheName((Ignite)ignite)});
        SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
        SnapshotFuture snap1 = gg.snapshot().createFullSnapshot(null, null, createParams, null);
        snap1.get();
        SnapshotFuture snap2 = gg.snapshot().createFullSnapshot(caches, null, createParams, null);
        snap2.get();
        SnapshotFuture snap3 = gg.snapshot().createSnapshot(caches, null, createParams, null);
        snap3.get();
        List infos = gg.snapshot().list();
        IgniteDbSnapshotSameTopologyTest.assertEquals((int)3, (int)infos.size());
        List iss1 = (List)gg.snapshot().checkSnapshot(snap1.snapshotOperation().snapshotId(), null, false, null).get(this.getTestTimeout());
        IgniteDbSnapshotSameTopologyTest.assertTrue((boolean)F.isEmpty((Collection)iss1));
        List iss2 = (List)gg.snapshot().checkSnapshot(snap2.snapshotOperation().snapshotId(), null, false, null).get(this.getTestTimeout());
        IgniteDbSnapshotSameTopologyTest.assertTrue((boolean)F.isEmpty((Collection)iss2));
        List iss3 = (List)gg.snapshot().checkSnapshot(snap3.snapshotOperation().snapshotId(), null, false, null).get(this.getTestTimeout());
        IgniteDbSnapshotSameTopologyTest.assertTrue((boolean)F.isEmpty((Collection)iss3));
    }

    @Test
    public void testSnapshotWithConstantLoad() throws Exception {
        final IgniteCache cache = ignite2.cache(this.getOrCreateDefaultCacheName((Ignite)ignite));
        final AtomicBoolean finished = new AtomicBoolean();
        final ThreadLocalRandom rnd = ThreadLocalRandom.current();
        IgniteInternalFuture f = GridTestUtils.runAsync((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                while (!finished.get()) {
                    int key = rnd.nextInt(300);
                    int val = rnd.nextInt();
                    cache.put((Object)key, (Object)val);
                    U.sleep((long)1L);
                }
                return null;
            }
        });
        int iterations = 5;
        for (int k = 1; k <= iterations; ++k) {
            U.sleep((long)1000L);
            System.out.println("Iteration: " + k);
            SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
            Set<String> cacheNames = Collections.singleton(this.getOrCreateDefaultCacheName((Ignite)ignite));
            SnapshotFuture fut = gg.snapshot().createFullSnapshot(cacheNames, null, createParams, null);
            fut.get(this.getTestTimeout());
            IgniteDbSnapshotSameTopologyTest.assertEquals((int)k, (int)gg.snapshot().list().size());
        }
        assert (!f.isDone());
        finished.set(true);
        f.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReuseCacheProxyAfterRestore() throws Exception {
        final IgniteCache cache = ignite.cache("cache1");
        IgniteDbSnapshotSameTopologyTest.loadWithIntsAsync((Ignite)ignite, "cache1", 0, 1, 300).get(this.getTestTimeout());
        SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
        final SnapshotFuture fut = gg.snapshot().createFullSnapshot(Collections.singleton("cache1"), null, createParams, null);
        fut.get(this.getTestTimeout());
        final SnapshotFuture restoreFut = gg.snapshot().restoreSnapshot(fut.snapshotOperation().snapshotId(), Collections.singleton("cache1"), null);
        restoreFut.initFuture().get(this.getTestTimeout());
        final AtomicBoolean restoreFinished = new AtomicBoolean(false);
        GridTestUtils.runAsync((Runnable)new Runnable(){

            @Override
            public void run() {
                restoreFut.get();
                restoreFinished.set(true);
            }
        });
        while (!restoreFinished.get()) {
            try {
                cache.size(new CachePeekMode[0]);
            }
            catch (IgniteCacheRestartingException e) {
                if (e.restartFuture() instanceof IgniteFinishedFutureImpl) continue;
                e.restartFuture().get(this.getTestTimeout());
                break;
            }
        }
        IgniteDbSnapshotSameTopologyTest.assertEquals((int)300, (int)cache.size(new CachePeekMode[0]));
        Transaction tx = ignite.transactions().txStart();
        cache.put((Object)1, (Object)-1);
        restoreFut.get();
        IgniteInternalFuture asyncFut = GridTestUtils.runAsync((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                gg.snapshot().restoreSnapshot(fut.snapshotOperation().snapshotId(), Collections.singleton("cache1"), null).get(IgniteDbSnapshotSameTopologyTest.this.getTestTimeout());
                return null;
            }
        });
        try {
            IgniteDbSnapshotSameTopologyTest.assertTrue((boolean)GridTestUtils.waitForCondition((GridAbsPredicate)new GridAbsPredicate(){

                public boolean apply() {
                    try {
                        cache.get((Object)0);
                        return false;
                    }
                    catch (IgniteCacheRestartingException expected) {
                        return true;
                    }
                }
            }, (long)30000L));
            try {
                cache.put((Object)2, (Object)-2);
                assert (false);
            }
            catch (IgniteCacheRestartingException igniteCacheRestartingException) {
                // empty catch block
            }
            tx.commit();
        }
        finally {
            asyncFut.get();
        }
    }

    @Test
    public void testRestoreWithConcurrentAtomicCacheOperations() throws Exception {
        this.testRestoreWithConcurrentCacheOperations(true);
    }

    @Test
    public void testRestoreWithConcurrentTxCacheOperations() throws Exception {
        this.testRestoreWithConcurrentCacheOperations(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testRestoreWithConcurrentCacheOperations(boolean atomic) throws Exception {
        String cacheName = atomic ? "cache3" : this.getOrCreateDefaultCacheName((Ignite)ignite);
        final IgniteCache cache = ignite2.cache(cacheName);
        final AtomicBoolean finished = new AtomicBoolean();
        final AtomicInteger exceptionCount = new AtomicInteger();
        final AtomicReference unexpectedException = new AtomicReference();
        final ThreadLocalRandom rnd = ThreadLocalRandom.current();
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
        SnapshotFuture snapshotFut = gg.snapshot().createFullSnapshot(Collections.singleton(cacheName), null, createParams, null);
        snapshotFut.get();
        IgniteInternalFuture f = null;
        try {
            int iteration;
            f = GridTestUtils.runAsync((Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    while (!finished.get()) {
                        int key = rnd.nextInt(300);
                        int val = rnd.nextInt();
                        try {
                            cache.put((Object)key, (Object)val);
                        }
                        catch (IgniteCacheRestartingException e) {
                            exceptionCount.incrementAndGet();
                            e.restartFuture().get(IgniteDbSnapshotSameTopologyTest.this.getTestTimeout());
                        }
                        catch (Throwable th) {
                            unexpectedException.compareAndSet(null, th);
                        }
                    }
                    return null;
                }
            });
            int iterations = 5;
            for (iteration = 1; iteration <= iterations || exceptionCount.get() == 0; ++iteration) {
                U.sleep((long)1000L);
                System.out.println("Iteration: " + iteration);
                CountDownLatch restorePauseLatch = new CountDownLatch(1);
                CountDownLatch restoreStartLatch = this.nextRestoreShouldAwait(restorePauseLatch);
                SnapshotFuture restoreSnapshot = gg.snapshot().restoreSnapshot(snapshotFut.snapshotOperation().snapshotId(), Collections.singleton(cacheName), null);
                IgniteDbSnapshotSameTopologyTest.assertTrue((boolean)restoreStartLatch.await(this.getTestTimeout(), TimeUnit.MILLISECONDS));
                Thread.sleep(1100L);
                restorePauseLatch.countDown();
                restoreSnapshot.get();
                if (unexpectedException.get() == null) continue;
                ((Throwable)unexpectedException.get()).printStackTrace();
                IgniteDbSnapshotSameTopologyTest.fail((String)("Unexpected exception " + unexpectedException.get()));
            }
            assert (!f.isDone()) : f.result() + " " + f.error();
            IgniteDbSnapshotSameTopologyTest.assertTrue((exceptionCount.get() < iteration ? 1 : 0) != 0);
        }
        finally {
            finished.set(true);
        }
        f.get();
    }

    @Test
    public void testIncrementalSnapshotAfterClear() throws Exception {
        IgniteCache cache1 = ignite.cache(this.getOrCreateDefaultCacheName((Ignite)ignite));
        IgniteCache cache2 = ignite.cache("cache2");
        IgniteCache cache3 = ignite.cache("cache3");
        cache1.clear();
        cache2.clear();
        cache3.clear();
        for (int i = 0; i < 100; ++i) {
            cache1.put((Object)i, (Object)new AbstractSnapshotTest.TestValue(i, i));
            if (i < 10) {
                cache2.put((Object)i, (Object)new AbstractSnapshotTest.TestValue(i, i));
            }
            if (i >= 1) continue;
            cache3.put((Object)i, (Object)new AbstractSnapshotTest.TestValue(i, i));
        }
        IgniteDbSnapshotSameTopologyTest.assertEquals((int)100, (int)cache1.size(new CachePeekMode[0]));
        IgniteDbSnapshotSameTopologyTest.assertEquals((int)10, (int)cache2.size(new CachePeekMode[0]));
        IgniteDbSnapshotSameTopologyTest.assertEquals((int)1, (int)cache3.size(new CachePeekMode[0]));
        SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
        SnapshotFuture fut1 = gg.snapshot().createFullSnapshot(null, null, createParams, null);
        fut1.get();
        cache3.clear();
        IgniteDbSnapshotSameTopologyTest.assertEquals((int)0, (int)cache3.size(new CachePeekMode[0]));
        SnapshotFuture fut2 = gg.snapshot().createSnapshot(null, null, createParams, null);
        fut2.get();
        cache2.clear();
        SnapshotFuture fut3 = gg.snapshot().createSnapshot(null, null, createParams, null);
        fut3.get();
        gg.snapshot().restoreSnapshot(fut2.snapshotOperation().snapshotId(), null, null).get(this.getTestTimeout());
        IgniteDbSnapshotSameTopologyTest.assertEquals((int)100, (int)cache1.size(new CachePeekMode[0]));
        IgniteDbSnapshotSameTopologyTest.assertEquals((int)10, (int)cache2.size(new CachePeekMode[0]));
        IgniteDbSnapshotSameTopologyTest.assertNull((Object)cache3.get((Object)0));
        IgniteDbSnapshotSameTopologyTest.assertEquals((int)0, (int)cache3.size(new CachePeekMode[0]));
    }

    @Test
    public void testIncrementalAfterFullWithSkippedPartitions() throws Exception {
        IgniteCache cache = ignite.cache("cache1");
        cache.destroy();
        cache = ignite.getOrCreateCache(this.getCacheConfig("cache1"));
        for (int i = 0; i < 300; ++i) {
            if (i % 32 == 0) continue;
            cache.put((Object)i, (Object)i);
        }
        SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
        SnapshotFuture fullSnapshot = gg.snapshot().createFullSnapshot(null, null, createParams, null);
        fullSnapshot.get();
        IgniteDbSnapshotSameTopologyTest.loadWithIntsAsync((Ignite)ignite, "cache1", 1, 1).get(this.getTestTimeout());
        SnapshotFuture incSnapshot = gg.snapshot().createSnapshot(null, null, createParams, null);
        incSnapshot.get();
        cache.destroy();
        gg.snapshot().restoreSnapshot(incSnapshot.snapshotOperation().snapshotId(), null, null).get(this.getTestTimeout());
        cache = ignite.cache("cache1");
        for (int i = 0; i < 300; ++i) {
            Integer val = (Integer)cache.get((Object)i);
            IgniteDbSnapshotSameTopologyTest.assertNotNull((String)("index=" + i), (Object)val);
            IgniteDbSnapshotSameTopologyTest.assertEquals((String)("index=" + i), (int)(i + 1), (int)val);
        }
    }

    @Test
    public void testSimpleIncremental() throws Exception {
        IgniteCache cache = ignite.cache(this.getOrCreateDefaultCacheName((Ignite)ignite));
        SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
        SnapshotFuture fut1 = gg.snapshot().createFullSnapshot(Collections.singleton(this.getOrCreateDefaultCacheName((Ignite)ignite)), null, createParams, null);
        fut1.get();
        SnapshotFuture fut2 = gg.snapshot().createSnapshot(Collections.singleton(this.getOrCreateDefaultCacheName((Ignite)ignite)), null, createParams, null);
        fut2.get();
        this.load((Ignite)ignite, 100);
        SnapshotFuture fut3 = gg.snapshot().createSnapshot(Collections.singleton(this.getOrCreateDefaultCacheName((Ignite)ignite)), null, createParams, null);
        fut3.get();
        cache.destroy();
        SnapshotOperationInfoImpl snapOpImpl = (SnapshotOperationInfoImpl)fut2.snapshotOperation();
        IgniteDbSnapshotSameTopologyTest.assertFalse((boolean)GridSnapshotOperationAttrs.getFullSnapshotParameter((GridSnapshotOperationEx)snapOpImpl.snapshotOperation()));
        gg.snapshot().restoreSnapshot(fut2.snapshotOperation().snapshotId(), Collections.singleton(this.getOrCreateDefaultCacheName((Ignite)ignite)), null).get(this.getTestTimeout());
        gg.snapshot().createFullSnapshot(Collections.singleton(this.getOrCreateDefaultCacheName((Ignite)ignite)), null, createParams, null).get(this.getTestTimeout());
        cache = ignite.cache(this.getOrCreateDefaultCacheName((Ignite)ignite));
        for (int i = 0; i < 300; ++i) {
            Integer val = (Integer)cache.get((Object)i);
            IgniteDbSnapshotSameTopologyTest.assertNotNull((String)("index=" + i), (Object)val);
            IgniteDbSnapshotSameTopologyTest.assertEquals((String)("index=" + i), (int)i, (int)val);
        }
        IgniteDbSnapshotSameTopologyTest.loadWithIntsAsync((Ignite)ignite, this.getOrCreateDefaultCacheName((Ignite)ignite), 1, 1).get(this.getTestTimeout());
        SnapshotFuture fut4 = gg.snapshot().createSnapshot(Collections.singleton(this.getOrCreateDefaultCacheName((Ignite)ignite)), null, createParams, null);
        fut4.get();
        cache.destroy();
        snapOpImpl = (SnapshotOperationInfoImpl)fut4.snapshotOperation();
        IgniteDbSnapshotSameTopologyTest.assertFalse((boolean)GridSnapshotOperationAttrs.getFullSnapshotParameter((GridSnapshotOperationEx)snapOpImpl.snapshotOperation()));
        gg.snapshot().restoreSnapshot(fut4.snapshotOperation().snapshotId(), Collections.singleton(this.getOrCreateDefaultCacheName((Ignite)ignite)), null).get(this.getTestTimeout());
        cache = ignite.cache(this.getOrCreateDefaultCacheName((Ignite)ignite));
        for (int i = 0; i < 300; ++i) {
            Integer val = (Integer)cache.get((Object)i);
            IgniteDbSnapshotSameTopologyTest.assertNotNull((String)("index=" + i), (Object)val);
            IgniteDbSnapshotSameTopologyTest.assertEquals((String)("index=" + i), (int)(i + 1), (int)val);
        }
    }

    @Test
    public void testCollectSnapshotInfos() throws Exception {
        GridCacheSnapshotManager snapshotMgr = (GridCacheSnapshotManager)ignite.context().cache().context().snapshot();
        IgniteCache cache = ignite.cache(this.getOrCreateDefaultCacheName((Ignite)ignite));
        SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
        SnapshotFuture fut1 = gg.snapshot().createFullSnapshot(Collections.singleton(this.getOrCreateDefaultCacheName((Ignite)ignite)), null, createParams, null);
        fut1.get();
        long snapshotId1 = fut1.snapshotOperation().snapshotId();
        for (int i = 0; i < 300; ++i) {
            cache.put((Object)i, (Object)(-i));
        }
        SnapshotFuture fut2 = gg.snapshot().createSnapshot(Collections.singleton(this.getOrCreateDefaultCacheName((Ignite)ignite)), null, createParams, null);
        fut2.get();
        long snapshotId2 = fut2.snapshotOperation().snapshotId();
        for (int i = 0; i < 300; ++i) {
            cache.put((Object)i, (Object)0);
        }
        SnapshotFuture fut3 = gg.snapshot().createSnapshot(Collections.singleton(this.getOrCreateDefaultCacheName((Ignite)ignite)), null, createParams, null);
        fut3.get();
        long snapshotId3 = fut3.snapshotOperation().snapshotId();
        List<Long> snapshotIds = Arrays.asList(snapshotId1, snapshotId2, snapshotId3);
        List snapshotInfos = snapshotMgr.getSnapshotList(null);
        IgniteDbSnapshotSameTopologyTest.assertEquals((int)3, (int)snapshotInfos.size());
        for (SnapshotInfo snapshotInfo : snapshotInfos) {
            IgniteDbSnapshotSameTopologyTest.assertTrue((boolean)snapshotIds.contains(snapshotInfo.snapshotId()));
        }
        snapshotIds = Arrays.asList(1L, 2L, 3L, 5L, 8L);
        for (Long snapshotId : snapshotIds) {
            IgniteDbSnapshotSameTopologyTest.assertNull((Object)snapshotMgr.getSnapshotInfo(snapshotId.longValue(), null));
        }
        snapshotIds = Arrays.asList(snapshotId1, snapshotId2);
        for (Long snapshotId : snapshotIds) {
            SnapshotInfoExtended info = snapshotMgr.getSnapshotInfo(snapshotId.longValue(), null);
            IgniteDbSnapshotSameTopologyTest.assertNotNull((Object)info);
            IgniteDbSnapshotSameTopologyTest.assertEquals((long)snapshotId, (long)info.snapshotId());
        }
    }

    @Test
    public void testThatWeTruncateFilesBeforeRestoreSnapshot() throws Exception {
        int i;
        IgniteEx affNode = this.getSomeAffinityNode();
        IgniteCache cache = affNode.cache(this.getOrCreateDefaultCacheName((Ignite)ignite));
        SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
        SnapshotFuture fut1 = gg.snapshot().createFullSnapshot(Collections.singleton(this.getOrCreateDefaultCacheName((Ignite)ignite)), null, createParams, null);
        fut1.get();
        int locPart = 0;
        Affinity aff = affNode.affinity(this.getOrCreateDefaultCacheName((Ignite)ignite));
        while (!aff.mapPartitionToNode(locPart).id().equals(this.getSomeAffinityNode().cluster().localNode().id())) {
            ++locPart;
        }
        int part0 = affNode.context().cache().context().pageStore().pages(CACHE_ID, locPart);
        for (int i2 = 0; i2 < 450; ++i2) {
            cache.put((Object)i2, (Object)(-i2));
        }
        SnapshotFuture fut2 = gg.snapshot().createSnapshot(Collections.singleton(this.getOrCreateDefaultCacheName((Ignite)ignite)), null, createParams, null);
        fut2.get();
        gg.snapshot().restoreSnapshot(fut1.snapshotOperation().snapshotId(), Collections.singleton(this.getOrCreateDefaultCacheName((Ignite)ignite)), null).get(this.getTestTimeout());
        IgnitePageStoreManager ignitePageStoreManager = affNode.context().cache().context().pageStore();
        ignitePageStoreManager.ensure(CACHE_ID, 0);
        IgniteDbSnapshotSameTopologyTest.assertEquals((int)part0, (int)ignitePageStoreManager.pages(CACHE_ID, locPart));
        for (i = 0; i < 300; ++i) {
            IgniteDbSnapshotSameTopologyTest.assertNotNull((Object)cache.get((Object)i));
            IgniteDbSnapshotSameTopologyTest.assertEquals((int)i, (int)((Integer)cache.get((Object)i)));
        }
        for (i = 300; i < 450; ++i) {
            IgniteDbSnapshotSameTopologyTest.assertNull((Object)cache.get((Object)i));
        }
    }

    @Test
    public void testConcurrentWritesFull() throws Exception {
        this.checkConcurrentWrites(false);
    }

    @Test
    public void testConcurrentWritesIncremental() throws Exception {
        this.checkConcurrentWrites(true);
    }

    private void checkConcurrentWrites(boolean incremental) throws Exception {
        String cacheName = "cache2";
        IgniteCache cache = ignite.cache(cacheName);
        HashMap<Integer, AbstractSnapshotTest.TestValue> curr = new HashMap<Integer, AbstractSnapshotTest.TestValue>();
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
        SnapshotFuture fut = gg.snapshot().createFullSnapshot(Collections.singleton(cacheName), null, createParams, null);
        LinkedHashMap snapshots = new LinkedHashMap();
        snapshots.put(fut.snapshotOperation().snapshotId(), new HashMap(curr));
        while (snapshots.size() < 5) {
            int updates;
            fut.initFuture().get(this.getTestTimeout());
            for (updates = 0; !fut.isDone() || updates < 50; ++updates) {
                int key = rnd.nextInt(600);
                AbstractSnapshotTest.TestValue val = new AbstractSnapshotTest.TestValue(key, rnd.nextInt());
                cache.put((Object)key, (Object)val);
                curr.put(key, val);
            }
            fut.get(this.getTestTimeout());
            IgniteDbSnapshotSameTopologyTest.assertTrue((boolean)fut.isDone());
            if (snapshots.size() < 5) {
                SnapshotFuture snapshotFuture = fut = incremental ? gg.snapshot().createSnapshot(Collections.singleton(cacheName), null, createParams, null) : gg.snapshot().createFullSnapshot(Collections.singleton(cacheName), null, createParams, null);
            }
            if (updates <= 0) continue;
            snapshots.put(fut.snapshotOperation().snapshotId(), new HashMap(curr));
        }
        fut.get(this.getTestTimeout());
        for (SnapshotInfo snapshotInfo : gg.snapshot().list()) {
            Map snapshot = (Map)snapshots.get(snapshotInfo.snapshotId());
            gg.snapshot().restoreSnapshot(snapshotInfo.snapshotId(), Collections.singleton(cacheName), null).get(this.getTestTimeout());
            cache = this.ignite(0).cache(cacheName);
            for (Map.Entry entry : snapshot.entrySet()) {
                IgniteDbSnapshotSameTopologyTest.assertEquals(entry.getValue(), (Object)cache.get(entry.getKey()));
            }
        }
    }

    @Test
    public void testSnapshotUnderLoad() throws Exception {
        int i;
        final IgniteCache cache1 = ignite.cache(this.getOrCreateDefaultCacheName((Ignite)ignite));
        final IgniteCache cache2 = ignite.cache("cache2");
        try (IgniteDataStreamer streamer = ignite.dataStreamer(this.getOrCreateDefaultCacheName((Ignite)ignite));){
            streamer.allowOverwrite(true);
            for (i = 0; i < 20000; ++i) {
                streamer.addData((Object)i, (Object)i);
            }
        }
        streamer = ignite.dataStreamer("cache2");
        var4_4 = null;
        try {
            streamer.allowOverwrite(true);
            for (i = 0; i < 20000; ++i) {
                streamer.addData((Object)i, (Object)i);
            }
        }
        catch (Throwable i2) {
            var4_4 = i2;
            throw i2;
        }
        finally {
            if (streamer != null) {
                if (var4_4 != null) {
                    try {
                        streamer.close();
                    }
                    catch (Throwable i2) {
                        var4_4.addSuppressed(i2);
                    }
                } else {
                    streamer.close();
                }
            }
        }
        ArrayList<Long> snapshots = new ArrayList<Long>();
        final AtomicBoolean stop = new AtomicBoolean();
        int initVal = 200000;
        Thread thread1 = new Thread(new Runnable(){

            @Override
            public void run() {
                int i = 200000;
                ThreadLocalRandom rnd = ThreadLocalRandom.current();
                while (!stop.get()) {
                    cache1.put((Object)i++, (Object)i);
                    if (i > 400000) {
                        i = 200000;
                    }
                    if (i % 1000 != 0) continue;
                    for (int j = 0; j < 100; ++j) {
                        int key = rnd.nextInt(i);
                        int val = rnd.nextInt();
                        cache1.put((Object)key, (Object)val);
                    }
                }
            }
        });
        Thread thread2 = new Thread(new Runnable(){

            @Override
            public void run() {
                int i = 200000;
                ThreadLocalRandom rnd = ThreadLocalRandom.current();
                while (!stop.get()) {
                    cache2.put((Object)i++, (Object)i);
                    if (i > 400000) {
                        i = 200000;
                    }
                    if (i % 1000 != 0) continue;
                    for (int j = 0; j < 100; ++j) {
                        int key = rnd.nextInt(i);
                        int val = rnd.nextInt();
                        cache2.put((Object)key, (Object)val);
                    }
                }
            }
        });
        thread1.start();
        thread2.start();
        SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
        SnapshotFuture future = gg.snapshot().createFullSnapshot(null, null, createParams, null);
        future.get();
        snapshots.add(future.snapshotOperation().snapshotId());
        future = gg.snapshot().createSnapshot(Collections.singleton("cache2"), null, createParams, null);
        future.get();
        snapshots.add(future.snapshotOperation().snapshotId());
        stop.set(true);
        thread1.join();
        thread2.join();
        for (Long id : snapshots) {
            gg.snapshot().restoreSnapshot(id.longValue(), null, null).get(this.getTestTimeout());
            cache1.put((Object)1, (Object)1);
            cache1.clear();
            cache2.put((Object)2, (Object)2);
            cache2.clear();
        }
    }

    @Test
    public void testCheckSnapshotMetadataMessageMerge() throws IgniteCheckedException {
        Map<Integer, Integer> map = Collections.singletonMap(1, 32);
        BitSet set1 = new BitSet();
        BitSet set2 = new BitSet();
        for (int i = 0; i < 32; ++i) {
            if (i % 2 == 0) {
                set1.set(i);
                continue;
            }
            set2.set(i);
        }
        ResultOfOperationWithSnapshot merged = SnapshotCheckFuture.merge((ResultOfOperationWithSnapshot)new ResultOfOperationWithSnapshot(map, Collections.singletonMap(1, set1), Collections.emptyList()), (CheckSnapshotMetadataMessage)new CheckSnapshotMetadataMessage(map, Collections.singletonMap(1, set2)), (ClusterNode)((ClusterNode)Mockito.mock(ClusterNode.class)), Collections.emptyList(), new ArrayList());
        IgniteDbSnapshotSameTopologyTest.assertEquals((int)32, (int)((BitSet)merged.partitionIdsForCacheGroup().get(1)).cardinality());
    }

    @Test
    public void testChecking_GoodScenario() throws Exception {
        SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
        SnapshotFuture fut = gg.snapshot().createFullSnapshot(null, null, createParams, null);
        fut.get(this.getTestTimeout());
        List issues = (List)gg.snapshot().checkSnapshot(fut.snapshotOperation().snapshotId(), null, false, null).get(this.getTestTimeout());
        MatcherAssert.assertThat((Object)issues, (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }

    @Test
    public void testCheckingNotExistingSnapshotId() throws Exception {
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        try {
            gg.snapshot().checkSnapshot(-1L, null, false, null).get(this.getTestTimeout());
            IgniteDbSnapshotSameTopologyTest.fail();
        }
        catch (Exception ex) {
            IgniteDbSnapshotSameTopologyTest.assertTrue((boolean)ex.getMessage().contains("Snapshot does not exist [id="));
        }
    }

    @Test
    public void testMovingNotExistingSnapshotId() throws Exception {
        try {
            gg.snapshot().moveSnapshot(-1L, U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"temp", (boolean)false), null).get(this.getTestTimeout());
            IgniteDbSnapshotSameTopologyTest.fail();
        }
        catch (Exception ex) {
            IgniteDbSnapshotSameTopologyTest.assertTrue((boolean)ex.getMessage().contains("Snapshot does not exist [id="));
        }
    }

    @Test
    public void testRestoringNotExistingSnapshotId() throws Exception {
        try {
            gg.snapshot().restoreSnapshot(-1L, null, null).get(this.getTestTimeout());
            IgniteDbSnapshotSameTopologyTest.fail();
        }
        catch (Exception ex) {
            IgniteDbSnapshotSameTopologyTest.assertTrue((boolean)ex.getMessage().contains("Snapshot does not exist [id="));
        }
    }

    @Test
    public void testCreatingSnapshotForNotExistingCaches() throws Exception {
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        String cache1 = "1cache";
        String cache2 = "2cache";
        SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
        try {
            gg.snapshot().createFullSnapshot(F.asSet((Object[])new String[]{cache1, cache2}), null, createParams, null).get(this.getTestTimeout());
            IgniteDbSnapshotSameTopologyTest.fail();
        }
        catch (Exception ex) {
            IgniteDbSnapshotSameTopologyTest.assertTrue((boolean)ex.getMessage().contains(cache1));
            IgniteDbSnapshotSameTopologyTest.assertTrue((boolean)ex.getMessage().contains(cache2));
        }
        gg.snapshot().createFullSnapshot(null, null, createParams, null).get(this.getTestTimeout());
    }

    @Test
    public void testRestoringSnapshotForNotExistingCaches() throws Exception {
        SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
        SnapshotFuture future = gg.snapshot().createFullSnapshot(null, null, createParams, null);
        future.get();
        String cache1 = "1cache";
        String cache2 = "2cache";
        try {
            gg.snapshot().restoreSnapshot(future.snapshotOperation().snapshotId(), F.asSet((Object[])new String[]{cache1, cache2}), null).get(this.getTestTimeout());
            IgniteDbSnapshotSameTopologyTest.fail();
        }
        catch (Exception ex) {
            IgniteDbSnapshotSameTopologyTest.assertTrue((boolean)ex.getMessage().contains(cache1));
            IgniteDbSnapshotSameTopologyTest.assertTrue((boolean)ex.getMessage().contains(cache2));
        }
        gg.snapshot().restoreSnapshot(future.snapshotOperation().snapshotId(), null, null).get(this.getTestTimeout());
    }

    @Test
    public void testChecking_NoPreviousSnapshot() throws Exception {
        IgniteCache cache1 = ignite.cache(this.getOrCreateDefaultCacheName((Ignite)ignite));
        IgniteCache cache2 = ignite.cache("cache2");
        SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
        SnapshotFuture fut = gg.snapshot().createFullSnapshot(null, null, createParams, null);
        fut.get(this.getTestTimeout());
        for (int i = 0; i < 150; ++i) {
            cache1.put((Object)i, (Object)(-i));
            cache2.put((Object)i, (Object)new AbstractSnapshotTest.TestValue(i, -i));
        }
        SnapshotFuture fut2 = gg.snapshot().createSnapshot(null, null, createParams, null);
        fut2.get();
        for (String s : this.snapshotFolders()) {
            File snapshotDir = U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)s, (boolean)false);
            File fullSnapDir = new File(snapshotDir, FileDatabaseSnapshotSpi.generateSnapshotDirName((long)fut.snapshotOperation().snapshotId(), null));
            U.delete((File)fullSnapDir);
        }
        List issues = (List)gg.snapshot().checkSnapshot(fut2.snapshotOperation().snapshotId(), null, false, null).get(this.getTestTimeout());
        IgniteDbSnapshotSameTopologyTest.assertFalse((boolean)issues.isEmpty());
        boolean found = false;
        for (SnapshotIssue issue : issues) {
            found |= issue.getIssue().startsWith("Failed to find previous snapshot: ");
        }
        IgniteDbSnapshotSameTopologyTest.assertTrue((boolean)found);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testChecking_NoDataFromOneNode() throws Exception {
        IgniteCache cache = ignite.getOrCreateCache(this.getCacheConfig("cache1").setName("testChecking_NoDataFromOneNode").setBackups(this.getBackupCount()));
        try {
            try (IgniteDataStreamer ldr = ignite.dataStreamer("testChecking_NoDataFromOneNode");){
                HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
                for (int i = 0; i < 300; ++i) {
                    map.put(i, i);
                }
                ldr.addData(map);
            }
            SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
            SnapshotFuture fut = gg.snapshot().createFullSnapshot(null, null, createParams, null);
            fut.get(this.getTestTimeout());
            this.removeFileOfOneNode(fut.snapshotOperation().snapshotId());
            List issues = (List)gg.snapshot().checkSnapshot(fut.snapshotOperation().snapshotId(), null, false, null).get(this.getTestTimeout());
            List issuesStr = issues.stream().map(SnapshotIssue::getIssue).collect(Collectors.toList());
            MatcherAssert.assertThat(issuesStr, (Matcher)Matchers.hasItem((Matcher)Matchers.containsString((String)"Not enough partitions in current topology to complete restore operation")));
        }
        finally {
            cache.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testChecking_NotEnoughPartitions() throws Exception {
        if (this.nodeCount() < 2) {
            return;
        }
        IgniteCache cache = ignite.getOrCreateCache(this.getCacheConfig("cache1").setName("testChecking_NotEnoughPartitions").setBackups(this.getBackupCount()));
        try {
            IgniteDbSnapshotSameTopologyTest.loadWithIntsAsync((Ignite)ignite, "testChecking_NotEnoughPartitions", 0, 300).get(this.getTestTimeout());
            SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
            SnapshotFuture fut = gg.snapshot().createFullSnapshot(null, null, createParams, null);
            fut.get(this.getTestTimeout());
            this.removeFileOfOneNode(fut.snapshotOperation().snapshotId());
            GridCacheSnapshotManager snapshotMgr = (GridCacheSnapshotManager)ignite.context().cache().context().snapshot();
            FileSnapshot snapshot = (FileSnapshot)snapshotMgr.snapshotSpi().snapshot(fut.snapshotOperation().snapshotId(), null, null, true, snapshotMgr.resolveSecurityLevel(), false);
            IgniteDbSnapshotSameTopologyTest.assertNotNull((Object)snapshot);
            SnapshotMetadataV2 metadata = snapshot.metadata();
            IgniteDbSnapshotSameTopologyTest.assertNotNull((Object)metadata);
            String[] expectedErrorMessages = (String[])this.getPartitionsForGroups(ignite, metadata).entrySet().stream().filter(e -> !((Integer)((T2)e.getValue()).get1()).equals(((Set)((T2)e.getValue()).get2()).size())).map(e -> "Not enough partitions in current topology to complete restore operation for grpId=" + e.getKey()).toArray(String[]::new);
            List issues = (List)gg.snapshot().checkSnapshot(fut.snapshotOperation().snapshotId(), null, false, null).get(this.getTestTimeout());
            List issuesStr = issues.stream().map(SnapshotIssue::getIssue).collect(Collectors.toList());
            IgniteDbSnapshotSameTopologyTest.assertEquals((int)1, (int)issuesStr.size());
            String issueStr = (String)issuesStr.get(0);
            IgniteDbSnapshotSameTopologyTest.assertTrue((!F.isEmpty((String)issueStr) ? 1 : 0) != 0);
            for (String expectedErrorMessage : expectedErrorMessages) {
                IgniteDbSnapshotSameTopologyTest.assertTrue((boolean)issueStr.contains(expectedErrorMessage));
            }
        }
        finally {
            cache.destroy();
        }
    }

    private Map<Integer, T2<Integer, Set<Integer>>> getPartitionsForGroups(IgniteEx ig, SnapshotMetadataV2 metadata) {
        HashMap<Integer, T2<Integer, Set<Integer>>> partitionsPerGrp = new HashMap<Integer, T2<Integer, Set<Integer>>>();
        for (Integer grpId : metadata.cacheGroupIds()) {
            CacheSnapshotMetadata cacheSnapshotMetadata = (CacheSnapshotMetadata)metadata.cacheGroupsMetadata().get(grpId);
            Map partCnt = cacheSnapshotMetadata.partitionSizesPerNode();
            for (Map.Entry e0 : partCnt.entrySet()) {
                Integer part = (Integer)e0.getKey();
                Map partSizesForConsistentIds = (Map)e0.getValue();
                if (F.isEmpty((Map)partSizesForConsistentIds) || !partSizesForConsistentIds.containsKey(U.maskForFileName((CharSequence)ig.localNode().consistentId().toString()))) continue;
                T2 parts = (T2)partitionsPerGrp.get(grpId);
                if (parts == null) {
                    if (cacheSnapshotMetadata.cacheConfigurations().isEmpty()) continue;
                    parts = new T2((Object)((CacheConfiguration)cacheSnapshotMetadata.cacheConfigurations().iterator().next()).getAffinity().partitions(), new HashSet());
                    partitionsPerGrp.put(grpId, (T2<Integer, Set<Integer>>)parts);
                }
                ((Set)parts.get2()).add(part);
            }
        }
        return partitionsPerGrp;
    }

    @Test
    public void testChecking_NoPartitions() throws Exception {
        SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
        SnapshotFuture fut = gg.snapshot().createFullSnapshot(null, null, createParams, null);
        fut.get(this.getTestTimeout());
        for (String snapshotDirectory : this.snapshotFolders()) {
            File snapshotDir = U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)snapshotDirectory, (boolean)false);
            File fullSnapDir = new File(snapshotDir, FileDatabaseSnapshotSpi.generateSnapshotDirName((long)fut.snapshotOperation().snapshotId(), null));
            File[] files = fullSnapDir.listFiles();
            if (files == null) continue;
            for (File consistentIdDir : files) {
                File cacheDir;
                if (consistentIdDir.isFile() || !(cacheDir = new File(consistentIdDir, Integer.toString(CU.cacheId((String)this.getOrCreateDefaultCacheName((Ignite)ignite))))).exists()) continue;
                IgniteDbSnapshotSameTopologyTest.assertTrue((boolean)cacheDir.isDirectory());
                CompressionOption compressionOption = gg.configuration().getSnapshotConfiguration().getCompressionOption();
                for (File file : cacheDir.listFiles()) {
                    if (!file.isFile() || !file.getName().startsWith("part-1")) continue;
                    switch (compressionOption) {
                        case ZIP: {
                            if (this.grid(0).configuration().getEncryptionSpi() instanceof NoopEncryptionSpi) {
                                IgniteDbSnapshotSameTopologyTest.assertTrue((boolean)AbstractSnapshotTest.isZipFile((SnapshotPath)new FsSnapshotPath(file)));
                                break;
                            }
                            IgniteDbSnapshotSameTopologyTest.assertFalse((boolean)AbstractSnapshotTest.isZipFile((SnapshotPath)new FsSnapshotPath(file)));
                            break;
                        }
                        case NONE: {
                            IgniteDbSnapshotSameTopologyTest.assertFalse((boolean)AbstractSnapshotTest.isZipFile((SnapshotPath)new FsSnapshotPath(file)));
                        }
                    }
                    IgniteDbSnapshotSameTopologyTest.assertTrue((boolean)file.delete());
                }
            }
        }
        List issues = (List)gg.snapshot().checkSnapshot(fut.snapshotOperation().snapshotId(), null, false, null).get(this.getTestTimeout());
        IgniteDbSnapshotSameTopologyTest.assertFalse((String)issues.toString(), (boolean)issues.isEmpty());
        boolean found = false;
        for (SnapshotIssue issue : issues) {
            found |= issue.getIssue().startsWith("Partition was not found!");
        }
        IgniteDbSnapshotSameTopologyTest.assertTrue((boolean)found);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testChecking_NoMappedPartitions() throws Exception {
        ArrayList<CacheConfiguration> cfgs = new ArrayList<CacheConfiguration>();
        cfgs.add(new CacheConfiguration("not_mapped_cache1").setGroupName("not_mapped_grp").setCacheMode(CacheMode.PARTITIONED).setNodeFilter((IgnitePredicate)new AbstractSnapshotTest.EmptyNodeFilter()).setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 4)));
        cfgs.add(new CacheConfiguration("not_mapped_cache2").setCacheMode(CacheMode.PARTITIONED).setNodeFilter((IgnitePredicate)new AbstractSnapshotTest.EmptyNodeFilter()).setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 4)));
        Collection caches = ignite.createCaches(cfgs);
        try {
            SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
            SnapshotFuture fut = gg.snapshot().createFullSnapshot(null, null, createParams, null);
            fut.get(this.getTestTimeout());
            List issues = (List)gg.snapshot().checkSnapshot(fut.snapshotOperation().snapshotId(), null, false, null).get(this.getTestTimeout());
            List issueMessages = issues.stream().map(SnapshotIssue::getIssue).collect(Collectors.toList());
            MatcherAssert.assertThat(issueMessages, (Matcher)Matchers.hasItem((Matcher)Matchers.containsString((String)"Assembled snapshot from all nodes doesn't contain partitions: ")));
            IgniteDbSnapshotSameTopologyTest.assertEquals((int)cfgs.size(), (int)issueMessages.size());
            List cacheNames = issues.stream().map(SnapshotIssue::getCacheName).collect(Collectors.toList());
            MatcherAssert.assertThat(cacheNames, (Matcher)Matchers.allOf((Matcher)Matchers.hasItem((Object)"not_mapped_grp [id = -1343101499, caches = [not_mapped_cache1 [id = -551927793]]]"), (Matcher)Matchers.hasItem((Object)"not_mapped_cache2 [id = -551927792]]")));
        }
        finally {
            caches.forEach(IgniteCache::destroy);
        }
    }

    @Test
    public void testRestoring_NoPartitions() throws Exception {
        SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
        SnapshotFuture fut = gg.snapshot().createFullSnapshot(null, null, createParams, null);
        fut.get(this.getTestTimeout());
        for (String snapshotDirectory : this.snapshotFolders()) {
            File snapshotDir = U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)snapshotDirectory, (boolean)false);
            File fullSnapDir = new File(snapshotDir, FileDatabaseSnapshotSpi.generateSnapshotDirName((long)fut.snapshotOperation().snapshotId(), null));
            File[] files = fullSnapDir.listFiles();
            if (files == null) continue;
            for (File consistentIdDir : files) {
                File cacheDir;
                if (consistentIdDir.isFile() || !(cacheDir = new File(consistentIdDir, Integer.toString(CU.cacheId((String)this.getOrCreateDefaultCacheName((Ignite)ignite))))).exists()) continue;
                IgniteDbSnapshotSameTopologyTest.assertTrue((boolean)cacheDir.isDirectory());
                for (File file : cacheDir.listFiles()) {
                    if (!file.isFile() || !file.getName().startsWith("part-1") || file.length() <= 0L) continue;
                    boolean delete = file.delete();
                    IgniteDbSnapshotSameTopologyTest.assertTrue((boolean)delete);
                }
            }
        }
        try {
            SnapshotFuture future = gg.snapshot().restoreSnapshot(fut.snapshotOperation().snapshotId(), null, null);
            future.get();
            IgniteDbSnapshotSameTopologyTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testCheckingSnapshotIterator() throws Exception {
        IgniteDbSnapshotSameTopologyTest.assertEquals((int)0, (int)gg.snapshot().list().size());
        SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
        SnapshotFuture fut = gg.snapshot().createFullSnapshot(null, null, createParams, null);
        fut.get(this.getTestTimeout());
        GridCacheSnapshotManager snapMgr = (GridCacheSnapshotManager)this.getSomeAffinityNode().context().cache().context().snapshot();
        DatabaseSnapshotSpi spi = snapMgr.snapshotSpi();
        ArrayList list = new ArrayList();
        spi.localSnapshots(false).iterator().forEachRemaining(list::add);
        IgniteDbSnapshotSameTopologyTest.assertEquals((int)1, (int)list.size());
        fut = gg.snapshot().createFullSnapshot(null, null, createParams, null);
        fut.get(this.getTestTimeout());
        list.clear();
        spi.localSnapshots(false).iterator().forEachRemaining(list::add);
        IgniteDbSnapshotSameTopologyTest.assertEquals((int)2, (int)list.size());
        gg.snapshot().deleteSnapshot(((SnapshotMetadataV2)list.remove(0)).id(), (SnapshotUpdateOperationParams)null, null).get(this.getTestTimeout());
        list.clear();
        spi.localSnapshots(false).iterator().forEachRemaining(list::add);
        IgniteDbSnapshotSameTopologyTest.assertEquals((int)1, (int)list.size());
        spi.localSnapshots(false).iterator().forEachRemaining(e -> {
            Void cfr_ignored_0 = (Void)gg.snapshot().deleteSnapshot(e.id(), (SnapshotUpdateOperationParams)null, null).get(this.getTestTimeout());
        });
        list.clear();
        spi.localSnapshots(false).iterator().forEachRemaining(list::add);
        IgniteDbSnapshotSameTopologyTest.assertEquals((int)0, (int)list.size());
    }

    @Test
    public void testChecking_ChecksumIssue() throws Exception {
        SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
        SnapshotFuture fut = gg.snapshot().createFullSnapshot(null, null, createParams, null);
        fut.get(this.getTestTimeout());
        for (String snapshotDirectory : this.snapshotFolders()) {
            File snapshotDir = U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)snapshotDirectory, (boolean)false);
            File fullSnapDir = new File(snapshotDir, FileDatabaseSnapshotSpi.generateSnapshotDirName((long)fut.snapshotOperation().snapshotId(), null));
            File[] files = fullSnapDir.listFiles();
            if (files == null) continue;
            for (File consistentIdDir : files) {
                if (consistentIdDir.isFile()) continue;
                for (File cacheDir : consistentIdDir.listFiles()) {
                    if (cacheDir.isFile()) continue;
                    for (File file : cacheDir.listFiles()) {
                        if (!file.isFile() || !file.getName().startsWith("part")) continue;
                        this.corruptSnapshotFile(file);
                    }
                }
            }
        }
        List issues = (List)gg.snapshot().checkSnapshot(fut.snapshotOperation().snapshotId(), null, false, null).get(this.getTestTimeout());
        IgniteDbSnapshotSameTopologyTest.assertFalse((boolean)issues.isEmpty());
        boolean found = false;
        for (SnapshotIssue issue : issues) {
            found |= issue.getIssue().startsWith(this.pageContentCorruptedMessage(issue.getCacheName()));
        }
        IgniteDbSnapshotSameTopologyTest.assertTrue((boolean)found);
    }

    @NotNull
    private String pageContentCorruptedMessage(String cachceName) {
        if (ignite.context().cache().cacheGroup(CU.cacheId((String)cachceName)).config().isEncryptionEnabled()) {
            return "Content of encrypted page is broken.";
        }
        return "Page is corrupted: cache group - ";
    }

    @Test
    public void testChecking_CacheAreNotContainedInSnapshot_BecauseItDoesNotExist() {
        this.checkSnapshotFailForCacheName("NotExistedCacheName");
    }

    @Test
    public void testChecking_CacheAreNotContainedInSnapshot_BecauseSnapshotWasForOtherCache() {
        this.checkSnapshotFailForCacheName("cache2");
    }

    private void checkSnapshotFailForCacheName(String checkingCacheName) {
        SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
        SnapshotFuture fut = gg.snapshot().createFullSnapshot((Set)ImmutableSet.of((Object)this.getOrCreateDefaultCacheName((Ignite)ignite)), null, createParams, null);
        fut.get(this.getTestTimeout());
        try {
            gg.snapshot().checkSnapshot(fut.snapshotOperation().snapshotId(), null, (Set)ImmutableSet.of((Object)checkingCacheName), false, false, null).get(this.getTestTimeout());
            IgniteDbSnapshotSameTopologyTest.fail((String)"check snapshot should be fail because snapshot doesn't have given cache");
        }
        catch (IgniteException ex) {
            MatcherAssert.assertThat((Object)ex.getMessage(), (Matcher)Matchers.is((Matcher)Matchers.startsWith((String)"Caches (cache groups) are not contained in snapshot ")));
        }
    }

    @Test
    public void testChecking_NotAllCachesInGroupWasRequestedToCheck_WhenForceIsFalse() {
        SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
        SnapshotFuture fut = gg.snapshot().createFullSnapshot((Set)ImmutableSet.of((Object)"cache5_g1", (Object)"cache6_g1"), null, createParams, null);
        fut.get(this.getTestTimeout());
        List issues = (List)gg.snapshot().checkSnapshot(fut.snapshotOperation().snapshotId(), null, (Set)ImmutableSet.of((Object)"cache5_g1"), false, false, null).get(this.getTestTimeout());
        List issuesMsg = issues.stream().map(SnapshotIssue::getIssue).collect(Collectors.toList());
        MatcherAssert.assertThat(issuesMsg, (Matcher)Matchers.hasItem((Matcher)Matchers.startsWith((String)"Following caches contained in snapshot's cache groups,")));
    }

    @Test
    public void testChecking_NotAllCachesInGroupWasRequestedToCheck_WhenForceIsTrue() {
        SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
        SnapshotFuture fut = gg.snapshot().createFullSnapshot((Set)ImmutableSet.of((Object)"cache5_g1", (Object)"cache6_g1"), null, createParams, null);
        fut.get(this.getTestTimeout());
        List issues = (List)gg.snapshot().checkSnapshot(fut.snapshotOperation().snapshotId(), null, (Set)ImmutableSet.of((Object)"cache5_g1"), true, false, null).get(this.getTestTimeout());
        MatcherAssert.assertThat((Object)issues, (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }

    @Test
    public void testChecking_ChecksumIssue_WhenOneTargetCacheFileWasCorrupted() throws Exception {
        SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
        SnapshotFuture fut = gg.snapshot().createFullSnapshot(null, null, createParams, null);
        fut.get(this.getTestTimeout());
        Integer cacheGroupId = GridCacheUtils.cacheId((String)this.getOrCreateDefaultCacheName((Ignite)ignite));
        long corruptedFilesCount = 0L;
        for (String snapshotDirectory : this.snapshotFolders()) {
            File snapshotDir = U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)snapshotDirectory, (boolean)false);
            File fullSnapDir = new File(snapshotDir, FileDatabaseSnapshotSpi.generateSnapshotDirName((long)fut.snapshotOperation().snapshotId(), null));
            File[] files = fullSnapDir.listFiles();
            if (files == null) continue;
            corruptedFilesCount = Math.max(corruptedFilesCount, Stream.of(files).filter(consistentIdDir -> !consistentIdDir.isFile()).flatMap(consistentIdDir -> Stream.of(consistentIdDir.listFiles())).filter(cacheDir -> !cacheDir.isFile()).filter(cacheDir -> cacheDir.getName().equals(Integer.toString(cacheGroupId))).map(cacheDir -> Stream.of(cacheDir.listFiles()).filter(file -> file.isFile() && file.getName().startsWith("part")).filter(this::corruptSnapshotFile).findFirst()).count());
        }
        MatcherAssert.assertThat((Object)corruptedFilesCount, (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
        List issues = (List)gg.snapshot().checkSnapshot(fut.snapshotOperation().snapshotId(), null, (Set)ImmutableSet.of((Object)this.getOrCreateDefaultCacheName((Ignite)ignite)), false, false, null).get(this.getTestTimeout());
        MatcherAssert.assertThat((Object)issues, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.empty())));
        IgniteDbSnapshotSameTopologyTest.assertTrue((boolean)issues.stream().anyMatch(issue -> issue.getIssue().startsWith(this.pageContentCorruptedMessage(issue.getCacheName()))));
    }

    @Test
    public void testChecking_CheckSnapshotByCacheName() throws Exception {
        SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
        SnapshotFuture fut = gg.snapshot().createFullSnapshot(null, null, createParams, null);
        fut.get(this.getTestTimeout());
        Integer cacheGroupId = GridCacheUtils.cacheId((String)this.getOrCreateDefaultCacheName((Ignite)ignite));
        long corruptedFilesCount = 0L;
        for (String snapshotDirectory : this.snapshotFolders()) {
            File snapshotDir = U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)snapshotDirectory, (boolean)false);
            File fullSnapDir = new File(snapshotDir, FileDatabaseSnapshotSpi.generateSnapshotDirName((long)fut.snapshotOperation().snapshotId(), null));
            File[] files = fullSnapDir.listFiles();
            if (files == null) continue;
            corruptedFilesCount = Math.max(corruptedFilesCount, Stream.of(files).filter(File::isDirectory).flatMap(consistentIdDir -> Stream.of(consistentIdDir.listFiles())).filter(File::isDirectory).filter(cacheDir -> !cacheDir.getName().equals(Integer.toString(cacheGroupId))).flatMap(cacheDir -> Stream.of(cacheDir.listFiles())).filter(file -> file.isFile() && file.getName().startsWith("part")).filter(this::corruptSnapshotFile).count());
        }
        MatcherAssert.assertThat((Object)corruptedFilesCount, (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
        List issues = (List)gg.snapshot().checkSnapshot(fut.snapshotOperation().snapshotId(), null, (Set)ImmutableSet.of((Object)this.getOrCreateDefaultCacheName((Ignite)ignite)), false, false, null).get(this.getTestTimeout());
        MatcherAssert.assertThat((Object)issues, (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean corruptSnapshotFile(File file) {
        if (file.getName().endsWith(".zip")) {
            byte[] bytes;
            ZipEntry entry;
            try (ZipInputStream in = new ZipInputStream(new FileInputStream(file));){
                entry = in.getNextEntry();
                bytes = IOUtils.toByteArray((InputStream)in);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (bytes.length <= 1024) return false;
            ByteBuffer buf = ByteBuffer.wrap(bytes);
            buf.putLong(512, buf.getLong(512) ^ 0xFFFFFFFFFFFFFFFFL);
            try (ZipOutputStream out = new ZipOutputStream(new FileOutputStream(file));){
                out.putNextEntry(new ZipEntry(entry.getName()));
                out.write(bytes);
                out.closeEntry();
                return true;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (file.getName().endsWith(CompressionOption.ZSTD.fileExtension())) {
            this.corruptCompressionFile(file, f -> SnapshotCompressionUtils.openZstdInputStream((InputStream)new FileInputStream(f.getAbsolutePath())), f -> SnapshotCompressionUtils.wrapWithZstdCompression((OutputStream)new FileOutputStream((File)f), (int)CompressionOption.ZSTD.minCompressionLevel()));
            return true;
        }
        if (file.getName().endsWith(CompressionOption.LZ4.fileExtension())) {
            this.corruptCompressionFile(file, f -> SnapshotCompressionUtils.openLz4InputStream((InputStream)new FileInputStream(f.getAbsolutePath())), f -> SnapshotCompressionUtils.wrapWithLz4Compression((OutputStream)new FileOutputStream((File)f), (int)CompressionOption.LZ4.minCompressionLevel()));
            return true;
        }
        if (file.getName().endsWith(CompressionOption.SNAPPY.fileExtension())) {
            this.corruptCompressionFile(file, f -> SnapshotCompressionUtils.openSnappyInputStream((InputStream)new FileInputStream(f.getAbsolutePath())), f -> SnapshotCompressionUtils.wrapWithSnappyCompression((OutputStream)new FileOutputStream((File)f)));
            return true;
        }
        if (file.length() <= 1024L) return false;
        try (FileChannel ch = FileChannel.open(file.toPath(), StandardOpenOption.WRITE, StandardOpenOption.READ);){
            ByteBuffer buf = ByteBuffer.allocate(1024);
            ch.read(buf, 0L);
            buf.putLong(512, buf.getLong(512) ^ 0xFFFFFFFFFFFFFFFFL);
            buf.rewind();
            ch.position(0L);
            ch.write(buf);
            ch.force(true);
            boolean bl = true;
            return bl;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private <IN extends InputStream, OUT extends OutputStream> void corruptCompressionFile(File file, ThrowableFunction<IN, File, IOException> inStreamCreator, ThrowableFunction<OUT, File, IOException> outStreamCreator) {
        ByteBuffer bb;
        Throwable throwable;
        try {
            throwable = null;
            try (InputStream in = (InputStream)inStreamCreator.apply((Object)file);){
                bb = ByteBuffer.wrap(IOUtils.toByteArray((InputStream)in));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (bb.array().length > 1024) {
            bb.putLong(512, bb.getLong(512) ^ 0xFFFFFFFFFFFFFFFFL);
            bb.rewind();
            try {
                throwable = null;
                try (OutputStream out = (OutputStream)outStreamCreator.apply((Object)file);){
                    out.write(bb.array());
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Test
    public void testSnapshotDirAttributeInListAndInfoNoCompression() throws Exception {
        this.snapshotDirAttributeInListAndInfo(CompressionOption.NONE);
    }

    @Test
    public void testSnapshotDirAttributeInListAndInfoZipCompression() throws Exception {
        this.snapshotDirAttributeInListAndInfo(CompressionOption.ZIP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void snapshotDirAttributeInListAndInfo(CompressionOption compressionOption) throws Exception {
        File moveDir = this.createOrCleanMoveDir();
        File specificDir = U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"fullSnapshot", (boolean)true);
        try {
            GridGain gg = (GridGain)ignite.plugin("GridGain");
            SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
            SnapshotFuture locSnapFut = gg.snapshot().createFullSnapshot(null, null, createParams, null);
            locSnapFut.get();
            List snapshotInfos = gg.snapshot().list();
            IgniteDbSnapshotSameTopologyTest.assertEquals((int)1, (int)snapshotInfos.size());
            for (Object map : ((SnapshotInfo)snapshotInfos.get(0)).snapshotAttributes().values()) {
                IgniteDbSnapshotSameTopologyTest.assertEquals((String)"<LOCAL>", (String)((String)map.get("SNAPSHOT_DIR")));
            }
            SnapshotInfoEx snapshot = gg.snapshot().snapshot(locSnapFut.snapshotOperation().snapshotId(), null);
            for (Map map : snapshot.snapshotAttributes().values()) {
                IgniteDbSnapshotSameTopologyTest.assertEquals((String)"<LOCAL>", (String)((String)map.get("SNAPSHOT_DIR")));
            }
            gg.snapshot().moveSnapshot(locSnapFut.snapshotOperation().snapshotId(), moveDir, null).get(this.getTestTimeout());
            snapshotInfos = gg.snapshot().listSnapshots(Collections.singleton(moveDir));
            IgniteDbSnapshotSameTopologyTest.assertEquals((int)1, (int)snapshotInfos.size());
            IgniteDbSnapshotSameTopologyTest.assertEquals((String)moveDir.getAbsolutePath(), (String)((String)((Map)((SnapshotInfo)snapshotInfos.get(0)).snapshotAttributes().get("<CLUSTER_WIDE>")).get("SNAPSHOT_DIR")));
            snapshot = gg.snapshot().snapshot(locSnapFut.snapshotOperation().snapshotId(), Collections.singleton(moveDir));
            IgniteDbSnapshotSameTopologyTest.assertTrue((boolean)this.getSnapshotDir(snapshot).startsWith(moveDir.getAbsolutePath()));
            SnapshotFuture specificPathSnapFut = gg.snapshot().createFullSnapshot(null, specificDir, this.createSnapshotParams(compressionOption, -1, 0), "Full snapshot to dir:" + specificDir);
            specificPathSnapFut.get();
            snapshotInfos = gg.snapshot().listSnapshots(Collections.singleton(specificDir));
            IgniteDbSnapshotSameTopologyTest.assertEquals((int)1, (int)snapshotInfos.size());
            IgniteDbSnapshotSameTopologyTest.assertEquals((String)specificDir.getAbsolutePath(), (String)((String)((Map)((SnapshotInfo)snapshotInfos.get(0)).snapshotAttributes().get("<CLUSTER_WIDE>")).get("SNAPSHOT_DIR")));
            snapshot = gg.snapshot().snapshot(specificPathSnapFut.snapshotOperation().snapshotId(), Collections.singleton(specificDir));
            IgniteDbSnapshotSameTopologyTest.assertTrue((boolean)this.getSnapshotDir(snapshot).startsWith(specificDir.getAbsolutePath()));
            File fullSnapDir = new File(specificDir, FileDatabaseSnapshotSpi.generateSnapshotDirName((long)((SnapshotInfo)snapshotInfos.get(0)).snapshotId(), null));
            File[] files = fullSnapDir.listFiles();
            IgniteDbSnapshotSameTopologyTest.assertNotNull((Object)files);
            for (File consistentIdDir : files) {
                File cacheDir = new File(consistentIdDir, Integer.toString(CU.cacheId((String)this.getOrCreateDefaultCacheName((Ignite)ignite))));
                if (!cacheDir.exists() || !cacheDir.isDirectory()) continue;
                block10: for (File file : cacheDir.listFiles()) {
                    if (!file.isFile() || !file.getName().startsWith("part-1")) continue;
                    switch (compressionOption) {
                        case ZIP: {
                            if (snapshot.masterKeyName() == null) {
                                IgniteDbSnapshotSameTopologyTest.assertTrue((boolean)AbstractSnapshotTest.isZipFile((SnapshotPath)new FsSnapshotPath(file)));
                                continue block10;
                            }
                            IgniteDbSnapshotSameTopologyTest.assertFalse((boolean)AbstractSnapshotTest.isZipFile((SnapshotPath)new FsSnapshotPath(file)));
                            continue block10;
                        }
                        case NONE: {
                            IgniteDbSnapshotSameTopologyTest.assertFalse((boolean)AbstractSnapshotTest.isZipFile((SnapshotPath)new FsSnapshotPath(file)));
                        }
                    }
                }
            }
        }
        finally {
            U.delete((File)specificDir);
        }
    }

    @Nullable
    private String getSnapshotDir(SnapshotInfoEx snapshot) {
        String path = null;
        Map map = (Map)snapshot.snapshotAttributes().get("<CLUSTER_WIDE>");
        for (Map.Entry entry : map.entrySet()) {
            if (((String)entry.getKey()).equals("SNAPSHOT_DIR")) {
                path = (String)entry.getValue();
                break;
            }
            if (!((String)entry.getValue()).equals("SNAPSHOT_DIR")) continue;
            path = (String)entry.getKey();
            break;
        }
        return path;
    }

    @Test
    public void testSnapshotOperationWithBrokenMetadata() throws Exception {
        SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
        SnapshotFuture fut = gg.snapshot().createFullSnapshot(null, null, createParams, null);
        fut.get(this.getTestTimeout());
        long id = fut.snapshotOperation().snapshotId();
        for (String snapshotDirectory : this.snapshotFolders()) {
            File snapshotDir = U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)snapshotDirectory, (boolean)false);
            File fullSnapDir = new File(snapshotDir, FileDatabaseSnapshotSpi.generateSnapshotDirName((long)id, null));
            File[] files = fullSnapDir.listFiles();
            if (files == null) continue;
            for (File consistentIdDir : files) {
                Object unmarshal;
                File meta;
                if (consistentIdDir.isFile() || !(meta = SnapshotUtils.resolve((Path)consistentIdDir.toPath(), (String)"snapshot-meta.bin").toFile()).exists() || !meta.isFile()) continue;
                JdkMarshaller marshaller = new JdkMarshaller();
                try (InputStream inputStream = SnapshotUtils.stream((SnapshotPath)new FsSnapshotPath(meta));){
                    unmarshal = marshaller.unmarshal(inputStream, ((Object)((Object)this)).getClass().getClassLoader());
                }
                IgniteDbSnapshotSameTopologyTest.assertTrue((boolean)(unmarshal instanceof SnapshotMetadataV2));
                SnapshotMetadataV2 metadata = (SnapshotMetadataV2)unmarshal;
                SnapshotMetadataV2 brokenMeta = new SnapshotMetadataV2(id, null, 1024, metadata.typeMap(), metadata.binaryMetadataMap(), false, false, null, null, metadata.cacheGroupsMetadata(), null, null, false, null, null, null, CompressionOption.NONE, metadata.compressionLevel(), false, metadata.exchangelessSnapshot(), null, metadata.consistentCutMetas());
                boolean delete = meta.delete();
                IgniteDbSnapshotSameTopologyTest.assertTrue((boolean)delete);
                SnapshotConfiguration snapCfg = gg.configuration().getSnapshotConfiguration();
                try (SnapshotOutputStream out = new SnapshotOutputStreamFactory(grpId -> false, snapCfg.getCompressionOption(), snapCfg.getCompressionLevel(), null, null, null, ignite.configuration().getEncryptionSpi(), ignite.configuration().getDataStorageConfiguration().getPageSize()).makeOutputStream(new FsSnapshotPath(meta));){
                    out.write(ByteBuffer.wrap(marshaller.marshal((Object)brokenMeta)));
                }
            }
        }
        GridTestUtils.assertThrows((IgniteLogger)log, () -> gg.snapshot().snapshot(id, null), IgniteException.class, null);
        List infos = gg.snapshot().list();
        boolean contains = false;
        for (SnapshotInfo info : infos) {
            if (info.snapshotId() != id) continue;
            contains = true;
        }
        IgniteDbSnapshotSameTopologyTest.assertTrue((!contains ? 1 : 0) != 0);
        try {
            List issues = (List)gg.snapshot().checkSnapshot(id, null, false, null).get(this.getTestTimeout());
            if (issues.isEmpty()) {
                IgniteDbSnapshotSameTopologyTest.fail();
            }
        }
        catch (IgniteException ex) {
            this.checkException(ex);
        }
        try {
            gg.snapshot().restoreSnapshot(id, null, null).get(this.getTestTimeout());
            IgniteDbSnapshotSameTopologyTest.fail();
        }
        catch (IgniteException ex) {
            this.checkException(ex);
        }
        try {
            gg.snapshot().deleteSnapshot(id, (SnapshotUpdateOperationParams)null, null).get(this.getTestTimeout());
            IgniteDbSnapshotSameTopologyTest.fail();
        }
        catch (IgniteException ex) {
            this.checkException(ex);
        }
    }

    private void checkException(IgniteException ex) {
        IgniteDbSnapshotSameTopologyTest.assertTrue((ex.getMessage().contains("Snapshot does not exist [id=") || ex.getMessage().contains("Snapshot and current configuration have different page size") || ex.getMessage().contains("Snapshot metadata is broken! snapshotId=") ? 1 : 0) != 0);
    }

    @Test
    public void testMoveSnapshot_WithoutForceMoveIsNotAllowedIfThereAreDependantSnapshots() throws Exception {
        File moveDir = this.createOrCleanMoveDir();
        try {
            IgniteCache cache1 = ignite.cache(this.getOrCreateDefaultCacheName((Ignite)ignite));
            IgniteCache cache2 = ignite.cache("cache2");
            SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
            SnapshotFuture fut = gg.snapshot().createSnapshot(null, null, createParams, null);
            fut.get(this.getTestTimeout());
            for (int i = 0; i < 300; ++i) {
                cache1.put((Object)i, (Object)(-i));
                cache2.put((Object)i, (Object)new AbstractSnapshotTest.TestValue(i, -i));
            }
            SnapshotFuture fut2 = gg.snapshot().createSnapshot(null, null, createParams, null);
            fut2.get();
            SnapshotFuture fut3 = gg.snapshot().moveSnapshot(fut.snapshotOperation().snapshotId(), moveDir, null);
            fut3.get();
            IgniteDbSnapshotSameTopologyTest.fail();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMoveSnapshot_ShouldFailIfPathIsInvalid() throws Exception {
        File moveDir = new File("@@^^^\"\"'");
        try {
            SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
            SnapshotFuture fut = gg.snapshot().createSnapshot(null, null, createParams, null);
            fut.get(this.getTestTimeout());
            this.load((Ignite)ignite, 10);
            SnapshotFuture fut2 = gg.snapshot().createSnapshot(null, null, createParams, null);
            fut2.get();
            SnapshotFuture fut3 = gg.snapshot().moveSnapshot(fut.snapshotOperation().snapshotId(), moveDir, null);
            fut3.get();
            IgniteDbSnapshotSameTopologyTest.fail();
        }
        catch (Throwable throwable) {
        }
        finally {
            try {
                U.delete((File)moveDir);
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCopySnapshot_ShouldFailIfPathIsInvalid() throws Exception {
        File moveDir = new File("@@^^^\"\"'");
        try {
            SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
            SnapshotFuture fut = gg.snapshot().createSnapshot(null, null, createParams, null);
            fut.get(this.getTestTimeout());
            this.load((Ignite)ignite, 10);
            SnapshotFuture fut2 = gg.snapshot().createSnapshot(null, null, createParams, null);
            fut2.get();
            SnapshotFuture fut3 = gg.snapshot().copySnapshot(fut.snapshotOperation().snapshotId(), moveDir, false, new SnapshotUpdateOperationParams(SnapshotChainMode.SINGLE, false, false, null), null);
            fut3.get();
            IgniteDbSnapshotSameTopologyTest.fail();
        }
        catch (Throwable throwable) {
        }
        finally {
            try {
                U.delete((File)moveDir);
            }
            catch (Exception exception) {}
        }
    }

    @Test
    public void testClientInitiatorLeft() throws Exception {
        if (!this.clientStarted()) {
            System.out.println("Test is skipped - no clients in topology.");
            return;
        }
        IgniteEx client = this.grid("client");
        IgniteCache cache = client.cache("cache1");
        for (int i = 0; i < 300; ++i) {
            cache.put((Object)i, (Object)i);
        }
        GridGain gg = (GridGain)client.plugin("GridGain");
        SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
        SnapshotFuture fut = gg.snapshot().createFullSnapshot(null, null, createParams, "test");
        fut.initFuture().get(this.getTestTimeout());
        long snapshotId = fut.snapshotOperation().snapshotId();
        this.stopGrid("client", false);
        IgniteEx client1 = this.startGrid("client");
        this.awaitPartitionMapExchange();
        final GridGain finalGg = (GridGain)client1.plugin("GridGain");
        GridTestUtils.waitForCondition((GridAbsPredicate)new GridAbsPredicate(){

            public boolean apply() {
                return finalGg.snapshot().ongoingSnapshotOperation() == null;
            }
        }, (long)(this.getTestTimeout() / 2L));
        finalGg.snapshot().restoreSnapshot(snapshotId, null, "test").get(this.getTestTimeout());
        cache = client1.cache("cache1");
        for (int i = 0; i < 300; ++i) {
            int k = i;
            IgniteCache cache0 = cache;
            Integer val = IgniteDbSnapshotSameTopologyTest.applyOnRestartingCache(() -> (Integer)cache0.get((Object)k));
            IgniteDbSnapshotSameTopologyTest.assertEquals((Object)i, (Object)val);
        }
    }

    @Test
    public void testClientOngoingSnapshotOperation() throws Exception {
        if (!this.clientStarted()) {
            System.out.println("Test is skipped - no clients in topology.");
            return;
        }
        IgniteEx client = this.grid("client");
        GridGain gg = (GridGain)client.plugin("GridGain");
        SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
        SnapshotFuture fut = gg.snapshot().createFullSnapshot(null, null, createParams, "test");
        long snapshotId = fut.snapshotOperation().snapshotId();
        GridCacheSnapshotManager snapshotManager = (GridCacheSnapshotManager)this.getSnapshotCrdNode().context().cache().context().snapshot();
        SnapshotOperationFuture opFut = null;
        while (opFut == null && !fut.isDone()) {
            opFut = snapshotManager.snapshotFuture();
        }
        IgniteDbSnapshotSameTopologyTest.assertFalse((boolean)fut.isDone());
        fut.get(this.getTestTimeout());
        SnapshotStatus status = opFut.snapshotStatus();
        IgniteDbSnapshotSameTopologyTest.assertEquals((long)status.operation().snapshotId(), (long)snapshotId);
        Set<ClusterNode> participants = this.getSnapshotParticipantNodes(status);
        IgniteDbSnapshotSameTopologyTest.assertEquals((int)participants.size(), (int)status.progress().size());
        for (ClusterNode node : participants) {
            IgniteDbSnapshotSameTopologyTest.assertTrue((boolean)status.progress().keySet().contains(node.id()));
        }
    }

    protected Set<ClusterNode> getSnapshotParticipantNodes(SnapshotStatus status) {
        Set cIds = ignite.cluster().currentBaselineTopology().stream().map(BaselineNode::consistentId).collect(Collectors.toSet());
        return status.operation().clusterNodes().stream().filter(node -> cIds.contains(node.consistentId())).collect(Collectors.toSet());
    }

    @Test
    public void testClientCacheProxyWorkingAfterSnapshotRestore() throws Exception {
        if (!this.clientStarted()) {
            System.out.println("Test is skipped - no clients in topology.");
            return;
        }
        IgniteEx client = this.grid("client");
        IgniteCache cache = IgniteDbSnapshotSameTopologyTest.applyOnRestartingCache(() -> IgniteDbSnapshotSameTopologyTest.lambda$testClientCacheProxyWorkingAfterSnapshotRestore$30((Ignite)client));
        for (int i = 0; i < 300; ++i) {
            cache.put((Object)i, (Object)i);
        }
        GridGain gg = (GridGain)client.plugin("GridGain");
        SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
        final SnapshotFuture fut = gg.snapshot().createFullSnapshot(null, null, createParams, "test");
        long snapshotId = fut.snapshotOperation().snapshotId();
        final GridGain finalGg = (GridGain)client.plugin("GridGain");
        GridTestUtils.waitForCondition((GridAbsPredicate)new GridAbsPredicate(){

            public boolean apply() {
                return finalGg.snapshot().ongoingSnapshotOperation() == null && fut.isDone();
            }
        }, (long)(this.getTestTimeout() / 2L));
        finalGg.snapshot().restoreSnapshot(snapshotId, null, "test").get(this.getTestTimeout());
        for (int i = 0; i < 300; ++i) {
            int k = i;
            Integer val = IgniteDbSnapshotSameTopologyTest.applyOnRestartingCache(() -> (Integer)cache.get((Object)k));
            IgniteDbSnapshotSameTopologyTest.assertEquals((Object)i, (Object)val);
        }
    }

    private static <R> R applyOnRestartingCache(Supplier<R> f) {
        while (true) {
            try {
                return f.get();
            }
            catch (IgniteCacheRestartingException e) {
                e.restartFuture().get();
                continue;
            }
            break;
        }
    }

    @Test
    public void testSimpleDelete() throws Exception {
        IgniteCache cache1 = ignite.cache(this.getOrCreateDefaultCacheName((Ignite)ignite));
        IgniteCache cache2 = ignite.cache("cache2");
        for (int i = 0; i < 300; ++i) {
            cache1.put((Object)i, (Object)i);
            cache2.put((Object)i, (Object)new AbstractSnapshotTest.TestValue(i, i));
        }
        SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
        SnapshotFuture fut = gg.snapshot().createFullSnapshot(null, null, createParams, null);
        fut.get(this.getTestTimeout());
        IgniteDbSnapshotSameTopologyTest.assertEquals((int)1, (int)gg.snapshot().list().size());
        SnapshotFuture future = gg.snapshot().deleteSnapshot(fut.snapshotOperation().snapshotId(), (SnapshotUpdateOperationParams)null, null);
        future.get();
        IgniteDbSnapshotSameTopologyTest.assertEquals((int)0, (int)gg.snapshot().list().size());
    }

    @Test
    public void testDelete_ForceRemovingSnapshotShouldRemoveDependentSnapshots() throws Exception {
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        IgniteCache cache1 = ignite.cache(this.getOrCreateDefaultCacheName((Ignite)ignite));
        IgniteCache cache2 = ignite.cache("cache2");
        for (int i = 0; i < 300; ++i) {
            cache1.put((Object)i, (Object)i);
            cache2.put((Object)i, (Object)new AbstractSnapshotTest.TestValue(i, i));
        }
        SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
        SnapshotFuture fut = gg.snapshot().createFullSnapshot(null, null, createParams, null);
        fut.get(this.getTestTimeout());
        IgniteDbSnapshotSameTopologyTest.assertEquals((int)1, (int)gg.snapshot().list().size());
        SnapshotFuture fut1 = gg.snapshot().createSnapshot(null, null, createParams, null);
        fut1.get();
        IgniteDbSnapshotSameTopologyTest.assertEquals((int)2, (int)gg.snapshot().list().size());
        SnapshotFuture fut2 = gg.snapshot().createSnapshot(null, null, createParams, null);
        fut2.get();
        IgniteDbSnapshotSameTopologyTest.assertEquals((int)3, (int)gg.snapshot().list().size());
        SnapshotFuture fut3 = gg.snapshot().createFullSnapshot(null, null, createParams, null);
        fut3.get();
        IgniteDbSnapshotSameTopologyTest.assertEquals((int)4, (int)gg.snapshot().list().size());
        SnapshotFuture future = gg.snapshot().forceDeleteSnapshot(fut.snapshotOperation().snapshotId(), null);
        future.get();
        List infos = gg.snapshot().list();
        IgniteDbSnapshotSameTopologyTest.assertEquals((int)1, (int)infos.size());
        IgniteDbSnapshotSameTopologyTest.assertEquals((long)fut3.snapshotOperation().snapshotId(), (long)((SnapshotInfo)infos.get(0)).snapshotId());
    }

    @Test
    public void testDelete_RemovingSnapshotShouldFailIfThereAreDependentSnapshots() throws Exception {
        int before = gg.snapshot().list().size();
        SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
        SnapshotFuture fut = gg.snapshot().createFullSnapshot(null, null, createParams, null);
        fut.get(this.getTestTimeout());
        IgniteDbSnapshotSameTopologyTest.assertEquals((int)(before + 1), (int)gg.snapshot().list().size());
        SnapshotFuture fut1 = gg.snapshot().createSnapshot(null, null, createParams, null);
        fut1.get();
        IgniteDbSnapshotSameTopologyTest.assertEquals((int)(before + 2), (int)gg.snapshot().list().size());
        SnapshotFuture future = gg.snapshot().deleteSnapshot(fut.snapshotOperation().snapshotId(), (SnapshotUpdateOperationParams)null, null);
        try {
            future.get();
            IgniteDbSnapshotSameTopologyTest.fail();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Test
    public void testDelete_DeletionSnapshotWhichHasDependentsShouldFail() throws Exception {
        SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
        SnapshotFuture fut = gg.snapshot().createFullSnapshot(null, null, createParams, null);
        fut.get(this.getTestTimeout());
        IgniteDbSnapshotSameTopologyTest.assertEquals((int)1, (int)gg.snapshot().list().size());
        SnapshotFuture fut1 = gg.snapshot().createSnapshot(null, null, createParams, null);
        fut1.get();
        IgniteDbSnapshotSameTopologyTest.assertEquals((int)2, (int)gg.snapshot().list().size());
        SnapshotFuture fut2 = gg.snapshot().createSnapshot(null, null, createParams, null);
        fut2.get();
        IgniteDbSnapshotSameTopologyTest.assertEquals((int)3, (int)gg.snapshot().list().size());
        SnapshotFuture fut3 = gg.snapshot().createFullSnapshot(null, null, createParams, null);
        fut3.get();
        IgniteDbSnapshotSameTopologyTest.assertEquals((int)4, (int)gg.snapshot().list().size());
        SnapshotFuture future = gg.snapshot().deleteSnapshot(fut.snapshotOperation().snapshotId(), (SnapshotUpdateOperationParams)null, null);
        try {
            future.get();
            IgniteDbSnapshotSameTopologyTest.fail();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Test
    public void testDeleteForNotExistingSnapshot() throws Exception {
        SnapshotFuture future = gg.snapshot().forceDeleteSnapshot(-1L, null);
        try {
            future.get();
            IgniteDbSnapshotSameTopologyTest.fail();
        }
        catch (IgniteException ex) {
            IgniteDbSnapshotSameTopologyTest.assertTrue((boolean)ex.getMessage().contains("Snapshot does not exist"));
        }
    }

    @Test
    public void testDelete_CreatingSnapshotAfterRemovingLastSnapshot() throws Exception {
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        IgniteCache cache1 = ignite.cache(this.getOrCreateDefaultCacheName((Ignite)ignite));
        IgniteCache cache2 = ignite.cache("cache2");
        for (int i = 0; i < 300; ++i) {
            cache1.put((Object)i, (Object)i);
            cache2.put((Object)i, (Object)new AbstractSnapshotTest.TestValue(i, i));
        }
        SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
        SnapshotFuture fut = gg.snapshot().createFullSnapshot(null, null, createParams, null);
        fut.get(this.getTestTimeout());
        SnapshotFuture delFut = gg.snapshot().deleteSnapshot(fut.snapshotOperation().snapshotId(), (SnapshotUpdateOperationParams)null, null);
        delFut.get();
        for (int i = 0; i < 300; ++i) {
            cache1.put((Object)i, (Object)(-i));
            cache2.put((Object)i, (Object)new AbstractSnapshotTest.TestValue(i, -i));
        }
        SnapshotFuture fut1 = gg.snapshot().createFullSnapshot(F.asSet((Object[])new String[]{this.getOrCreateDefaultCacheName((Ignite)ignite), "cache2"}), null, createParams, null);
        fut1.get();
        for (int i = 0; i < 300; ++i) {
            cache1.put((Object)i, (Object)i);
            cache2.put((Object)i, (Object)new AbstractSnapshotTest.TestValue(i, i));
        }
        List infos = gg.snapshot().list();
        IgniteDbSnapshotSameTopologyTest.assertEquals((int)1, (int)infos.size());
        IgniteDbSnapshotSameTopologyTest.assertEquals((long)fut1.snapshotOperation().snapshotId(), (long)((SnapshotInfo)infos.get(0)).snapshotId());
        IgniteDbSnapshotSameTopologyTest.assertTrue((boolean)((SnapshotInfo)infos.get(0)).fullSnapshot());
        gg.snapshot().restoreSnapshot(fut1.snapshotOperation().snapshotId(), null, null).get(this.getTestTimeout());
        cache1 = ignite.cache(this.getOrCreateDefaultCacheName((Ignite)ignite));
        cache2 = ignite.cache("cache2");
        for (int i = 0; i < 300; ++i) {
            IgniteDbSnapshotSameTopologyTest.assertEquals((int)(-i), (int)((Integer)cache1.get((Object)i)));
            IgniteDbSnapshotSameTopologyTest.assertEquals((Object)new AbstractSnapshotTest.TestValue(i, -i), (Object)cache2.get((Object)i));
        }
    }

    @Test
    public void testDelete_CreatingSnapshotAfterRemovingLastDependentSnapshot() throws Exception {
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        IgniteCache cache1 = ignite.cache(this.getOrCreateDefaultCacheName((Ignite)ignite));
        IgniteCache cache2 = ignite.cache("cache2");
        for (int i = 0; i < 300; ++i) {
            cache1.put((Object)i, (Object)i);
            cache2.put((Object)i, (Object)new AbstractSnapshotTest.TestValue(i, i));
        }
        SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
        SnapshotFuture fut = gg.snapshot().createFullSnapshot(null, null, createParams, null);
        fut.get(this.getTestTimeout());
        for (int i = 0; i < 300; ++i) {
            cache1.put((Object)i, (Object)0);
            cache2.put((Object)i, (Object)new AbstractSnapshotTest.TestValue(0, 0));
        }
        SnapshotFuture futDependent = gg.snapshot().createSnapshot(null, null, createParams, null);
        futDependent.get();
        SnapshotFuture delFut = gg.snapshot().forceDeleteSnapshot(fut.snapshotOperation().snapshotId(), null);
        delFut.get();
        for (int i = 0; i < 300; ++i) {
            cache1.put((Object)i, (Object)(-i));
            cache2.put((Object)i, (Object)new AbstractSnapshotTest.TestValue(i, -i));
        }
        gg.snapshot().createFullSnapshot(F.asSet((Object[])new String[]{this.getOrCreateDefaultCacheName((Ignite)ignite), "cache2"}), null, createParams, null).get(this.getTestTimeout());
        SnapshotFuture fut1 = gg.snapshot().createSnapshot(F.asSet((Object[])new String[]{this.getOrCreateDefaultCacheName((Ignite)ignite), "cache2"}), null, createParams, null);
        fut1.get();
        for (int i = 0; i < 300; ++i) {
            cache1.put((Object)i, (Object)i);
            cache2.put((Object)i, (Object)new AbstractSnapshotTest.TestValue(i, i));
        }
        SnapshotInfoEx info = gg.snapshot().snapshot(fut1.snapshotOperation().snapshotId(), null);
        IgniteDbSnapshotSameTopologyTest.assertFalse((boolean)info.fullSnapshot());
        gg.snapshot().restoreSnapshot(fut1.snapshotOperation().snapshotId(), null, null).get(this.getTestTimeout());
        cache1 = ignite.cache(this.getOrCreateDefaultCacheName((Ignite)ignite));
        cache2 = ignite.cache("cache2");
        for (int i = 0; i < 300; ++i) {
            IgniteDbSnapshotSameTopologyTest.assertEquals((int)(-i), (int)((Integer)cache1.get((Object)i)));
            IgniteDbSnapshotSameTopologyTest.assertEquals((Object)new AbstractSnapshotTest.TestValue(i, -i), (Object)cache2.get((Object)i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testManyCachesInGroup() throws Exception {
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        CacheConfiguration gcfg = new CacheConfiguration().setGroupName("G").setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 32)).setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC).setNodeFilter((IgnitePredicate)new AbstractSnapshotTest.TestNodeFilter()).setBackups(1);
        IgniteCache cacheA = ignite.getOrCreateCache(new CacheConfiguration((CompleteConfiguration)gcfg).setName("A"));
        IgniteCache cacheB = ignite.getOrCreateCache(new CacheConfiguration((CompleteConfiguration)gcfg).setName("B"));
        IgniteCache cacheC = ignite.getOrCreateCache(new CacheConfiguration((CompleteConfiguration)gcfg).setName("C"));
        try {
            this.fillCaches((Ignite)ignite, (IgniteCache<Integer, Integer>)cacheA, (IgniteCache<Integer, Integer>)cacheB, (IgniteCache<Integer, Integer>)cacheC, 1);
            SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
            SnapshotFuture futFull = gg.snapshot().createFullSnapshot(null, null, createParams, null);
            futFull.get();
            this.fillCaches((Ignite)ignite, (IgniteCache<Integer, Integer>)cacheA, (IgniteCache<Integer, Integer>)cacheB, (IgniteCache<Integer, Integer>)cacheC, -1);
            SnapshotFuture futInc = gg.snapshot().createSnapshot(null, null, createParams, null);
            futInc.get();
            this.fillCaches((Ignite)ignite, (IgniteCache<Integer, Integer>)cacheA, (IgniteCache<Integer, Integer>)cacheB, (IgniteCache<Integer, Integer>)cacheC, 0);
            gg.snapshot().restoreSnapshot(futInc.snapshotOperation().snapshotId(), null, null).get(this.getTestTimeout());
            cacheA = ignite.cache("A");
            cacheB = ignite.cache("B");
            cacheC = ignite.cache("C");
            this.checkCaches((IgniteCache<Integer, Integer>)cacheA, (IgniteCache<Integer, Integer>)cacheB, (IgniteCache<Integer, Integer>)cacheC, -1);
            gg.snapshot().restoreSnapshot(futFull.snapshotOperation().snapshotId(), null, null).get(this.getTestTimeout());
            cacheA = ignite.cache("A");
            cacheB = ignite.cache("B");
            cacheC = ignite.cache("C");
            this.checkCaches((IgniteCache<Integer, Integer>)cacheA, (IgniteCache<Integer, Integer>)cacheB, (IgniteCache<Integer, Integer>)cacheC, 1);
        }
        finally {
            cacheA.destroy();
            cacheB.destroy();
            cacheC.destroy();
        }
    }

    private void checkCaches(final IgniteCache<Integer, Integer> cacheA, final IgniteCache<Integer, Integer> cacheB, IgniteCache<Integer, Integer> cacheC, final int multiply) throws IgniteCheckedException {
        IgniteInternalFuture futureA = GridTestUtils.runAsync((Runnable)new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < 300; ++i) {
                    IgniteDbSnapshotSameTopologyTest.assertEquals((int)(multiply * i), (int)((Integer)cacheA.get((Object)i)));
                }
            }
        });
        IgniteInternalFuture futureB = GridTestUtils.runAsync((Runnable)new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < 300; ++i) {
                    IgniteDbSnapshotSameTopologyTest.assertEquals((int)(multiply * i * 2), (int)((Integer)cacheB.get((Object)i)));
                }
            }
        });
        for (int i = 0; i < 300; ++i) {
            IgniteDbSnapshotSameTopologyTest.assertEquals((int)(multiply * i * 3), (int)((Integer)cacheC.get((Object)i)));
        }
        futureA.get();
        futureB.get();
    }

    private void fillCaches(Ignite ig, IgniteCache<Integer, Integer> cacheA, IgniteCache<Integer, Integer> cacheB, IgniteCache<Integer, Integer> cacheC, int multiply) throws IgniteCheckedException {
        IgniteInternalFuture futureA = IgniteDbSnapshotSameTopologyTest.loadWithIntsAsync(ig, cacheA.getName(), 0, multiply);
        IgniteInternalFuture futureB = IgniteDbSnapshotSameTopologyTest.loadWithIntsAsync(ig, cacheB.getName(), 0, 2 * multiply);
        IgniteInternalFuture futureC = IgniteDbSnapshotSameTopologyTest.loadWithIntsAsync(ig, cacheC.getName(), 0, 3 * multiply);
        futureC.get();
        futureB.get();
        futureA.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSnapshotGroupPropagation() throws Exception {
        CacheConfiguration cfg = new CacheConfiguration().setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 32)).setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC).setNodeFilter((IgnitePredicate)new AbstractSnapshotTest.TestNodeFilter()).setBackups(1);
        IgniteCache cacheA = ignite.getOrCreateCache(new CacheConfiguration((CompleteConfiguration)cfg).setGroupName("G1").setName("A"));
        IgniteCache cacheB = ignite.getOrCreateCache(new CacheConfiguration((CompleteConfiguration)cfg).setGroupName("G1").setName("B"));
        IgniteCache cacheC = ignite.getOrCreateCache(new CacheConfiguration((CompleteConfiguration)cfg).setGroupName("G2").setName("C"));
        try {
            this.fillCaches((Ignite)ignite, (IgniteCache<Integer, Integer>)cacheA, (IgniteCache<Integer, Integer>)cacheB, (IgniteCache<Integer, Integer>)cacheC, 1);
            SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
            SnapshotFuture fut = gg.snapshot().createFullSnapshot(Collections.singleton("A"), null, createParams, null);
            fut.get(this.getTestTimeout());
            IgniteDbSnapshotSameTopologyTest.assertEquals(new HashSet<String>(Arrays.asList("A", "B")), (Object)fut.snapshotOperation().cacheNames());
            this.fillCaches((Ignite)ignite, (IgniteCache<Integer, Integer>)cacheA, (IgniteCache<Integer, Integer>)cacheB, (IgniteCache<Integer, Integer>)cacheC, -1);
            cacheA.destroy();
            cacheB.destroy();
            gg.snapshot().restoreSnapshot(fut.snapshotOperation().snapshotId(), null, Collections.singleton("B"), true, null, null).get(this.getTestTimeout());
            cacheA = ignite.cache("A");
            cacheB = ignite.cache("B");
            for (int i = 0; i < 300; ++i) {
                IgniteDbSnapshotSameTopologyTest.assertEquals((int)i, (int)((Integer)cacheA.get((Object)i)));
                IgniteDbSnapshotSameTopologyTest.assertEquals((int)(i * 2), (int)((Integer)cacheB.get((Object)i)));
                IgniteDbSnapshotSameTopologyTest.assertEquals((int)(-i * 3), (int)((Integer)cacheC.get((Object)i)));
            }
        }
        finally {
            cacheA.destroy();
            cacheB.destroy();
            cacheC.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultipleCachesMultipleGroups() throws Exception {
        CacheConfiguration cfg = new CacheConfiguration().setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 32)).setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC).setNodeFilter((IgnitePredicate)new AbstractSnapshotTest.TestNodeFilter()).setBackups(1);
        IgniteCache cacheA = ignite.getOrCreateCache(new CacheConfiguration((CompleteConfiguration)cfg).setGroupName("G1").setName("A"));
        IgniteCache cacheB = ignite.getOrCreateCache(new CacheConfiguration((CompleteConfiguration)cfg).setGroupName("G1").setName("B"));
        IgniteCache cacheC = ignite.getOrCreateCache(new CacheConfiguration((CompleteConfiguration)cfg).setGroupName("G2").setName("C"));
        IgniteCache cacheD = ignite.getOrCreateCache(new CacheConfiguration((CompleteConfiguration)cfg).setGroupName("G2").setName("D"));
        try {
            int i;
            IgniteCache cache2 = ignite.cache("cache2");
            for (int i2 = 0; i2 < 300; ++i2) {
                cacheA.put((Object)i2, (Object)i2);
                cacheB.put((Object)i2, (Object)(i2 * 2));
                cacheC.put((Object)i2, (Object)(i2 * 3));
                cacheD.put((Object)i2, (Object)(i2 * 4));
                cache2.put((Object)i2, (Object)(i2 * 5));
            }
            SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
            SnapshotFuture fut = gg.snapshot().createFullSnapshot(new HashSet<String>(Arrays.asList("A", "B", "C", "D", "cache2")), null, createParams, null);
            fut.get(this.getTestTimeout());
            for (i = 0; i < 300; ++i) {
                cacheB.put((Object)i, (Object)(-i * 2));
                cacheC.put((Object)i, (Object)(-i * 3));
                cacheD.put((Object)i, (Object)(-i * 4));
            }
            cacheA.destroy();
            cacheB.destroy();
            cacheC.destroy();
            cacheD.destroy();
            cache2.destroy();
            gg.snapshot().restoreSnapshot(fut.snapshotOperation().snapshotId(), null, null).get(this.getTestTimeout());
            cacheA = ignite.cache("A");
            cacheB = ignite.cache("B");
            cacheC = ignite.cache("C");
            cacheD = ignite.cache("D");
            cache2 = ignite.cache("cache2");
            for (i = 0; i < 300; ++i) {
                IgniteDbSnapshotSameTopologyTest.assertEquals((int)i, (int)((Integer)cacheA.get((Object)i)));
                IgniteDbSnapshotSameTopologyTest.assertEquals((Object)(i * 2), (Object)cacheB.get((Object)i));
                IgniteDbSnapshotSameTopologyTest.assertEquals((Object)(i * 3), (Object)cacheC.get((Object)i));
                IgniteDbSnapshotSameTopologyTest.assertEquals((Object)(i * 4), (Object)cacheD.get((Object)i));
                IgniteDbSnapshotSameTopologyTest.assertEquals((Object)(i * 5), (Object)cache2.get((Object)i));
            }
        }
        finally {
            cacheA.destroy();
            cacheB.destroy();
            cacheC.destroy();
            cacheD.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRestoreDynamicallyStartedCache() throws Exception {
        String dynCache = "dyn-cache";
        CacheConfiguration cfg = new CacheConfiguration().setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 32)).setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC).setNodeFilter((IgnitePredicate)new AbstractSnapshotTest.TestNodeFilter()).setName(dynCache).setBackups(1);
        IgniteCache cache = ignite.getOrCreateCache(cfg);
        try {
            cache.put((Object)1, (Object)1);
            SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
            SnapshotFuture fut = gg.snapshot().createFullSnapshot(Collections.singleton(dynCache), null, createParams, null);
            fut.get(this.getTestTimeout());
            cache.put((Object)1, (Object)-1);
            gg.snapshot().restoreSnapshot(fut.snapshotOperation().snapshotId(), Collections.singleton(dynCache), null).get(this.getTestTimeout());
            cache = ignite.cache(dynCache);
            IgniteDbSnapshotSameTopologyTest.assertEquals((int)1, (int)((Integer)cache.get((Object)1)));
        }
        finally {
            ignite.destroyCache(dynCache);
        }
    }

    @Test
    public void testEmptySnapshotNodeDir() throws Exception {
        IgniteCache cache = ignite.cache(this.getOrCreateDefaultCacheName((Ignite)ignite));
        for (int i = 0; i < 100; ++i) {
            cache.put((Object)i, (Object)(2 * i));
        }
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
        gg.snapshot().createFullSnapshot(Collections.singleton(this.getOrCreateDefaultCacheName((Ignite)ignite)), null, createParams, null).get(this.getTestTimeout());
        this.clearSnapshotNodeDir(this.snapshotFolders());
        IgniteDbSnapshotSameTopologyTest.assertEquals((int)0, (int)gg.snapshot().list().size());
    }

    @Test
    public void testSnapshotRestoreFromNonAffinityServerNode() throws Exception {
        int i;
        if (!this.dummyStarted()) {
            System.out.println("Node with node filter is not started. Will skip test.");
            return;
        }
        IgniteEx ignite = this.grid("dummy");
        IgniteCache cache1 = ignite.cache(this.getOrCreateDefaultCacheName((Ignite)ignite));
        SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
        SnapshotFuture snapFut = gg.snapshot().createFullSnapshot(Collections.singleton(this.getOrCreateDefaultCacheName((Ignite)ignite)), null, createParams, null);
        snapFut.get();
        for (i = 0; i < 300; ++i) {
            cache1.put((Object)i, (Object)(-i));
        }
        gg.snapshot().restoreSnapshot(snapFut.snapshotOperation().snapshotId(), snapFut.snapshotOperation().cacheNames(), null).get(this.getTestTimeout());
        IgniteDbSnapshotSameTopologyTest.assertEquals((int)300, (int)cache1.size(new CachePeekMode[0]));
        for (i = 0; i < 300; ++i) {
            IgniteDbSnapshotSameTopologyTest.assertEquals((Object)i, (Object)cache1.get((Object)i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRestoreCancelWithConcurrentCacheOperations() throws Exception {
        int iteration;
        int i = ThreadLocalRandom.current().nextInt();
        String cacheName = i % 2 == 0 ? "cache3" : this.getOrCreateDefaultCacheName((Ignite)ignite);
        final IgniteCache cache = ignite2.cache(cacheName);
        final AtomicBoolean finished = new AtomicBoolean();
        final AtomicInteger exceptionCount = new AtomicInteger();
        final ThreadLocalRandom rnd = ThreadLocalRandom.current();
        SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
        SnapshotFuture snapshotFut = gg.snapshot().createFullSnapshot(Collections.singleton(cacheName), null, createParams, null);
        snapshotFut.get();
        IgniteInternalFuture f = GridTestUtils.runAsync((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                while (!finished.get()) {
                    int key = rnd.nextInt(300);
                    int val = rnd.nextInt();
                    try {
                        cache.put((Object)key, (Object)val);
                    }
                    catch (IgniteCacheRestartingException e) {
                        exceptionCount.incrementAndGet();
                        e.restartFuture().get(IgniteDbSnapshotSameTopologyTest.this.getTestTimeout());
                    }
                    catch (Throwable th) {
                        System.err.println("Unexpected exception in load-thread");
                        th.printStackTrace();
                        exceptionCount.incrementAndGet();
                        throw th;
                    }
                }
                return null;
            }
        }, (String)"load-thread");
        int iterations = 5;
        SnapshotFuture opFut = null;
        try {
            for (iteration = 1; iteration <= iterations || exceptionCount.get() == 0; ++iteration) {
                U.sleep((long)1000L);
                System.out.println("Iteration: " + iteration);
                CountDownLatch restorePauseLatch = new CountDownLatch(1);
                CountDownLatch restoreStartLatch = this.nextRestoreShouldAwait(restorePauseLatch);
                opFut = ThreadLocalRandom.current().nextBoolean() ? gg.snapshot().restoreSnapshot(snapshotFut.snapshotOperation().snapshotId(), Collections.singleton(cacheName), null) : gg.snapshot().checkSnapshot(snapshotFut.snapshotOperation().snapshotId(), null, false, null);
                IgniteDbSnapshotSameTopologyTest.assertTrue((boolean)restoreStartLatch.await(this.getTestTimeout(), TimeUnit.MILLISECONDS));
                if (ThreadLocalRandom.current().nextBoolean()) {
                    restorePauseLatch.countDown();
                    opFut.get();
                    continue;
                }
                Thread.sleep(1100L);
                try {
                    IgniteFuture future = gg.snapshot().cancelSnapshotOperation(opFut.operationId(), null);
                    restorePauseLatch.countDown();
                    future.get();
                    continue;
                }
                catch (IgniteException e) {
                    IgniteDbSnapshotSameTopologyTest.assertTrue((boolean)e.getMessage().contains("Snapshot operation in non-cancelable state!"));
                }
            }
        }
        catch (Throwable throwable) {
            if (opFut != null && !opFut.isDone()) {
                try {
                    opFut.get();
                }
                catch (IgniteException e) {
                    e.printStackTrace();
                }
            }
            IgniteDbSnapshotSameTopologyTest.assertTrue((String)("exceptionCount.get()=" + exceptionCount.get() + ", iteration=" + iteration), (exceptionCount.get() < iteration ? 1 : 0) != 0);
            IgniteDbSnapshotSameTopologyTest.assertFalse((String)(f.result() + " " + f.error()), (boolean)f.isDone());
            finished.set(true);
            throw throwable;
        }
        if (opFut != null && !opFut.isDone()) {
            try {
                opFut.get();
            }
            catch (IgniteException e) {
                e.printStackTrace();
            }
        }
        IgniteDbSnapshotSameTopologyTest.assertTrue((String)("exceptionCount.get()=" + exceptionCount.get() + ", iteration=" + iteration), (exceptionCount.get() < iteration ? 1 : 0) != 0);
        IgniteDbSnapshotSameTopologyTest.assertFalse((String)(f.result() + " " + f.error()), (boolean)f.isDone());
        finished.set(true);
        f.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPartialRestore() throws Exception {
        GridGain gg = (GridGain)dummyNode.plugin("GridGain");
        CacheConfiguration cfg = new CacheConfiguration().setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 32)).setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC).setBackups(1);
        IgniteCache cacheA = dummyNode.getOrCreateCache(new CacheConfiguration((CompleteConfiguration)cfg).setGroupName("PART-G1").setName("PART-A"));
        IgniteCache cacheB = dummyNode.getOrCreateCache(new CacheConfiguration((CompleteConfiguration)cfg).setGroupName("PART-G1").setName("PART-B"));
        IgniteCache cacheC = dummyNode.getOrCreateCache(new CacheConfiguration((CompleteConfiguration)cfg).setGroupName("PART-G2").setName("PART-C"));
        try {
            this.fillCaches((Ignite)dummyNode, (IgniteCache<Integer, Integer>)cacheA, (IgniteCache<Integer, Integer>)cacheB, (IgniteCache<Integer, Integer>)cacheC, 1);
            SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
            SnapshotFuture fut = gg.snapshot().createFullSnapshot(new HashSet<String>(Arrays.asList("PART-A", "PART-C")), null, createParams, null);
            fut.get(this.getTestTimeout());
            this.fillCaches((Ignite)dummyNode, (IgniteCache<Integer, Integer>)cacheA, (IgniteCache<Integer, Integer>)cacheB, (IgniteCache<Integer, Integer>)cacheC, -1);
            gg.snapshot().restoreSnapshot(fut.snapshotOperation().snapshotId(), null, new HashSet<String>(Collections.singletonList("PART-B")), true, null, null).get(this.getTestTimeout());
            cacheA = dummyNode.cache("PART-A");
            cacheB = dummyNode.cache("PART-B");
            cacheC = dummyNode.cache("PART-C");
            for (int i = 0; i < 300; ++i) {
                IgniteDbSnapshotSameTopologyTest.assertEquals((int)i, (int)((Integer)cacheA.get((Object)i)));
                IgniteDbSnapshotSameTopologyTest.assertEquals((int)(i * 2), (int)((Integer)cacheB.get((Object)i)));
                IgniteDbSnapshotSameTopologyTest.assertEquals((int)(-i * 3), (int)((Integer)cacheC.get((Object)i)));
            }
        }
        finally {
            cacheA.destroy();
            cacheB.destroy();
            cacheC.destroy();
        }
    }

    @Test
    public void testSnapshotMetricsMXBean() throws Exception {
        int SNAPSHOTS = 6;
        GridCacheSnapshotManager snapshotManager = (GridCacheSnapshotManager)U.field((Object)gg.snapshot(), (String)"snapshotMgr");
        SnapshotMetricsMXBean snapMetrics = (SnapshotMetricsMXBean)U.field((Object)snapshotManager, (String)"snapshotMetricsMXBean");
        SnapshotMetricsMXBeanImpl.SnapshotMetrics[] snapshotHistory = (SnapshotMetricsMXBeanImpl.SnapshotMetrics[])U.field((Object)snapMetrics, (String)"snapshotHistory");
        for (int i = 0; i < snapshotHistory.length; ++i) {
            snapshotHistory[i] = null;
        }
        GridTestUtils.setFieldValue((Object)snapMetrics, (String)"head", (Object)0);
        GridTestUtils.setFieldValue((Object)snapMetrics, (String)"size", (Object)0);
        AbstractSnapshotTest.SnapshotMetricsCollector c = new AbstractSnapshotTest.SnapshotMetricsCollector((Integer)U.field((Object)snapMetrics, (String)"snapshotHistorySize"), snapMetrics, ignite);
        final AtomicInteger indexRef = new AtomicInteger(0);
        for (int i = 0; i < 6; ++i) {
            System.out.println("Iteration: " + i);
            indexRef.set(i);
            final AtomicReference fut = new AtomicReference();
            c.runSnapshotOperation(new IgniteCallable<SnapshotFuture>(){

                public SnapshotFuture call() throws Exception {
                    SnapshotFuture f = gg.snapshot().createFullSnapshot(null, null, new SnapshotCommonParams(2), IgniteDbSnapshotSameTopologyTest.this.createSnapshotParams(SnapshotConfiguration.DEFAULT_COMPRESSION, -1, indexRef.get() == 5 ? 100000 : 0), null);
                    fut.set(f);
                    return f;
                }
            });
            if (i % 2 != 0) continue;
            c.runSnapshotOperation(new IgniteCallable<SnapshotFuture>(){

                public SnapshotFuture call() throws Exception {
                    return gg.snapshot().restoreSnapshot(((SnapshotFuture)fut.get()).snapshotOperation().snapshotId(), null, null);
                }
            });
        }
        IgniteDbSnapshotSameTopologyTest.assertEquals((int)5, (int)snapMetrics.getAvailableSnapshotMetrics());
        IgniteDbSnapshotSameTopologyTest.assertFalse((boolean)snapMetrics.isSnapshotInProgress());
        LinkedList<AbstractSnapshotTest.SnapshotMetrics> metrics = c.historySnapshots();
        int i = 0;
        for (AbstractSnapshotTest.SnapshotMetrics expMetrics : metrics) {
            System.out.println("Iteration: " + i + " Expected Actual");
            long snapshotId = snapMetrics.snapshotId(i);
            long startTime = snapMetrics.snapshotStartTime(i);
            long finishTime = snapMetrics.snapshotFinishTime(i);
            String type = snapMetrics.snapshotOperation(i);
            long writeThrottlingTime = snapMetrics.getWriteThrottlingTime(i);
            System.out.println(i + " - " + expMetrics.snapshotId + " " + snapshotId + "\n" + i + " - " + expMetrics.startTime + " " + startTime + "\n" + i + " - " + expMetrics.finishTime + " " + finishTime + "\n" + i + " - " + expMetrics.operationType + " " + type + "\n" + i + " - " + expMetrics.bytesWritten + "\n" + i + " - " + expMetrics.writeThrottlingTime + " " + writeThrottlingTime);
            IgniteDbSnapshotSameTopologyTest.assertEquals((long)expMetrics.snapshotId, (long)snapshotId);
            IgniteDbSnapshotSameTopologyTest.assertTrue((expMetrics.startTime <= startTime ? 1 : 0) != 0);
            IgniteDbSnapshotSameTopologyTest.assertTrue((expMetrics.finishTime >= finishTime ? 1 : 0) != 0);
            IgniteDbSnapshotSameTopologyTest.assertEquals((String)expMetrics.operationType, (String)type);
            if (i == 0) {
                IgniteDbSnapshotSameTopologyTest.assertTrue((expMetrics.writeThrottlingTime > 0L ? 1 : 0) != 0);
            } else {
                IgniteDbSnapshotSameTopologyTest.assertTrue((expMetrics.writeThrottlingTime == 0L ? 1 : 0) != 0);
            }
            IgniteDbSnapshotSameTopologyTest.assertEquals((long)expMetrics.writeThrottlingTime, (long)writeThrottlingTime);
            if (++i != 5) continue;
            break;
        }
        String[] beansToValidate = new String[]{"org.gridgain.grid.internal.processors.cache.database.SnapshotMXBeanImpl", "org.gridgain.grid.internal.processors.cache.database.SnapshotMetricsMXBeanImpl", "org.apache.ignite.internal.mxbean.SqlQueryMXBeanImpl", "org.apache.ignite.internal.processors.cache.CacheClusterMetricsMXBeanImpl", "org.apache.ignite.internal.processors.cache.CacheGroupMetricsMXBeanImpl", "org.apache.ignite.internal.processors.cache.persistence.DataStorageMXBeanImpl"};
        this.validateMbeans((Ignite)ignite, beansToValidate);
    }

    @Test
    public void testCreateSnapshotToSpecificPathNoCompression() throws Exception {
        this.createSnapshotToSpecificPathAndParallelism(2, CompressionOption.NONE, -1);
    }

    @Test
    public void testCreateSnapshotToSpecificPathCompression() throws Exception {
        this.createSnapshotToSpecificPathAndParallelism(2, CompressionOption.ZIP, -1);
    }

    @Test
    public void testCreateSnapshotToSpecificPathCompressionAndParallelism() throws Exception {
        this.createSnapshotToSpecificPathAndParallelism(8, CompressionOption.ZIP, 5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createSnapshotToSpecificPathAndParallelism(int parallelism, CompressionOption compressionOption, int compressionLevel) throws Exception {
        try (IgniteDataStreamer ldr = ignite.dataStreamer(this.getOrCreateDefaultCacheName((Ignite)ignite));){
            ldr.allowOverwrite(true);
            HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
            for (int i = 0; i < 300; ++i) {
                map.put(i, i);
            }
            ldr.addData(map);
        }
        File fullSnapshotDir = U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"fullSnapshot", (boolean)true);
        File incSnapshotDir = U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"incremental", (boolean)true);
        try {
            int i;
            SnapshotFuture fullSnapshotFut = gg.snapshot().createFullSnapshot(F.asSet((Object)this.getOrCreateDefaultCacheName((Ignite)ignite)), fullSnapshotDir, new SnapshotCommonParams(parallelism), this.createSnapshotParams(compressionOption, compressionLevel, 0), "Full snapshot to dir:" + fullSnapshotDir);
            fullSnapshotFut.get();
            long id = fullSnapshotFut.snapshotOperation().snapshotId();
            this.verifySnapshotContent(fullSnapshotDir, id, gg, (Ignite)ignite, false, compressionOption);
            try (IgniteDataStreamer ldr = ignite.dataStreamer(this.getOrCreateDefaultCacheName((Ignite)ignite));){
                ldr.allowOverwrite(true);
                HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
                for (i = 0; i < 150; ++i) {
                    map.put(i, i + 1);
                }
                ldr.addData(map);
            }
            SnapshotFuture incSnapshotFut = gg.snapshot().createSnapshot(F.asSet((Object)this.getOrCreateDefaultCacheName((Ignite)ignite)), incSnapshotDir, this.createSnapshotParams(compressionOption, -1, 0), "Incremental snapshot to dir:" + incSnapshotDir);
            incSnapshotFut.get();
            id = incSnapshotFut.snapshotOperation().snapshotId();
            this.verifySnapshotContent(incSnapshotDir, id, gg, (Ignite)ignite, false, compressionOption);
            ignite.cache(this.getOrCreateDefaultCacheName((Ignite)ignite)).clear();
            gg.snapshot().restoreSnapshot(fullSnapshotFut.snapshotOperation().snapshotId(), Collections.singletonList(fullSnapshotDir), (Set)Sets.newHashSet((Object[])new String[]{this.getOrCreateDefaultCacheName((Ignite)ignite)}), "Restore full snapshot from: " + fullSnapshotDir).get(this.getTestTimeout());
            IgniteCache cache1 = ignite.cache(this.getOrCreateDefaultCacheName((Ignite)ignite));
            assert (cache1 != null);
            for (int i2 = 0; i2 < 300; ++i2) {
                IgniteDbSnapshotSameTopologyTest.assertEquals((int)i2, (int)((Integer)cache1.get((Object)i2)));
            }
            gg.snapshot().restoreSnapshot(incSnapshotFut.snapshotOperation().snapshotId(), Arrays.asList(fullSnapshotDir, incSnapshotDir), (Set)Sets.newHashSet((Object[])new String[]{this.getOrCreateDefaultCacheName((Ignite)ignite)}), "Restore Incremental snapshot from: " + incSnapshotDir).get(this.getTestTimeout());
            IgniteCache cache2 = ignite.cache(this.getOrCreateDefaultCacheName((Ignite)ignite));
            assert (cache2 != null);
            for (i = 0; i < 300; ++i) {
                if (i < 150) {
                    IgniteDbSnapshotSameTopologyTest.assertEquals((int)(i + 1), (int)((Integer)cache2.get((Object)i)));
                    continue;
                }
                IgniteDbSnapshotSameTopologyTest.assertEquals((int)i, (int)((Integer)cache2.get((Object)i)));
            }
        }
        finally {
            U.delete((File)fullSnapshotDir);
            U.delete((File)incSnapshotDir);
        }
    }

    @Test
    public void testRestoreWithDeletedIndexes() throws Exception {
        Collection clusterNodes = ignite.context().discovery().discoCache().aliveBaselineNodes();
        this.testRestoreWithoutIndexes((Ignite)ignite, clusterNodes, this.getOrCreateDefaultCacheName((Ignite)ignite));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRestoreWithNodeWithSameAssignment() throws Exception {
        String cacheName = "newCache1";
        IgniteCacheProxy cache = (IgniteCacheProxy)ignite.getOrCreateCache(new CacheConfiguration(cacheName).setBackups(G.allGrids().size()).setNodeFilter((IgnitePredicate)new AbstractSnapshotTest.TestNodeFilter()));
        try {
            Set cIds = U.getBaselineTopology((GridCacheContext)cache.context()).consistentIds();
            Collection clusterNodes = GridCacheUtils.affinityNodes((GridCacheContext)cache.context(), (AffinityTopologyVersion)AffinityTopologyVersion.NONE);
            for (ClusterNode node : clusterNodes) {
                if (!cIds.contains(node.consistentId())) continue;
                this.testRestoreWithoutIndexes((Ignite)ignite, Collections.singletonList(node), cacheName);
            }
        }
        finally {
            if (cache != null) {
                cache.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void snapshotCreationShouldFailIfThereIsNotUserCacheNameAmongCacheNames() throws IgniteCheckedException {
        String internalCache = "snapshotCreationShouldFailIfThereIsNotUserCacheNameAmongCacheNames";
        ignite.context().cache().dynamicStartCache(new CacheConfiguration(internalCache), internalCache, null, CacheType.INTERNAL, false, true, true, false).get(this.getTestTimeout());
        try {
            try {
                GridGain gg = (GridGain)ignite.plugin("GridGain");
                SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
                gg.snapshot().createFullSnapshot(Collections.singleton(internalCache), null, createParams, null).get(this.getTestTimeout());
                IgniteDbSnapshotSameTopologyTest.fail();
            }
            catch (IgniteException e) {
                IgniteDbSnapshotSameTopologyTest.assertTrue((boolean)e.getMessage().contains(internalCache));
                IgniteDbSnapshotSameTopologyTest.assertTrue((boolean)e.getMessage().contains("not user cache"));
            }
        }
        finally {
            ignite.context().cache().dynamicDestroyCache(internalCache, false, false, false, null).get(this.getTestTimeout());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void snapshotCreationShouldFailIfThereIsMVCCCaches() throws IgniteCheckedException {
        String mvccCacheName = "snapshotCreationShouldFailIfThereIsMVCCCaches";
        ignite.createCache(new CacheConfiguration(mvccCacheName).setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL_SNAPSHOT));
        try {
            try {
                GridGain gg = (GridGain)ignite.plugin("GridGain");
                SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
                gg.snapshot().createFullSnapshot(Collections.singleton(mvccCacheName), null, createParams, null).get(this.getTestTimeout());
                IgniteDbSnapshotSameTopologyTest.fail();
            }
            catch (IgniteException e) {
                IgniteDbSnapshotSameTopologyTest.assertTrue((boolean)e.getMessage().contains(mvccCacheName));
                IgniteDbSnapshotSameTopologyTest.assertTrue((boolean)e.getMessage().contains("TRANSACTIONAL_SNAPSHOT"));
            }
        }
        finally {
            ignite.destroyCache(mvccCacheName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void snapshotCreationShouldFilterOutMVCCCachesWhenNoCachesWereSet() throws IgniteCheckedException {
        String mvccCacheName = "snapshotCreationShouldFilterOutMVCCCachesWhenNoCachesWereSet";
        ignite.createCache(new CacheConfiguration(mvccCacheName).setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL_SNAPSHOT));
        try {
            SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
            SnapshotFuture snapshot = gg.snapshot().createFullSnapshot(null, null, createParams, null);
            snapshot.get();
            IgniteDbSnapshotSameTopologyTest.assertFalse((boolean)snapshot.snapshotOperation().cacheNames().contains(mvccCacheName));
        }
        finally {
            ignite.destroyCache(mvccCacheName);
        }
    }

    private void testRestoreWithoutIndexes(Ignite ig, Collection<ClusterNode> gridToClearIndexes, String cacheName) throws Exception {
        IgniteDbSnapshotSameTopologyTest.loadWithIntsAsync(ig, cacheName, 0, 1).get(this.getTestTimeout());
        SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
        gg.snapshot().createFullSnapshot(Collections.singleton(cacheName), null, createParams, null).get(this.getTestTimeout());
        IgniteDbSnapshotSameTopologyTest.loadWithIntsAsync(ig, cacheName, 1, 1).get(this.getTestTimeout());
        gg.snapshot().createSnapshot(Collections.singleton(cacheName), null, createParams, null).get(this.getTestTimeout());
        IgniteDbSnapshotSameTopologyTest.loadWithIntsAsync(ig, cacheName, 2, 1).get(this.getTestTimeout());
        SnapshotFuture fut = gg.snapshot().createFullSnapshot(Collections.singleton(cacheName), null, createParams, null);
        fut.get(this.getTestTimeout());
        IgniteDbSnapshotSameTopologyTest.loadWithIntsAsync(ig, cacheName, 3, 1).get(this.getTestTimeout());
        gg.snapshot().createSnapshot(Collections.singleton(cacheName), null, createParams, null).get(this.getTestTimeout());
        IgniteDbSnapshotSameTopologyTest.loadWithIntsAsync(ig, cacheName, 4, 1).get(this.getTestTimeout());
        for (ClusterNode node : gridToClearIndexes) {
            IgniteEx igEx = (IgniteEx)G.ignite((UUID)node.id());
            GridCacheSnapshotManager snapMgr = (GridCacheSnapshotManager)igEx.context().cache().context().snapshot();
            FileSnapshot snapshot = (FileSnapshot)snapMgr.snapshotSpi().snapshot(fut.snapshotOperation().snapshotId(), null, null, false, snapMgr.resolveSecurityLevel(), false);
            String consistentId = U.maskForFileName((CharSequence)igEx.context().discovery().localNode().consistentId().toString());
            SnapshotPath consIdDir = snapshot.snapshotDirectory().resolve(consistentId);
            IgniteDbSnapshotSameTopologyTest.assertTrue((boolean)consIdDir.exists());
            this.removeIndexBin(((FsSnapshotPath)consIdDir).getFile().toPath());
        }
        gg.snapshot().restoreSnapshot(fut.snapshotOperation().snapshotId(), null, null).get(this.getTestTimeout());
        ig.cache(cacheName).put((Object)-1, (Object)-1);
    }

    private void removeIndexBin(Path dir) throws IOException {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir);){
            for (Path path : stream) {
                if (Files.isRegularFile(path, new LinkOption[0])) {
                    if (!path.endsWith("index.bin")) continue;
                    Files.delete(path);
                    System.err.println("DEL");
                    continue;
                }
                if (!Files.isDirectory(path, new LinkOption[0])) continue;
                this.removeIndexBin(path);
            }
        }
    }

    @Test
    public void testSnapshotOfNonPersistentCacheShouldFail() throws Exception {
        IgniteCache cache1 = ignite.cache(this.getOrCreateDefaultCacheName((Ignite)ignite));
        IgniteCache cacheNp = ignite.cache("noPersistence");
        for (int i = 0; i < 10; ++i) {
            cache1.put((Object)i, (Object)i);
            cacheNp.put((Object)i, (Object)i);
        }
        try {
            SnapshotFuture fut = gg.snapshot().createFullSnapshot(F.asSet((Object[])new String[]{this.getOrCreateDefaultCacheName((Ignite)ignite), "noPersistence"}), null);
            fut.get(this.getTestTimeout());
            IgniteDbSnapshotSameTopologyTest.fail();
        }
        catch (Exception e) {
            IgniteDbSnapshotSameTopologyTest.assertTrue((String)e.toString(), (boolean)e.getMessage().contains("non-persistent"));
        }
    }

    @Test
    public void testThatIncrementalSnapshotSavesOnlyChangedPages() throws Exception {
        SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
        for (int i = 0; i < 3; ++i) {
            IgniteDbSnapshotSameTopologyTest.loadWithIntsAsync((Ignite)ignite, "cache1", i, 1).get(this.getTestTimeout());
            gg.snapshot().createFullSnapshot(null, null, createParams, "SNAP FULL " + i).get(this.getTestTimeout());
        }
        ignite.cache("cache1").put((Object)0, (Object)Integer.MIN_VALUE);
        SnapshotFuture incSnapshot = gg.snapshot().createSnapshot(Collections.singleton("cache1"), null, createParams, "SNAP INC");
        incSnapshot.get();
        long totalSize = this.getSnapshotSizeInByteOnCluster(incSnapshot.snapshotOperation().snapshotId());
        long sizeInPages = totalSize / (long)ignite.configuration().getDataStorageConfiguration().getPageSize();
        long estimatedSizeInPages = (2 * (this.getBackupCount() + 1) * this.getCacheConfig("cache1").getAffinity().partitions() + 3) * 3 / 2;
        MatcherAssert.assertThat((Object)sizeInPages, (Matcher)Matchers.lessThan((Comparable)Long.valueOf(estimatedSizeInPages)));
    }

    @Ignore(value="https://ggsystems.atlassian.net/browse/GG-14027")
    @Test
    public void testSqlQueriesWhileCacheIsRestored() throws Exception {
        SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
        SnapshotFuture snapFut = gg.snapshot().createFullSnapshot(Collections.singleton("cache2"), null, createParams, null);
        snapFut.get();
        CountDownLatch countDownLatch = this.addWaitingStageFinishListener(SnapshotOperationStage.SECOND, ignite);
        SnapshotFuture restoreSnapFut = gg.snapshot().restoreSnapshot(snapFut.snapshotOperation().snapshotId(), null, null);
        countDownLatch.await(this.getTestTimeout(), TimeUnit.MILLISECONDS);
        try {
            ignite.cache("cache1").query(new SqlFieldsQuery("SELECT * FROM \"cache2\".TestValue")).getAll();
            IgniteDbSnapshotSameTopologyTest.fail();
        }
        catch (IgniteCacheRestartingException ex) {
            ex.restartFuture().get(this.getTestTimeout());
        }
        restoreSnapFut.get();
        ignite.cache("cache1").query(new SqlFieldsQuery("SELECT * FROM \"cache2\".TestValue")).getAll();
    }

    @Test
    public void testCreateRestoreSnapshotWithLocalCache() {
        this.checkLocalCache();
        SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
        SnapshotFuture fut = gg.snapshot().createFullSnapshot(null, null, createParams, null);
        fut.get(this.getTestTimeout());
        long snapId = fut.snapshotOperation().snapshotId();
        List infos = gg.snapshot().list();
        IgniteDbSnapshotSameTopologyTest.assertEquals((int)1, (int)infos.size());
        IgniteDbSnapshotSameTopologyTest.assertEquals((long)((SnapshotInfo)infos.get(0)).snapshotId(), (long)snapId);
        SnapshotFuture checkSnapshotFut = gg.snapshot().checkSnapshot(snapId, null, false, null);
        List issues = (List)checkSnapshotFut.get();
        IgniteDbSnapshotSameTopologyTest.assertEquals((String)issues.toString(), (int)0, (int)issues.size());
        gg.snapshot().restoreSnapshot(snapId, null, null).get(this.getTestTimeout());
        this.checkLocalCache();
    }

    @NotNull
    private IgniteCache checkLocalCache() {
        IgniteCache locCache = ignite.cache("localCache");
        IgniteDbSnapshotSameTopologyTest.assertNotNull((Object)locCache);
        IgniteDbSnapshotSameTopologyTest.assertEquals((Object)((CacheConfiguration)locCache.getConfiguration(CacheConfiguration.class)).getCacheMode(), (Object)CacheMode.LOCAL);
        IgniteDbSnapshotSameTopologyTest.assertTrue((locCache.localSize(new CachePeekMode[0]) != 0 ? 1 : 0) != 0);
        return locCache;
    }

    @Test
    public void testRestoreSnapshotOnChangedCacheGroup() throws Exception {
        try {
            this.runRestoreOnChangedCacheGrp();
        }
        finally {
            this.ensureCachesCreated();
            if (ignite.cache("cache4_g2") != null) {
                ignite.destroyCache("cache4_g2");
            }
        }
    }

    private void runRestoreOnChangedCacheGrp() throws InterruptedException {
        IgniteEx client = this.clientStarted() ? this.grid("client") : ignite;
        this.fillCachesWithDummyBinaryObjects((Ignite)client, "cache5_g1", "cache6_g1", "cache8_g2");
        this.awaitPartitionMapExchange();
        GridGain gridGain = (GridGain)client.plugin("GridGain");
        SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
        gridGain.snapshot().createFullSnapshot(new HashSet<String>(Arrays.asList("cache5_g1", "cache6_g1", "cache8_g2")), null, createParams, null).get(this.getTestTimeout());
        client.getOrCreateCache(this.getCacheConfig("cache4_g2"));
        this.fillCachesWithDummyBinaryObjects((Ignite)client, "cache4_g2");
        GridGain gg = (GridGain)client.plugin("GridGain");
        GridSnapshot db = gg.snapshot();
        IgniteDbSnapshotSameTopologyTest.assertNotNull((Object)db);
        List snapshotInfos = db.list();
        IgniteDbSnapshotSameTopologyTest.assertEquals((String)this.buildSnapshotInfo(snapshotInfos), (int)1, (int)snapshotInfos.size());
        SnapshotInfo snapshot = (SnapshotInfo)snapshotInfos.get(0);
        long snapshotId = snapshot.snapshotId();
        List issues = (List)gridGain.snapshot().checkSnapshot(snapshotId, null, false, null).get(this.getTestTimeout());
        boolean found = false;
        for (SnapshotIssue next : issues) {
            if (log.isInfoEnabled()) {
                log.info("Check found an issue: " + next.toString());
            }
            if (!next.getCacheName().equals("cache4_g2")) continue;
            found = true;
        }
        IgniteDbSnapshotSameTopologyTest.assertTrue((String)("Expected to find snapshot check issue in " + issues), (boolean)found);
        SnapshotFuture futWoForce = gridGain.snapshot().restoreSnapshot(snapshotId, null, null, false, null, "restore snapshot without force flag");
        try {
            futWoForce.get();
            IgniteDbSnapshotSameTopologyTest.fail((String)"Restore without force restore should fail in this case");
        }
        catch (IgniteException e) {
            IgniteDbSnapshotSameTopologyTest.assertTrue((String)e.getMessage(), (boolean)e.getMessage().contains("cache4_g2"));
        }
        SnapshotFuture futWithForce = gridGain.snapshot().restoreSnapshot(snapshotId, null, null, true, null, "force restore snapshot");
        futWithForce.get();
        this.checkCacheFill((Ignite)client, "cache5_g1");
        this.checkCacheFill((Ignite)client, "cache6_g1");
        this.checkCacheFill((Ignite)client, "cache8_g2");
        IgniteDbSnapshotSameTopologyTest.assertNull((Object)client.cache("cache4_g2"));
    }

    @Test
    public void testRestoreSnapshotIfSomeCacheInGroupNotSpecified() throws Exception {
        try {
            this.runRestoreSnapshotIfSomeCacheInGroupNotSpecified();
        }
        finally {
            this.ensureCachesCreated();
        }
    }

    @Test
    public void testThatClientLeftDoesNotFailSnapshotRestore() throws Exception {
        IgniteCacheSnapshotManager snapshot = ignite.context().cache().context().snapshot();
        IgniteDbSnapshotSameTopologyTest.assertTrue((boolean)(snapshot instanceof GridCacheSnapshotManager));
        GridCacheSnapshotManager mgr = (GridCacheSnapshotManager)snapshot;
        SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
        SnapshotFuture createFut = gg.snapshot().createFullSnapshot(null, null, createParams, null);
        createFut.get();
        for (int i = 1; i <= 3; ++i) {
            this.startGrid("client" + i);
        }
        SnapshotFuture fut = mgr.startGlobalTestSnapshotOperation((Map)ImmutableMap.of((Object)"DELEGATE_FACTORY", (Object)RestoreFutureFactory.class.getName(), (Object)"SNAPSHOT_ID", (Object)createFut.snapshotOperation().snapshotId(), (Object)"PAUSE_AFTER_FIRST_STAGE_ON_CRD", (Object)7000, (Object)"HANG_ON_FIRST_STAGE", (Object)true, (Object)TEST_NESTED_PARAMS, this.getTestRestoreParameters()), null);
        fut.initFuture().get(this.getTestTimeout());
        for (int i = 1; i <= 3; ++i) {
            this.stopGrid("client" + i, false, true);
            Thread.sleep(2000L);
        }
        fut.get(this.getTestTimeout());
    }

    protected Map<String, Object> getTestRestoreParameters() {
        return Collections.emptyMap();
    }

    @Test
    public void testSnapshotMetricsMXBeanOnSnapshotCreate() throws Exception {
        GridCacheSnapshotManager snapshotManager = (GridCacheSnapshotManager)U.field((Object)gg.snapshot(), (String)"snapshotMgr");
        SnapshotMetricsMXBean snapMetrics = (SnapshotMetricsMXBean)U.field((Object)snapshotManager, (String)"snapshotMetricsMXBean");
        SnapshotMetricsMXBeanImpl.SnapshotMetrics[] snapshotHistory = (SnapshotMetricsMXBeanImpl.SnapshotMetrics[])U.field((Object)snapMetrics, (String)"snapshotHistory");
        for (int i = 0; i < snapshotHistory.length; ++i) {
            snapshotHistory[i] = null;
        }
        GridTestUtils.setFieldValue((Object)snapMetrics, (String)"head", (Object)0);
        GridTestUtils.setFieldValue((Object)snapMetrics, (String)"size", (Object)0);
        IgniteDbSnapshotSameTopologyTest.assertFalse((boolean)snapMetrics.isSnapshotInProgress());
        IgniteDbSnapshotSameTopologyTest.assertEquals((long)snapMetrics.getBytesWritten(), (long)-1L);
        IgniteDbSnapshotSameTopologyTest.assertEquals((long)snapMetrics.getPartitionsWritten(), (long)-1L);
        this.checkSnapshotBytesWritten(snapMetrics, true);
        this.load((Ignite)ignite, 10);
        this.checkSnapshotBytesWritten(snapMetrics, false);
        IgniteDbSnapshotSameTopologyTest.assertFalse((boolean)snapMetrics.isSnapshotInProgress());
        IgniteDbSnapshotSameTopologyTest.assertTrue((snapMetrics.getBytesWritten() != 0L ? 1 : 0) != 0);
        IgniteDbSnapshotSameTopologyTest.assertTrue((snapMetrics.getPartitionsWritten() != 0L ? 1 : 0) != 0);
    }

    @Test
    public void testMoveToUncleanDir() throws Exception {
        File movedDir = this.createOrCleanMoveDir();
        GridSnapshot ggSnapshots = gg.snapshot();
        GridCacheSnapshotManager snapshotMgr = (GridCacheSnapshotManager)ignite.context().cache().context().snapshot();
        DatabaseSnapshotSpi snapshotSpi = snapshotMgr.snapshotSpi();
        File origPath = snapshotSpi.snapshotWorkingDirectory();
        SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
        SnapshotFuture create = ggSnapshots.createFullSnapshot(null, null, createParams, null);
        create.get();
        long snapshotId = create.snapshotOperation().snapshotId();
        String snapshotDirName = FileDatabaseSnapshotSpi.generateSnapshotDirName((long)snapshotId, null);
        File snapshotPath = origPath.toPath().resolve(snapshotDirName).toFile();
        Path targetSnapshotDir = movedDir.toPath().resolve(snapshotDirName);
        FileUtils.copyDirectory((File)snapshotPath, (File)targetSnapshotDir.toFile());
        ggSnapshots.moveSnapshot(snapshotId, movedDir, null).get(this.getTestTimeout());
    }

    private void checkSnapshotBytesWritten(SnapshotMetricsMXBean snapMetrics, boolean fullSnap) throws Exception {
        CountDownLatch latch = this.addWaitingStageFinishListener(SnapshotOperationStage.FIRST, this.getNonCoordinator(this.getSnapshotCrdNode()));
        SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
        SnapshotFuture fut = fullSnap ? gg.snapshot().createFullSnapshot(null, null, createParams, null) : gg.snapshot().createSnapshot(null, null, createParams, null);
        long preBytesWritten = snapMetrics.getBytesWritten();
        long prePartsWritten = snapMetrics.getPartitionsWritten();
        long preTotalBytesWrittenOnStorage = snapMetrics.getTotalBytesWrittenOnStorage();
        latch.await();
        IgniteDbSnapshotSameTopologyTest.assertTrue((boolean)snapMetrics.isSnapshotInProgress());
        IgniteDbSnapshotSameTopologyTest.assertTrue((boolean)GridTestUtils.waitForCondition(() -> snapMetrics.getBytesWritten() > 0L, (long)10000L));
        IgniteDbSnapshotSameTopologyTest.assertTrue((boolean)GridTestUtils.waitForCondition(() -> snapMetrics.getPartitionsWritten() > 0L, (long)10000L));
        fut.get(this.getTestTimeout());
        IgniteDbSnapshotSameTopologyTest.assertTrue((snapMetrics.getTotalBytesWrittenOnStorage() > 0L ? 1 : 0) != 0);
        long postBytesWritten = snapMetrics.getBytesWritten();
        long postPartsWritten = snapMetrics.getPartitionsWritten();
        long postBytesWrittenOnStorage = snapMetrics.getTotalBytesWrittenOnStorage();
        IgniteDbSnapshotSameTopologyTest.assertTrue((String)("preBytesWritten: " + preBytesWritten + " postBytesWritten: " + postBytesWritten), (boolean)(fullSnap ? preBytesWritten <= postBytesWritten : preBytesWritten >= postBytesWritten));
        IgniteDbSnapshotSameTopologyTest.assertTrue((String)("preTotalBytesWrittenOnStorage: " + preTotalBytesWrittenOnStorage + " postBytesWrittenOnStorage: " + postBytesWrittenOnStorage), (boolean)(fullSnap ? preTotalBytesWrittenOnStorage <= postBytesWrittenOnStorage : preTotalBytesWrittenOnStorage >= postBytesWrittenOnStorage));
        IgniteDbSnapshotSameTopologyTest.assertTrue((String)("prePartsWritten: " + prePartsWritten + " postPartsWritten: " + postPartsWritten), (boolean)(fullSnap ? prePartsWritten <= postPartsWritten : prePartsWritten >= postPartsWritten));
        long sizeOnDisk = IgniteDbSnapshotSameTopologyTest.sizeOfSnapshotOnDisc(fut.snapshotOperation().snapshotId(), ignite);
        long partsCount = IgniteDbSnapshotSameTopologyTest.snapshotPartitionsCount(fut.snapshotOperation().snapshotId(), ignite);
        IgniteDbSnapshotSameTopologyTest.assertEquals((String)("Size on disk: " + sizeOnDisk + ", but metrics shown: " + postBytesWrittenOnStorage), (long)postBytesWrittenOnStorage, (long)sizeOnDisk);
        IgniteDbSnapshotSameTopologyTest.assertEquals((String)("Partitions on disk: " + partsCount + ", but metrics shown: " + postPartsWritten), (long)postPartsWritten, (long)partsCount);
    }

    protected IgniteEx getSnapshotCrdNode() {
        return dummyNode;
    }

    protected IgniteEx getSomeAffinityNode() {
        return ignite;
    }

    protected void ensureCachesCreated() {
        for (String name : staticCacheConfigs) {
            ignite.getOrCreateCache(this.getCacheConfig(name));
        }
    }

    private void runRestoreSnapshotIfSomeCacheInGroupNotSpecified() throws InterruptedException {
        IgniteEx client = this.clientStarted() ? this.grid("client") : ignite;
        this.fillCachesWithDummyBinaryObjects((Ignite)client, "cache5_g1", "cache6_g1", "cache8_g2");
        this.awaitPartitionMapExchange();
        GridGain gridGain = (GridGain)client.plugin("GridGain");
        HashSet<String> cacheNames = new HashSet<String>(Arrays.asList("cache5_g1", "cache6_g1", "cache8_g2"));
        SnapshotCreateParams createParams = this.createSnapshotParams(gg.configuration().getSnapshotConfiguration());
        gridGain.snapshot().createFullSnapshot(cacheNames, null, createParams, null).get(this.getTestTimeout());
        GridSnapshot db = ((GridGain)client.plugin("GridGain")).snapshot();
        IgniteDbSnapshotSameTopologyTest.assertNotNull((Object)db);
        List snapshotInfos = db.list();
        IgniteDbSnapshotSameTopologyTest.assertEquals((String)this.buildSnapshotInfo(snapshotInfos), (int)1, (int)snapshotInfos.size());
        SnapshotInfo snapshot = (SnapshotInfo)snapshotInfos.get(0);
        long snapshotId = snapshot.snapshotId();
        String missedCache = "cache6_g1";
        cacheNames.remove("cache6_g1");
        SnapshotFuture futWoForce = gridGain.snapshot().restoreSnapshot(snapshotId, null, cacheNames, false, null, "restore snapshot without force flag");
        try {
            futWoForce.get();
            IgniteDbSnapshotSameTopologyTest.fail((String)"Restore without force restore should fail in this case");
        }
        catch (IgniteException e) {
            IgniteDbSnapshotSameTopologyTest.assertTrue((String)e.getMessage(), (boolean)e.getMessage().contains("cache6_g1"));
        }
        SnapshotFuture futWithForce = gridGain.snapshot().restoreSnapshot(snapshotId, null, cacheNames, true, null, "force restore snapshot");
        futWithForce.get();
        this.checkCacheFill((Ignite)client, "cache5_g1");
        this.checkCacheFill((Ignite)client, "cache6_g1");
        this.checkCacheFill((Ignite)client, "cache8_g2");
    }

    private void checkCacheFill(Ignite client, String cacheName) {
        IgniteCache cache = IgniteDbSnapshotSameTopologyTest.applyOnRestartingCache(() -> client.cache(cacheName).withKeepBinary());
        for (int i = 0; i < 100; ++i) {
            IgniteDbSnapshotSameTopologyTest.assertNotNull((Object)cache.get((Object)i));
        }
    }

    private void fillCachesWithDummyBinaryObjects(Ignite client, String ... cacheNames) {
        for (String cacheName : cacheNames) {
            IgniteCache cache = client.cache(cacheName).withKeepBinary();
            for (int i = 0; i < 100; ++i) {
                cache.put((Object)i, (Object)client.binary().builder("type1").setField("cache", (Object)cacheName).setField("id", (Object)i).setField("name", (Object)("Name " + i)).build());
            }
        }
    }

    @Nullable
    protected IgniteEx getNonCoordinator(IgniteEx snapshotCrdNode) {
        if (!ignite.equals(snapshotCrdNode)) {
            return ignite;
        }
        if (!ignite2.equals(snapshotCrdNode)) {
            return ignite2;
        }
        return null;
    }

    private String buildSnapshotInfo(List<SnapshotInfo> snapshots) {
        StringBuilder sb = new StringBuilder();
        sb.append("\nSnapshot infos:\n");
        for (SnapshotInfo info : snapshots) {
            sb.append("\t").append("id=").append(info.snapshotId()).append(", initiator=").append(info.initiatorNode()).append("\n");
        }
        return sb.toString();
    }

    private static /* synthetic */ IgniteCache lambda$testClientCacheProxyWorkingAfterSnapshotRestore$30(Ignite client) {
        return client.cache("cache1").withKeepBinary();
    }

    public static class RestoreFutureFactory
    implements SnapshotTestFuture.DelegateFactory {
        public SnapshotOperationFuture<Object> createDelegate(int protocolVersion, IgniteUuid id, boolean initiator, UUID initiatorId, @Nullable GridFutureAdapter clientInitFut, @Nullable GridFutureAdapter clientDoneFut, GridCacheSnapshotManager snapMgr, GridCacheSharedContext cctx, SnapshotConfiguration snapConf, SnapshotMetricsMXBeanImpl snapshotMetrics) {
            return new TestSnapshotRestoreFuture(protocolVersion, id, initiator, initiatorId, clientInitFut, clientDoneFut, snapMgr, cctx, snapConf, snapshotMetrics);
        }

        public static class TestSnapshotRestoreFuture
        extends SnapshotRestoreFuture {
            TestSnapshotRestoreFuture(int protocolVersion, IgniteUuid id, boolean initiator, UUID initiatorId, @Nullable GridFutureAdapter clientInitFut, @Nullable GridFutureAdapter clientDoneFut, GridCacheSnapshotManager snapMgr, GridCacheSharedContext cctx, SnapshotConfiguration snapConf, SnapshotMetricsMXBeanImpl snapshotMetrics) {
                super(protocolVersion, id, initiator, initiatorId, clientInitFut, clientDoneFut, snapMgr, cctx, snapConf, snapshotMetrics);
            }

            public static Map<String, Object> getTestNestedParams(GridSnapshotOperationEx op) {
                Object param = op.extraParameter();
                if (param instanceof Map) {
                    return (Map)((Map)param).get(IgniteDbSnapshotSameTopologyTest.TEST_NESTED_PARAMS);
                }
                return null;
            }

            public synchronized void init(SnapshotOperationInfoImpl snapshotInfo) {
                this.snapshotInfo = snapshotInfo;
                Map o = (Map)snapshotInfo.snapshotOperation().extraParameter();
                if (o.get("SNAPSHOT_ID") instanceof Long) {
                    SnapshotInfoExtended info;
                    Long snapshotId = (Long)o.get("SNAPSHOT_ID");
                    try {
                        info = this.snapMgr.getSnapshotInfo(snapshotId.longValue(), null);
                    }
                    catch (IgniteCheckedException e) {
                        throw new IgniteException((Throwable)e);
                    }
                    snapshotInfo = new SnapshotOperationInfoImpl(this.id, (GridSnapshotOperationEx)new GridSnapshotOperationImpl(SnapshotOperationType.RESTORE, snapshotId.longValue(), new HashSet(info.cacheNamesWithGroups().values()), info.cacheNames(), null, TestSnapshotRestoreFuture.getTestNestedParams(snapshotInfo.snapshotOperation()), null, null, null), this.initiatorNodeId(), snapshotInfo.topologyVersion(), snapshotInfo.clusterNodes());
                }
                super.init(snapshotInfo);
            }

            public void onMessage(UUID senderNodeId, Object msg) {
                Map o;
                if (msg instanceof ClusterWideSnapshotOperationStageFinishedMessage && ((ClusterWideSnapshotOperationStageFinishedMessage)msg).stage() == SnapshotOperationStage.FIRST && (o = (Map)this.snapshotInfo.snapshotOperation().extraParameter()) != null && o.get("PAUSE_AFTER_FIRST_STAGE_ON_CRD") instanceof Integer) {
                    this.snapMgr.submitTaskToSnapshotExecutor(this.type(), () -> {
                        try {
                            U.sleep((long)((Integer)o.get("PAUSE_AFTER_FIRST_STAGE_ON_CRD")).intValue());
                        }
                        catch (IgniteInterruptedCheckedException e) {
                            e.printStackTrace();
                        }
                        super.onMessage(senderNodeId, msg);
                    });
                    return;
                }
                super.onMessage(senderNodeId, msg);
            }
        }
    }
}

