/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database;

import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiClosure;
import org.apache.ignite.plugin.PluginConfiguration;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.configuration.SnapshotConfiguration;
import org.gridgain.grid.persistentstore.SnapshotChainMode;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.gridgain.grid.persistentstore.SnapshotUpdateOperationParams;
import org.jetbrains.annotations.NotNull;
import org.junit.Test;

public class IgniteDbSnapshotRestoreTestWithDifferentConfig
extends GridCommonAbstractTest {
    private static final String CACHE_NAME = "cache";
    private static final String CACHE_GROUP_NAME = "cacheGroup";
    private static final String CACHE_GROUP_NAME_NEW = "cacheGroup2";
    public static final String SNAPSHOT_PATH = "snapshot";
    private static final int SOME_INT_CONST = 17;
    private static final int NODES_COUNT = 2;
    private static final int NEW_NODE_INDEX = 2;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        GridGainConfiguration ggCfg = new GridGainConfiguration();
        SnapshotConfiguration snapshotConfiguration = new SnapshotConfiguration().setSnapshotsPath(SNAPSHOT_PATH);
        ggCfg.setSnapshotConfiguration(snapshotConfiguration);
        cfg.setPluginConfigurations(new PluginConfiguration[]{ggCfg});
        cfg.setCacheConfiguration(new CacheConfiguration[]{this.getCacheConfig(false)});
        cfg.setDataStorageConfiguration(new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setPersistenceEnabled(true)));
        return cfg;
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.cleanSnapshotDirs();
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        this.cleanSnapshotDirs();
        super.afterTest();
    }

    protected void cleanSnapshotDirs() throws Exception {
        this.cleanPersistenceDir();
        this.cleanSnapshotNodeDir();
        U.delete((File)this.getMoveDir());
    }

    private void cleanSnapshotNodeDir() throws IgniteCheckedException {
        U.delete((File)U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)SNAPSHOT_PATH, (boolean)false));
    }

    @NotNull
    private File getMoveDirWithCreate() throws IgniteCheckedException {
        File moveDir = this.getMoveDir();
        moveDir.mkdirs();
        return moveDir;
    }

    private File getMoveDir() throws IgniteCheckedException {
        return U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"move_test", (boolean)true);
    }

    private CacheConfiguration getCacheConfig(boolean afterRestore) {
        LinkedHashMap<String, String> fields = new LinkedHashMap<String, String>();
        fields.put("v1", Integer.class.getName());
        fields.put("v2", String.class.getName());
        fields.put("v3", String.class.getName());
        fields.put("v4", String.class.getName());
        fields.put("v5", Integer.class.getName());
        if (afterRestore) {
            fields.put("v7", String.class.getName());
            fields.put("v8", Integer.class.getName());
            fields.put("v9", String.class.getName());
        } else {
            fields.put("v6", String.class.getName());
            fields.put("v7", String.class.getName());
        }
        LinkedList<QueryIndex> indexes = new LinkedList<QueryIndex>();
        indexes.add(new QueryIndex("v2", true, "TESTVALUE_V2_IDX"));
        indexes.add(new QueryIndex("v3", true, "TESTVALUE_V3_IDX"));
        if (afterRestore) {
            indexes.add(new QueryIndex("v5", true, "TESTVALUE_V5_IDX"));
            indexes.add(new QueryIndex("v7", true, "TESTVALUE_V7_IDX"));
        } else {
            indexes.add(new QueryIndex("v4", true, "TESTVALUE_V4_IDX"));
        }
        return new CacheConfiguration().setCacheMode(afterRestore ? CacheMode.REPLICATED : CacheMode.PARTITIONED).setName(CACHE_NAME).setGroupName(afterRestore ? CACHE_GROUP_NAME_NEW : CACHE_GROUP_NAME).setBackups(afterRestore ? 0 : 2).setSqlSchema("PUBLIC").setIndexedTypes(new Class[]{Integer.class, TestValue.class}).setQueryEntities(Collections.singleton(new QueryEntity(Integer.class.getName(), TestValue.class.getName()).setFields(fields).setIndexes(indexes)));
    }

    private Set<String> asSet(String ... strings) {
        HashSet<String> set = new HashSet<String>();
        for (String s : strings) {
            set.add(s);
        }
        return set;
    }

    @Test
    public void testRestoring() throws Exception {
        IgniteEx ignite = this.startGrids(2);
        ignite.cluster().active(true);
        IgniteCache cache = ignite.getOrCreateCache(this.getCacheConfig(false));
        cache.query(new SqlFieldsQuery("create table t (id integer primary key, p integer) with \"cacheGroup=cacheGroup, backups=2\"")).getAll();
        cache.query(new SqlFieldsQuery("create index T_IDX on t(p)")).getAll();
        cache.query(new SqlFieldsQuery("create index TESTVALUE_V5_V6_IDX on TESTVALUE(v5, v6)")).getAll();
        String plan = ((List)cache.query(new SqlFieldsQuery("explain select * from TestValue where v2 = ?").setArgs(new Object[]{"a"})).getAll().get(0)).get(0).toString();
        IgniteDbSnapshotRestoreTestWithDifferentConfig.assertTrue((String)plan, (boolean)plan.contains("TESTVALUE_V2_IDX"));
        plan = ((List)cache.query(new SqlFieldsQuery("explain select * from TestValue where v5 = ?").setArgs(new Object[]{1})).getAll().get(0)).get(0).toString();
        IgniteDbSnapshotRestoreTestWithDifferentConfig.assertTrue((String)plan, (boolean)plan.contains("TESTVALUE_V5_V6_IDX"));
        plan = ((List)cache.query(new SqlFieldsQuery("explain select * from t where p = 0")).getAll().get(0)).get(0).toString();
        IgniteDbSnapshotRestoreTestWithDifferentConfig.assertTrue((boolean)plan.contains("T_IDX"));
        for (int i = 0; i < 100; ++i) {
            cache.put((Object)i, (Object)new TestValue(i, i + 17));
            int p = i + 17;
            cache.query(new SqlFieldsQuery("insert into t(id, p) values (" + i + ", " + p + ")")).getAll();
        }
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        SnapshotFuture fut = gg.snapshot().createFullSnapshot(this.asSet(CACHE_NAME, "SQL_PUBLIC_T"), null);
        long snapshotId = fut.snapshotOperation().snapshotId();
        fut.get();
        File snapshotMovePath = this.getMoveDirWithCreate();
        SnapshotUpdateOperationParams parameters = new SnapshotUpdateOperationParams(SnapshotChainMode.SINGLE, true, false, null);
        gg.snapshot().copySnapshot(snapshotId, snapshotMovePath, parameters, null).get();
        this.stopAllGrids();
        this.cleanPersistenceDir();
        ignite = this.startGrid(1);
        this.startGrid(2);
        ignite.cluster().active(true);
        gg = (GridGain)ignite.plugin("GridGain");
        CacheConfiguration ccfgAfterRestore = this.getCacheConfig(true);
        gg.snapshot().restoreSnapshot(snapshotId, Collections.singleton(snapshotMovePath), null, true, (IgniteBiClosure & Serializable)(s, c) -> c.setCacheMode(ccfgAfterRestore.getCacheMode()).setBackups(ccfgAfterRestore.getBackups()).setQueryEntities(ccfgAfterRestore.getQueryEntities()), null).get();
        cache = ignite.cache(CACHE_NAME);
        cache.indexReadyFuture().get();
        for (int i = 1; i <= 2; ++i) {
            IgniteEx iex = this.grid(i);
            this.info("Checking grid: " + i);
            iex.cache(CACHE_NAME).indexReadyFuture().get();
        }
        IgniteH2Indexing idx = (IgniteH2Indexing)ignite.context().query().getIndexing();
        GridH2Table tbl = idx.schemaManager().dataTable("PUBLIC", "TESTVALUE");
        IgniteDbSnapshotRestoreTestWithDifferentConfig.assertNotNull((Object)tbl);
        IgniteDbSnapshotRestoreTestWithDifferentConfig.assertFalse((boolean)tbl.rebuildFromHashInProgress());
        plan = ((List)cache.query(new SqlFieldsQuery("explain select * from TestValue where v2 = ?").setArgs(new Object[]{"a"})).getAll().get(0)).get(0).toString();
        IgniteDbSnapshotRestoreTestWithDifferentConfig.assertTrue((String)plan, (boolean)plan.contains("TESTVALUE_V2_IDX"));
        plan = ((List)cache.query(new SqlFieldsQuery("explain select * from TestValue where v7 = ?").setArgs(new Object[]{"a"})).getAll().get(0)).get(0).toString();
        IgniteDbSnapshotRestoreTestWithDifferentConfig.assertFalse((String)plan, (boolean)plan.contains("TESTVALUE_V7_IDX"));
        plan = ((List)cache.query(new SqlFieldsQuery("explain select * from TestValue where v5 = ?").setArgs(new Object[]{1})).getAll().get(0)).get(0).toString();
        IgniteDbSnapshotRestoreTestWithDifferentConfig.assertTrue((String)plan, (boolean)plan.contains("TESTVALUE_V5_V6_IDX"));
        plan = ((List)cache.query(new SqlFieldsQuery("explain select * from t where p = 0")).getAll().get(0)).get(0).toString();
        IgniteDbSnapshotRestoreTestWithDifferentConfig.assertTrue((boolean)plan.contains("T_IDX"));
        for (int i = 0; i < 100; ++i) {
            IgniteDbSnapshotRestoreTestWithDifferentConfig.assertEquals((int)i, (int)((TestValue)cache.get((Object)i)).v1);
            int p = i + 17;
            List res = cache.query(new SqlFieldsQuery("select id, p from t where p = " + p)).getAll();
            IgniteDbSnapshotRestoreTestWithDifferentConfig.assertEquals((String)String.valueOf(i), (String)((List)res.get(0)).get(0).toString());
            IgniteDbSnapshotRestoreTestWithDifferentConfig.assertEquals((String)String.valueOf(p), (String)((List)res.get(0)).get(1).toString());
        }
    }

    protected static class TestValue
    implements Serializable {
        @QuerySqlField
        private final int v1;
        @QuerySqlField(index=true)
        private final int v2;
        @QuerySqlField(index=true)
        private final String v3;
        @QuerySqlField(index=true)
        private final String v4;
        @QuerySqlField
        private final int v5;
        @QuerySqlField
        private final String v6;
        @QuerySqlField
        private final String v7;
        @QuerySqlField
        private final Integer v8;
        @QuerySqlField
        private final String v9;

        protected TestValue(int v1, int v2) {
            this.v1 = v1;
            this.v2 = v2;
            this.v3 = Integer.toBinaryString(v1) + Integer.toHexString(v2);
            this.v4 = Integer.toBinaryString(v2) + Integer.toHexString(v1);
            this.v5 = v2;
            this.v6 = this.v3 + this.v4;
            this.v7 = this.v4 + this.v3;
            this.v8 = this.v5 + 1;
            this.v9 = this.v7 + "a";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TestValue value = (TestValue)o;
            return this.v1 == value.v1 && this.v2 == value.v2;
        }

        public int hashCode() {
            int result = this.v1;
            result = 31 * result + this.v2;
            return result;
        }

        public String toString() {
            return S.toString(TestValue.class, (Object)this);
        }
    }
}

