/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.failure.FailureHandler;
import org.apache.ignite.failure.StopNodeFailureHandler;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.PluginConfiguration;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.configuration.SnapshotConfiguration;
import org.gridgain.grid.persistentstore.GridSnapshot;
import org.gridgain.grid.persistentstore.RestoreSnapshotParams;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.junit.Test;

public class IgniteDbSnapshotRestoreTestWithDifferentAffinity
extends GridCommonAbstractTest {
    private static boolean affinityForOneNode;

    public IgniteConfiguration getConfiguration(String instanceName) throws Exception {
        return super.getConfiguration(instanceName).setCacheConfiguration(new CacheConfiguration[]{new CacheConfiguration("default").setCacheMode(CacheMode.PARTITIONED).setBackups(1).setAffinity((AffinityFunction)new CustomAffinityFunction())}).setDataStorageConfiguration(new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setPersistenceEnabled(true))).setPluginConfigurations(new PluginConfiguration[]{new GridGainConfiguration().setSnapshotConfiguration(new SnapshotConfiguration())});
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.cleanSnapshotDirs();
        affinityForOneNode = false;
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        this.cleanSnapshotDirs();
        super.afterTest();
        affinityForOneNode = false;
    }

    protected FailureHandler getFailureHandler(String igniteInstanceName) {
        return new StopNodeFailureHandler();
    }

    protected void cleanSnapshotDirs() throws Exception {
        this.cleanPersistenceDir();
        U.delete((File)U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"snapshot", (boolean)false));
    }

    @Test
    public void test() throws Exception {
        int nodeCount = 3;
        IgniteEx ignite = this.startGrids(nodeCount);
        ignite.cluster().state(ClusterState.ACTIVE);
        IgniteCache cache = ignite.cache("default");
        for (int i = 0; i < 100; ++i) {
            cache.put((Object)i, (Object)i);
        }
        GridGain plugin = (GridGain)ignite.plugin("GridGain");
        GridSnapshot snapshot = plugin.snapshot();
        SnapshotFuture fullFut = snapshot.createFullSnapshot(null, "full-snapshot");
        long snapshotId = fullFut.snapshotOperation().snapshotId();
        fullFut.get(this.getTestTimeout());
        ignite.cluster().state(ClusterState.INACTIVE);
        this.stopAllGrids();
        this.cleanPersistenceDir();
        affinityForOneNode = true;
        ignite = this.startGrids(nodeCount);
        ignite.cluster().state(ClusterState.ACTIVE);
        plugin = (GridGain)ignite.plugin("GridGain");
        snapshot = plugin.snapshot();
        snapshot.restore(new RestoreSnapshotParams().snapshotId(snapshotId)).get(this.getTestTimeout());
        cache = ignite.cache("default");
        for (int i = 0; i < 100; ++i) {
            IgniteDbSnapshotRestoreTestWithDifferentAffinity.assertEquals((Object)i, (Object)cache.get((Object)i));
        }
    }

    private static class CustomAffinityFunction
    extends RendezvousAffinityFunction {
        CustomAffinityFunction() {
            super(false, 16);
        }

        public List<ClusterNode> assignPartition(int part, List<ClusterNode> nodes, int backups, Map<UUID, Collection<ClusterNode>> neighborhoodCache) {
            if (affinityForOneNode) {
                if (nodes != null && !nodes.isEmpty()) {
                    return Collections.singletonList(nodes.get(0));
                }
                return Collections.emptyList();
            }
            return super.assignPartition(part, nodes, backups, neighborhoodCache);
        }
    }
}

