/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database;

import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.lang.GridAbsPredicate;
import org.apache.ignite.internal.util.lang.GridAbsPredicateX;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.testframework.GridTestUtils;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.internal.processors.cache.database.AbstractSnapshotTest;
import org.gridgain.grid.internal.processors.cache.database.SnapshotOperationStage;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotOperationInfoImpl;
import org.gridgain.grid.persistentstore.GridSnapshot;
import org.gridgain.grid.persistentstore.SnapshotChainMode;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.gridgain.grid.persistentstore.SnapshotInfo;
import org.gridgain.grid.persistentstore.SnapshotOperationType;
import org.gridgain.grid.persistentstore.SnapshotStatus;
import org.gridgain.grid.persistentstore.SnapshotUpdateOperationParams;
import org.jetbrains.annotations.NotNull;
import org.junit.Test;

public class IgniteDbSnapshotNotStableWithMoveSnapshotTopologiesTest
extends AbstractSnapshotTest {
    private boolean clientMode;
    private boolean skipPersistenceCfg;
    private int backupCount = 0;

    @Override
    protected int getBackupCount() {
        return this.backupCount;
    }

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        System.setProperty("GG_TEST_SKIP_SNAPSHOT_SYNC", "true");
    }

    @Override
    protected void afterTestsStopped() throws Exception {
        super.afterTestsStopped();
        System.clearProperty("GG_TEST_SKIP_SNAPSHOT_SYNC");
    }

    @Override
    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(gridName);
        if (gridName.startsWith("client")) {
            cfg.setClientMode(true);
        } else {
            cfg.setClientMode(this.clientMode);
        }
        if (this.skipPersistenceCfg) {
            cfg.setDataStorageConfiguration(null);
        }
        return cfg;
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.stopAllGrids();
        this.cleanSnapshotDirs();
        if (this.startDummy()) {
            this.startGrid("dummy");
            this.startGrid("client");
        }
    }

    @Override
    protected void afterTest() throws Exception {
        this.stopAllGrids();
        this.skipPersistenceCfg = false;
        this.cleanSnapshotDirs();
        this.backupCount = 0;
    }

    protected final void moveSnapshot(long snapshotId, File sharedFolder, GridSnapshot snp) {
        this.moveSnapshotAsync(snapshotId, sharedFolder, SnapshotChainMode.DEFAULT, snp).get();
    }

    protected final void moveSnapshot(long snapshotId, File sharedFolder, SnapshotChainMode mode, GridSnapshot snp) {
        this.moveSnapshotAsync(snapshotId, sharedFolder, mode, snp).get();
    }

    protected SnapshotFuture<Void> moveSnapshotAsync(long snapshotId, File sharedFolder, SnapshotChainMode mode, GridSnapshot snp) {
        return snp.moveSnapshot(snapshotId, sharedFolder, true, new SnapshotUpdateOperationParams(mode, true, false, null), null);
    }

    @NotNull
    protected SnapshotOperationType getOperationType() {
        return SnapshotOperationType.MOVE;
    }

    protected boolean startDummy() {
        return true;
    }

    private void validateData(IgniteCache<Object, Object> cache, int shift) {
        for (int i = 0; i < 300; ++i) {
            IgniteDbSnapshotNotStableWithMoveSnapshotTopologiesTest.assertEquals((String)"values in cache have diverged", (Object)(i + shift), (Object)cache.get((Object)i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMarshallerMappingsAreRestoredFromSnapshot() throws Exception {
        File moveDir = this.createOrCleanMoveDir();
        try {
            int i;
            this.startGrids(2);
            IgniteEx ig = this.ignite(0);
            ig.cluster().active(true);
            this.awaitPartitionMapExchange();
            this.loadDiverseClasses((Ignite)ig);
            GridGain gg = (GridGain)ig.plugin("GridGain");
            SnapshotFuture fut = gg.snapshot().createFullSnapshot(null, null);
            fut.get();
            this.moveSnapshot(fut.snapshotOperation().snapshotId(), moveDir, gg.snapshot());
            this.stopAllGrids();
            this.cleanPersistenceDir();
            this.startGrids(2);
            this.clientMode = true;
            this.startGrid(2);
            this.clientMode = false;
            ig = this.ignite(0);
            ig.cluster().baselineAutoAdjustEnabled(false);
            ig.cluster().active(true);
            ig.destroyCache("cache4");
            gg = (GridGain)ig.plugin("GridGain");
            gg.snapshot().restoreSnapshot(fut.snapshotOperation().snapshotId(), Collections.singleton(moveDir), null, null).get();
            for (i = 0; i < 3; ++i) {
                ig = this.grid(i);
                this.checkCacheValues((IgniteCache<Integer, Object>)ig.cache("cache4"));
            }
            this.startGrid(3);
            this.startGrid(4);
            this.clientMode = true;
            this.startGrid(5);
            this.grid(3).cluster().setBaselineTopology(ig.cluster().topologyVersion());
            IgniteDbSnapshotNotStableWithMoveSnapshotTopologiesTest.assertEquals((int)4, (int)ig.cluster().currentBaselineTopology().size());
            for (i = 0; i < 6; ++i) {
                ig = this.grid(i);
                this.checkCacheValues((IgniteCache<Integer, Object>)ig.cache("cache4"));
            }
        }
        finally {
            this.clientMode = false;
        }
    }

    private void loadDiverseClasses(Ignite ign) {
        IgniteCache cache = ign.cache("cache4");
        cache.put((Object)101, (Object)new TestValue1(101));
        cache.put((Object)102, (Object)new TestValue2(102));
        cache.put((Object)103, (Object)new TestValue3(103));
        cache.put((Object)104, (Object)new TestValue4(104));
        cache.put((Object)105, (Object)new TestValue5(105));
        cache.put((Object)106, (Object)new TestValue6(106));
        cache.put((Object)107, (Object)new TestValue7(107));
        cache.put((Object)108, (Object)new TestValue8(108));
        cache.put((Object)109, (Object)new TestValue9(109));
        cache.put((Object)110, (Object)new TestValue10(110));
    }

    private void checkCacheValues(IgniteCache<Integer, Object> cache) {
        TestValue1 v1 = (TestValue1)cache.get((Object)101);
        IgniteDbSnapshotNotStableWithMoveSnapshotTopologiesTest.assertEquals((int)101, (int)v1.getValue());
        TestValue2 v2 = (TestValue2)cache.get((Object)102);
        IgniteDbSnapshotNotStableWithMoveSnapshotTopologiesTest.assertEquals((int)102, (int)v2.getValue());
        TestValue3 v3 = (TestValue3)cache.get((Object)103);
        IgniteDbSnapshotNotStableWithMoveSnapshotTopologiesTest.assertEquals((int)103, (int)v3.getValue());
        TestValue4 v4 = (TestValue4)cache.get((Object)104);
        IgniteDbSnapshotNotStableWithMoveSnapshotTopologiesTest.assertEquals((int)104, (int)v4.getValue());
        TestValue5 v5 = (TestValue5)cache.get((Object)105);
        IgniteDbSnapshotNotStableWithMoveSnapshotTopologiesTest.assertEquals((int)105, (int)v5.getValue());
        TestValue6 v6 = (TestValue6)cache.get((Object)106);
        IgniteDbSnapshotNotStableWithMoveSnapshotTopologiesTest.assertEquals((int)106, (int)v6.getValue());
        TestValue7 v7 = (TestValue7)cache.get((Object)107);
        IgniteDbSnapshotNotStableWithMoveSnapshotTopologiesTest.assertEquals((int)107, (int)v7.getValue());
        TestValue8 v8 = (TestValue8)cache.get((Object)108);
        IgniteDbSnapshotNotStableWithMoveSnapshotTopologiesTest.assertEquals((int)108, (int)v8.getValue());
        TestValue9 v9 = (TestValue9)cache.get((Object)109);
        IgniteDbSnapshotNotStableWithMoveSnapshotTopologiesTest.assertEquals((int)109, (int)v9.getValue());
        TestValue10 v10 = (TestValue10)cache.get((Object)110);
        IgniteDbSnapshotNotStableWithMoveSnapshotTopologiesTest.assertEquals((int)110, (int)v10.getValue());
    }

    @Test
    public void testPkIndexRestored() throws Exception {
        File moveDir = this.createOrCleanMoveDir();
        this.startGrids(2);
        IgniteEx ignite = this.ignite(0);
        ignite.cluster().active(true);
        this.awaitPartitionMapExchange();
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        IgniteCache cache = ignite.cache("cache1");
        for (int i = 0; i < 300; ++i) {
            cache.put((Object)i, (Object)i);
        }
        SnapshotFuture fut = gg.snapshot().createFullSnapshot(Collections.singleton("cache1"), null);
        fut.get();
        this.moveSnapshot(fut.snapshotOperation().snapshotId(), moveDir, gg.snapshot());
        this.startGrid(2);
        gg.snapshot().restoreSnapshot(fut.snapshotOperation().snapshotId(), Collections.singleton(moveDir), Collections.singleton("cache1"), null).get();
        cache = ignite.cache("cache1");
        for (int i = 0; i < 300; ++i) {
            Integer val = (Integer)cache.get((Object)i);
            IgniteDbSnapshotNotStableWithMoveSnapshotTopologiesTest.assertNotNull((String)("index=" + i), (Object)val);
            IgniteDbSnapshotNotStableWithMoveSnapshotTopologiesTest.assertEquals((String)("index=" + i), (int)i, (int)val);
        }
        cache.indexReadyFuture().get();
        IgniteDbSnapshotNotStableWithMoveSnapshotTopologiesTest.assertEquals((int)300, (int)cache.query(new SqlFieldsQuery("select * from Integer where _key between 0 and ?").setArgs(new Object[]{300})).getAll().size());
        String plan = ((List)cache.query(new SqlFieldsQuery("explain select * from Integer where _key between 0 and ?").setArgs(new Object[]{300})).getAll().get(0)).get(0).toString();
        IgniteDbSnapshotNotStableWithMoveSnapshotTopologiesTest.assertTrue((String)plan, (boolean)plan.contains("_key_PK:"));
    }

    @Test
    public void testRestoreOnNodeWithDifferentSnapshotTag() throws Exception {
        IgniteEx ignite = this.startGrid(0);
        ignite.cluster().baselineAutoAdjustEnabled(false);
        ignite.cluster().active(true);
        this.load((Ignite)ignite);
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        SnapshotFuture fullSnapshot = gg.snapshot().createFullSnapshot(null, null);
        fullSnapshot.get();
        IgniteCache cache = ignite.cache("cache1");
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 32; ++j) {
                cache.put((Object)j, (Object)(j + i));
            }
            gg.snapshot().createSnapshot(null, null).get();
        }
        this.startGrid(1);
        ignite.cluster().setBaselineTopology(ignite.cluster().topologyVersion());
        IgniteDbSnapshotNotStableWithMoveSnapshotTopologiesTest.assertEquals((int)3, (int)ignite.cluster().currentBaselineTopology().size());
        U.sleep((long)5000L);
        this.load((Ignite)ignite);
        SnapshotFuture fullSnapshot1 = gg.snapshot().createFullSnapshot(null, null);
        fullSnapshot1.get();
        long lastSnapshotId = fullSnapshot1.snapshotOperation().snapshotId();
        File moveDir = this.createOrCleanMoveDir();
        this.moveSnapshot(lastSnapshotId, moveDir, gg.snapshot());
        this.startGrid(2);
        this.startGrid(3);
        this.startGrid(4);
        ignite.cluster().setBaselineTopology(ignite.cluster().topologyVersion());
        IgniteDbSnapshotNotStableWithMoveSnapshotTopologiesTest.assertEquals((int)6, (int)ignite.cluster().currentBaselineTopology().size());
        U.sleep((long)5000L);
        gg.snapshot().restoreSnapshot(lastSnapshotId, Collections.singleton(moveDir), null, null).get();
        for (int i = 0; i < 32; ++i) {
            cache.put((Object)i, (Object)(-i));
        }
        cache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRestoreOnNewTopology_5_Than_2() throws Exception {
        File moveDir = this.createOrCleanMoveDir();
        try {
            int i;
            this.startGrids(5);
            IgniteEx ig = this.ignite(0);
            ig.cluster().active(true);
            this.awaitPartitionMapExchange();
            GridGain gg = (GridGain)ig.plugin("GridGain");
            this.load((Ignite)ig);
            SnapshotFuture fut = gg.snapshot().createFullSnapshot(null, null);
            fut.get();
            fut = gg.snapshot().createFullSnapshot(null, null);
            fut.get();
            this.moveSnapshot(fut.snapshotOperation().snapshotId(), moveDir, gg.snapshot());
            IgniteDbSnapshotNotStableWithMoveSnapshotTopologiesTest.assertTrue((boolean)new File(moveDir.listFiles()[0], "snapshot-meta.bin").exists());
            this.stopAllGrids();
            this.cleanPersistenceDir();
            this.startGrids(2);
            ig = this.ignite(0);
            ig.cluster().baselineAutoAdjustEnabled(false);
            ig.cluster().active(true);
            ig.cluster().setBaselineTopology(ig.cluster().topologyVersion());
            IgniteDbSnapshotNotStableWithMoveSnapshotTopologiesTest.assertEquals((int)2, (int)ig.cluster().currentBaselineTopology().size());
            gg = (GridGain)ig.plugin("GridGain");
            gg.snapshot().restoreSnapshot(fut.snapshotOperation().snapshotId(), Collections.singleton(moveDir), F.asSet((Object[])new String[]{"cache1", "cache2"}), null).get();
            IgniteCache cache1 = ig.cache("cache1");
            IgniteCache cache2 = ig.cache("cache2");
            for (i = 0; i < 300; ++i) {
                Integer val1 = (Integer)cache1.get((Object)i);
                IgniteDbSnapshotNotStableWithMoveSnapshotTopologiesTest.assertNotNull((String)("index=" + i), (Object)val1);
                IgniteDbSnapshotNotStableWithMoveSnapshotTopologiesTest.assertEquals((String)("index=" + i), (int)i, (int)val1);
                AbstractSnapshotTest.TestValue val2 = (AbstractSnapshotTest.TestValue)cache2.get((Object)i);
                IgniteDbSnapshotNotStableWithMoveSnapshotTopologiesTest.assertNotNull((String)("index=" + i), (Object)val2);
                IgniteDbSnapshotNotStableWithMoveSnapshotTopologiesTest.assertEquals((String)("index=" + i), (Object)new AbstractSnapshotTest.TestValue(i, i), (Object)val2);
            }
            for (i = 0; i < 300; ++i) {
                cache1.put((Object)i, (Object)0);
                cache2.put((Object)i, (Object)new AbstractSnapshotTest.TestValue(i, i));
            }
        }
        finally {
            U.delete((File)moveDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testListSnapshotFromPreviousTopology_5_Than_2() throws Exception {
        File moveDir = this.createOrCleanMoveDir();
        try {
            IgniteEx ignite = this.startGrids(5);
            ignite.cluster().active(true);
            this.awaitPartitionMapExchange();
            GridGain gg = (GridGain)ignite.plugin("GridGain");
            IgniteCache cache1 = ignite.cache("cache1");
            IgniteCache cache2 = ignite.cache("cache2");
            for (int i = 0; i < 300; ++i) {
                cache1.put((Object)i, (Object)i);
                cache2.put((Object)i, (Object)new AbstractSnapshotTest.TestValue(i, i));
            }
            SnapshotFuture fut = gg.snapshot().createFullSnapshot(null, null);
            fut.get();
            fut = gg.snapshot().createFullSnapshot(null, null);
            fut.get();
            for (SnapshotInfo snInfo : gg.snapshot().list()) {
                this.moveSnapshot(snInfo.snapshotId(), moveDir, gg.snapshot());
            }
            this.stopAllGrids();
            this.cleanPersistenceDir();
            this.startGrids(2);
            ignite = this.ignite(0);
            ignite.cluster().baselineAutoAdjustEnabled(false);
            ignite.cluster().active(true);
            ignite.cluster().setBaselineTopology(ignite.cluster().topologyVersion());
            gg = (GridGain)ignite.plugin("GridGain");
            List infos = gg.snapshot().listSnapshots(Collections.singleton(moveDir));
            IgniteDbSnapshotNotStableWithMoveSnapshotTopologiesTest.assertEquals((int)2, (int)infos.size());
            for (SnapshotInfo info : infos) {
                gg.snapshot().checkSnapshot(info.snapshotId(), Collections.singleton(moveDir), false, null).get();
            }
        }
        finally {
            U.delete((File)moveDir);
        }
    }

    @Test
    public void testRestoreOnNewTopology_2_Than_5_Shared_Folder() throws Exception {
        int i;
        File moveDir = this.createOrCleanMoveDir();
        this.startGrids(2);
        IgniteEx ignite = this.ignite(0);
        ignite.cluster().baselineAutoAdjustEnabled(false);
        ignite.cluster().active(true);
        this.awaitPartitionMapExchange();
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        this.load((Ignite)ignite, 1);
        SnapshotFuture fut = gg.snapshot().createFullSnapshot(null, null);
        fut.get();
        this.load((Ignite)ignite);
        fut = gg.snapshot().createFullSnapshot(null, null);
        fut.get();
        this.moveSnapshot(fut.snapshotOperation().snapshotId(), moveDir, gg.snapshot());
        this.stopAllGrids();
        this.cleanSnapshotDirs(false);
        this.startGrids(5);
        ignite = this.ignite(0);
        ignite.cluster().baselineAutoAdjustEnabled(false);
        ignite.cluster().active(true);
        ignite.cluster().setBaselineTopology(ignite.cluster().topologyVersion());
        IgniteDbSnapshotNotStableWithMoveSnapshotTopologiesTest.assertEquals((int)5, (int)ignite.cluster().currentBaselineTopology().size());
        this.load((Ignite)ignite, 10);
        gg = (GridGain)ignite.plugin("GridGain");
        List issues = (List)gg.snapshot().checkSnapshot(fut.snapshotOperation().snapshotId(), Collections.singleton(moveDir), false, null).get();
        IgniteDbSnapshotNotStableWithMoveSnapshotTopologiesTest.assertTrue((boolean)issues.isEmpty());
        gg.snapshot().restoreSnapshot(fut.snapshotOperation().snapshotId(), Collections.singleton(moveDir), F.asSet((Object[])new String[]{"cache1", "cache2"}), null).get();
        IgniteCache cache1 = ignite.cache("cache1");
        IgniteCache cache2 = ignite.cache("cache2");
        for (i = 0; i < 300; ++i) {
            Integer val1 = (Integer)cache1.get((Object)i);
            IgniteDbSnapshotNotStableWithMoveSnapshotTopologiesTest.assertNotNull((String)("index=" + i), (Object)val1);
            IgniteDbSnapshotNotStableWithMoveSnapshotTopologiesTest.assertEquals((String)("index=" + i), (int)i, (int)val1);
            AbstractSnapshotTest.TestValue val2 = (AbstractSnapshotTest.TestValue)cache2.get((Object)i);
            IgniteDbSnapshotNotStableWithMoveSnapshotTopologiesTest.assertNotNull((String)("index=" + i), (Object)val2);
            IgniteDbSnapshotNotStableWithMoveSnapshotTopologiesTest.assertEquals((String)("index=" + i), (Object)new AbstractSnapshotTest.TestValue(i, i), (Object)val2);
        }
        for (i = 0; i < 300; ++i) {
            cache1.put((Object)i, (Object)0);
            cache2.put((Object)i, (Object)new AbstractSnapshotTest.TestValue(i, i));
        }
    }

    @Test
    public void testSnapshotAfterRestoringOnNewTopology() throws Exception {
        int i;
        File moveDir = this.createOrCleanMoveDir();
        this.startGrids(5);
        IgniteEx ignite = this.ignite(0);
        ignite.cluster().baselineAutoAdjustEnabled(false);
        ignite.cluster().active(true);
        this.awaitPartitionMapExchange();
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        IgniteCache cache1 = ignite.cache("cache1");
        IgniteCache cache2 = ignite.cache("cache2");
        for (int i2 = 0; i2 < 300; ++i2) {
            cache1.put((Object)i2, (Object)i2);
            cache2.put((Object)i2, (Object)new AbstractSnapshotTest.TestValue(i2, i2));
        }
        SnapshotFuture fut = gg.snapshot().createFullSnapshot(null, null);
        fut.get();
        cache1.destroy();
        cache2.destroy();
        this.moveSnapshot(fut.snapshotOperation().snapshotId(), moveDir, gg.snapshot());
        this.stopAllGrids();
        this.startGrids(2);
        ignite = this.ignite(0);
        ignite.cluster().active(true);
        ignite.cluster().setBaselineTopology(ignite.cluster().topologyVersion());
        IgniteDbSnapshotNotStableWithMoveSnapshotTopologiesTest.assertEquals((int)2, (int)ignite.cluster().currentBaselineTopology().size());
        gg = (GridGain)ignite.plugin("GridGain");
        gg.snapshot().restoreSnapshot(fut.snapshotOperation().snapshotId(), Collections.singleton(moveDir), F.asSet((Object[])new String[]{"cache1", "cache2"}), null).get();
        cache1 = ignite.cache("cache1");
        cache2 = ignite.cache("cache2");
        for (int i3 = 0; i3 < 300; ++i3) {
            cache1.put((Object)i3, (Object)(-i3));
            cache2.put((Object)i3, (Object)new AbstractSnapshotTest.TestValue(i3, -i3));
        }
        SnapshotFuture fut2 = gg.snapshot().createFullSnapshot(null, null);
        fut2.get();
        cache1.destroy();
        cache2.destroy();
        gg.snapshot().restoreSnapshot(fut2.snapshotOperation().snapshotId(), F.asSet((Object[])new String[]{"cache1", "cache2"}), null).get();
        cache1 = ignite.cache("cache1");
        cache2 = ignite.cache("cache2");
        for (i = 0; i < 300; ++i) {
            Integer val1 = (Integer)cache1.get((Object)i);
            IgniteDbSnapshotNotStableWithMoveSnapshotTopologiesTest.assertNotNull((String)("index=" + i), (Object)val1);
            IgniteDbSnapshotNotStableWithMoveSnapshotTopologiesTest.assertEquals((String)("index=" + i), (int)(-i), (int)val1);
            AbstractSnapshotTest.TestValue val2 = (AbstractSnapshotTest.TestValue)cache2.get((Object)i);
            IgniteDbSnapshotNotStableWithMoveSnapshotTopologiesTest.assertNotNull((String)("index=" + i), (Object)val2);
            IgniteDbSnapshotNotStableWithMoveSnapshotTopologiesTest.assertEquals((String)("index=" + i), (Object)new AbstractSnapshotTest.TestValue(i, -i), (Object)val2);
        }
        for (i = 0; i < 300; ++i) {
            cache1.put((Object)i, (Object)0);
            cache2.put((Object)i, (Object)new AbstractSnapshotTest.TestValue(i, i));
        }
    }

    @Test
    public void testRestoreIncrementalSnapshotOnNewTopology() throws Exception {
        int i;
        File moveDir = this.createOrCleanMoveDir();
        this.startGrids(5);
        IgniteEx ignite = this.ignite(0);
        ignite.cluster().baselineAutoAdjustEnabled(false);
        ignite.cluster().active(true);
        this.awaitPartitionMapExchange();
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        IgniteCache cache1 = ignite.cache("cache1");
        IgniteCache cache2 = ignite.cache("cache2");
        for (int i2 = 0; i2 < 300; ++i2) {
            cache1.put((Object)i2, (Object)i2);
            cache2.put((Object)i2, (Object)new AbstractSnapshotTest.TestValue(i2, i2));
        }
        SnapshotFuture fut = gg.snapshot().createFullSnapshot(null, null);
        fut.get();
        fut = gg.snapshot().createFullSnapshot(null, null);
        for (int i3 = 0; i3 < 300; ++i3) {
            cache1.put((Object)i3, (Object)(-i3));
            cache2.put((Object)i3, (Object)new AbstractSnapshotTest.TestValue(i3, -i3));
        }
        fut.get();
        SnapshotFuture fut2 = gg.snapshot().createFullSnapshot(null, null);
        fut2.get();
        this.moveSnapshot(fut2.snapshotOperation().snapshotId(), moveDir, gg.snapshot());
        cache1.destroy();
        cache2.destroy();
        this.stopAllGrids();
        this.startGrids(2);
        ignite = this.ignite(0);
        ignite.cluster().active(true);
        ignite.cluster().setBaselineTopology(ignite.cluster().topologyVersion());
        IgniteDbSnapshotNotStableWithMoveSnapshotTopologiesTest.assertEquals((int)2, (int)ignite.cluster().currentBaselineTopology().size());
        gg = (GridGain)ignite.plugin("GridGain");
        gg.snapshot().restoreSnapshot(fut2.snapshotOperation().snapshotId(), Collections.singleton(moveDir), F.asSet((Object[])new String[]{"cache1", "cache2"}), null).get();
        cache1 = ignite.cache("cache1");
        cache2 = ignite.cache("cache2");
        for (i = 0; i < 300; ++i) {
            Integer val1 = (Integer)cache1.get((Object)i);
            IgniteDbSnapshotNotStableWithMoveSnapshotTopologiesTest.assertNotNull((String)("index=" + i), (Object)val1);
            IgniteDbSnapshotNotStableWithMoveSnapshotTopologiesTest.assertEquals((String)("index=" + i), (int)(-i), (int)val1);
            AbstractSnapshotTest.TestValue val2 = (AbstractSnapshotTest.TestValue)cache2.get((Object)i);
            IgniteDbSnapshotNotStableWithMoveSnapshotTopologiesTest.assertNotNull((String)("index=" + i), (Object)val2);
            IgniteDbSnapshotNotStableWithMoveSnapshotTopologiesTest.assertEquals((String)("index=" + i), (Object)new AbstractSnapshotTest.TestValue(i, -i), (Object)val2);
        }
        for (i = 0; i < 300; ++i) {
            cache1.put((Object)i, (Object)0);
            cache2.put((Object)i, (Object)new AbstractSnapshotTest.TestValue(i, i));
        }
    }

    @Test
    public void testCancelling_MoveAndCreateAndRestore() throws Exception {
        File moveDir = this.createOrCleanMoveDir();
        this.startGrids(3);
        IgniteEx ignite = this.ignite(0);
        ignite.cluster().active(true);
        this.awaitPartitionMapExchange();
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        IgniteCache cache1 = ignite.getOrCreateCache("newCache1");
        int totalEntriesCount = 102400;
        try (IgniteDataStreamer streamer = ignite.dataStreamer("newCache1");){
            streamer.allowOverwrite(true);
            for (int i = 0; i < totalEntriesCount; ++i) {
                streamer.addData((Object)i, (Object)i);
            }
        }
        SnapshotFuture fut = gg.snapshot().createFullSnapshot(null, null);
        fut.initFuture().get();
        IgniteFuture cancelCreateFut = gg.snapshot().cancelSnapshotOperation(fut.operationId(), null);
        IgniteDbSnapshotNotStableWithMoveSnapshotTopologiesTest.assertTrue((boolean)((Boolean)cancelCreateFut.get()));
        IgniteDbSnapshotNotStableWithMoveSnapshotTopologiesTest.assertEquals((int)0, (int)gg.snapshot().list().size());
        fut = gg.snapshot().createFullSnapshot(null, null);
        fut.get();
        SnapshotFuture<Void> moveFut = this.moveSnapshotAsync(fut.snapshotOperation().snapshotId(), moveDir, SnapshotChainMode.DEFAULT, gg.snapshot());
        moveFut.initFuture().get();
        for (Object ig : G.allGrids()) {
            gg = (GridGain)ig.plugin("GridGain");
            SnapshotStatus status = gg.snapshot().ongoingSnapshotOperation();
            IgniteDbSnapshotNotStableWithMoveSnapshotTopologiesTest.assertNotNull((String)("futIsDone = " + moveFut.isDone()), (Object)status);
            SnapshotOperationInfoImpl snapOpImpl = (SnapshotOperationInfoImpl)status.operation();
            IgniteDbSnapshotNotStableWithMoveSnapshotTopologiesTest.assertEquals((Object)this.getOperationType(), (Object)snapOpImpl.snapshotOperation().type());
        }
        IgniteFuture cancelMoveFut = gg.snapshot().cancelSnapshotOperation(moveFut.operationId(), null);
        IgniteDbSnapshotNotStableWithMoveSnapshotTopologiesTest.assertTrue((boolean)((Boolean)cancelMoveFut.get()));
        for (final Ignite ig : G.allGrids()) {
            GridTestUtils.waitForCondition((GridAbsPredicate)new GridAbsPredicateX(){

                public boolean applyx() {
                    GridGain gg = (GridGain)ig.plugin("GridGain");
                    SnapshotStatus status = gg.snapshot().ongoingSnapshotOperation();
                    return status == null;
                }
            }, (long)10000L);
        }
        try {
            moveFut.get();
            IgniteDbSnapshotNotStableWithMoveSnapshotTopologiesTest.fail();
        }
        catch (Exception ig) {
            // empty catch block
        }
        IgniteDbSnapshotNotStableWithMoveSnapshotTopologiesTest.assertEquals((int)1, (int)gg.snapshot().list().size());
        gg.snapshot().deleteSnapshot(fut.snapshotOperation().snapshotId(), (SnapshotUpdateOperationParams)null, null).get();
        SnapshotFuture newSnapFut = gg.snapshot().createFullSnapshot(null, null);
        newSnapFut.get();
        SnapshotFuture restoreFut = gg.snapshot().restoreSnapshot(fut.snapshotOperation().snapshotId(), Collections.singleton(moveDir), null, null);
        try {
            restoreFut.get();
            IgniteDbSnapshotNotStableWithMoveSnapshotTopologiesTest.fail((String)"We should fail if we try to restore on not existing snapshot");
        }
        catch (Exception ig) {
            // empty catch block
        }
        CountDownLatch latch = this.addWaitingStageFinishListener(SnapshotOperationStage.SECOND, this.grid(2));
        SnapshotFuture<Void> moveFut2 = this.moveSnapshotAsync(newSnapFut.snapshotOperation().snapshotId(), moveDir, SnapshotChainMode.DEFAULT, gg.snapshot());
        latch.await();
        IgniteFuture cancelMoveFut2 = gg.snapshot().forceCancelSnapshotOperation(moveFut2.operationId(), null);
        IgniteDbSnapshotNotStableWithMoveSnapshotTopologiesTest.assertTrue((boolean)((Boolean)cancelMoveFut2.get()));
        try {
            moveFut2.get();
            IgniteDbSnapshotNotStableWithMoveSnapshotTopologiesTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (int i = 0; i < 300; ++i) {
            cache1.put((Object)i, (Object)(300 - i));
        }
        SnapshotFuture restoreFuture = gg.snapshot().restoreSnapshot(newSnapFut.snapshotOperation().snapshotId(), Collections.singleton(moveDir), null, null);
        restoreFuture.initFuture().get();
        IgniteDbSnapshotNotStableWithMoveSnapshotTopologiesTest.assertTrue((boolean)((Boolean)gg.snapshot().cancelSnapshotOperation(restoreFuture.operationId(), null).get()));
        IgniteDbSnapshotNotStableWithMoveSnapshotTopologiesTest.assertEquals((int)totalEntriesCount, (int)cache1.size(new CachePeekMode[0]));
        for (int i = 0; i < 300; ++i) {
            IgniteDbSnapshotNotStableWithMoveSnapshotTopologiesTest.assertEquals((Object)(300 - i), (Object)cache1.get((Object)i));
        }
        gg.snapshot().restoreSnapshot(newSnapFut.snapshotOperation().snapshotId(), Collections.singleton(moveDir), null, null).get();
        for (int i = 0; i < 300; ++i) {
            IgniteDbSnapshotNotStableWithMoveSnapshotTopologiesTest.assertEquals((Object)i, (Object)cache1.get((Object)i));
        }
        gg.snapshot().createFullSnapshot(null, null).get();
    }

    @Test
    public void testMoveSnapshotAndRestore() throws Exception {
        File moveDir = this.createOrCleanMoveDir();
        this.startGrids(3);
        IgniteEx ignite = this.ignite(0);
        ignite.cluster().active(true);
        this.awaitPartitionMapExchange();
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        this.load((Ignite)ignite);
        SnapshotFuture fut = gg.snapshot().createFullSnapshot(null, null);
        fut.get();
        this.load((Ignite)ignite, 10);
        SnapshotFuture fut2 = gg.snapshot().createSnapshot(null, null);
        fut2.get();
        try {
            File tmp = new File(moveDir, "tmp");
            tmp.createNewFile();
            this.moveSnapshot(fut.snapshotOperation().snapshotId(), tmp, SnapshotChainMode.FROM_CURRENT_TO_LAST, gg.snapshot());
            IgniteDbSnapshotNotStableWithMoveSnapshotTopologiesTest.fail((String)"Should not move the snapshot when path is file");
        }
        catch (IgniteException e) {
            IgniteDbSnapshotNotStableWithMoveSnapshotTopologiesTest.assertTrue((boolean)e.getMessage().contains("tmp"));
        }
        this.moveSnapshot(fut.snapshotOperation().snapshotId(), moveDir, SnapshotChainMode.FROM_CURRENT_TO_LAST, gg.snapshot());
        File[] files = moveDir.listFiles();
        IgniteDbSnapshotNotStableWithMoveSnapshotTopologiesTest.assertTrue((String)Arrays.asList(files).toString(), (files.length >= 2 ? 1 : 0) != 0);
        for (String snapDir : this.snapshotFolders()) {
            File snapshotDir = U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)snapDir, (boolean)false);
            IgniteDbSnapshotNotStableWithMoveSnapshotTopologiesTest.assertEquals((String)Arrays.toString(snapshotDir.listFiles()), (int)0, (int)snapshotDir.listFiles().length);
        }
        this.stopAllGrids();
        this.startGrids(3);
        this.startGrid("dummy");
        ignite = this.ignite(0);
        ignite.cluster().active(true);
        ignite.destroyCache("cache1");
        ignite.destroyCache("cache2");
        gg = (GridGain)ignite.plugin("GridGain");
        gg.snapshot().restoreSnapshot(fut2.snapshotOperation().snapshotId(), Collections.singleton(moveDir), null, null).get();
        IgniteCache cache1 = ignite.cache("cache1");
        IgniteCache cache2 = ignite.cache("cache2");
        for (int i = 0; i < 300; ++i) {
            Integer val1 = (Integer)cache1.get((Object)i);
            IgniteDbSnapshotNotStableWithMoveSnapshotTopologiesTest.assertNotNull((String)("index=" + i), (Object)val1);
            IgniteDbSnapshotNotStableWithMoveSnapshotTopologiesTest.assertEquals((String)("index=" + i), (int)(i + 10), (int)val1);
            AbstractSnapshotTest.TestValue val2 = (AbstractSnapshotTest.TestValue)cache2.get((Object)i);
            IgniteDbSnapshotNotStableWithMoveSnapshotTopologiesTest.assertNotNull((String)("index=" + i), (Object)val2);
            IgniteDbSnapshotNotStableWithMoveSnapshotTopologiesTest.assertEquals((String)("index=" + i), (Object)new AbstractSnapshotTest.TestValue(i, i + 10), (Object)val2);
        }
    }

    @Test
    public void testMoveSnapshotAndRestoreWithStoppedNodeAfterSnapshotCreation() throws Exception {
        this.stopAllGrids();
        this.backupCount = 1;
        File moveDir = this.createOrCleanMoveDir();
        this.startGrids(3);
        IgniteEx ignite = this.ignite(0);
        ignite.cluster().active(true);
        this.awaitPartitionMapExchange();
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        this.load((Ignite)ignite);
        SnapshotFuture fut = gg.snapshot().createFullSnapshot(null, null);
        fut.get();
        this.stopGrid(2);
        this.moveSnapshot(fut.snapshotOperation().snapshotId(), moveDir, gg.snapshot());
        this.stopAllGrids();
        this.cleanSnapshotDirs(false);
        this.startGrids(4);
        ignite = this.ignite(0);
        ignite.cluster().active(true);
        IgniteDbSnapshotNotStableWithMoveSnapshotTopologiesTest.assertEquals((int)4, (int)ignite.cluster().currentBaselineTopology().size());
        gg = (GridGain)ignite.plugin("GridGain");
        IgniteCache cache1 = ignite.cache("cache1");
        IgniteCache cache2 = ignite.cache("cache2");
        IgniteDbSnapshotNotStableWithMoveSnapshotTopologiesTest.assertEquals((int)0, (int)cache1.size(new CachePeekMode[0]));
        IgniteDbSnapshotNotStableWithMoveSnapshotTopologiesTest.assertEquals((int)0, (int)cache2.size(new CachePeekMode[0]));
        gg.snapshot().restoreSnapshot(fut.snapshotOperation().snapshotId(), Collections.singleton(moveDir), null, null).get();
        for (int i = 0; i < 300; ++i) {
            Integer val1 = (Integer)cache1.get((Object)i);
            IgniteDbSnapshotNotStableWithMoveSnapshotTopologiesTest.assertNotNull((String)("index=" + i), (Object)val1);
            IgniteDbSnapshotNotStableWithMoveSnapshotTopologiesTest.assertEquals((String)("index=" + i), (int)i, (int)val1);
            AbstractSnapshotTest.TestValue val2 = (AbstractSnapshotTest.TestValue)cache2.get((Object)i);
            IgniteDbSnapshotNotStableWithMoveSnapshotTopologiesTest.assertNotNull((String)("index=" + i), (Object)val2);
            IgniteDbSnapshotNotStableWithMoveSnapshotTopologiesTest.assertEquals((String)("index=" + i), (Object)new AbstractSnapshotTest.TestValue(i, i), (Object)val2);
        }
    }

    private static class TestValue10
    implements Serializable {
        private final int val;

        TestValue10(int val) {
            this.val = val;
        }

        int getValue() {
            return this.val;
        }
    }

    private static class TestValue9
    implements Serializable {
        private final int val;

        TestValue9(int val) {
            this.val = val;
        }

        int getValue() {
            return this.val;
        }
    }

    private static class TestValue8
    implements Serializable {
        private final int val;

        TestValue8(int val) {
            this.val = val;
        }

        int getValue() {
            return this.val;
        }
    }

    private static class TestValue7
    implements Serializable {
        private final int val;

        TestValue7(int val) {
            this.val = val;
        }

        int getValue() {
            return this.val;
        }
    }

    private static class TestValue6
    implements Serializable {
        private final int val;

        TestValue6(int val) {
            this.val = val;
        }

        int getValue() {
            return this.val;
        }
    }

    private static class TestValue5
    implements Serializable {
        private final int val;

        TestValue5(int val) {
            this.val = val;
        }

        int getValue() {
            return this.val;
        }
    }

    private static class TestValue4
    implements Serializable {
        private final int val;

        TestValue4(int val) {
            this.val = val;
        }

        int getValue() {
            return this.val;
        }
    }

    private static class TestValue3
    implements Serializable {
        private final int val;

        TestValue3(int val) {
            this.val = val;
        }

        int getValue() {
            return this.val;
        }
    }

    private static class TestValue2
    implements Serializable {
        private final int val;

        TestValue2(int val) {
            this.val = val;
        }

        int getValue() {
            return this.val;
        }
    }

    private static class TestValue1
    implements Serializable {
        private final int val;

        TestValue1(int val) {
            this.val = val;
        }

        int getValue() {
            return this.val;
        }
    }
}

