/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database;

import java.io.Serializable;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.metastorage.DistributedMetaStorage;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.internal.processors.cache.database.AbstractSnapshotTest;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.junit.Test;

public class IgniteDbSnapshotDistributedMetastorageTest
extends AbstractSnapshotTest {
    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.stopAllGrids();
        this.cleanSnapshotDirs();
    }

    @Override
    protected void afterTest() throws Exception {
        super.afterTest();
        this.stopAllGrids();
        this.cleanSnapshotDirs();
    }

    @Test
    public void testSimpleMetastorageReadsAfterSnapshotRestore() throws Exception {
        String keyBefore = "key0";
        String keyAfter = "key1";
        String firstVal0 = "valBefore0";
        String lastVal0 = "valAfter0";
        String lastVal1 = "valAfter1";
        IgniteEx ignite = this.startGrids(2);
        ignite.cluster().active(true);
        DistributedMetaStorage metastorage = ignite.context().distributedMetastorage();
        metastorage.write(keyBefore, (Serializable)((Object)firstVal0));
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        SnapshotFuture snapshotFuture = gg.snapshot().createFullSnapshot(null, null);
        snapshotFuture.get();
        metastorage.write(keyBefore, (Serializable)((Object)lastVal0));
        metastorage.write(keyAfter, (Serializable)((Object)lastVal1));
        gg.snapshot().restoreSnapshot(snapshotFuture.snapshotOperation().snapshotId(), null, null).get();
        metastorage = ignite.context().distributedMetastorage();
        String keyBeforeVal = (String)((Object)metastorage.read(keyBefore));
        String keyAfterVal = (String)((Object)metastorage.read(keyAfter));
        IgniteDbSnapshotDistributedMetastorageTest.assertNotNull((Object)keyBeforeVal);
        IgniteDbSnapshotDistributedMetastorageTest.assertNotNull((Object)keyAfterVal);
        IgniteDbSnapshotDistributedMetastorageTest.assertEquals((String)keyBeforeVal, (String)lastVal0);
        IgniteDbSnapshotDistributedMetastorageTest.assertEquals((String)keyAfterVal, (String)lastVal1);
    }
}

