/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.internal.processors.cache.database.AbstractSnapshotTest;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CompressionOption;
import org.gridgain.grid.internal.processors.cache.database.snapshot.DatabaseSnapshotSpi;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridCacheSnapshotManager;
import org.gridgain.grid.internal.processors.cache.database.snapshot.LatestSnapshotMismatchHandlingPolicy;
import org.gridgain.grid.internal.processors.cache.database.snapshot.Snapshot;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotCreateParameters;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotMetadataV2;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotUtils;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.SnapshotPath;
import org.gridgain.grid.persistentstore.GridSnapshot;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.gridgain.grid.persistentstore.SnapshotIssue;
import org.gridgain.grid.persistentstore.snapshot.file.FileSnapshot;
import org.junit.Test;

public class IgniteDbSnapshoIncrementalDifferentChainsTest
extends AbstractSnapshotTest {
    private static final String NORMAL = "normal";
    private static final String LEAVER = "leaver";
    private static SnapshotCreateParameters createParameters;
    private Map<String, Integer> entryCount;

    protected void beforeTest() throws Exception {
        this.stopAllGrids();
        this.cleanSnapshotDirs();
        createParameters = null;
        this.entryCount = new HashMap<String, Integer>();
    }

    @Override
    protected void afterTest() throws Exception {
        this.stopAllGrids();
        this.cleanSnapshotDirs();
    }

    @Override
    protected void afterTestsStopped() throws Exception {
    }

    @Override
    protected int getBackupCount() {
        return 2;
    }

    @Test
    public void testWithoutFullPolicyIncrementalOrIgnore() throws Exception {
        createParameters = this.parameters(LatestSnapshotMismatchHandlingPolicy.INCREMENTAL_OR_IGNORE);
        long snapshotId = this.incrementalSnapshotWithoutFull(true);
        SnapshotMetadataV2 normalMetadata = this.metadata(NORMAL, this.snapshot(NORMAL, snapshotId));
        IgniteDbSnapshoIncrementalDifferentChainsTest.assertNotNull((Object)normalMetadata);
        IgniteDbSnapshoIncrementalDifferentChainsTest.assertNull((Object)this.snapshot(LEAVER, snapshotId));
    }

    @Test
    public void testWithoutFullPolicyIncrementalOrIgnoreNormalInitiator() throws Exception {
        createParameters = this.parameters(LatestSnapshotMismatchHandlingPolicy.INCREMENTAL_OR_IGNORE);
        long snapshotId = this.incrementalSnapshotWithoutFull(false);
        SnapshotMetadataV2 normalMetadata = this.metadata(NORMAL, this.snapshot(NORMAL, snapshotId));
        IgniteDbSnapshoIncrementalDifferentChainsTest.assertNotNull((Object)normalMetadata);
        IgniteDbSnapshoIncrementalDifferentChainsTest.assertNull((Object)this.snapshot(LEAVER, snapshotId));
    }

    @Test
    public void testWithoutFullPolicyIncrementalOrFull() throws Exception {
        createParameters = this.parameters(LatestSnapshotMismatchHandlingPolicy.INCREMENTAL_OR_FULL);
        long snapshotId = this.incrementalSnapshotWithoutFull(true);
        this.validateIncrementalSnapshotWithoutFull(snapshotId, false, true, 1, 3);
    }

    @Test
    public void testWithoutFullPolicyIncrementalOrFullNormalInitiator() throws Exception {
        createParameters = this.parameters(LatestSnapshotMismatchHandlingPolicy.INCREMENTAL_OR_FULL);
        long snapshotId = this.incrementalSnapshotWithoutFull(false);
        this.validateIncrementalSnapshotWithoutFull(snapshotId, false, true, 1, 3);
    }

    private void validateIncrementalSnapshotWithoutFull(long snapshotId, boolean mergedIsFull, boolean isFull, int leaverChainSize, int normalChainSize) throws Exception {
        this.grid(LEAVER).getOrCreateCache("cache1").clear();
        List<SnapshotIssue> issues = this.checkSnapshot(LEAVER, snapshotId);
        IgniteDbSnapshoIncrementalDifferentChainsTest.assertEquals((int)0, (int)issues.size());
        this.restoreSnapshot(LEAVER, snapshotId, Collections.singleton("cache1"));
        FileSnapshot leaverInc2 = this.snapshot(LEAVER, snapshotId);
        FileSnapshot normieInc2 = this.snapshot(NORMAL, snapshotId);
        IgniteDbSnapshoIncrementalDifferentChainsTest.assertEquals((boolean)mergedIsFull, (boolean)leaverInc2.metadata().fullSnapshot());
        SnapshotMetadataV2 leaverMd = this.metadata(LEAVER, leaverInc2);
        IgniteDbSnapshoIncrementalDifferentChainsTest.assertEquals((boolean)isFull, (boolean)leaverMd.fullSnapshot());
        List<Snapshot> previousLeaverSnapshots = this.previousSnapshots(leaverInc2);
        IgniteDbSnapshoIncrementalDifferentChainsTest.assertEquals((int)leaverChainSize, (int)previousLeaverSnapshots.size());
        List<Snapshot> previousNormieSnapshots = this.previousSnapshots(normieInc2);
        IgniteDbSnapshoIncrementalDifferentChainsTest.assertEquals((int)normalChainSize, (int)previousNormieSnapshots.size());
        this.stopGrid(LEAVER);
        this.stopGrid(NORMAL);
        this.startGrid(LEAVER);
        this.grid(LEAVER).cluster().state(ClusterState.ACTIVE);
        this.validateCache(LEAVER, "cache1");
        this.stopGrid(LEAVER);
        this.startGrid(NORMAL);
        this.grid(NORMAL).cluster().state(ClusterState.ACTIVE);
        this.validateCache(NORMAL, "cache1");
    }

    private long incrementalSnapshotWithoutFull(boolean leaverIsInitiator) throws Exception {
        this.startGrid(NORMAL);
        this.startGrid(LEAVER);
        this.grid(NORMAL).cluster().state(ClusterState.ACTIVE);
        this.fillCache(NORMAL, "cache1");
        this.stopGrid(LEAVER);
        this.fullSnapshot(NORMAL, "full", Collections.singleton("cache1"));
        this.startGrid(LEAVER);
        this.awaitPartitionMapExchange();
        this.fillCache(LEAVER, "cache1");
        this.stopGrid(LEAVER);
        this.incrementalSnapshot(NORMAL, "inc-1", Collections.singleton("cache1"));
        this.fillCache(NORMAL, "cache1");
        this.startGrid(LEAVER);
        this.awaitPartitionMapExchange();
        this.fillCache(LEAVER, "cache1");
        SnapshotFuture<Void> snapshotFut = this.incrementalSnapshot(leaverIsInitiator ? LEAVER : NORMAL, "inc-2", Collections.singleton("cache1"));
        long snapshotId = snapshotFut.snapshotOperation().snapshotId();
        snapshotFut.get();
        return snapshotId;
    }

    @Test
    public void testDifferentBasePolicyIncrementalOrIgnore() throws Exception {
        createParameters = this.parameters(LatestSnapshotMismatchHandlingPolicy.INCREMENTAL_OR_IGNORE);
        long snapshotId = this.incrementalSnapshotWithDifferentIntermediateIncrementals(true);
        this.validateIncrementalSnapshotWithoutFull(snapshotId, false, false, 2, 3);
    }

    @Test
    public void testDifferentBasePolicyIncrementalOrIgnoreNormalInitiator() throws Exception {
        createParameters = this.parameters(LatestSnapshotMismatchHandlingPolicy.INCREMENTAL_OR_IGNORE);
        long snapshotId = this.incrementalSnapshotWithDifferentIntermediateIncrementals(false);
        this.validateIncrementalSnapshotWithoutFull(snapshotId, false, false, 2, 3);
    }

    @Test
    public void testDifferentBasePolicyIncrementalOrFull() throws Exception {
        createParameters = this.parameters(LatestSnapshotMismatchHandlingPolicy.INCREMENTAL_OR_FULL);
        long snapshotId = this.incrementalSnapshotWithDifferentIntermediateIncrementals(true);
        this.validateIncrementalSnapshotWithoutFull(snapshotId, false, false, 2, 3);
    }

    @Test
    public void testDifferentBasePolicyIncrementalOrFullNormalInitiator() throws Exception {
        createParameters = this.parameters(LatestSnapshotMismatchHandlingPolicy.INCREMENTAL_OR_FULL);
        long snapshotId = this.incrementalSnapshotWithDifferentIntermediateIncrementals(false);
        this.validateIncrementalSnapshotWithoutFull(snapshotId, false, false, 2, 3);
    }

    private long incrementalSnapshotWithDifferentIntermediateIncrementals(boolean leaverIsInitiator) throws Exception {
        this.startGrid(NORMAL);
        this.startGrid(LEAVER);
        this.grid(NORMAL).cluster().state(ClusterState.ACTIVE);
        this.fillCache(NORMAL, "cache1");
        this.fullSnapshot(NORMAL, "full", Collections.singleton("cache1"));
        this.fillCache(LEAVER, "cache1");
        this.stopGrid(LEAVER);
        this.incrementalSnapshot(NORMAL, "inc-1", Collections.singleton("cache1"));
        this.fillCache(NORMAL, "cache1");
        this.startGrid(LEAVER);
        this.awaitPartitionMapExchange();
        this.fillCache(LEAVER, "cache1");
        SnapshotFuture<Void> snapshotFut = this.incrementalSnapshot(leaverIsInitiator ? LEAVER : NORMAL, "inc-2", Collections.singleton("cache1"));
        long snapshotId = snapshotFut.snapshotOperation().snapshotId();
        snapshotFut.get();
        return snapshotId;
    }

    @Test
    public void testDifferentFullPolicyIncrementalOrIgnore() throws Exception {
        createParameters = this.parameters(LatestSnapshotMismatchHandlingPolicy.INCREMENTAL_OR_IGNORE);
        long snapshotId = this.incrementalSnapshotWithDifferentFulls(true);
        SnapshotMetadataV2 normalMetadata = this.metadata(NORMAL, this.snapshot(NORMAL, snapshotId));
        IgniteDbSnapshoIncrementalDifferentChainsTest.assertNotNull((Object)normalMetadata);
        IgniteDbSnapshoIncrementalDifferentChainsTest.assertNull((Object)this.snapshot(LEAVER, snapshotId));
    }

    @Test
    public void testDifferentFullPolicyIncrementalOrIgnoreNormalInitiator() throws Exception {
        createParameters = this.parameters(LatestSnapshotMismatchHandlingPolicy.INCREMENTAL_OR_IGNORE);
        long snapshotId = this.incrementalSnapshotWithDifferentFulls(false);
        SnapshotMetadataV2 normalMetadata = this.metadata(NORMAL, this.snapshot(NORMAL, snapshotId));
        IgniteDbSnapshoIncrementalDifferentChainsTest.assertNotNull((Object)normalMetadata);
        IgniteDbSnapshoIncrementalDifferentChainsTest.assertNull((Object)this.snapshot(LEAVER, snapshotId));
    }

    @Test
    public void testDifferentFullPolicyIncrementalOrFull() throws Exception {
        createParameters = this.parameters(LatestSnapshotMismatchHandlingPolicy.INCREMENTAL_OR_FULL);
        long snapshotId = this.incrementalSnapshotWithDifferentFulls(true);
        this.validateIncrementalSnapshotWithoutFull(snapshotId, false, true, 1, 3);
    }

    @Test
    public void testDifferentFullPolicyIncrementalOrFullNormalInitiator() throws Exception {
        createParameters = this.parameters(LatestSnapshotMismatchHandlingPolicy.INCREMENTAL_OR_FULL);
        long snapshotId = this.incrementalSnapshotWithDifferentFulls(false);
        this.validateIncrementalSnapshotWithoutFull(snapshotId, false, true, 1, 3);
    }

    private long incrementalSnapshotWithDifferentFulls(boolean leaverIsInitiator) throws Exception {
        this.startGrid(NORMAL);
        this.startGrid(LEAVER);
        this.grid(NORMAL).cluster().state(ClusterState.ACTIVE);
        this.fillCache(NORMAL, "cache1");
        this.fullSnapshot(NORMAL, "full-1", Collections.singleton("cache1"));
        this.fillCache(LEAVER, "cache1");
        this.stopGrid(LEAVER);
        this.fullSnapshot(NORMAL, "full-2", Collections.singleton("cache1"));
        this.fillCache(NORMAL, "cache1");
        this.incrementalSnapshot(NORMAL, "inc-1", Collections.singleton("cache1"));
        this.fillCache(NORMAL, "cache1");
        this.startGrid(LEAVER);
        this.awaitPartitionMapExchange();
        this.fillCache(LEAVER, "cache1");
        SnapshotFuture<Void> snapshotFut = this.incrementalSnapshot(leaverIsInitiator ? LEAVER : NORMAL, "inc-2", Collections.singleton("cache1"));
        long snapshotId = snapshotFut.snapshotOperation().snapshotId();
        snapshotFut.get();
        return snapshotId;
    }

    private void fillCache(String igniteName, String cacheName) {
        IgniteCache cache = this.grid(igniteName).getOrCreateCache(this.getCacheConfig(cacheName));
        int count = this.entryCount.getOrDefault(cacheName, 0);
        for (int i = 0; i < 32; ++i) {
            cache.put((Object)(i + count), (Object)i);
        }
        this.entryCount.put(cacheName, count + 32);
    }

    private void validateCache(String igniteName, String cacheName) {
        IgniteCache cache = this.grid(igniteName).getOrCreateCache(this.getCacheConfig(cacheName));
        for (int i = 0; i < this.entryCount.get(cacheName); ++i) {
            IgniteDbSnapshoIncrementalDifferentChainsTest.assertEquals((Object)(i % 32), (Object)cache.get((Object)i));
        }
    }

    private SnapshotFuture<Void> fullSnapshot(String igniteName, String name, Set<String> caches) {
        GridGain gg = (GridGain)this.grid(igniteName).plugin("GridGain");
        GridSnapshot snapshot = gg.snapshot();
        SnapshotFuture fullSnapshotFut = snapshot.createFullSnapshot(caches, null, createParameters, name);
        fullSnapshotFut.get();
        return fullSnapshotFut;
    }

    private FileSnapshot snapshot(String igniteName, long snapshotId) {
        GridCacheSnapshotManager snapMgr = (GridCacheSnapshotManager)this.grid(igniteName).context().cache().context().snapshot();
        DatabaseSnapshotSpi snapshotSpi = snapMgr.snapshotSpi();
        Snapshot snap = snapshotSpi.snapshot(snapshotId, null, null, true, null, false);
        return (FileSnapshot)snap;
    }

    private SnapshotFuture<Void> incrementalSnapshot(String igniteName, String name, Set<String> caches) {
        GridGain gg = (GridGain)this.grid(igniteName).plugin("GridGain");
        GridSnapshot snapshot = gg.snapshot();
        SnapshotFuture incSnapshotFut = snapshot.createSnapshot(caches, null, createParameters, name);
        incSnapshotFut.get();
        return incSnapshotFut;
    }

    private SnapshotFuture<Void> restoreSnapshot(String igniteName, long snapshotId, Set<String> caches) {
        GridGain gg = (GridGain)this.grid(igniteName).plugin("GridGain");
        GridSnapshot snapshot = gg.snapshot();
        SnapshotFuture restoreSnapshotFut = snapshot.restoreSnapshot(snapshotId, caches, "restore snapshot");
        restoreSnapshotFut.get();
        return restoreSnapshotFut;
    }

    private List<SnapshotIssue> checkSnapshot(String igniteName, long snapshotId) {
        GridGain gg = (GridGain)this.grid(igniteName).plugin("GridGain");
        GridSnapshot snapshot = gg.snapshot();
        return (List)snapshot.checkSnapshot(snapshotId, null, true, "check snapshot").get();
    }

    private SnapshotCreateParameters parameters(LatestSnapshotMismatchHandlingPolicy policy) {
        return new SnapshotCreateParameters(CompressionOption.NONE, -1, 0, true, null, null, policy);
    }

    private List<Snapshot> previousSnapshots(FileSnapshot snapshot) {
        return StreamSupport.stream(snapshot.getPreviousSnapshots(null, null).spliterator(), false).collect(Collectors.toList());
    }

    private SnapshotMetadataV2 metadata(String igniteName, FileSnapshot snapshot) {
        return SnapshotUtils.readSnapshotMetadata((SnapshotPath)snapshot.snapshotDirectory().resolve(U.maskForFileName((CharSequence)this.grid(igniteName).context().discovery().localNode().consistentId().toString())), (boolean)true, (IgniteConfiguration)new IgniteConfiguration(), (IgniteLogger)log, null);
    }
}

