/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.WALMode;
import org.apache.ignite.failure.FailureHandler;
import org.apache.ignite.failure.StopNodeFailureHandler;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.managers.discovery.CustomEventListener;
import org.apache.ignite.internal.managers.discovery.DiscoCache;
import org.apache.ignite.internal.managers.discovery.DiscoveryCustomMessage;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.persistence.partstate.GroupPartitionId;
import org.apache.ignite.internal.processors.cluster.BaselineTopology;
import org.apache.ignite.internal.processors.cluster.ChangeGlobalStateMessage;
import org.apache.ignite.internal.processors.cluster.GridClusterStateProcessor;
import org.apache.ignite.internal.processors.cluster.IGridClusterStateProcessor;
import org.apache.ignite.internal.util.lang.GridAbsPredicate;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.plugin.CachePluginContext;
import org.apache.ignite.plugin.CachePluginProvider;
import org.apache.ignite.plugin.ExtensionRegistry;
import org.apache.ignite.plugin.IgnitePlugin;
import org.apache.ignite.plugin.PluginConfiguration;
import org.apache.ignite.plugin.PluginContext;
import org.apache.ignite.plugin.PluginProvider;
import org.apache.ignite.plugin.PluginValidationException;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.apache.ignite.spi.discovery.DiscoverySpiCustomMessage;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinder;
import org.apache.ignite.spi.discovery.tcp.ipfinder.vm.TcpDiscoveryVmIpFinder;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.configuration.SnapshotConfiguration;
import org.gridgain.grid.internal.processors.cache.database.GridSnapshotAwareClusterStateProcessorImpl;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CompressionOption;
import org.gridgain.grid.internal.processors.cache.database.snapshot.FutureTaskQueue;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridCacheSnapshotManager;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotEncryptionOptions;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotOperationContext;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotSession;
import org.gridgain.grid.persistentstore.MessageDigestFactory;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.gridgain.grid.persistentstore.SnapshotInfo;
import org.gridgain.grid.persistentstore.SnapshotStatus;
import org.gridgain.grid.persistentstore.snapshot.file.FileDatabaseSnapshotSpi;
import org.jetbrains.annotations.Nullable;
import org.junit.Test;

public class IgniteDbBaselineTopologySelfTest
extends GridCommonAbstractTest {
    private static final TcpDiscoveryVmIpFinder IP_FINDER = new TcpDiscoveryVmIpFinder(true);
    private static final String CACHE_NAME = "cache";
    private static final int NODE_COUNT = 4;
    private boolean predefinedCache;
    private boolean clientMode;
    @Nullable
    private IgniteInClosure<DiscoverySpiCustomMessage> spiSendCallback;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setDataStorageConfiguration(new DataStorageConfiguration().setWalMode(WALMode.LOG_ONLY).setDefaultDataRegionConfiguration(new DataRegionConfiguration().setPersistenceEnabled(true).setInitialSize(0x6400000L).setMaxSize(0x6400000L)));
        cfg.setPluginConfigurations(new PluginConfiguration[]{new GridGainConfiguration().setSnapshotConfiguration(new SnapshotConfiguration().setSnapshotsPath("snapshot").setPointInTimeRecoveryEnabled(true))});
        if (this.predefinedCache) {
            cfg.setCacheConfiguration(new CacheConfiguration[]{new CacheConfiguration().setName(CACHE_NAME)});
        }
        if (this.clientMode) {
            cfg.setClientMode(true);
        }
        if (this.spiSendCallback != null) {
            final IgniteInClosure<DiscoverySpiCustomMessage> callback0 = this.spiSendCallback;
            cfg.setDiscoverySpi((DiscoverySpi)new TcpDiscoverySpi(){

                public void sendCustomEvent(DiscoverySpiCustomMessage msg) throws IgniteException {
                    callback0.apply((Object)msg);
                    super.sendCustomEvent(msg);
                }
            }.setIpFinder((TcpDiscoveryIpFinder)IP_FINDER));
        } else {
            cfg.setDiscoverySpi((DiscoverySpi)new TcpDiscoverySpi().setIpFinder((TcpDiscoveryIpFinder)IP_FINDER));
        }
        cfg.setFailureHandler((FailureHandler)new StopNodeFailureHandler());
        return cfg;
    }

    protected void beforeTest() throws Exception {
        this.cleanPersistenceDir();
        U.delete((File)U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"snapshot", (boolean)false));
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        this.cleanPersistenceDir();
        U.delete((File)U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"snapshot", (boolean)false));
        this.predefinedCache = false;
        this.clientMode = false;
        this.spiSendCallback = null;
        TestSnapshotClusterStateProcessorPluginProvider.enabled = false;
        System.clearProperty("GG_DISABLE_SNAPSHOT_ON_BASELINE_CHANGE_WITH_ENABLED_PITR");
    }

    @Test
    public void testSnapshotCreatedWhenBaselineTopologySetFromServer() throws Exception {
        this.testSnapshotCreatedWhenBaselineTopologySet(false);
    }

    @Test
    public void testSnapshotCreatedWhenBaselineTopologySetFromClient() throws Exception {
        this.testSnapshotCreatedWhenBaselineTopologySet(true);
    }

    private void testSnapshotCreatedWhenBaselineTopologySet(boolean fromClient) throws Exception {
        int k;
        SnapshotStatus status;
        this.predefinedCache = true;
        IgniteEx ignite = this.startGrids(4);
        ignite.cluster().baselineAutoAdjustEnabled(false);
        if (fromClient) {
            this.clientMode = true;
            ignite = this.startGrid(14);
            this.clientMode = false;
        }
        ignite.cluster().active(true);
        IgniteDbBaselineTopologySelfTest.assertTrue((boolean)ignite.cluster().active());
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        IgniteCache cache = ignite.cache(CACHE_NAME);
        for (int k2 = 0; k2 < 1000; ++k2) {
            cache.put((Object)k2, (Object)k2);
        }
        this.startGrid(4);
        IgniteEx finalIgnite = ignite;
        Thread thread = new Thread(() -> finalIgnite.cluster().setBaselineTopology((Collection)finalIgnite.cluster().nodes().stream().filter(n -> !n.isClient()).collect(Collectors.toSet())));
        thread.start();
        boolean started = false;
        do {
            if ((status = gg.snapshot().ongoingSnapshotOperation()) == null) continue;
            started = true;
        } while (status != null || !started);
        thread.join();
        for (int k3 = 0; k3 < 1000; ++k3) {
            if (k3 % 2 == 0) {
                cache.remove((Object)k3);
                continue;
            }
            cache.put((Object)k3, (Object)(k3 * 2));
        }
        List snapshots = gg.snapshot().list();
        IgniteDbBaselineTopologySelfTest.assertEquals((int)2, (int)snapshots.size());
        gg.snapshot().restoreSnapshot(((SnapshotInfo)snapshots.get(0)).snapshotId(), null, "test").get();
        for (k = 0; k < 1000; ++k) {
            IgniteDbBaselineTopologySelfTest.assertNull((String)("k=" + k), (Object)cache.get((Object)k));
        }
        gg.snapshot().restoreSnapshot(((SnapshotInfo)snapshots.get(1)).snapshotId(), null, "test").get();
        for (k = 0; k < 1000; ++k) {
            IgniteDbBaselineTopologySelfTest.assertEquals((String)("k=" + k), (Object)k, (Object)cache.get((Object)k));
        }
    }

    @Test
    public void testSnapshotNotCreatedIfNoUserCaches() throws Exception {
        IgniteEx ignite = this.startGrids(4);
        ignite.cluster().baselineAutoAdjustEnabled(false);
        ignite.cluster().active(true);
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        IgniteDbBaselineTopologySelfTest.assertTrue((boolean)gg.snapshot().list().isEmpty());
        ignite.getOrCreateCache(CACHE_NAME);
        this.startGrid(4);
        ignite.cluster().setBaselineTopology(ignite.cluster().nodes());
        IgniteDbBaselineTopologySelfTest.assertEquals((int)1, (int)gg.snapshot().list().size());
    }

    @Test
    public void testConcurrentActivation() throws Exception {
        this.predefinedCache = true;
        IgniteEx ignite = this.startGrids(4);
        AtomicInteger cntr = new AtomicInteger();
        GridTestUtils.runMultiThreadedAsync(() -> {
            int n = cntr.getAndIncrement();
            IgniteEx ig = this.grid(n);
            ig.cluster().active(true);
        }, (int)4, (String)"test-activate-thread").get();
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        IgniteDbBaselineTopologySelfTest.assertEquals((int)1, (int)gg.snapshot().list().size());
    }

    @Test
    public void testConcurrentActivationReverseOrder() throws Exception {
        this.predefinedCache = true;
        IgniteEx ignite = this.startGrids(4);
        AtomicInteger cntr = new AtomicInteger(4);
        GridTestUtils.runMultiThreadedAsync(() -> {
            int n = cntr.decrementAndGet();
            IgniteEx ig = this.grid(n);
            ig.cluster().active(true);
        }, (int)4, (String)"test-activate-thread").get();
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        IgniteDbBaselineTopologySelfTest.assertEquals((int)1, (int)gg.snapshot().list().size());
    }

    @Test
    public void testConcurrentAutoActivation() throws Exception {
        this.predefinedCache = true;
        IgniteEx ignite = this.startGrids(4);
        ignite.cluster().active(true);
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        IgniteDbBaselineTopologySelfTest.assertEquals((int)1, (int)gg.snapshot().list().size());
        IgniteCache cache = ignite.cache(CACHE_NAME);
        for (int k = 0; k < 100; ++k) {
            cache.put((Object)k, (Object)k);
        }
        this.stopAllGrids();
        ignite = this.startGrid(0);
        final CountDownLatch autoActivationLatch = new CountDownLatch(1);
        final CountDownLatch manualActivationLatch = new CountDownLatch(1);
        ignite.context().discovery().setCustomEventListener(ChangeGlobalStateMessage.class, (CustomEventListener)new CustomEventListener<ChangeGlobalStateMessage>(){

            public void onCustomEvent(AffinityTopologyVersion topVer, ClusterNode snd, ChangeGlobalStateMessage msg) {
                autoActivationLatch.countDown();
                try {
                    manualActivationLatch.await();
                }
                catch (InterruptedException ex) {
                    throw new IgniteException((Throwable)ex);
                }
            }
        });
        this.spiSendCallback = new IgniteInClosure<DiscoverySpiCustomMessage>(){

            public void apply(DiscoverySpiCustomMessage msg) {
                DiscoveryCustomMessage msg0 = (DiscoveryCustomMessage)GridTestUtils.getFieldValue((Object)msg, (String[])new String[]{"delegate"});
                if (msg0 instanceof ChangeGlobalStateMessage) {
                    manualActivationLatch.countDown();
                }
            }
        };
        this.startGrid(1);
        this.spiSendCallback = null;
        for (int i = 2; i < 4; ++i) {
            this.startGrid(i);
        }
        autoActivationLatch.await();
        this.grid(1).cluster().active(true);
        IgniteDbBaselineTopologySelfTest.assertTrue((boolean)GridTestUtils.waitForCondition((GridAbsPredicate)new GridAbsPredicate(){

            public boolean apply() {
                return IgniteDbBaselineTopologySelfTest.this.grid(0).cluster().active();
            }
        }, (long)5000L));
        gg = (GridGain)ignite.plugin("GridGain");
        IgniteDbBaselineTopologySelfTest.assertEquals((int)1, (int)gg.snapshot().list().size());
        ignite.cache(CACHE_NAME).put((Object)101, (Object)101);
    }

    @Test
    public void testConflictingStateChanges() throws Exception {
        this.predefinedCache = true;
        IgniteEx ignite = this.startGrid(0);
        ignite.cluster().baselineAutoAdjustEnabled(false);
        ignite.cluster().active(true);
        for (int n = 1; n < 4; ++n) {
            this.startGrid(n);
        }
        AtomicInteger cntr = new AtomicInteger(1);
        GridTestUtils.runMultiThreadedAsync(() -> {
            try {
                int n = cntr.getAndIncrement();
                IgniteEx ig = this.grid(n);
                ig.cluster().baselineAutoAdjustEnabled(false);
                ArrayList<ClusterNode> nodes = new ArrayList<ClusterNode>();
                nodes.add(ignite.localNode());
                nodes.add(ig.localNode());
                ig.cluster().setBaselineTopology(nodes);
            }
            catch (IgniteException igniteException) {
                // empty catch block
            }
        }, (int)3, (String)"test-activate-thread").get();
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        int snapshots = gg.snapshot().list().size();
        IgniteDbBaselineTopologySelfTest.assertTrue((snapshots > 1 ? 1 : 0) != 0);
        ignite.cluster().setBaselineTopology(ignite.cluster().nodes());
        IgniteDbBaselineTopologySelfTest.assertEquals((int)(snapshots + 1), (int)gg.snapshot().list().size());
    }

    @Test
    public void testStateChangeWhileSnapshotInProgress() throws Exception {
        CountDownLatch startLatch = new CountDownLatch(1);
        CountDownLatch finishLatch = new CountDownLatch(1);
        GridCacheSnapshotManager.TEST_SNAPSHOT_SPI.set(new TestSnapshotSpi(startLatch, finishLatch));
        IgniteEx ignite = this.startGrid(0);
        ignite.cluster().baselineAutoAdjustEnabled(false);
        ignite.cluster().active(true);
        this.startGrid(1);
        ignite.getOrCreateCache(CACHE_NAME);
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        SnapshotFuture snapFut = gg.snapshot().createFullSnapshot(null, "Test snapshot");
        startLatch.await();
        try {
            ignite.cluster().setBaselineTopology(ignite.cluster().nodes());
            IgniteDbBaselineTopologySelfTest.fail((String)"Exception wasn't thrown");
        }
        catch (IgniteException ex) {
            IgniteDbBaselineTopologySelfTest.assertTrue((String)ex.getMessage(), (boolean)ex.getMessage().contains("Failed to activate cluster"));
        }
        finishLatch.countDown();
        snapFut.get();
        ignite.cluster().setBaselineTopology(ignite.cluster().nodes());
        IgniteDbBaselineTopologySelfTest.assertEquals((int)2, (int)gg.snapshot().list().size());
    }

    @Test
    public void testSnapshotNotCreatedIfBaselineTopologyWasntChanged() throws Exception {
        this.predefinedCache = true;
        IgniteEx ignite = this.startGrids(4);
        ignite.cluster().active(true);
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        IgniteDbBaselineTopologySelfTest.assertEquals((int)1, (int)gg.snapshot().list().size());
        ignite.cluster().active(false);
        ignite.cluster().active(true);
        IgniteDbBaselineTopologySelfTest.assertEquals((int)1, (int)gg.snapshot().list().size());
    }

    @Test
    public void testDelayedSnapshotNotFailClusterActivation() throws Exception {
        this.predefinedCache = true;
        TestSnapshotClusterStateProcessorPluginProvider.enabled = false;
        IgniteEx ignite = this.startGrids(2);
        this.checkLocalNodeIsCoordinator(ignite);
        ignite.cluster().active(true);
        ignite.cache(CACHE_NAME).put((Object)1, (Object)1);
        this.stopAllGrids();
        TestSnapshotClusterStateProcessorPluginProvider.enabled = true;
        ignite = this.startGrids(2);
        IgniteDbBaselineTopologySelfTest.assertEquals((String)("Invalid " + GridClusterStateProcessor.class.getSimpleName() + " implementation"), TestGridClusterStateProcessor.class, ignite.context().state().getClass());
        TestGridClusterStateProcessor stateProc = (TestGridClusterStateProcessor)ignite.context().state();
        this.checkLocalNodeIsCoordinator(ignite);
        IgniteDbBaselineTopologySelfTest.assertTrue((boolean)GridTestUtils.waitForCondition(() -> stateProc.processedMsgs.size() == 1, (long)5000L));
        this.awaitPartitionMapExchange();
        ignite.cluster().active(false);
        stateProc.stateChangeMsgProcessed.set(new CountDownLatch(1));
        ignite.cluster().active(true);
        IgniteDbBaselineTopologySelfTest.assertTrue((boolean)GridTestUtils.waitForCondition(() -> stateProc.processedMsgs.size() == 2, (long)5000L));
        this.checkCorrectStateConditions(stateProc);
        IgniteDbBaselineTopologySelfTest.assertTrue((String)"Cluster must be activated", (boolean)ignite.cluster().active());
    }

    private void checkCorrectStateConditions(TestGridClusterStateProcessor stateProc) {
        BaselineTopology prev = ((ChangeGlobalStateMessage)stateProc.processedMsgs.get(0)).baselineTopology();
        BaselineTopology cur = ((ChangeGlobalStateMessage)stateProc.processedMsgs.get(1)).baselineTopology();
        IgniteDbBaselineTopologySelfTest.assertTrue((String)("Baseline topologies must be same " + prev + " and " + cur), (boolean)BaselineTopology.equals((BaselineTopology)prev, (BaselineTopology)cur));
        IgniteDbBaselineTopologySelfTest.assertFalse((String)"Option must be disabled!", (boolean)IgniteSystemProperties.getBoolean((String)"GG_DISABLE_SNAPSHOT_ON_BASELINE_CHANGE_WITH_ENABLED_PITR", (boolean)false));
    }

    private void checkLocalNodeIsCoordinator(IgniteEx ignite) {
        ClusterNode crd = ignite.cluster().nodes().stream().min(Comparator.comparingLong(ClusterNode::order)).get();
        IgniteDbBaselineTopologySelfTest.assertEquals((String)"Coordinator on different node!", (Object)ignite.localNode(), (Object)crd);
    }

    @Test
    public void testEnabledSnapshotOnBaselineChangeWithEnabledPitr() throws Exception {
        this.predefinedCache = true;
        System.setProperty("GG_DISABLE_SNAPSHOT_ON_BASELINE_CHANGE_WITH_ENABLED_PITR", "false");
        IgniteEx ignite = this.startGrids(4);
        ignite.cluster().baselineAutoAdjustEnabled(false);
        ignite.cluster().active(true);
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        IgniteDbBaselineTopologySelfTest.assertEquals((int)1, (int)gg.snapshot().list().size());
        this.startGrid(4);
        ignite.cluster().setBaselineTopology(ignite.cluster().forServers().nodes());
        IgniteDbBaselineTopologySelfTest.assertEquals((int)2, (int)gg.snapshot().list().size());
    }

    @Test
    public void testDisabledSnapshotOnBaselineChangeWithEnabledPitr() throws Exception {
        this.predefinedCache = true;
        System.setProperty("GG_DISABLE_SNAPSHOT_ON_BASELINE_CHANGE_WITH_ENABLED_PITR", "true");
        IgniteEx ignite = this.startGrids(4);
        ignite.cluster().baselineAutoAdjustEnabled(false);
        ignite.cluster().active(true);
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        Thread.sleep(5000L);
        IgniteDbBaselineTopologySelfTest.assertEquals((int)0, (int)gg.snapshot().list().size());
        this.startGrid(4);
        ignite.cluster().setBaselineTopology(ignite.cluster().forServers().nodes());
        Thread.sleep(5000L);
        IgniteDbBaselineTopologySelfTest.assertEquals((int)0, (int)gg.snapshot().list().size());
    }

    private static class TestSnapshotSpi
    extends FileDatabaseSnapshotSpi {
        private final CountDownLatch snapshotStartLatch;
        private final CountDownLatch snapshotFinishLatch;

        public TestSnapshotSpi(CountDownLatch snapshotStartLatch, CountDownLatch snapshotFinishLatch) {
            this.snapshotStartLatch = snapshotStartLatch;
            this.snapshotFinishLatch = snapshotFinishLatch;
        }

        public SnapshotSession sessionForSnapshotCreation(long id, boolean fullSnapshot, File storePath, CompressionOption compression, int compressionLevel, FutureTaskQueue<GroupPartitionId> futureTaskQueue, SnapshotOperationContext snapshotOperationContext, @Nullable MessageDigestFactory msgDigestFactory, @Nullable SnapshotEncryptionOptions encryptionOptions) throws IgniteCheckedException {
            this.snapshotStartLatch.countDown();
            try {
                this.snapshotFinishLatch.await();
            }
            catch (InterruptedException ex) {
                throw new IgniteCheckedException((Throwable)ex);
            }
            return super.sessionForSnapshotCreation(id, fullSnapshot, storePath, compression, compressionLevel, futureTaskQueue, snapshotOperationContext, msgDigestFactory, encryptionOptions);
        }
    }

    public static class TestSnapshotClusterStateProcessorPluginProvider
    implements PluginProvider {
        private static volatile boolean enabled;
        private GridKernalContext igniteCtx;

        public String name() {
            return "TestSnapshotClusterStateProcessorPlugin";
        }

        public String version() {
            return "1.0";
        }

        public String copyright() {
            return "";
        }

        public void initExtensions(PluginContext ctx, ExtensionRegistry registry) {
            this.igniteCtx = ((IgniteEx)ctx.grid()).context();
        }

        public CachePluginProvider createCacheProvider(CachePluginContext ctx) {
            return null;
        }

        public void start(PluginContext ctx) throws IgniteCheckedException {
        }

        public void stop(boolean cancel) throws IgniteCheckedException {
        }

        public void onIgniteStart() throws IgniteCheckedException {
        }

        public void onIgniteStop(boolean cancel) {
        }

        @Nullable
        public Serializable provideDiscoveryData(UUID nodeId) {
            return null;
        }

        public void receiveDiscoveryData(UUID nodeId, Serializable data) {
        }

        public void validateNewNode(ClusterNode node) throws PluginValidationException {
        }

        @Nullable
        public Object createComponent(PluginContext ctx, Class cls) {
            if (enabled && IGridClusterStateProcessor.class.equals((Object)cls) && ctx.igniteConfiguration().getIgniteInstanceName().endsWith("0")) {
                return new TestGridClusterStateProcessor(this.igniteCtx);
            }
            return null;
        }

        public IgnitePlugin plugin() {
            return new IgnitePlugin(){};
        }
    }

    private static class TestGridClusterStateProcessor
    extends GridSnapshotAwareClusterStateProcessorImpl {
        private final List<ChangeGlobalStateMessage> processedMsgs = new CopyOnWriteArrayList<ChangeGlobalStateMessage>();
        private final AtomicReference<CountDownLatch> stateChangeMsgProcessed = new AtomicReference();

        private TestGridClusterStateProcessor(GridKernalContext ctx) {
            super(ctx);
        }

        public boolean onStateChangeMessage(AffinityTopologyVersion topVer, ChangeGlobalStateMessage msg, DiscoCache discoCache) {
            boolean res = super.onStateChangeMessage(topVer, msg, discoCache);
            if (msg.activate()) {
                this.processedMsgs.add(msg);
            }
            if (this.stateChangeMsgProcessed.get() != null) {
                this.stateChangeMsgProcessed.get().countDown();
            }
            return res;
        }

        public IgniteInternalFuture<?> wrapStateChangeFuture(IgniteInternalFuture fut, ChangeGlobalStateMessage msg) {
            try {
                if (this.stateChangeMsgProcessed.get() != null) {
                    this.stateChangeMsgProcessed.get().await(3L, TimeUnit.SECONDS);
                }
            }
            catch (InterruptedException e) {
                throw new IgniteException((Throwable)e);
            }
            return super.wrapStateChangeFuture(fut, msg);
        }
    }
}

