/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.plugin.PluginConfiguration;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinder;
import org.apache.ignite.spi.discovery.tcp.ipfinder.vm.TcpDiscoveryVmIpFinder;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.configuration.SnapshotConfiguration;
import org.gridgain.grid.persistentstore.GridSnapshot;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.gridgain.grid.persistentstore.SnapshotIssue;
import org.junit.Test;

public class DplSnapshotTest
extends GridCommonAbstractTest {
    private static final String WORK_DIR = "C:\\temp\\ignite\\work\\";
    private static final String NODE_CONSISTENT_ID = "192_168_56_1_47500";
    private static final long SNAPSHOT_ID = 1489577307860L;
    private static final String PLUGIN_NAME = "GridGain";
    private static final TcpDiscoveryIpFinder ipFinder = new TcpDiscoveryVmIpFinder(true);
    private IgniteEx grid;
    private GridGain gg;
    private GridSnapshot db;

    protected long getTestTimeout() {
        return 86400000L;
    }

    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(gridName);
        cfg.setUserAttributes(Collections.singletonMap("DPLModuleIdSet1098", Collections.singleton("DPLDefaultModuleId1098")));
        TcpDiscoverySpi discoverySpi = (TcpDiscoverySpi)cfg.getDiscoverySpi();
        discoverySpi.setIpFinder(ipFinder);
        DataStorageConfiguration dbCfg = new DataStorageConfiguration();
        DataRegionConfiguration region = new DataRegionConfiguration().setMaxSize(0x40000000L).setName("dfltDataRegion").setPersistenceEnabled(true);
        dbCfg.setDefaultDataRegionConfiguration(region);
        cfg.setDataStorageConfiguration(dbCfg);
        GridGainConfiguration ggCfg = new GridGainConfiguration();
        SnapshotConfiguration ggDbCfg = new SnapshotConfiguration();
        ggCfg.setSnapshotConfiguration(ggDbCfg);
        cfg.setPluginConfigurations(new PluginConfiguration[]{ggCfg});
        cfg.setConsistentId((Serializable)((Object)NODE_CONSISTENT_ID));
        cfg.setWorkDirectory(WORK_DIR);
        return cfg;
    }

    @Test
    public void testCheckSnapshot() {
        SnapshotFuture fut = this.db.checkSnapshot(1489577307860L, null, false, "Test CHECK snapshot");
        List issues = (List)fut.get();
        for (SnapshotIssue issue : issues) {
            this.error("Issue:" + issue);
        }
        if (!issues.isEmpty()) {
            throw new RuntimeException("CHECK failed with " + issues.size() + " issue(s)");
        }
    }

    @Test
    public void testRestoreSnapshot() {
        SnapshotFuture fut = this.db.restoreSnapshot(1489577307860L, null, "Test RESTORE snapshot");
        fut.get();
        for (String cacheName : this.grid.cacheNames()) {
            IgniteCache cache = this.grid.cache(cacheName);
            this.log().info(S.toString((String)">>> Cache", (String)"name", (Object)cacheName, (String)"size", (Object)cache.size(new CachePeekMode[0])));
        }
    }

    protected void beforeTestsStarted() throws Exception {
        this.stopAllGrids();
        this.cleanPersistenceDir();
    }

    protected void beforeTest() throws Exception {
        this.startGrid();
        this.grid = this.grid();
        this.grid.active(true);
        this.gg = (GridGain)this.grid.plugin(PLUGIN_NAME);
        this.db = this.gg.snapshot();
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        this.db = null;
        this.gg = null;
        this.grid = null;
        this.cleanPersistenceDir();
    }
}

