/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.Ignition;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.managers.communication.GridIoMessage;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.plugin.PluginConfiguration;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.communication.CommunicationSpi;
import org.apache.ignite.spi.communication.tcp.TcpCommunicationSpi;
import org.apache.ignite.testframework.ListeningTestLogger;
import org.apache.ignite.testframework.LogListener;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.configuration.SnapshotConfiguration;
import org.gridgain.grid.internal.processors.cache.database.AbstractSnapshotTest;
import org.gridgain.grid.internal.processors.cache.database.messages.ClusterWideCancelSnapshotOperationMessage;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.junit.Test;

public class DoubledClusterWideCancelSnapshotOperationMessageTest
extends AbstractSnapshotTest {
    private static LogListener assertLsnr = LogListener.matches((String)"Snapshot executor died because of").andMatches("java.lang.AssertionError: previousStage=CANCELLED, stageInProgress=null").build();
    private static LogListener warnLsnr = LogListener.matches((String)"Duplicated ClusterWideCancelSnapshotOperationMessage from node").atLeast(2).build();

    @Override
    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        ListeningTestLogger log = new ListeningTestLogger(false, DoubledClusterWideCancelSnapshotOperationMessageTest.log);
        log.registerListener(assertLsnr);
        log.registerListener(warnLsnr);
        return super.getConfiguration(igniteInstanceName).setGridLogger((IgniteLogger)log).setCommunicationSpi((CommunicationSpi)new TestTcpCommunicationSpi()).setDataStorageConfiguration(new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setPersistenceEnabled(true).setMaxSize(0x10000000L))).setPluginConfigurations(new PluginConfiguration[]{new GridGainConfiguration().setSnapshotConfiguration(new SnapshotConfiguration())}).setCacheConfiguration(new CacheConfiguration[]{new CacheConfiguration("default").setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 8))});
    }

    protected void beforeTestsStarted() throws Exception {
        IgniteEx ignite = this.startGrids(2);
        Ignition.setClientMode((boolean)true);
        this.startGrid("client");
        Ignition.setClientMode((boolean)false);
        ignite.cluster().active(true);
    }

    public void beforeTest() throws Exception {
        U.invoke(LogListener.class, (Object)assertLsnr, (String)"reset", (Object[])new Object[0]);
        U.invoke(LogListener.class, (Object)warnLsnr, (String)"reset", (Object[])new Object[0]);
    }

    @Test
    public void testCancelFromCrd() throws Exception {
        IgniteEx ignite = this.ignite(0);
        DoubledClusterWideCancelSnapshotOperationMessageTest.assertEquals((long)ignite.cluster().localNode().order(), (long)1L);
        this.cancelFromNode((Ignite)ignite);
    }

    @Test
    public void testCancelFromServerNode() throws Exception {
        IgniteEx notCrdServer = this.ignite(1);
        DoubledClusterWideCancelSnapshotOperationMessageTest.assertTrue((notCrdServer.cluster().localNode().order() != 1L ? 1 : 0) != 0);
        this.cancelFromNode((Ignite)notCrdServer);
    }

    @Test
    public void testCancelFromClient() throws Exception {
        IgniteEx client = this.grid("client");
        DoubledClusterWideCancelSnapshotOperationMessageTest.assertTrue((boolean)client.cluster().localNode().isClient());
        this.cancelFromNode((Ignite)client);
    }

    private void cancelFromNode(Ignite ignite) throws IgniteCheckedException {
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        SnapshotFuture fut = gg.snapshot().createFullSnapshot(null, null);
        fut.get();
        long snapId = fut.snapshotOperation().snapshotId();
        fut = gg.snapshot().moveSnapshot(snapId, this.createOrCleanMoveDir(), "");
        fut.initFuture().get();
        IgniteFuture cancelFut = gg.snapshot().cancelSnapshotOperation(fut.operationId(), null);
        try {
            fut.get();
            DoubledClusterWideCancelSnapshotOperationMessageTest.fail();
        }
        catch (Exception e) {
            DoubledClusterWideCancelSnapshotOperationMessageTest.assertTrue((boolean)this.getErrorMessage(e).contains("Snapshot operation has been cancelled"));
        }
        DoubledClusterWideCancelSnapshotOperationMessageTest.assertTrue((boolean)((Boolean)cancelFut.get()));
        DoubledClusterWideCancelSnapshotOperationMessageTest.assertFalse((boolean)assertLsnr.check());
        DoubledClusterWideCancelSnapshotOperationMessageTest.assertTrue((boolean)warnLsnr.check());
    }

    private String getErrorMessage(Throwable th) {
        StringWriter writer = new StringWriter();
        th.printStackTrace(new PrintWriter(writer));
        return writer.toString();
    }

    private static class TestTcpCommunicationSpi
    extends TcpCommunicationSpi {
        private TestTcpCommunicationSpi() {
        }

        public void sendMessage(ClusterNode node, Message msg, IgniteInClosure<IgniteException> ackC) throws IgniteSpiException {
            GridIoMessage ioMsg;
            Message msg0;
            if (msg instanceof GridIoMessage && (msg0 = (ioMsg = (GridIoMessage)msg).message()) instanceof ClusterWideCancelSnapshotOperationMessage) {
                System.out.println("Sending ClusterWideCancelSnapshotOperationMessage to " + node + " twice.");
                super.sendMessage(node, msg, ackC);
            }
            super.sendMessage(node, msg, ackC);
        }

        public void sendMessage(ClusterNode node, Message msg) throws IgniteSpiException {
            this.sendMessage(node, msg, null);
        }
    }
}

