/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database;

import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.WALMode;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.plugin.PluginConfiguration;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.configuration.SnapshotConfiguration;
import org.junit.Test;

public class DbSnapshotClientDisconnectSelfTest
extends GridCommonAbstractTest {
    protected boolean client;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        DataStorageConfiguration dsCfg = new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setPersistenceEnabled(true).setMaxSize(0x10000000L)).setWalMode(WALMode.LOG_ONLY);
        cfg.setDataStorageConfiguration(dsCfg);
        GridGainConfiguration ggCfg = new GridGainConfiguration();
        ggCfg.setSnapshotConfiguration(new SnapshotConfiguration());
        cfg.setPluginConfigurations(new PluginConfiguration[]{ggCfg});
        if (this.client) {
            cfg.setClientMode(true);
        }
        CacheConfiguration ccfg = new CacheConfiguration("test").setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL).setBackups(2).setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 32));
        cfg.setCacheConfiguration(new CacheConfiguration[]{ccfg});
        return cfg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSnapshotClientDisconnect() throws Exception {
        this.startGrids(3);
        this.grid(0).cluster().active(true);
        StringBuilder itr = new StringBuilder("i");
        try {
            for (int r = 0; r < 10; ++r) {
                itr.append("1");
                this.client = true;
                IgniteEx client = this.startGrid(3);
                GridGain gg = (GridGain)this.grid(0).plugin("GridGain");
                for (int i = 0; i < 10000; ++i) {
                    client.cache("test").put((Object)i, (Object)(itr.toString() + i));
                }
                IgniteInternalFuture snF = GridTestUtils.runAsync(() -> gg.snapshot().createFullSnapshot(null, "Test: " + itr).get());
                client.close();
                snF.get();
            }
        }
        finally {
            this.stopAllGrids();
        }
    }
}

