/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.io;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ReadableByteChannel;
import java.security.MessageDigest;
import junit.framework.TestCase;
import org.gridgain.grid.internal.io.GridReadableByteChannel;
import org.gridgain.grid.internal.io.GridReadableDigestByteChannel;
import org.junit.Assert;

public class GridReadableDigestByteChannelTest
extends TestCase {
    public void testDigestIsCorrect() throws Exception {
        ByteBuffer channelBuffer = ByteBuffer.allocateDirect(16);
        channelBuffer.order(ByteOrder.nativeOrder());
        String testString = "TEST";
        MessageDigest digest = MessageDigest.getInstance("MD5");
        GridReadableDigestByteChannel digestByteChannel = new GridReadableDigestByteChannel((ReadableByteChannel)new GridReadableByteChannel((InputStream)new ByteArrayInputStream(testString.getBytes())), digest);
        int read = digestByteChannel.read(channelBuffer);
        GridReadableDigestByteChannelTest.assertEquals((int)read, (int)channelBuffer.position());
        byte[] readBytes = new byte[read];
        channelBuffer.flip();
        channelBuffer.get(readBytes);
        GridReadableDigestByteChannelTest.assertEquals((String)testString, (String)new String(readBytes));
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        md5.update(testString.getBytes());
        byte[] expectedDigest = md5.digest();
        byte[] digestFromChannel = digest.digest();
        Assert.assertArrayEquals((byte[])expectedDigest, (byte[])digestFromChannel);
    }

    public void testDigestIsCorrectWithBufferCompaction() throws Exception {
        int read;
        ByteBuffer channelBuffer = ByteBuffer.allocateDirect(4);
        channelBuffer.order(ByteOrder.nativeOrder());
        MessageDigest digest = MessageDigest.getInstance("MD5");
        byte[] buf = new byte[]{1, 2, 3, 0, 0, 1, 0, 5, 3, 0, 0, 9, 0, 0, 1, 0};
        GridReadableDigestByteChannel digestByteChannel = new GridReadableDigestByteChannel((ReadableByteChannel)new GridReadableByteChannel((InputStream)new ByteArrayInputStream(buf)), digest);
        while ((read = digestByteChannel.read(channelBuffer)) != -1) {
            if (read == 1) {
                channelBuffer.clear();
                continue;
            }
            channelBuffer.position(read / 2);
            channelBuffer.compact();
        }
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        md5.update(buf);
        byte[] expectedDigest = md5.digest();
        byte[] digestFromChannel = digest.digest();
        Assert.assertArrayEquals((byte[])expectedDigest, (byte[])digestFromChannel);
    }
}

