/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal;

import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.WALMode;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.pagemem.wal.IgniteWriteAheadLogManager;
import org.apache.ignite.internal.processors.cache.persistence.GridCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointHistory;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileDescriptor;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.PluginConfiguration;
import org.apache.ignite.testframework.junits.WithSystemProperty;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.configuration.SnapshotConfiguration;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class GridPluginProviderPITRConfigTest
extends GridCommonAbstractTest {
    private CacheConfiguration<Integer, Integer> cacheConfiguration() {
        CacheConfiguration ccfg = new CacheConfiguration("default");
        return ccfg.setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL);
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.stopAllGrids();
        this.cleanPersistenceDir();
    }

    protected void afterTest() throws Exception {
        super.afterTest();
        this.stopAllGrids();
        this.cleanPersistenceDir();
    }

    @NotNull
    private IgniteEx startGridWithPITR(boolean enablePITR, Consumer<DataStorageConfiguration> customConfigurator) throws Exception {
        IgniteConfiguration cfg = this.getConfiguration();
        DataStorageConfiguration dbCfg = new DataStorageConfiguration();
        dbCfg.setWalMode(WALMode.LOG_ONLY);
        dbCfg.setWalSegmentSize(524288);
        dbCfg.setCheckpointFrequency(60000L);
        dbCfg.setDefaultDataRegionConfiguration(new DataRegionConfiguration().setMaxSize(0x6400000L).setPersistenceEnabled(true));
        cfg.setDataStorageConfiguration(dbCfg);
        this.configPITR(cfg, enablePITR);
        if (customConfigurator != null) {
            customConfigurator.accept(dbCfg);
        }
        IgniteEx ex = this.startGrid(cfg);
        ex.cluster().state(ClusterState.ACTIVE);
        return ex;
    }

    private void testTruncationWhenPITREnabled(long walArchiveSize, int expCheckpointNum, boolean isTruncationEnabled) throws Exception {
        IgniteEx ex = this.startGridWithPITR(true, dbCfg -> dbCfg.setMaxWalArchiveSize(walArchiveSize));
        long size = ex.context().config().getDataStorageConfiguration().getMaxWalArchiveSize();
        GridPluginProviderPITRConfigTest.assertEquals((long)walArchiveSize, (long)size);
        GridCacheDatabaseSharedManager dbMgr = this.makeCheckpoints(ex, 20);
        IgniteWriteAheadLogManager wal = this.wal((Ignite)ex);
        FileDescriptor[] files = (FileDescriptor[])U.findNonPublicMethod(wal.getClass(), (String)"walArchiveFiles", (Class[])new Class[0]).invoke((Object)wal, new Object[0]);
        boolean hasFirstSegment = Stream.of(files).anyMatch(desc -> desc.file().getName().endsWith("0001.wal"));
        Assert.assertNotEquals((Object)isTruncationEnabled, (Object)hasFirstSegment);
        CheckpointHistory hist = dbMgr.checkpointHistory();
        GridPluginProviderPITRConfigTest.assertNotNull((Object)hist);
        GridPluginProviderPITRConfigTest.assertEquals((int)expCheckpointNum, (int)hist.checkpoints().size());
    }

    @Test
    @WithSystemProperty(key="IGNITE_PDS_MAX_CHECKPOINT_MEMORY_HISTORY_SIZE", value="2")
    public void testWALTruncationDisabledWhenPITREnabled() throws Exception {
        this.testTruncationWhenPITREnabled(-1L, 2, false);
    }

    @Test
    @Ignore(value="https://ggsystems.atlassian.net/browse/GG-32278")
    @WithSystemProperty(key="IGNITE_PDS_MAX_CHECKPOINT_MEMORY_HISTORY_SIZE", value="2")
    public void testWALTruncationEnabledWhenPITREnabled() throws Exception {
        this.testTruncationWhenPITREnabled(0x200000L, 14, true);
    }

    @Test
    public void testWALTruncationEnabledWhenPITRDisabled() throws Exception {
        long maxWalArchiveSize = 0x200000L;
        IgniteEx ex = this.startGridWithPITR(false, dbCfg -> dbCfg.setMaxWalArchiveSize(maxWalArchiveSize));
        long size = ex.context().config().getDataStorageConfiguration().getMaxWalArchiveSize();
        GridPluginProviderPITRConfigTest.assertEquals((long)maxWalArchiveSize, (long)size);
        this.makeCheckpoints(ex, 50);
        IgniteWriteAheadLogManager wal = this.wal((Ignite)ex);
        FileDescriptor[] files = (FileDescriptor[])U.findNonPublicMethod(wal.getClass(), (String)"walArchiveFiles", (Class[])new Class[0]).invoke((Object)wal, new Object[0]);
        boolean firstSegmentDeleted = Stream.of(files).noneMatch(desc -> desc.file().getName().endsWith("0001.wal"));
        GridPluginProviderPITRConfigTest.assertTrue((boolean)firstSegmentDeleted);
    }

    private void configPITR(IgniteConfiguration cfg, boolean enablePITR) {
        cfg.getDataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setPersistenceEnabled(true));
        cfg.setPluginConfigurations(new PluginConfiguration[]{new GridGainConfiguration().setSnapshotConfiguration(new SnapshotConfiguration().setPointInTimeRecoveryEnabled(enablePITR))});
    }

    private GridCacheDatabaseSharedManager makeCheckpoints(IgniteEx ex, int requiredCheckpointsNum) throws IgniteCheckedException {
        GridCacheDatabaseSharedManager dbMgr = this.gridDatabase((Ignite)ex);
        IgniteCache cache = ex.getOrCreateCache(this.cacheConfiguration());
        int i = 0;
        while (requiredCheckpointsNum != 0) {
            cache.put((Object)i, (Object)i);
            if (i % 10 == 0) {
                this.forceCheckpoint();
                --requiredCheckpointsNum;
            }
            ++i;
        }
        return dbMgr;
    }

    private GridCacheDatabaseSharedManager gridDatabase(Ignite ignite) {
        return (GridCacheDatabaseSharedManager)((IgniteEx)ignite).context().cache().context().database();
    }

    private IgniteWriteAheadLogManager wal(Ignite ignite) {
        return ((IgniteEx)ignite).context().cache().context().wal();
    }
}

