/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.encryption;

import java.io.File;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.TestRecordingCommunicationSpi;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.plugin.PluginConfiguration;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.communication.CommunicationSpi;
import org.apache.ignite.spi.encryption.EncryptionSpi;
import org.apache.ignite.spi.encryption.keystore.KeystoreEncryptionSpi;
import org.apache.ignite.spi.encryption.noop.NoopEncryptionSpi;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.ListeningTestLogger;
import org.apache.ignite.testframework.junits.SystemPropertiesList;
import org.apache.ignite.testframework.junits.WithSystemProperty;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.gridgain.TestUtils;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.configuration.SnapshotConfiguration;
import org.gridgain.grid.internal.GridGainImpl;
import org.gridgain.grid.internal.processors.cache.database.GridSnapshotEx;
import org.gridgain.grid.internal.processors.cache.database.SnapshotOperationStage;
import org.gridgain.grid.internal.processors.cache.database.messages.ClusterWideSnapshotOperationStageFinishedMessage;
import org.gridgain.grid.internal.processors.cache.database.messages.SnapshotOperationStageFinishedMessage;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CompressionOption;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotCreateParameters;
import org.gridgain.grid.internal.processors.cache.database.snapshot.schedule.SnapshotSchedule;
import org.gridgain.grid.internal.processors.cache.database.snapshot.schedule.SnapshotScheduleProcessor;
import org.gridgain.grid.persistentstore.CheckSnapshotParams;
import org.gridgain.grid.persistentstore.MessageDigestFactory;
import org.gridgain.grid.persistentstore.SnapshotCreateParams;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.gridgain.grid.persistentstore.SnapshotInfo;
import org.gridgain.grid.persistentstore.SnapshotIssue;
import org.gridgain.grid.persistentstore.SnapshotOperationType;
import org.gridgain.grid.persistentstore.SnapshotStatus;
import org.junit.Test;

public class SnapshotEncryptionTest
extends GridCommonAbstractTest {
    private static final String KEYSTORE_PATH = IgniteUtils.resolveIgnitePath((String)(TestUtils.TEST_ROOT + "/snapshot/snapshot-encryption.jks")).getAbsolutePath();
    private static final char[] KEYSTORE_PASSWORD = "keep_clear_mind".toCharArray();
    private static final String STORAGE_MASTER_KEY = "ignite.master.key";
    private static final String SNAPSHOT_MASTER_KEY = "snapshot.master.key";
    public static final String PLAIN_CACHE_NAME = "default_PLAIN";
    public static final MessageDigestFactory SNAPSHOT_DIGEST_FACTORY = new MessageDigestFactory(){

        public String getAlgorithmCode() {
            return this.createDigest().getAlgorithm();
        }

        public MessageDigest createDigest() {
            try {
                return MessageDigest.getInstance("SHA-256");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }
    };
    public boolean encryptionEnabled;
    boolean pitrEnabled;
    private ListeningTestLogger listeningLog;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        KeystoreEncryptionSpi encSpi = new KeystoreEncryptionSpi();
        encSpi.setKeyStorePath(KEYSTORE_PATH);
        encSpi.setKeyStorePassword(KEYSTORE_PASSWORD);
        encSpi.setMasterKeyName(STORAGE_MASTER_KEY);
        return super.getConfiguration(igniteInstanceName).setCommunicationSpi((CommunicationSpi)new TestRecordingCommunicationSpi()).setConsistentId((Serializable)((Object)igniteInstanceName)).setGridLogger((IgniteLogger)(this.listeningLog != null ? this.listeningLog : log)).setCacheConfiguration(new CacheConfiguration[]{this.getCacheConfiguration("default"), this.getCacheConfiguration("default_1"), this.getCacheConfiguration("default_2")}).setEncryptionSpi((EncryptionSpi)(this.encryptionEnabled ? encSpi : new NoopEncryptionSpi())).setDataStorageConfiguration(new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setMaxSize(0x40000000L).setPersistenceEnabled(true))).setPluginConfigurations(new PluginConfiguration[]{new GridGainConfiguration().setSnapshotConfiguration(new SnapshotConfiguration().setPointInTimeRecoveryEnabled(this.pitrEnabled).setMessageDigestFactory(SNAPSHOT_DIGEST_FACTORY))});
    }

    private CacheConfiguration getCacheConfiguration(String cacheName) {
        return new CacheConfiguration(cacheName).setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL).setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC).setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 32)).setIndexedTypes(new Class[]{Integer.class, Integer.class}).setBackups(1).setEncryptionEnabled(this.encryptionEnabled);
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.stopAllGrids();
        this.cleanPersistenceDir();
        this.clearSnapshotDir("snapshot");
        this.encryptionEnabled = true;
    }

    protected void clearSnapshotDir(String snapDir) throws IgniteCheckedException {
        U.delete((File)U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)snapDir, (boolean)false));
    }

    protected void afterTest() throws Exception {
        super.afterTest();
        this.stopAllGrids();
        this.cleanPersistenceDir();
    }

    @Test
    @SystemPropertiesList(value={@WithSystemProperty(key="GG_SNAPSHOT_SECURITY_FEATURE", value="true"), @WithSystemProperty(key="GG_SNAPSHOT_SECURITY_LEVEL", value="REQUIRE")})
    public void testWithDigestSecuritRequire() throws Exception {
        this.testWithEncryptedCache();
    }

    @Test
    @SystemPropertiesList(value={@WithSystemProperty(key="GG_SNAPSHOT_SECURITY_FEATURE", value="true"), @WithSystemProperty(key="GG_SNAPSHOT_SECURITY_LEVEL", value="IGNORE_MISSING")})
    public void testWithDigestSecuritIgnireMissing() throws Exception {
        this.testWithEncryptedCache();
    }

    @Test
    @SystemPropertiesList(value={@WithSystemProperty(key="GG_SNAPSHOT_SECURITY_FEATURE", value="true"), @WithSystemProperty(key="GG_SNAPSHOT_SECURITY_LEVEL", value="IGNORE_EXISTING")})
    public void testWithDigestSecuritIgnireExisting() throws Exception {
        this.testWithEncryptedCache();
    }

    @Test
    @SystemPropertiesList(value={@WithSystemProperty(key="GG_SNAPSHOT_SECURITY_FEATURE", value="true"), @WithSystemProperty(key="GG_SNAPSHOT_SECURITY_LEVEL", value="DISABLED")})
    public void testWithDigestSecuritIgnireDisabled() throws Exception {
        this.testWithEncryptedCache();
    }

    @Test
    public void testWithoutEncryptedCache() throws Exception {
        this.encryptionEnabled = false;
        IgniteEx ignite0 = this.startGrids(2);
        ignite0.cluster().state(ClusterState.ACTIVE);
        this.loadData(ignite0, "default");
        GridGain gg = (GridGain)ignite0.plugin("GridGain");
        SnapshotFuture fut = this.createEncryptedFullSnapshot(gg);
        fut.get();
        long snapId = fut.snapshotOperation().snapshotId();
        ignite0.cache("default").put((Object)10, (Object)52);
        gg.snapshot().restoreSnapshot(snapId, null, "test-restore").get();
        this.checkData(ignite0, "default");
    }

    @Test
    public void testWithEncryptedCache() throws Exception {
        IgniteEx ignite0 = this.startGrids(2);
        ignite0.cluster().state(ClusterState.ACTIVE);
        ignite0.getOrCreateCache(new CacheConfiguration(PLAIN_CACHE_NAME));
        this.loadData(ignite0, "default");
        this.loadData(ignite0, "default_1");
        this.loadData(ignite0, "default_2");
        this.loadData(ignite0, PLAIN_CACHE_NAME);
        GridGain gg = (GridGain)ignite0.plugin("GridGain");
        SnapshotFuture fut = this.createEncryptedFullSnapshot(gg);
        fut.get();
        long snapId = fut.snapshotOperation().snapshotId();
        List issues = (List)gg.snapshot().check(new CheckSnapshotParams().snapshotId(snapId)).get();
        if (!F.isEmpty((Collection)issues)) {
            for (SnapshotIssue issue : issues) {
                this.info(issue.toString());
            }
            SnapshotEncryptionTest.fail((String)"Snapshot was checked with issues.");
        }
        ignite0.cache("default").put((Object)10, (Object)52);
        ignite0.cache(PLAIN_CACHE_NAME).put((Object)10, (Object)52);
        gg.snapshot().restoreSnapshot(snapId, null, "test-restore").get();
        this.checkData(ignite0, "default");
        this.checkData(ignite0, PLAIN_CACHE_NAME);
    }

    @Test
    public void testBigPartition() throws Exception {
        IgniteEx ignite0 = this.startGrids(1);
        ignite0.cluster().state(ClusterState.ACTIVE);
        ignite0.createCache(this.getCacheConfiguration(PLAIN_CACHE_NAME).setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 1)));
        this.loadData(ignite0, PLAIN_CACHE_NAME, 1000000, 0);
        GridGain gg = (GridGain)ignite0.plugin("GridGain");
        SnapshotFuture fut = this.createEncryptedFullSnapshot(gg);
        long snapId = fut.snapshotOperation().snapshotId();
        this.assertCheckedSnapshotSuccessfully(gg, snapId);
        this.restoreSnapshot(gg, snapId);
        this.checkData(ignite0, PLAIN_CACHE_NAME, 1000000);
    }

    @Test
    public void restartClusterDuringRestoreWithEncryption() throws Exception {
        this.restartClusterDuringRestore(true);
    }

    @Test
    public void restartClusterDuringRestore() throws Exception {
        this.restartClusterDuringRestore(false);
    }

    public void restartClusterDuringRestore(boolean isEncryptionEnabled) throws Exception {
        this.encryptionEnabled = isEncryptionEnabled;
        IgniteEx ignite0 = this.startGrids(2);
        ignite0.cluster().state(ClusterState.ACTIVE);
        for (String cacheName : ignite0.cacheNames()) {
            this.loadData(ignite0, cacheName);
        }
        GridGain gg = (GridGain)ignite0.plugin("GridGain");
        SnapshotFuture fut = this.createEncryptedFullSnapshot(gg);
        fut.get();
        long snapId = fut.snapshotOperation().snapshotId();
        gg.snapshot().restoreSnapshot(snapId, null, "test-restore");
        TestRecordingCommunicationSpi spi = TestRecordingCommunicationSpi.spi((Ignite)this.ignite(1));
        spi.blockMessages((IgniteBiPredicate & Serializable)(node, msg) -> {
            if (msg instanceof ClusterWideSnapshotOperationStageFinishedMessage) {
                ClusterWideSnapshotOperationStageFinishedMessage stageFinishedMsg = (ClusterWideSnapshotOperationStageFinishedMessage)msg;
                return stageFinishedMsg.stage() == SnapshotOperationStage.SECOND;
            }
            if (msg instanceof SnapshotOperationStageFinishedMessage) {
                SnapshotOperationStageFinishedMessage stageFinishedMsg = (SnapshotOperationStageFinishedMessage)msg;
                return stageFinishedMsg.stage() == SnapshotOperationStage.SECOND;
            }
            return false;
        });
        spi.waitForBlocked();
        this.stopAllGrids();
        ignite0 = this.startGrid(0);
        boolean clusterFullyStarted = false;
        try {
            this.startGrid(1);
            clusterFullyStarted = true;
        }
        catch (Exception ex) {
            log.info("Exception was caught [type=" + ex.getClass().getSimpleName() + ", msg=" + ex.getMessage() + ']');
            Exception causeSpiEx = (Exception)X.cause((Throwable)ex, IgniteSpiException.class);
            SnapshotEncryptionTest.assertTrue((causeSpiEx != null && (causeSpiEx.getMessage().contains("BaselineTopology of joining node (" + this.getTestIgniteInstanceName(1) + ") is not compatible with BaselineTopology in the cluster.") || causeSpiEx.getMessage().contains("Cache key differs! Node join is rejected.")) ? 1 : 0) != 0);
        }
        if (clusterFullyStarted) {
            for (String cacheName : ignite0.cacheNames()) {
                this.checkData(ignite0, cacheName);
            }
        }
    }

    @Test
    public void testRecoveryFailsWithExceptionWhenEncryptedCache() throws Exception {
        this.pitrEnabled = true;
        IgniteEx ig = this.startGrids(4);
        ig.cluster().state(ClusterState.ACTIVE);
        GridGain gg = (GridGain)ig.plugin("GridGain");
        long initVal = 100L;
        long keys = 1000L;
        try (IgniteDataStreamer st = ig.dataStreamer("default");){
            st.allowOverwrite(true);
            for (long i = 0L; i < keys; ++i) {
                st.addData((Object)i, (Object)initVal);
            }
        }
        gg.snapshot().createFullSnapshot(null, null).get();
        IgniteCache cache = ig.cache("default");
        HashSet<Long> slicePoint = new HashSet<Long>(4);
        ArrayList<T2> points = new ArrayList<T2>(4);
        for (int i = 0; i < 4; ++i) {
            slicePoint.add(keys / 5L * (long)(i + 1));
        }
        for (long i = 0L; i < keys; ++i) {
            Long val = (Long)cache.get((Object)i);
            long nextVal = val + 50L;
            cache.put((Object)i, (Object)nextVal);
            if (!slicePoint.contains(i)) continue;
            U.sleep((long)500L);
            points.add(new T2((Object)U.currentTimeMillis(), (Object)i));
            U.sleep((long)500L);
        }
        Collections.reverse(points);
        GridSnapshotEx rec = (GridSnapshotEx)gg.snapshot();
        for (T2 tup : points) {
            long time = (Long)tup.get1();
            System.err.println(">>> recovery to " + time);
            GridTestUtils.assertThrows((IgniteLogger)log, () -> rec.recoveryTo(time, null).get(), IgniteException.class, (String)"Point in time recovery is not allowed if there is encrypted cache");
        }
    }

    @Test
    public void testSnapshotCreatedWhenBaselineTopologySet() throws Exception {
        SnapshotStatus status;
        this.pitrEnabled = true;
        this.listeningLog = new ListeningTestLogger(log);
        IgniteEx ignite = this.startGrids(4);
        ignite.cluster().baselineAutoAdjustEnabled(false);
        ignite.cluster().state(ClusterState.ACTIVE);
        SnapshotEncryptionTest.assertEquals((Object)ClusterState.ACTIVE, (Object)ignite.cluster().state());
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        IgniteCache cache = ignite.cache("default");
        this.loadData(ignite, "default");
        this.startGrid(4);
        IgniteEx finalIgnite = ignite;
        Thread thread = new Thread(() -> finalIgnite.cluster().setBaselineTopology((Collection)finalIgnite.cluster().nodes().stream().filter(n -> !n.isClient()).collect(Collectors.toSet())));
        thread.start();
        boolean started = false;
        do {
            if ((status = gg.snapshot().ongoingSnapshotOperation()) == null) continue;
            started = true;
        } while (status != null || !started);
        thread.join();
        for (int k = 0; k < 1000; ++k) {
            if (k % 2 == 0) {
                cache.remove((Object)k);
                continue;
            }
            cache.put((Object)k, (Object)(k * 2));
        }
        List snapshots = gg.snapshot().list();
        SnapshotEncryptionTest.assertEquals((int)2, (int)snapshots.size());
        gg.snapshot().restoreSnapshot(((SnapshotInfo)snapshots.get(0)).snapshotId(), null, "test").get();
        SnapshotEncryptionTest.assertEquals((int)0, (int)cache.size(new CachePeekMode[0]));
        gg.snapshot().restoreSnapshot(((SnapshotInfo)snapshots.get(1)).snapshotId(), null, "test").get();
        this.checkData(ignite, "default");
    }

    @Test
    public void testScheduleWithEncryptedCaches() throws Exception {
        IgniteEx ignite = this.startGrids(2);
        ignite.cluster().baselineAutoAdjustEnabled(false);
        ignite.cluster().state(ClusterState.ACTIVE);
        SnapshotEncryptionTest.assertEquals((Object)ClusterState.ACTIVE, (Object)ignite.cluster().state());
        GridGainImpl gg = (GridGainImpl)ignite.plugin("GridGain");
        this.loadData(ignite, "default");
        List snapshots = gg.snapshot().list();
        SnapshotEncryptionTest.assertEquals((int)0, (int)snapshots.size());
        SnapshotCreateParameters createParameters = new SnapshotCreateParameters(CompressionOption.NONE, -1, 0, false);
        SnapshotSchedule schedule = new SnapshotSchedule("", "", SnapshotOperationType.CREATE, "* * * * *", "*/2 * * * *", null, 10L, "", true, null, createParameters);
        SnapshotScheduleProcessor scheduler = (SnapshotScheduleProcessor)gg.provider().getSnapshotScheduler();
        scheduler.start(schedule);
        GridTestUtils.waitForCondition(() -> !gg.snapshot().list().isEmpty(), (long)120001L);
        snapshots = gg.snapshot().list();
        SnapshotEncryptionTest.assertEquals((int)1, (int)snapshots.size());
        this.loadData(ignite, "default", 1000, 1);
        gg.snapshot().restoreSnapshot(((SnapshotInfo)snapshots.get(0)).snapshotId(), null, "test").get();
        this.checkData(ignite, "default");
    }

    private void loadData(IgniteEx ig, String cacheName) {
        this.loadData(ig, cacheName, 1000, 0);
    }

    private void loadData(IgniteEx ig, String cacheName, int cnt, int base) {
        try (IgniteDataStreamer ldr = ig.dataStreamer(cacheName);){
            ldr.allowOverwrite(true);
            for (int i = 0; i < cnt; ++i) {
                ldr.addData((Object)i, (Object)(base + i));
            }
        }
    }

    private void checkData(IgniteEx ig, String cacheName) {
        this.checkData(ig, cacheName, 1000);
    }

    private void checkData(IgniteEx ig, String cacheName, int cnt) {
        IgniteCache cache = ig.cache(cacheName);
        for (int i = 0; i < cnt; ++i) {
            SnapshotEncryptionTest.assertEquals((Object)i, (Object)cache.get((Object)i));
        }
    }

    @Test
    public void fullSnapshotWithTDEAndFullTrackingPage() throws Exception {
        int valuePrefixSize = 100000;
        int entryCount = 1000;
        String cacheName = UUID.randomUUID().toString();
        IgniteEx ignite0 = this.startGrids(1);
        ignite0.cluster().state(ClusterState.ACTIVE);
        IgniteCache cache = ignite0.createCache(this.getCacheConfiguration(cacheName).setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 1)));
        String originalPrefix = this.repeat("a", 100000);
        try (IgniteDataStreamer ldr = ignite0.dataStreamer(cacheName);){
            for (int i = 0; i < 1000; ++i) {
                ldr.addData((Object)i, (Object)(originalPrefix + i));
            }
        }
        this.forceCheckpoint();
        String updatedPrefix = this.repeat("b", 100000);
        for (int i = 0; i < 1000; ++i) {
            cache.put((Object)i, (Object)(updatedPrefix + i));
        }
        GridGain gg = (GridGain)ignite0.plugin("GridGain");
        SnapshotFuture fut = this.createEncryptedFullSnapshot(gg);
        long snapId = fut.snapshotOperation().snapshotId();
        this.assertCheckedSnapshotSuccessfully(gg, snapId);
        this.restoreSnapshot(gg, snapId);
        SnapshotEncryptionTest.assertEquals((int)1000, (int)cache.size(new CachePeekMode[0]));
        for (int i = 0; i < 1000; ++i) {
            String expectedValue = this.repeat("b", 100000) + i;
            SnapshotEncryptionTest.assertEquals((String)expectedValue, (String)((String)cache.get((Object)i)));
        }
    }

    private String repeat(String s, int count) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            buf.append(s);
        }
        return buf.toString();
    }

    private SnapshotFuture createEncryptedFullSnapshot(GridGain gg) {
        SnapshotCreateParams params = this.createSnapshotCreateParams();
        SnapshotFuture fut = gg.snapshot().createFullSnapshot(null, null, params, "test-create");
        fut.get(60L, TimeUnit.SECONDS);
        return fut;
    }

    protected SnapshotCreateParams createSnapshotCreateParams() {
        return new SnapshotCreateParams(CompressionOption.NONE, -1, 0, true, "Encrypted snap", SNAPSHOT_MASTER_KEY);
    }

    private void assertCheckedSnapshotSuccessfully(GridGain gg, long snapId) {
        List<SnapshotIssue> issues = this.checkSnapshot(gg, snapId);
        if (!F.isEmpty(issues)) {
            for (SnapshotIssue issue : issues) {
                this.info(issue.toString());
            }
            SnapshotEncryptionTest.fail((String)"Snapshot was checked with issues.");
        }
    }

    private List<SnapshotIssue> checkSnapshot(GridGain gg, long snapId) {
        return (List)gg.snapshot().check(new CheckSnapshotParams().snapshotId(snapId)).get(60L, TimeUnit.SECONDS);
    }

    private void restoreSnapshot(GridGain gg, long snapId) {
        gg.snapshot().restoreSnapshot(snapId, null, "test-restore").get(60L, TimeUnit.SECONDS);
    }
}

