/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.cache.db;

import java.util.Map;
import java.util.Objects;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.DynamicCacheDescriptor;
import org.apache.ignite.internal.util.IgniteUtils;
import org.gridgain.cache.db.IgniteStandByClusterJoinNodeWithDifferentStateWithOutCachesTest;
import org.junit.Assert;
import org.junit.Test;

public class IgniteStandByClusterJoinNodeWithDifferentStateWithCachesTest
extends IgniteStandByClusterJoinNodeWithDifferentStateWithOutCachesTest {
    private final String cacheName = "cache";
    private final String descriptors = "registeredCaches";
    private final String caches = "caches";

    @Test
    public void testJoinActiveNodeToInActiveClusterWithStaticCacheConfigurationOnInActiveNode() throws Exception {
        CacheConfiguration ccfg = new CacheConfiguration("cache");
        IgniteConfiguration cfg0 = this.cfg(this.name(0)).setCacheConfiguration(new CacheConfiguration[]{ccfg}).setActiveOnStart(false);
        IgniteConfiguration cfg1 = this.cfg(this.name(1)).setCacheConfiguration(new CacheConfiguration[]{ccfg}).setActiveOnStart(false);
        IgniteConfiguration cfg2 = this.cfg(this.name(2)).setCacheConfiguration(new CacheConfiguration[]{ccfg}).setActiveOnStart(false);
        IgniteConfiguration cfg3 = this.cfg(this.name(3)).setActiveOnStart(true);
        this.checkJoin(false, cfg0, cfg1, cfg2, cfg3);
        IgniteEx ig0 = this.grid(0);
        IgniteEx ig1 = this.grid(1);
        IgniteEx ig2 = this.grid(2);
        IgniteEx ig3 = this.grid(3);
        Map desc0 = (Map)IgniteUtils.field((Object)ig0.context().cache(), (String)"registeredCaches");
        Map desc1 = (Map)IgniteUtils.field((Object)ig0.context().cache(), (String)"registeredCaches");
        Map desc2 = (Map)IgniteUtils.field((Object)ig0.context().cache(), (String)"registeredCaches");
        Map desc3 = (Map)IgniteUtils.field((Object)ig0.context().cache(), (String)"registeredCaches");
        Assert.assertTrue((boolean)desc0.isEmpty());
        Assert.assertTrue((boolean)desc1.isEmpty());
        Assert.assertTrue((boolean)desc2.isEmpty());
        Assert.assertTrue((boolean)desc3.isEmpty());
        Assert.assertNull((Object)ig0.context().cache().cache("cache"));
        Assert.assertNull((Object)ig1.context().cache().cache("cache"));
        Assert.assertNull((Object)ig2.context().cache().cache("cache"));
        Assert.assertNull((Object)ig3.context().cache().cache("cache"));
        ig0.active(true);
        Map desc00 = (Map)IgniteUtils.field((Object)ig0.context().cache(), (String)"registeredCaches");
        Map desc11 = (Map)IgniteUtils.field((Object)ig0.context().cache(), (String)"registeredCaches");
        Map desc22 = (Map)IgniteUtils.field((Object)ig0.context().cache(), (String)"registeredCaches");
        Map desc33 = (Map)IgniteUtils.field((Object)ig0.context().cache(), (String)"registeredCaches");
        Assert.assertTrue((desc00.size() == 4 ? 1 : 0) != 0);
        Assert.assertTrue((desc11.size() == 4 ? 1 : 0) != 0);
        Assert.assertTrue((desc22.size() == 4 ? 1 : 0) != 0);
        Assert.assertTrue((desc33.size() == 4 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)ig0.context().cache().cache("cache"));
        Assert.assertNotNull((Object)ig1.context().cache().cache("cache"));
        Assert.assertNotNull((Object)ig2.context().cache().cache("cache"));
        Assert.assertNotNull((Object)ig3.context().cache().cache("cache"));
    }

    @Test
    public void testJoinActiveClientNodeToInActiveClusterWithStaticCacheConfigurationOnInActiveNode() throws Exception {
        CacheConfiguration ccfg = new CacheConfiguration("cache");
        IgniteConfiguration cfg0 = this.cfg(this.name(0)).setCacheConfiguration(new CacheConfiguration[]{ccfg}).setActiveOnStart(false);
        IgniteConfiguration cfg1 = this.cfg(this.name(1)).setCacheConfiguration(new CacheConfiguration[]{ccfg}).setActiveOnStart(false);
        IgniteConfiguration cfg2 = this.cfg(this.name(2)).setCacheConfiguration(new CacheConfiguration[]{ccfg}).setActiveOnStart(false);
        IgniteConfiguration cfg3 = this.cfg(this.name(3)).setClientMode(true).setActiveOnStart(true);
        this.checkJoin(false, cfg0, cfg1, cfg2, cfg3);
        IgniteEx ig0 = this.grid(0);
        IgniteEx ig1 = this.grid(1);
        IgniteEx ig2 = this.grid(2);
        IgniteEx ig3 = this.grid(3);
        Map desc0 = (Map)IgniteUtils.field((Object)ig0.context().cache(), (String)"registeredCaches");
        Map desc1 = (Map)IgniteUtils.field((Object)ig0.context().cache(), (String)"registeredCaches");
        Map desc2 = (Map)IgniteUtils.field((Object)ig0.context().cache(), (String)"registeredCaches");
        Map desc3 = (Map)IgniteUtils.field((Object)ig0.context().cache(), (String)"registeredCaches");
        Assert.assertTrue((boolean)desc0.isEmpty());
        Assert.assertTrue((boolean)desc1.isEmpty());
        Assert.assertTrue((boolean)desc2.isEmpty());
        Assert.assertTrue((boolean)desc3.isEmpty());
        Assert.assertNull((Object)ig0.context().cache().cache("cache"));
        Assert.assertNull((Object)ig1.context().cache().cache("cache"));
        Assert.assertNull((Object)ig2.context().cache().cache("cache"));
        Assert.assertNull((Object)ig3.context().cache().cache("cache"));
        ig0.active(true);
        Map desc00 = (Map)IgniteUtils.field((Object)ig0.context().cache(), (String)"registeredCaches");
        Map desc11 = (Map)IgniteUtils.field((Object)ig0.context().cache(), (String)"registeredCaches");
        Map desc22 = (Map)IgniteUtils.field((Object)ig0.context().cache(), (String)"registeredCaches");
        Map desc33 = (Map)IgniteUtils.field((Object)ig0.context().cache(), (String)"registeredCaches");
        Assert.assertTrue((desc00.size() == 4 ? 1 : 0) != 0);
        Assert.assertTrue((desc11.size() == 4 ? 1 : 0) != 0);
        Assert.assertTrue((desc22.size() == 4 ? 1 : 0) != 0);
        Assert.assertTrue((desc33.size() == 4 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)ig0.context().cache().cache("cache"));
        Assert.assertNotNull((Object)ig1.context().cache().cache("cache"));
        Assert.assertNotNull((Object)ig2.context().cache().cache("cache"));
        Assert.assertNull((Object)ig3.context().cache().cache("cache"));
        ig3.cache("cache");
        Assert.assertNotNull((Object)ig3.context().cache().cache("cache"));
    }

    @Test
    public void testJoinInActiveNodeToActiveClusterWithStaticCacheConfigurationOnActiveNode() throws Exception {
        CacheConfiguration ccfg = new CacheConfiguration("cache");
        IgniteConfiguration cfg0 = this.cfg(this.name(0)).setCacheConfiguration(new CacheConfiguration[]{ccfg}).setActiveOnStart(true);
        IgniteConfiguration cfg1 = this.cfg(this.name(1)).setCacheConfiguration(new CacheConfiguration[]{ccfg}).setActiveOnStart(true);
        IgniteConfiguration cfg2 = this.cfg(this.name(2)).setCacheConfiguration(new CacheConfiguration[]{ccfg}).setActiveOnStart(true);
        IgniteConfiguration cfg3 = this.cfg(this.name(3)).setActiveOnStart(false);
        this.checkJoin(true, cfg0, cfg1, cfg2, cfg3);
        IgniteEx ig0 = this.grid(0);
        IgniteEx ig1 = this.grid(1);
        IgniteEx ig2 = this.grid(2);
        IgniteEx ig3 = this.grid(3);
        Map desc0 = (Map)IgniteUtils.field((Object)ig0.context().cache(), (String)"registeredCaches");
        Map desc1 = (Map)IgniteUtils.field((Object)ig0.context().cache(), (String)"registeredCaches");
        Map desc2 = (Map)IgniteUtils.field((Object)ig0.context().cache(), (String)"registeredCaches");
        Map desc3 = (Map)IgniteUtils.field((Object)ig0.context().cache(), (String)"registeredCaches");
        Assert.assertTrue((desc0.size() == 4 ? 1 : 0) != 0);
        Assert.assertTrue((desc1.size() == 4 ? 1 : 0) != 0);
        Assert.assertTrue((desc2.size() == 4 ? 1 : 0) != 0);
        Assert.assertTrue((desc3.size() == 4 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)ig0.context().cache().cache("cache"));
        Assert.assertNotNull((Object)ig1.context().cache().cache("cache"));
        Assert.assertNotNull((Object)ig2.context().cache().cache("cache"));
        Assert.assertNotNull((Object)ig3.context().cache().cache("cache"));
    }

    @Test
    public void testJoinInActiveClientNodeToActiveClusterWithStaticCacheConfigurationOnActiveNode() throws Exception {
        CacheConfiguration ccfg = new CacheConfiguration("cache");
        IgniteConfiguration cfg0 = this.cfg(this.name(0)).setCacheConfiguration(new CacheConfiguration[]{ccfg}).setActiveOnStart(true);
        IgniteConfiguration cfg1 = this.cfg(this.name(1)).setCacheConfiguration(new CacheConfiguration[]{ccfg}).setActiveOnStart(true);
        IgniteConfiguration cfg2 = this.cfg(this.name(2)).setCacheConfiguration(new CacheConfiguration[]{ccfg}).setActiveOnStart(true);
        IgniteConfiguration cfg3 = this.cfg(this.name(3)).setClientMode(true).setActiveOnStart(false);
        this.checkJoin(true, cfg0, cfg1, cfg2, cfg3);
        IgniteEx ig0 = this.grid(0);
        IgniteEx ig1 = this.grid(1);
        IgniteEx ig2 = this.grid(2);
        IgniteEx ig3 = this.grid(3);
        Map desc0 = (Map)IgniteUtils.field((Object)ig0.context().cache(), (String)"registeredCaches");
        Map desc1 = (Map)IgniteUtils.field((Object)ig0.context().cache(), (String)"registeredCaches");
        Map desc2 = (Map)IgniteUtils.field((Object)ig0.context().cache(), (String)"registeredCaches");
        Map desc3 = (Map)IgniteUtils.field((Object)ig0.context().cache(), (String)"registeredCaches");
        Assert.assertTrue((desc0.size() == 4 ? 1 : 0) != 0);
        Assert.assertTrue((desc1.size() == 4 ? 1 : 0) != 0);
        Assert.assertTrue((desc2.size() == 4 ? 1 : 0) != 0);
        Assert.assertTrue((desc3.size() == 4 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)ig0.context().cache().cache("cache"));
        Assert.assertNotNull((Object)ig1.context().cache().cache("cache"));
        Assert.assertNotNull((Object)ig2.context().cache().cache("cache"));
        Assert.assertNull((Object)ig3.context().cache().cache("cache"));
        ig3.cache("cache");
        Assert.assertNotNull((Object)ig3.context().cache().cache("cache"));
    }

    @Test
    public void testJoinActiveNodeToInActiveClusterWithStaticCacheConfigurationOnActiveNode() throws Exception {
        CacheConfiguration ccfg = new CacheConfiguration("cache");
        IgniteConfiguration cfg0 = this.cfg(this.name(0)).setActiveOnStart(false);
        IgniteConfiguration cfg1 = this.cfg(this.name(1)).setActiveOnStart(false);
        IgniteConfiguration cfg2 = this.cfg(this.name(2)).setActiveOnStart(false);
        IgniteConfiguration cfg3 = this.cfg(this.name(3)).setCacheConfiguration(new CacheConfiguration[]{ccfg}).setActiveOnStart(true);
        this.checkJoin(false, cfg0, cfg1, cfg2, cfg3);
        IgniteEx ig0 = this.grid(0);
        IgniteEx ig1 = this.grid(1);
        IgniteEx ig2 = this.grid(2);
        IgniteEx ig3 = this.grid(3);
        Map desc0 = (Map)IgniteUtils.field((Object)ig0.context().cache(), (String)"registeredCaches");
        Map desc1 = (Map)IgniteUtils.field((Object)ig0.context().cache(), (String)"registeredCaches");
        Map desc2 = (Map)IgniteUtils.field((Object)ig0.context().cache(), (String)"registeredCaches");
        Map desc3 = (Map)IgniteUtils.field((Object)ig0.context().cache(), (String)"registeredCaches");
        Assert.assertTrue((boolean)desc0.isEmpty());
        Assert.assertTrue((boolean)desc1.isEmpty());
        Assert.assertTrue((boolean)desc2.isEmpty());
        Assert.assertTrue((boolean)desc3.isEmpty());
        Assert.assertNull((Object)ig0.context().cache().cache("cache"));
        Assert.assertNull((Object)ig1.context().cache().cache("cache"));
        Assert.assertNull((Object)ig2.context().cache().cache("cache"));
        Assert.assertNull((Object)ig3.context().cache().cache("cache"));
        ig0.active(true);
        Map desc00 = (Map)IgniteUtils.field((Object)ig0.context().cache(), (String)"registeredCaches");
        Map desc11 = (Map)IgniteUtils.field((Object)ig0.context().cache(), (String)"registeredCaches");
        Map desc22 = (Map)IgniteUtils.field((Object)ig0.context().cache(), (String)"registeredCaches");
        Map desc33 = (Map)IgniteUtils.field((Object)ig0.context().cache(), (String)"registeredCaches");
        Assert.assertTrue((desc00.size() == 4 ? 1 : 0) != 0);
        Assert.assertTrue((desc11.size() == 4 ? 1 : 0) != 0);
        Assert.assertTrue((desc22.size() == 4 ? 1 : 0) != 0);
        Assert.assertTrue((desc33.size() == 4 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)ig0.context().cache().cache("cache"));
        Assert.assertNotNull((Object)ig1.context().cache().cache("cache"));
        Assert.assertNotNull((Object)ig2.context().cache().cache("cache"));
        Assert.assertNotNull((Object)ig3.context().cache().cache("cache"));
    }

    @Test
    public void testJoinActiveClientNodeToInActiveClusterWithStaticCacheConfigurationOnActiveClientNode() throws Exception {
        CacheConfiguration ccfg = new CacheConfiguration("cache");
        IgniteConfiguration cfg0 = this.cfg(this.name(0)).setActiveOnStart(false);
        IgniteConfiguration cfg1 = this.cfg(this.name(1)).setActiveOnStart(false);
        IgniteConfiguration cfg2 = this.cfg(this.name(2)).setActiveOnStart(false);
        IgniteConfiguration cfg3 = this.cfg(this.name(3)).setCacheConfiguration(new CacheConfiguration[]{ccfg}).setClientMode(true).setActiveOnStart(true);
        this.checkJoin(false, cfg0, cfg1, cfg2, cfg3);
        IgniteEx ig0 = this.grid(0);
        IgniteEx ig1 = this.grid(1);
        IgniteEx ig2 = this.grid(2);
        IgniteEx ig3 = this.grid(3);
        Map desc0 = (Map)IgniteUtils.field((Object)ig0.context().cache(), (String)"registeredCaches");
        Map desc1 = (Map)IgniteUtils.field((Object)ig0.context().cache(), (String)"registeredCaches");
        Map desc2 = (Map)IgniteUtils.field((Object)ig0.context().cache(), (String)"registeredCaches");
        Map desc3 = (Map)IgniteUtils.field((Object)ig0.context().cache(), (String)"registeredCaches");
        Assert.assertTrue((boolean)desc0.isEmpty());
        Assert.assertTrue((boolean)desc1.isEmpty());
        Assert.assertTrue((boolean)desc2.isEmpty());
        Assert.assertTrue((boolean)desc3.isEmpty());
        Assert.assertNull((Object)ig0.context().cache().cache("cache"));
        Assert.assertNull((Object)ig1.context().cache().cache("cache"));
        Assert.assertNull((Object)ig2.context().cache().cache("cache"));
        Assert.assertNull((Object)ig3.context().cache().cache("cache"));
        ig0.active(true);
        Map desc00 = (Map)IgniteUtils.field((Object)ig0.context().cache(), (String)"registeredCaches");
        Map desc11 = (Map)IgniteUtils.field((Object)ig0.context().cache(), (String)"registeredCaches");
        Map desc22 = (Map)IgniteUtils.field((Object)ig0.context().cache(), (String)"registeredCaches");
        Map desc33 = (Map)IgniteUtils.field((Object)ig0.context().cache(), (String)"registeredCaches");
        Assert.assertTrue((desc00.size() == 4 ? 1 : 0) != 0);
        Assert.assertTrue((desc11.size() == 4 ? 1 : 0) != 0);
        Assert.assertTrue((desc22.size() == 4 ? 1 : 0) != 0);
        Assert.assertTrue((desc33.size() == 4 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)ig0.context().cache().cache("cache"));
        Assert.assertNotNull((Object)ig1.context().cache().cache("cache"));
        Assert.assertNotNull((Object)ig2.context().cache().cache("cache"));
        Assert.assertNull((Object)ig3.context().cache().cache("cache"));
        ig3.cache("cache");
        Assert.assertNotNull((Object)ig3.context().cache().cache("cache"));
    }

    @Test
    public void testJoinInActiveNodeToActiveClusterWithStaticCacheConfigurationOnInActiveNode() throws Exception {
        CacheConfiguration ccfg = new CacheConfiguration("cache");
        IgniteConfiguration cfg0 = this.cfg(this.name(0)).setActiveOnStart(true);
        IgniteConfiguration cfg1 = this.cfg(this.name(1)).setActiveOnStart(true);
        IgniteConfiguration cfg2 = this.cfg(this.name(2)).setActiveOnStart(true);
        IgniteConfiguration cfg3 = this.cfg(this.name(3)).setCacheConfiguration(new CacheConfiguration[]{ccfg}).setActiveOnStart(false);
        this.checkJoin(true, cfg0, cfg1, cfg2, cfg3);
        IgniteEx ig0 = this.grid(0);
        IgniteEx ig1 = this.grid(1);
        IgniteEx ig2 = this.grid(2);
        IgniteEx ig3 = this.grid(3);
        Map desc0 = (Map)IgniteUtils.field((Object)ig0.context().cache(), (String)"registeredCaches");
        Map desc1 = (Map)IgniteUtils.field((Object)ig0.context().cache(), (String)"registeredCaches");
        Map desc2 = (Map)IgniteUtils.field((Object)ig0.context().cache(), (String)"registeredCaches");
        Map desc3 = (Map)IgniteUtils.field((Object)ig0.context().cache(), (String)"registeredCaches");
        Assert.assertTrue((desc0.size() == 4 ? 1 : 0) != 0);
        Assert.assertTrue((desc1.size() == 4 ? 1 : 0) != 0);
        Assert.assertTrue((desc2.size() == 4 ? 1 : 0) != 0);
        Assert.assertTrue((desc3.size() == 4 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)ig0.context().cache().cache("cache"));
        Assert.assertNotNull((Object)ig1.context().cache().cache("cache"));
        Assert.assertNotNull((Object)ig2.context().cache().cache("cache"));
        Assert.assertNull((Object)ig3.context().cache().cache("cache"));
        ig3.cache("cache");
        Assert.assertNotNull((Object)ig3.context().cache().cache("cache"));
    }

    @Test
    public void testJoinInActiveClientNodeToActiveClusterWithStaticCacheConfigurationOnInActiveClientNode() throws Exception {
        CacheConfiguration ccfg = new CacheConfiguration("cache");
        IgniteConfiguration cfg0 = this.cfg(this.name(0)).setActiveOnStart(true);
        IgniteConfiguration cfg1 = this.cfg(this.name(1)).setActiveOnStart(true);
        IgniteConfiguration cfg2 = this.cfg(this.name(2)).setActiveOnStart(true);
        IgniteConfiguration cfg3 = this.cfg(this.name(3)).setCacheConfiguration(new CacheConfiguration[]{ccfg}).setClientMode(true).setActiveOnStart(false);
        this.checkJoin(true, cfg0, cfg1, cfg2, cfg3);
        IgniteEx ig0 = this.grid(0);
        IgniteEx ig1 = this.grid(1);
        IgniteEx ig2 = this.grid(2);
        IgniteEx ig3 = this.grid(3);
        Map desc0 = (Map)IgniteUtils.field((Object)ig0.context().cache(), (String)"registeredCaches");
        Map desc1 = (Map)IgniteUtils.field((Object)ig0.context().cache(), (String)"registeredCaches");
        Map desc2 = (Map)IgniteUtils.field((Object)ig0.context().cache(), (String)"registeredCaches");
        Map desc3 = (Map)IgniteUtils.field((Object)ig0.context().cache(), (String)"registeredCaches");
        Assert.assertTrue((desc0.size() == 4 ? 1 : 0) != 0);
        Assert.assertTrue((desc1.size() == 4 ? 1 : 0) != 0);
        Assert.assertTrue((desc2.size() == 4 ? 1 : 0) != 0);
        Assert.assertTrue((desc3.size() == 4 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)ig0.context().cache().cache("cache"));
        Assert.assertNotNull((Object)ig1.context().cache().cache("cache"));
        Assert.assertNotNull((Object)ig2.context().cache().cache("cache"));
        Assert.assertNull((Object)ig3.context().cache().cache("cache"));
        ig3.cache("cache");
        Assert.assertNotNull((Object)ig3.context().cache().cache("cache"));
    }

    @Override
    protected void checkJoin(boolean assertFlag, IgniteConfiguration ... cfgs) throws Exception {
        super.checkJoin(assertFlag, cfgs);
        IgniteEx ig0 = this.grid(0);
        IgniteEx ig1 = this.grid(1);
        IgniteEx ig2 = this.grid(2);
        IgniteEx ig3 = this.grid(3);
        Map desc0 = (Map)IgniteUtils.field((Object)ig0.context().cache(), (String)"registeredCaches");
        Map desc1 = (Map)IgniteUtils.field((Object)ig1.context().cache(), (String)"registeredCaches");
        Map desc2 = (Map)IgniteUtils.field((Object)ig2.context().cache(), (String)"registeredCaches");
        Map desc3 = (Map)IgniteUtils.field((Object)ig3.context().cache(), (String)"registeredCaches");
        IgniteStandByClusterJoinNodeWithDifferentStateWithCachesTest.assertTrue((boolean)this.checkCacheDescriptors(desc0, desc1));
        IgniteStandByClusterJoinNodeWithDifferentStateWithCachesTest.assertTrue((boolean)this.checkCacheDescriptors(desc1, desc2));
        IgniteStandByClusterJoinNodeWithDifferentStateWithCachesTest.assertTrue((boolean)this.checkCacheDescriptors(desc2, desc3));
        Map caches0 = (Map)IgniteUtils.field((Object)ig0.context().cache(), (String)"caches");
        Map caches1 = (Map)IgniteUtils.field((Object)ig1.context().cache(), (String)"caches");
        Map caches2 = (Map)IgniteUtils.field((Object)ig2.context().cache(), (String)"caches");
        Map caches3 = (Map)IgniteUtils.field((Object)ig3.context().cache(), (String)"caches");
        IgniteStandByClusterJoinNodeWithDifferentStateWithCachesTest.assertTrue((caches0.size() == caches1.size() && caches1.size() == caches2.size() && (caches2.size() == caches3.size() || caches2.size() - 1 == caches3.size()) ? 1 : 0) != 0);
    }

    protected boolean checkCacheDescriptors(Map<String, DynamicCacheDescriptor> desc0, Map<String, DynamicCacheDescriptor> desc1) {
        if (desc0.size() != desc1.size()) {
            return false;
        }
        for (Map.Entry<String, DynamicCacheDescriptor> desc : desc0.entrySet()) {
            DynamicCacheDescriptor desc00 = desc.getValue();
            DynamicCacheDescriptor desc11 = desc1.get(desc.getKey());
            if (Objects.equals(desc00.cacheId(), desc11.cacheId())) continue;
            return false;
        }
        return true;
    }
}

