/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.cache.db;

import java.io.File;
import java.io.Serializable;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.WALMode;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.PluginConfiguration;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinder;
import org.apache.ignite.spi.discovery.tcp.ipfinder.vm.TcpDiscoveryVmIpFinder;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.configuration.SnapshotConfiguration;
import org.junit.Test;

public class IgniteDbWithClientRestartSelfTest
extends GridCommonAbstractTest {
    private static final int GRID_CNT = 3;
    public static final String CACHE_NAME = "cache1";
    private static final TcpDiscoveryVmIpFinder ipFinder = new TcpDiscoveryVmIpFinder(true);

    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(gridName);
        DataStorageConfiguration memCfg = new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setMaxSize(0x19000000L).setPersistenceEnabled(true)).setWalMode(WALMode.LOG_ONLY);
        cfg.setDataStorageConfiguration(memCfg);
        GridGainConfiguration ggCfg = new GridGainConfiguration();
        SnapshotConfiguration ggDbCfg = new SnapshotConfiguration();
        ggCfg.setSnapshotConfiguration(ggDbCfg);
        cfg.setPluginConfigurations(new PluginConfiguration[]{ggCfg});
        cfg.setConsistentId((Serializable)((Object)gridName));
        cfg.setDiscoverySpi((DiscoverySpi)new TcpDiscoverySpi().setIpFinder((TcpDiscoveryIpFinder)ipFinder));
        cfg.setActiveOnStart(false);
        if (this.getTestIgniteInstanceName(3).equals(gridName) || this.getTestIgniteInstanceName(4).equals(gridName) || this.getTestIgniteInstanceName(5).equals(gridName)) {
            cfg.setClientMode(true);
        }
        return cfg;
    }

    protected void beforeTestsStarted() throws Exception {
        this.stopAllGrids();
        this.deleteWorkFiles();
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        System.clearProperty("IGNITE_PDS_PARTITION_DESTROY_CHECKPOINT_DELAY");
        this.deleteWorkFiles();
    }

    private void deleteWorkFiles() throws Exception {
        this.cleanPersistenceDir();
        U.delete((File)U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"snapshot", (boolean)false));
    }

    @Test
    public void testCase() throws Exception {
        int i;
        this.startGrids(3);
        CacheConfiguration ccfg1 = new CacheConfiguration();
        this.ignite(0).active(true);
        ccfg1.setName(CACHE_NAME);
        ccfg1.setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL);
        ccfg1.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        ccfg1.setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 128));
        ccfg1.setBackups(2);
        this.ignite(0).getOrCreateCache(ccfg1);
        this.startGrid(3);
        this.startGrid(4);
        this.startGrid(5);
        for (i = 0; i < 3; ++i) {
            this.stopGrid(i);
        }
        for (i = 0; i < 3; ++i) {
            this.startGrid(i);
            U.sleep((long)1000L);
        }
        this.ignite(0).active(true);
    }
}

