/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.processors.query.h2.sql;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.InvalidJsonException;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.ParseContext;
import com.jayway.jsonpath.Predicate;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import org.apache.ignite.cache.query.annotations.QuerySqlFunction;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueBoolean;
import org.gridgain.internal.h2.value.ValueBytes;
import org.gridgain.internal.h2.value.ValueDecimal;
import org.gridgain.internal.h2.value.ValueDouble;
import org.gridgain.internal.h2.value.ValueFloat;
import org.gridgain.internal.h2.value.ValueInt;
import org.gridgain.internal.h2.value.ValueLong;
import org.gridgain.internal.h2.value.ValueNull;
import org.gridgain.internal.h2.value.ValueShort;
import org.gridgain.internal.h2.value.ValueString;

public class JsonFunctions {
    private static final Configuration JSON_PATH_CONF = Configuration.defaultConfiguration().addOptions(new Option[]{Option.SUPPRESS_EXCEPTIONS}).addOptions(new Option[]{Option.DEFAULT_PATH_LEAF_TO_NULL});

    private JsonFunctions() {
    }

    @QuerySqlFunction(alias="JSON_OBJECT", deterministic=true)
    public static String jsonObject(Value ... values) throws SQLException {
        if (values.length % 2 != 0) {
            throw new SQLException("JSON_OBJECT expects an even number of arguments, got " + values.length);
        }
        DocumentContext ctx = JsonFunctions.json().parse("{}");
        int i = 0;
        int l = values.length;
        while (i < l) {
            String name;
            if ((name = values[i++].getString()) == null) {
                throw DbException.getInvalidValueException((String)"JSON_OBJECT key", (Object)"NULL");
            }
            Value value = values[i++];
            ctx.put("$", name, JsonFunctions.jsonReadValue(value), new Predicate[0]);
        }
        Map map = (Map)ctx.read("$", new Predicate[0]);
        return JSONObject.toJSONString((Map)map);
    }

    @QuerySqlFunction(alias="JSON_ARRAY", deterministic=true)
    public static String jsonArray(Value ... values) {
        DocumentContext ctx = JsonFunctions.json().parse("[]");
        for (Value value : values) {
            Object object = JsonFunctions.jsonReadValue(value);
            ctx.add("$", object, new Predicate[0]);
        }
        JSONArray arr = (JSONArray)ctx.read("$", new Predicate[0]);
        return JSONArray.toJSONString((List)arr);
    }

    @QuerySqlFunction(alias="JSON_VALUE", deterministic=true)
    public static String jsonValue(String json, String path) {
        if (json == null || path == null) {
            return null;
        }
        Object read = JsonFunctions.json().parse(json).read(path, new Predicate[0]);
        if (read == null || read instanceof JSONArray || read instanceof Map) {
            return null;
        }
        return read.toString();
    }

    @QuerySqlFunction(alias="JSON_QUERY", deterministic=true)
    public static String jsonQuery(String json, String path) {
        if (json == null || path == null) {
            return null;
        }
        Object read = JsonFunctions.json().parse(json).read(path, new Predicate[0]);
        if (read instanceof JSONArray) {
            return JSONArray.toJSONString((List)((JSONArray)read));
        }
        if (read instanceof Map) {
            return JSONObject.toJSONString((Map)((Map)read));
        }
        return null;
    }

    @QuerySqlFunction(alias="JSON_MODIFY", deterministic=true)
    public static String jsonModify(String json, String path, Value newValue) {
        Object newo;
        if (json == null || path == null) {
            return null;
        }
        if (newValue instanceof ValueString) {
            newo = JsonFunctions.json().parse(newValue.getString()).json();
        } else if (newValue instanceof ValueBytes) {
            String s = new String(newValue.getBytes(), StandardCharsets.UTF_8);
            newo = JsonFunctions.json().parse(s).json();
        } else {
            newo = newValue.getObject();
        }
        DocumentContext ctx = JsonFunctions.json().parse(json);
        if (newo == null) {
            ctx.delete(path, new Predicate[0]);
        } else {
            ctx.set(path, newo, new Predicate[0]);
        }
        return ctx.jsonString();
    }

    @QuerySqlFunction(alias="IS_JSON", deterministic=true)
    public static Boolean isJson(String s) {
        if (s == null) {
            return null;
        }
        try {
            return null != JsonFunctions.json().parse(s).read("$", new Predicate[0]);
        }
        catch (RuntimeException ignored) {
            return false;
        }
    }

    private static Object jsonReadValue(Value value) {
        Object object;
        if (value instanceof ValueString) {
            object = value.getString();
            if (value.getString().startsWith("[") || value.getString().startsWith("{")) {
                try {
                    object = JsonFunctions.json().parse(value.getString()).read("$", new Predicate[0]);
                }
                catch (InvalidJsonException invalidJsonException) {}
            }
        } else {
            object = value instanceof ValueBoolean || value instanceof ValueDecimal || value instanceof ValueDouble || value instanceof ValueFloat || value instanceof ValueInt || value instanceof ValueLong || value instanceof ValueNull || value instanceof ValueShort ? value.getObject() : value.getString();
        }
        return object;
    }

    private static ParseContext json() {
        return JsonPath.using((Configuration)JSON_PATH_CONF);
    }
}

