/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.sql.copy.s3;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class ByteStreamsUtils {
    public static void skipFully(InputStream in, long n) throws IOException {
        long skipped = ByteStreamsUtils.skipUpTo(in, n);
        if (skipped < n) {
            throw new EOFException("reached end of stream after skipping " + skipped + " bytes; " + n + " bytes expected");
        }
    }

    private static long skipUpTo(InputStream in, long n) throws IOException {
        int skip;
        long remaining;
        long totalSkipped;
        long skipped;
        byte[] buf = ByteStreamsUtils.createBuffer();
        for (totalSkipped = 0L; totalSkipped < n && ((skipped = ByteStreamsUtils.skipSafely(in, remaining = n - totalSkipped)) != 0L || (skipped = (long)in.read(buf, 0, skip = (int)Math.min(remaining, (long)buf.length))) != -1L); totalSkipped += skipped) {
        }
        return totalSkipped;
    }

    private static byte[] createBuffer() {
        return new byte[8192];
    }

    private static long skipSafely(InputStream in, long n) throws IOException {
        int available = in.available();
        return available == 0 ? 0L : in.skip(Math.min((long)available, n));
    }
}

