/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.sql.copy.iceberg;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.CatalogUtil;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.data.IcebergGenerics;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.io.CloseableGroup;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.ignite.internal.sql.engine.prepare.copy.CopyLocationPath;
import org.gridgain.internal.sql.copy.Reader;
import org.gridgain.internal.sql.copy.iceberg.IcebergUtils;

public class IcebergReader
implements Reader {
    private final CloseableGroup closeableGroup;
    private final CloseableIterator<Record> iterator;
    private final List<String> columns;

    public IcebergReader(CopyLocationPath location, Map<String, String> properties, List<String> locationColumns) {
        Map<String, String> props = IcebergUtils.combineProperties(location, properties);
        String impl = props.get("catalog-impl");
        String tableIdentifier = props.get("table-identifier");
        if (tableIdentifier == null || tableIdentifier.isEmpty()) {
            throw new IllegalArgumentException("Cannot load iceberg, 'table-identifier' property is null (ex.: 'db.schema.tbl' or 'tbl')");
        }
        TableIdentifier name = TableIdentifier.of((String[])tableIdentifier.split("[./\\\\]"));
        Catalog catalog = CatalogUtil.loadCatalog((String)impl, (String)impl, props, (Object)IcebergUtils.combineConfiguration(props));
        Table table = catalog.loadTable(name);
        CloseableIterable records = IcebergGenerics.read((Table)table).build();
        this.iterator = records.iterator();
        this.closeableGroup = new CloseableGroup();
        this.closeableGroup.setSuppressCloseFailure(true);
        if (catalog instanceof Closeable) {
            this.closeableGroup.addCloseable((Closeable)catalog);
        }
        this.closeableGroup.addCloseable((Closeable)table.io());
        this.closeableGroup.addCloseable((Closeable)records);
        this.closeableGroup.addCloseable(this.iterator);
        this.columns = IcebergReader.schemaColumns(table.schema(), locationColumns);
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public List<?> next() {
        return IcebergUtils.asList((Record)this.iterator.next(), this.columns);
    }

    @Override
    public void close() throws Exception {
        this.closeableGroup.close();
    }

    private static List<String> schemaColumns(Schema schema, List<String> locationColumns) {
        Collection values = schema.idToName().values();
        if (locationColumns.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>(locationColumns.size());
        for (String columnName : locationColumns) {
            for (String icebergColumnName : values) {
                if (!icebergColumnName.equalsIgnoreCase(columnName)) continue;
                result.add(icebergColumnName);
            }
        }
        return result;
    }
}

