/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.sql.copy.csv;

import com.opencsv.CSVParser;
import com.opencsv.CSVParserBuilder;
import com.opencsv.CSVReader;
import com.opencsv.CSVReaderBuilder;
import com.opencsv.ICSVParser;
import com.opencsv.exceptions.CsvValidationException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.ignite.internal.sql.engine.prepare.copy.CopyLocationPath;
import org.gridgain.internal.sql.copy.Reader;
import org.gridgain.internal.sql.copy.csv.CsvProperties;
import org.gridgain.internal.sql.copy.s3.S3ClientFactory;
import org.gridgain.internal.sql.copy.s3.S3Utils;
import org.jetbrains.annotations.Nullable;

public class CsvReader
implements Reader {
    private final CSVReader reader;
    private final Iterator<String[]> iterator;
    private final String nullstring;
    private final boolean trim;
    private final Map<Integer, Integer> columnsMapping;
    private final boolean fieldOrderMatchesColumnOrder;

    public CsvReader(CopyLocationPath location, Map<String, String> properties, List<String> columns) throws IOException {
        CsvProperties.validate(properties);
        char delimiter = properties.getOrDefault("delimiter", ",").charAt(0);
        Charset charset = Charset.forName(properties.getOrDefault("charset", "UTF-8"));
        boolean header = Boolean.parseBoolean(properties.getOrDefault("header", "false"));
        char quoteChar = properties.getOrDefault("quoteChar", "\"").charAt(0);
        char escapeChar = properties.getOrDefault("escapeChar", "\\").charAt(0);
        boolean strictQuotes = Boolean.parseBoolean(properties.getOrDefault("strictQuotes", "false"));
        boolean ignoreLeadingWhitespace = Boolean.parseBoolean(properties.getOrDefault("igniteLeadingWhitespace", "true"));
        boolean ignoreQuoations = Boolean.parseBoolean(properties.getOrDefault("ignoreQuotations", "false"));
        this.nullstring = properties.getOrDefault("null", "");
        this.trim = Boolean.parseBoolean(properties.getOrDefault("trim", "true"));
        CSVParser parser = new CSVParserBuilder().withSeparator(delimiter).withQuoteChar(quoteChar).withEscapeChar(escapeChar).withStrictQuotes(strictQuotes).withIgnoreLeadingWhiteSpace(ignoreLeadingWhitespace).withIgnoreQuotations(ignoreQuoations).build();
        this.reader = new CSVReaderBuilder(CsvReader.getReaderForPath(location.path(), charset, properties)).withCSVParser((ICSVParser)parser).build();
        try {
            this.columnsMapping = this.createColumnsMapping(header, columns);
            this.iterator = this.reader.iterator();
        }
        catch (Exception ex) {
            this.reader.close();
            throw new IOException("Failed to read CSV file '" + location.path() + "'", ex);
        }
        this.fieldOrderMatchesColumnOrder = this.isFieldOrderMatchesColumnOrder();
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public List<?> next() {
        return Arrays.asList(this.processRow(this.mapColumns(this.iterator.next())));
    }

    @Override
    public void close() throws Exception {
        this.reader.close();
    }

    private static java.io.Reader getReaderForPath(String path, Charset charset, Map<String, String> properties) throws IOException {
        if (S3Utils.isS3Scheme(path)) {
            return S3ClientFactory.getInputStreamReader(path, properties);
        }
        return Files.newBufferedReader(Paths.get(path, new String[0]), charset);
    }

    private String[] mapColumns(String[] row) {
        if (row.length == this.columnsMapping.size() && this.fieldOrderMatchesColumnOrder) {
            return row;
        }
        String[] newRow = new String[this.columnsMapping.size()];
        for (int i = 0; i < this.columnsMapping.size(); ++i) {
            newRow[i] = row[this.columnsMapping.get(i)];
        }
        return newRow;
    }

    private String[] processRow(String[] row) {
        if (this.nullstring != null) {
            for (int i = 0; i < row.length; ++i) {
                if (row[i] == null) continue;
                row[i] = this.processTrim(row[i]);
                row[i] = this.processNullString(row[i]);
            }
        }
        return row;
    }

    @Nullable
    private String processNullString(String val) {
        return this.nullstring.equals(val) ? null : val;
    }

    private String processTrim(String val) {
        return this.trim ? val.trim() : val;
    }

    private Map<Integer, Integer> createColumnsMapping(boolean header, List<String> columns) throws IOException, CsvValidationException {
        HashMap<Integer, Integer> columnsMapping = new HashMap<Integer, Integer>();
        if (header) {
            String[] headerRow = this.reader.readNext();
            for (int i = 0; i < columns.size(); ++i) {
                String column = columns.get(i);
                for (int j = 0; j < headerRow.length; ++j) {
                    if (!column.equalsIgnoreCase(headerRow[j])) continue;
                    columnsMapping.put(i, j);
                }
            }
        } else {
            for (int i = 0; i < columns.size(); ++i) {
                columnsMapping.put(i, i);
            }
        }
        return Collections.unmodifiableMap(columnsMapping);
    }

    private boolean isFieldOrderMatchesColumnOrder() {
        for (Map.Entry<Integer, Integer> entry : this.columnsMapping.entrySet()) {
            if (entry.getKey().equals(entry.getValue())) continue;
            return false;
        }
        return true;
    }
}

