/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.sql.copy;

import com.google.auto.service.AutoService;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.internal.lang.IgniteInternalException;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.schema.Column;
import org.apache.ignite.internal.sql.engine.InternalSqlRow;
import org.apache.ignite.internal.sql.engine.InternalSqlRowSingleLong;
import org.apache.ignite.internal.sql.engine.exec.query.CopyHandlerModule;
import org.apache.ignite.internal.sql.engine.prepare.copy.CopyCommand;
import org.apache.ignite.internal.sql.engine.prepare.copy.CopyLocation;
import org.apache.ignite.internal.sql.engine.prepare.copy.CopyLocationPath;
import org.apache.ignite.internal.sql.engine.prepare.copy.CopyLocationSelect;
import org.apache.ignite.internal.sql.engine.prepare.copy.CopyLocationTable;
import org.apache.ignite.internal.sql.engine.sql.copy.GridgainSqlCopyFormat;
import org.apache.ignite.internal.table.distributed.TableManager;
import org.apache.ignite.internal.thread.IgniteThreadFactory;
import org.apache.ignite.internal.thread.ThreadOperation;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.sql.SqlException;
import org.gridgain.internal.sql.copy.CommonProperties;
import org.gridgain.internal.sql.copy.Reader;
import org.gridgain.internal.sql.copy.Writer;
import org.gridgain.internal.sql.copy.csv.CsvReader;
import org.gridgain.internal.sql.copy.csv.CsvWriter;
import org.gridgain.internal.sql.copy.iceberg.IcebergReader;
import org.gridgain.internal.sql.copy.iceberg.IcebergWriter;
import org.gridgain.internal.sql.copy.parquet.IcebergParquetReader;
import org.gridgain.internal.sql.copy.parquet.IcebergParquetWriter;
import org.gridgain.internal.sql.copy.table.SelectReader;
import org.gridgain.internal.sql.copy.table.TableReader;
import org.gridgain.internal.sql.copy.table.TableWriter;
import org.gridgain.internal.sql.copy.vaildation.PropertyValidationException;
import org.jetbrains.annotations.Nullable;

@AutoService(value={CopyHandlerModule.class})
public class CopyHandlerModuleImpl
implements CopyHandlerModule {
    private static final IgniteLogger LOG = Loggers.forClass(CopyHandlerModuleImpl.class);
    private static final int NUM_THREADS = 4;
    @Nullable
    private ExecutorService executor;

    public CompletableFuture<Iterator<InternalSqlRow>> handle(String nodeName, TableManager mgr, CopyCommand cmd) {
        try {
            CommonProperties.validate(cmd.properties());
        }
        catch (PropertyValidationException e) {
            return CompletableFuture.failedFuture((Throwable)new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, e.getMessage()));
        }
        ExecutorService executor = this.executor(nodeName);
        return CompletableFuture.supplyAsync(() -> {
            int batchSize = Integer.parseInt(cmd.properties().getOrDefault("batchSize", "1024"));
            try (Reader reader = CopyHandlerModuleImpl.getReader(mgr, cmd, batchSize);){
                Iterator<InternalSqlRowSingleLong> iterator;
                block16: {
                    Writer writer = CopyHandlerModuleImpl.getWriter(mgr, cmd, reader.columns(), batchSize, executor);
                    try {
                        long count = 0L;
                        while (reader.hasNext()) {
                            writer.write(reader.next());
                            ++count;
                        }
                        InternalSqlRowSingleLong row = new InternalSqlRowSingleLong(count);
                        iterator = List.of(row).iterator();
                        if (writer == null) break block16;
                    }
                    catch (Throwable throwable) {
                        if (writer != null) {
                            try {
                                writer.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    writer.close();
                }
                return iterator;
            }
            catch (PropertyValidationException e) {
                throw new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, e.getMessage());
            }
            catch (Exception e) {
                LOG.error("Failed to COPY", (Throwable)e);
                throw new CompletionException(e);
            }
        }, executor);
    }

    public synchronized void close() {
        if (this.executor != null) {
            IgniteUtils.shutdownAndAwaitTermination((ExecutorService)this.executor, (long)10L, (TimeUnit)TimeUnit.SECONDS);
        }
    }

    static Reader getReader(TableManager mgr, CopyCommand cmd, int batchSize) throws IOException {
        List columns;
        CopyLocation location = cmd.from();
        GridgainSqlCopyFormat fmt = cmd.format();
        List list = columns = cmd.into() instanceof CopyLocationTable ? ((CopyLocationTable)cmd.into()).columns() : Collections.emptyList();
        if (GridgainSqlCopyFormat.CSV == fmt && location instanceof CopyLocationPath) {
            return new CsvReader((CopyLocationPath)location, cmd.properties(), columns);
        }
        if (GridgainSqlCopyFormat.PARQUET == fmt && location instanceof CopyLocationPath) {
            return new IcebergParquetReader((CopyLocationPath)location, cmd.properties(), columns);
        }
        if (GridgainSqlCopyFormat.ICEBERG == fmt && location instanceof CopyLocationPath) {
            return new IcebergReader((CopyLocationPath)location, cmd.properties(), columns);
        }
        if (location instanceof CopyLocationTable) {
            return new TableReader(mgr, (CopyLocationTable)location);
        }
        if (location instanceof CopyLocationSelect) {
            return new SelectReader((CopyLocationSelect)location, batchSize);
        }
        throw CopyHandlerModuleImpl.unexpected();
    }

    static Writer getWriter(TableManager mgr, CopyCommand cmd, List<Column> columns, int batchSize, ExecutorService executor) throws IOException {
        CopyLocation location = cmd.into();
        GridgainSqlCopyFormat fmt = cmd.format();
        if (GridgainSqlCopyFormat.CSV == fmt && location instanceof CopyLocationPath) {
            return new CsvWriter((CopyLocationPath)location, cmd.properties(), columns);
        }
        if (GridgainSqlCopyFormat.PARQUET == fmt && location instanceof CopyLocationPath) {
            return new IcebergParquetWriter((CopyLocationPath)location, cmd.properties(), columns);
        }
        if (GridgainSqlCopyFormat.ICEBERG == fmt && location instanceof CopyLocationPath) {
            return new IcebergWriter((CopyLocationPath)location, cmd.properties(), columns);
        }
        if (location instanceof CopyLocationTable) {
            return new TableWriter(mgr, (CopyLocationTable)location, columns, batchSize, executor);
        }
        throw CopyHandlerModuleImpl.unexpected();
    }

    private static IgniteInternalException unexpected() {
        String msg = "Unexpected locations COPY FROM";
        return new IgniteInternalException(ErrorGroups.Common.INTERNAL_ERR, msg);
    }

    private synchronized ExecutorService executor(String nodeName) {
        if (this.executor == null) {
            ThreadPoolExecutor executor = new ThreadPoolExecutor(4, 4, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)IgniteThreadFactory.create((String)nodeName, (String)"sql-copy", (IgniteLogger)LOG, (ThreadOperation[])new ThreadOperation[0]));
            executor.allowCoreThreadTimeOut(true);
            this.executor = executor;
        }
        return this.executor;
    }
}

