/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.sql.copy.csv;

import java.nio.charset.Charset;
import java.util.Map;
import org.gridgain.internal.sql.copy.vaildation.PropertyValidationException;

public class CsvProperties {
    public static final String DELIMITER = "delimiter";
    public static final String DFLT_DELIMITER = ",";
    public static final String CHARSET = "charset";
    public static final String DFLT_CHARSET = "UTF-8";
    public static final String NULL = "null";
    public static final String DFLT_NULL = "";
    public static final String TRIM = "trim";
    public static final String DFLT_TRIM = "true";
    public static final String HEADER = "header";
    public static final String DFLT_HEADER = "false";
    public static final String QUOTE_CHAR = "quoteChar";
    public static final String DFLT_QUOTE_CHAR = "\"";
    public static final String ESCAPE_CHAR = "escapeChar";
    public static final String DFLT_ESCAPE_CHAR = "\\";
    public static final String STRICT_QUOTES = "strictQuotes";
    public static final String DFLT_STRICT_QUOTES = "false";
    public static final String IGNORE_LEADING_WHITESPACE = "igniteLeadingWhitespace";
    public static final String DFLT_IGNORE_LEADING_WHITESPACE = "true";
    public static final String IGNORE_QUOATIONS = "ignoreQuotations";
    public static final String DFLT_IGNORE_QUOATIONS = "false";

    public static void validate(Map<String, String> properties) throws PropertyValidationException {
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            CsvProperties.validate(entry.getKey(), entry.getValue());
        }
    }

    private static void validate(String key, String value) throws PropertyValidationException {
        switch (key) {
            case "batchSize": 
            case "delimiter": 
            case "quoteChar": 
            case "escapeChar": 
            case "null": {
                break;
            }
            case "charset": {
                if (Charset.isSupported(value)) break;
                throw new PropertyValidationException("Unsupported charset: " + value);
            }
            case "trim": 
            case "header": 
            case "strictQuotes": 
            case "igniteLeadingWhitespace": 
            case "ignoreQuotations": {
                if ("true".equals(value) || "false".equals(value)) break;
                throw new PropertyValidationException("Invalid value for property '" + key + "': " + value);
            }
            case "s3.access-key-id": 
            case "s3.secret-access-key": 
            case "s3.client-region": 
            case "s3.endpoint": {
                break;
            }
            default: {
                throw new PropertyValidationException("Unknown property: " + key);
            }
        }
    }
}

