/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.sql.copy;

import java.util.Map;
import org.gridgain.internal.sql.copy.vaildation.PropertyValidationException;

public class CommonProperties {
    public static final String BATCH_SIZE = "batchSize";
    public static final String DFLT_BATCH_SIZE = "1024";

    public static void validate(Map<String, String> properties) throws PropertyValidationException {
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            CommonProperties.validate(entry.getKey(), entry.getValue());
        }
    }

    private static void validate(String key, String value) throws PropertyValidationException {
        switch (key) {
            case "batchSize": {
                try {
                    int batchSize = Integer.parseInt(value);
                    if (batchSize <= 0) {
                        throw new PropertyValidationException("Batch size must be greater than 0: " + value);
                    }
                    break;
                }
                catch (NumberFormatException e) {
                    throw new PropertyValidationException("Invalid batch size: " + value);
                }
            }
        }
    }
}

