/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.sql.copy.parquet;

import org.apache.parquet.column.page.PageReadStore;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.io.ColumnIOFactory;
import org.apache.parquet.io.MessageColumnIO;
import org.apache.parquet.io.RecordReader;
import org.apache.parquet.io.api.RecordMaterializer;
import org.apache.parquet.schema.MessageType;
import org.gridgain.internal.sql.copy.parquet.ObjectGroup;
import org.gridgain.internal.sql.copy.parquet.convert.GroupRecordConverter;

public class RowGroupReader {
    private final RecordReader<Group> currentRecordReader;
    private final long totalPageCount;
    private long currentPageRead = 0L;

    public RowGroupReader(MessageType schema, PageReadStore pageReadStore) {
        this.totalPageCount = pageReadStore.getRowCount();
        MessageColumnIO columnIo = new ColumnIOFactory().getColumnIO(schema);
        this.currentRecordReader = columnIo.getRecordReader(pageReadStore, (RecordMaterializer)new GroupRecordConverter(schema));
    }

    public boolean hasNext() {
        return this.currentPageRead < this.totalPageCount;
    }

    public ObjectGroup readNext() {
        ++this.currentPageRead;
        return (ObjectGroup)((Object)this.currentRecordReader.read());
    }
}

