/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.sql.copy.iceberg;

import java.io.Closeable;
import java.io.IOException;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.iceberg.CatalogUtil;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.data.parquet.GenericParquetWriter;
import org.apache.iceberg.io.CloseableGroup;
import org.apache.iceberg.io.DataWriter;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.parquet.Parquet;
import org.apache.ignite.internal.schema.Column;
import org.apache.ignite.internal.sql.engine.prepare.copy.CopyLocationPath;
import org.apache.parquet.schema.MessageType;
import org.gridgain.internal.sql.copy.Writer;
import org.gridgain.internal.sql.copy.iceberg.IcebergUtils;
import org.jetbrains.annotations.Nullable;

public class IcebergWriter
implements Writer {
    private final Schema schema;
    private final Table table;
    private final DataWriter<Record> dataWriter;
    private final GenericRecord rec;
    private final CloseableGroup closeableGroup;

    public IcebergWriter(CopyLocationPath location, Map<String, String> properties, @Nullable List<Column> columns) throws IOException {
        if (CollectionUtils.isEmpty(columns)) {
            throw new IllegalArgumentException("Cannot read table table without schema descriptor");
        }
        Map<String, String> props = IcebergUtils.combineProperties(location, properties);
        String impl = props.get("catalog-impl");
        String tableIdentifier = props.get("table-identifier");
        if (tableIdentifier == null || tableIdentifier.isEmpty()) {
            throw new IllegalArgumentException("Cannot load iceberg, 'table-identifier' property is null (ex.: 'db.schema.tbl' or 'tbl')");
        }
        TableIdentifier name = TableIdentifier.of((String[])tableIdentifier.split("[./\\\\]"));
        Catalog catalog = CatalogUtil.buildIcebergCatalog((String)impl, props, (Object)IcebergUtils.combineConfiguration(props));
        this.schema = IcebergUtils.asIcebergSchema(columns);
        this.table = catalog.createTable(name, this.schema, PartitionSpec.unpartitioned(), props);
        FileIO tableIo = this.table.io();
        OutputFile outputFile = tableIo.newOutputFile(this.outputFileName());
        this.dataWriter = Parquet.writeData((OutputFile)outputFile).schema(this.schema).createWriterFunc(messageType -> GenericParquetWriter.create((Schema)this.schema, (MessageType)messageType)).overwrite().withSpec(PartitionSpec.unpartitioned()).build();
        this.rec = GenericRecord.create((Schema)this.schema);
        this.closeableGroup = new CloseableGroup();
        this.closeableGroup.setSuppressCloseFailure(true);
        if (catalog instanceof Closeable) {
            this.closeableGroup.addCloseable((Closeable)catalog);
        }
        this.closeableGroup.addCloseable((Closeable)tableIo);
    }

    @Override
    public void write(List<?> item) throws IOException {
        this.dataWriter.write((Object)IcebergUtils.asRecord(item, this.rec, this.schema));
    }

    @Override
    public void close() throws Exception {
        this.dataWriter.close();
        this.table.newAppend().appendFile(this.dataWriter.toDataFile()).commit();
        this.closeableGroup.close();
    }

    private String outputFileName() {
        String fileName = DateTimeFormatter.ofPattern("yyyyMMdd-HHmmss.SSS").withZone(ZoneOffset.UTC).format(Instant.now()) + "-UTC.parquet";
        return this.table.location() + "/data/" + fileName;
    }
}

