/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.sql.copy.parquet;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.iceberg.Files;
import org.apache.iceberg.Schema;
import org.apache.iceberg.aws.s3.S3FileIOProperties;
import org.apache.iceberg.aws.s3.S3InputFile;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.data.parquet.GenericParquetReaders;
import org.apache.iceberg.io.CloseableGroup;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.metrics.MetricsContext;
import org.apache.iceberg.parquet.Parquet;
import org.apache.iceberg.parquet.ParquetIoPublic;
import org.apache.iceberg.parquet.ParquetSchemaUtil;
import org.apache.iceberg.types.Types;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.sql.engine.prepare.copy.CopyLocationPath;
import org.apache.parquet.Strings;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.schema.MessageType;
import org.gridgain.internal.sql.copy.Reader;
import org.gridgain.internal.sql.copy.iceberg.IcebergUtils;
import org.gridgain.internal.sql.copy.parquet.ParquetProperties;
import org.gridgain.internal.sql.copy.parquet.PathUtils;
import org.gridgain.internal.sql.copy.s3.S3ClientFactory;
import org.gridgain.internal.sql.copy.s3.S3Utils;
import software.amazon.awssdk.services.s3.S3Client;

public class IcebergParquetReader
implements Reader {
    private static final IgniteLogger LOG = Loggers.forClass(IcebergParquetReader.class);
    private final CloseableGroup closeableGroup;
    private final Iterator<Record> iterator;
    private final List<String> columns;

    public IcebergParquetReader(CopyLocationPath from, Map<String, String> properties, List<String> columns) throws IOException {
        ParquetProperties.validate(properties);
        String pattern = properties.getOrDefault("pattern", "");
        List<InputFile> inputFiles = IcebergParquetReader.getInputFilesFromPattern(from.path(), pattern, IcebergUtils.combineProperties(from, properties));
        if (inputFiles.isEmpty()) {
            throw new IOException(IgniteStringFormatter.format((String)"No files to read from matching pattern: '{}'", (Object[])new Object[]{pattern}));
        }
        this.closeableGroup = new CloseableGroup();
        this.closeableGroup.setSuppressCloseFailure(true);
        MessageType parquetSchema = this.getParquetSchema(inputFiles.get(0));
        if (!this.validateSchemas(inputFiles, parquetSchema)) {
            throw new IOException("All parquet files must have the same schema");
        }
        Schema schema = ParquetSchemaUtil.convert((MessageType)parquetSchema);
        this.columns = columns.stream().map(col -> {
            Types.NestedField nf = schema.caseInsensitiveFindField(col);
            if (nf == null) {
                LOG.warn("Column '{}' not found in parquet schema, values will be null", new Object[]{col});
                return null;
            }
            return nf.name();
        }).collect(Collectors.toList());
        CloseableIterable reader = inputFiles.stream().map(inputFile -> IcebergParquetReader.createReader(schema, inputFile)).collect(Collectors.collectingAndThen(Collectors.toList(), CloseableIterable::concat));
        this.iterator = this.addCloseable(reader).iterator();
    }

    private static CloseableIterable<Record> createReader(Schema schema, InputFile inputFile) {
        return Parquet.read((InputFile)inputFile).project(schema).createReaderFunc(fileSchema -> GenericParquetReaders.buildReader((Schema)schema, (MessageType)fileSchema)).caseInsensitive().build();
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public List<?> next() {
        return IcebergUtils.asList(this.iterator.next(), this.columns);
    }

    @Override
    public void close() throws Exception {
        this.closeableGroup.close();
    }

    private <T extends Closeable> T addCloseable(T closeable) {
        this.closeableGroup.addCloseable(closeable);
        return closeable;
    }

    private MessageType getParquetSchema(InputFile file) throws IOException {
        ParquetFileReader schemaReader = this.addCloseable(ParquetFileReader.open((org.apache.parquet.io.InputFile)ParquetIoPublic.file(file)));
        return schemaReader.getFileMetaData().getSchema();
    }

    private boolean validateSchemas(List<InputFile> files, MessageType schema) throws IOException {
        if (files.size() == 1) {
            return true;
        }
        for (InputFile file : files) {
            MessageType parquetSchema = this.getParquetSchema(file);
            if (parquetSchema.equals((Object)schema)) continue;
            return false;
        }
        return true;
    }

    private static List<InputFile> getInputFilesFromPattern(String path, String pattern, Map<String, String> properties) throws IOException {
        if (Strings.isNullOrEmpty((String)pattern)) {
            if (S3Utils.isS3Scheme(path)) {
                return Collections.singletonList(S3InputFile.fromLocation((String)path, (S3Client)S3ClientFactory.createS3Client(properties), (S3FileIOProperties)new S3FileIOProperties(), (MetricsContext)MetricsContext.nullMetrics()));
            }
            return Collections.singletonList(Files.localInput((File)Paths.get(path, new String[0]).toFile()));
        }
        List<Path> matchedFiles = PathUtils.getFilesByPattern(path, pattern);
        return matchedFiles.stream().map(Path::toFile).map(Files::localInput).collect(Collectors.toList());
    }
}

