/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.sql.copy.s3;

public class S3Uri {
    private static final String SCHEME_DELIM = "://";
    private static final String PATH_DELIM = "/";
    private static final String QUERY_DELIM = "\\?";
    private final String location;
    private final String scheme;
    private final String bucket;
    private final String key;

    public S3Uri(String location) {
        this.location = location;
        String[] schemeSplit = location.split(SCHEME_DELIM);
        this.scheme = schemeSplit[0];
        String[] authoritySplit = schemeSplit[1].split(PATH_DELIM, 2);
        this.bucket = authoritySplit[0];
        String path = authoritySplit.length > 1 ? authoritySplit[1] : "";
        this.key = path = path.split(QUERY_DELIM)[0];
    }

    public String bucket() {
        return this.bucket;
    }

    public String key() {
        return this.key;
    }

    public String location() {
        return this.location;
    }

    public String scheme() {
        return this.scheme;
    }

    public String toString() {
        return this.location;
    }
}

