/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.sql.copy.s3;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.compress.utils.CountingOutputStream;
import org.apache.ignite.internal.sql.engine.util.Commons;
import org.apache.parquet.io.PositionOutputStream;
import org.gridgain.internal.sql.copy.s3.S3Uri;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.http.ContentStreamProvider;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;

public class S3OutputStream
extends PositionOutputStream {
    private static final Logger LOG = LoggerFactory.getLogger(S3OutputStream.class);
    private final S3Client s3Client;
    private final S3Uri location;
    private final CountingOutputStream stream;
    private final File stagingFile;
    private long pos = 0L;
    private boolean closed = false;

    public S3OutputStream(S3Client s3, S3Uri location) throws IOException {
        this.s3Client = s3;
        this.location = location;
        File stagingDirectory = Files.createTempDirectory("s3fileio-", new FileAttribute[0]).toFile();
        stagingDirectory.deleteOnExit();
        this.stagingFile = File.createTempFile("s3fileio-", ".tmp", stagingDirectory);
        this.stream = new CountingOutputStream((OutputStream)new BufferedOutputStream(Files.newOutputStream(this.stagingFile.toPath(), new OpenOption[0])));
    }

    public long getPos() {
        return this.pos;
    }

    public void flush() throws IOException {
        this.stream.flush();
    }

    public void write(int b) throws IOException {
        this.stream.write(b);
        ++this.pos;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        int remaining = len;
        int relativeOffset = off;
        this.stream.write(b, relativeOffset, remaining);
        this.pos += (long)len;
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        try {
            Commons.closeQuiet((Object)this.stream);
            this.completeUploads();
            super.close();
        }
        finally {
            this.cleanUpStagingFiles();
            this.closed = true;
        }
    }

    private void cleanUpStagingFiles() {
        try {
            if (!this.stagingFile.delete()) {
                LOG.info("Failed to delete staging file: {}", (Object)this.stagingFile);
            }
        }
        catch (Exception e) {
            LOG.info("Failed to delete staging file: {}", (Object)this.stagingFile, (Object)e);
        }
    }

    private void completeUploads() {
        long contentLength = this.stagingFile.length();
        ContentStreamProvider contentProvider = () -> new BufferedInputStream(S3OutputStream.uncheckedInputStream(this.stagingFile));
        PutObjectRequest.Builder requestBuilder = PutObjectRequest.builder().bucket(this.location.bucket()).key(this.location.key());
        this.s3Client.putObject((PutObjectRequest)requestBuilder.build(), RequestBody.fromContentProvider((ContentStreamProvider)contentProvider, (long)contentLength, (String)"application/octet-stream"));
    }

    private static InputStream uncheckedInputStream(File file) {
        try {
            return Files.newInputStream(file.toPath(), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

