/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.sql.copy.s3;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.ignite.internal.sql.engine.util.Commons;
import org.apache.parquet.io.SeekableInputStream;
import org.gridgain.internal.sql.copy.s3.ByteStreamsUtils;
import org.gridgain.internal.sql.copy.s3.S3Uri;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.core.sync.ResponseTransformer;
import software.amazon.awssdk.http.Abortable;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.NoSuchKeyException;

public class S3InputStream
extends SeekableInputStream {
    private static final Logger LOG = LoggerFactory.getLogger(S3InputStream.class);
    private final S3Client s3client;
    private final S3Uri location;
    private InputStream stream;
    private long pos = 0L;
    private long next = 0L;
    private boolean closed = false;

    public S3InputStream(S3Client s3, S3Uri location) {
        this.s3client = s3;
        this.location = location;
    }

    private InputStream readRange(int start, int len) {
        String range = String.format("bytes=%s-%s", start, start + len - 1);
        GetObjectRequest.Builder requestBuilder = GetObjectRequest.builder().bucket(this.location.bucket()).key(this.location.key()).range(range);
        return (InputStream)this.s3client.getObject((GetObjectRequest)requestBuilder.build(), ResponseTransformer.toInputStream());
    }

    public long getPos() {
        return this.next;
    }

    public void seek(long newPos) {
        if (this.closed) {
            throw new IllegalStateException("Cannot seek: already closed");
        }
        if (newPos < 0L) {
            throw new IllegalArgumentException("position is negative: " + newPos);
        }
        this.next = newPos;
    }

    public void readFully(byte[] bytes) throws IOException {
        S3InputStream.readFully(this.stream, bytes, 0, bytes.length);
    }

    public void readFully(byte[] buffer, int start, int len) throws IOException {
        S3InputStream.readFully(this.readRange(start, len), buffer, start, len);
    }

    public void readFully(ByteBuffer buf) throws IOException {
        this.positionStream();
        byte[] buffer = new byte[buf.remaining()];
        this.readFully(buffer);
        buf.put(buffer, buf.position() + buf.arrayOffset(), buf.remaining());
    }

    private static void readFully(InputStream stream, byte[] bytes, int offset, int length) throws IOException {
        S3InputStream.readRemaining(stream, bytes, offset, length);
    }

    public int read(ByteBuffer buf) throws IOException {
        byte[] buffer = new byte[buf.remaining()];
        int code = this.read(buffer);
        buf.put(buffer, buf.position() + buf.arrayOffset(), buf.remaining());
        return code;
    }

    public int read() throws IOException {
        if (this.closed) {
            throw new IllegalStateException("Cannot read: already closed");
        }
        this.positionStream();
        ++this.pos;
        ++this.next;
        return this.stream.read();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("Cannot read: already closed");
        }
        this.positionStream();
        int bytesRead = this.stream.read(b, off, len);
        this.pos += (long)bytesRead;
        this.next += (long)bytesRead;
        return bytesRead;
    }

    public void close() throws IOException {
        super.close();
        this.closeStream();
        this.closed = true;
    }

    private void positionStream() throws IOException {
        if (this.stream != null && this.next == this.pos) {
            return;
        }
        if (this.stream != null && this.next > this.pos) {
            long skip = this.next - this.pos;
            int skipSize = 0x100000;
            if (skip <= (long)Math.max(this.stream.available(), skipSize)) {
                LOG.debug("Read-through seek for {} to offset {}", (Object)this.location, (Object)this.next);
                try {
                    ByteStreamsUtils.skipFully(this.stream, skip);
                    this.pos = this.next;
                    return;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        LOG.debug("Seek with new stream for {} to offset {}", (Object)this.location, (Object)this.next);
        this.pos = this.next;
        this.openStream();
    }

    private void openStream() throws IOException {
        GetObjectRequest.Builder requestBuilder = GetObjectRequest.builder().bucket(this.location.bucket()).key(this.location.key()).range(String.format("bytes=%s-", this.pos));
        this.closeStream();
        try {
            this.stream = (InputStream)this.s3client.getObject((GetObjectRequest)requestBuilder.build(), ResponseTransformer.toInputStream());
        }
        catch (NoSuchKeyException e) {
            throw new IOException("Location does not exist:" + String.valueOf(this.location), e);
        }
    }

    private void closeStream() throws IOException {
        if (this.stream != null) {
            this.abortStream();
            Commons.closeQuiet((Object)this.stream);
            this.stream = null;
        }
    }

    private void abortStream() {
        try {
            if (this.stream instanceof Abortable && this.stream.read() != -1) {
                ((Abortable)this.stream).abort();
            }
        }
        catch (Exception e) {
            LOG.info("An error occurred while aborting the stream", (Throwable)e);
        }
    }

    private static int readRemaining(InputStream stream, byte[] bytes, int offset, int length) throws IOException {
        int bytesRead;
        int pos = offset;
        int remaining = length;
        while (remaining > 0 && (bytesRead = stream.read(bytes, pos, remaining)) >= 0) {
            remaining -= bytesRead;
            pos += bytesRead;
        }
        return length - remaining;
    }
}

