/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.sql.copy.parquet;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.ignite.internal.sql.engine.prepare.copy.CopyLocationPath;
import org.apache.parquet.Strings;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.schema.MessageType;
import org.gridgain.internal.sql.copy.Reader;
import org.gridgain.internal.sql.copy.parquet.LocalInputFile;
import org.gridgain.internal.sql.copy.parquet.ParquetFileReader;
import org.gridgain.internal.sql.copy.parquet.ParquetProperties;
import org.gridgain.internal.sql.copy.parquet.PathUtils;
import org.gridgain.internal.sql.copy.s3.S3ClientFactory;
import org.gridgain.internal.sql.copy.s3.S3Utils;

@Deprecated(forRemoval=true)
public class ParquetReader
implements Reader {
    private ParquetFileReader currentParquetFileReader;
    private final List<ParquetFileReader> parquetFileReaderList = new ArrayList<ParquetFileReader>();
    private final Iterator<ParquetFileReader> parquetFileReaderIterator;
    private long totalRecordCount = 0L;
    private int totalRecordRead = 0;

    public ParquetReader(CopyLocationPath from, Map<String, String> properties, List<String> columns) throws IOException {
        ParquetProperties.validate(properties);
        String pattern = properties.getOrDefault("pattern", "");
        List<InputFile> inputFiles = this.getInputFilesFromPattern(from.path(), pattern, properties);
        if (inputFiles.isEmpty()) {
            throw new IOException("No files to read from matching pattern: '" + pattern + "'");
        }
        for (InputFile inputFile : inputFiles) {
            this.parquetFileReaderList.add(new ParquetFileReader(inputFile, columns));
        }
        if (!this.validateSchemas(this.parquetFileReaderList)) {
            throw new IOException("All parquet files must have the same schema");
        }
        this.totalRecordCount = this.parquetFileReaderList.stream().mapToLong(ParquetFileReader::totalRecordCount).sum();
        this.parquetFileReaderIterator = this.parquetFileReaderList.iterator();
        this.currentParquetFileReader = this.parquetFileReaderIterator.next();
    }

    @Override
    public boolean hasNext() {
        return (long)this.totalRecordRead < this.totalRecordCount;
    }

    private List<InputFile> getInputFilesFromPattern(String path, String pattern, Map<String, String> properties) throws IOException {
        if (Strings.isNullOrEmpty((String)pattern)) {
            if (S3Utils.isS3Scheme(path)) {
                return Collections.singletonList(S3ClientFactory.getS3InputFile(path, properties));
            }
            return Collections.singletonList(new LocalInputFile(Paths.get(path, new String[0])));
        }
        List<Path> matchedFiles = PathUtils.getFilesByPattern(path, pattern);
        return matchedFiles.stream().map(LocalInputFile::new).collect(Collectors.toList());
    }

    @Override
    public List<?> next() {
        while (!this.currentParquetFileReader.hasNext()) {
            this.currentParquetFileReader = this.parquetFileReaderIterator.next();
        }
        ++this.totalRecordRead;
        return this.currentParquetFileReader.next();
    }

    @Override
    public void close() throws Exception {
        for (ParquetFileReader parquetFileReader : this.parquetFileReaderList) {
            parquetFileReader.close();
        }
    }

    private boolean validateSchemas(List<ParquetFileReader> list) {
        if (list.size() > 1) {
            MessageType firstScheme = list.get(0).getSchema();
            return list.stream().map(ParquetFileReader::getSchema).allMatch(x -> x.equals((Object)firstScheme));
        }
        return true;
    }
}

