/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.sql.copy.parquet;

import java.util.UUID;
import org.apache.parquet.io.api.Binary;

public class ParquetUuidUtils {
    public static Binary fromUuid(UUID uuid) {
        byte[] data = new byte[16];
        ParquetUuidUtils.writeLong(data, 0, uuid.getMostSignificantBits());
        ParquetUuidUtils.writeLong(data, 8, uuid.getLeastSignificantBits());
        return Binary.fromConstantByteArray((byte[])data);
    }

    private static void writeLong(byte[] array, int offset, long value) {
        for (int i = 0; i < 8; ++i) {
            array[i + offset] = (byte)(value >>> (8 - i - 1) * 8);
        }
    }

    public static UUID fromBinaryToUuid(Binary binary) {
        byte[] data = binary.getBytes();
        long mostSigBits = ParquetUuidUtils.readLong(data, 0);
        long leastSigBits = ParquetUuidUtils.readLong(data, 8);
        return new UUID(mostSigBits, leastSigBits);
    }

    private static long readLong(byte[] array, int offset) {
        long value = 0L;
        for (int i = 0; i < 8; ++i) {
            value |= (long)(array[i + offset] & 0xFF) << (8 - i - 1) * 8;
        }
        return value;
    }
}

