/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.sql.copy.parquet.s3;

import java.io.IOException;
import org.apache.parquet.io.OutputFile;
import org.apache.parquet.io.PositionOutputStream;
import org.gridgain.internal.sql.copy.parquet.s3.BaseS3File;
import org.gridgain.internal.sql.copy.s3.S3OutputStream;
import org.gridgain.internal.sql.copy.s3.S3Uri;
import software.amazon.awssdk.services.s3.S3Client;

public class S3OutputFile
extends BaseS3File
implements OutputFile {
    public static S3OutputFile fromLocation(String location, S3Client client) {
        return new S3OutputFile(client, new S3Uri(location));
    }

    S3OutputFile(S3Client client, S3Uri uri) {
        super(client, uri);
    }

    public PositionOutputStream create(long l) throws IOException {
        return this.createOrOverwrite(l);
    }

    public PositionOutputStream createOrOverwrite(long l) throws IOException {
        try {
            return new S3OutputStream(this.client(), this.uri());
        }
        catch (IOException e) {
            throw new IOException("Failed to create output stream for location: " + this.uri(), e);
        }
    }

    public boolean supportsBlockSize() {
        return true;
    }

    public long defaultBlockSize() {
        return 512L;
    }
}

