/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.snapshots.filesystem;

import java.io.IOException;
import java.net.URI;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import org.gridgain.internal.snapshots.filesystem.FsyncWritableByteChannel;
import org.gridgain.internal.snapshots.filesystem.SnapshotMetaPath;

public class LocalSnapshotMetaPath
implements SnapshotMetaPath {
    private final Path path;

    public LocalSnapshotMetaPath(Path path) {
        this.path = path;
    }

    @Override
    public ReadableByteChannel readChannel() throws IOException {
        return FileChannel.open(this.path, StandardOpenOption.READ);
    }

    @Override
    public WritableByteChannel writeChannel() throws IOException {
        Files.createDirectories(this.path.getParent(), new FileAttribute[0]);
        FileChannel channel = FileChannel.open(this.path, StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW);
        return new FsyncWritableByteChannel(this.path, channel);
    }

    @Override
    public URI uri() {
        return this.path.toUri();
    }
}

