/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.snapshots.communication.messages;

import java.util.Objects;
import java.util.Set;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;
import org.gridgain.internal.snapshots.communication.messages.CreateSnapshotMessage;
import org.gridgain.internal.snapshots.communication.messages.CreateSnapshotMessageBuilder;
import org.gridgain.internal.snapshots.communication.messages.CreateSnapshotMessageSerializer;

public class CreateSnapshotMessageImpl
implements CreateSnapshotMessage,
Cloneable {
    public static final short GROUP_TYPE = 1000;
    public static final short TYPE = 1;
    @IgniteToStringInclude
    private final String destination;
    @IgniteToStringInclude
    private final String encryptionProviderName;
    @IgniteToStringInclude
    private final int snapshotTypeOrdinal;
    @IgniteToStringInclude
    private final Set<String> tableNames;
    @IgniteToStringInclude
    private final long timestampLong;
    @IgniteToStringInclude
    private final Set<String> structureNames;

    private CreateSnapshotMessageImpl(String destination, String encryptionProviderName, int snapshotTypeOrdinal, Set<String> tableNames, long timestampLong, Set<String> structureNames) {
        this.destination = destination;
        this.encryptionProviderName = encryptionProviderName;
        this.snapshotTypeOrdinal = snapshotTypeOrdinal;
        this.tableNames = tableNames;
        this.timestampLong = timestampLong;
        this.structureNames = structureNames;
    }

    @Override
    public String destination() {
        return this.destination;
    }

    @Override
    public String encryptionProviderName() {
        return this.encryptionProviderName;
    }

    @Override
    public int snapshotTypeOrdinal() {
        return this.snapshotTypeOrdinal;
    }

    @Override
    public Set<String> tableNames() {
        return this.tableNames;
    }

    @Override
    public long timestampLong() {
        return this.timestampLong;
    }

    @Override
    public Set<String> structureNames() {
        return this.structureNames;
    }

    public MessageSerializer serializer() {
        return CreateSnapshotMessageSerializer.INSTANCE;
    }

    public short groupType() {
        return 1000;
    }

    public String toString() {
        return S.toString(CreateSnapshotMessageImpl.class, (Object)this);
    }

    public short messageType() {
        return 1;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        CreateSnapshotMessageImpl otherMessage = (CreateSnapshotMessageImpl)other;
        return Objects.equals(this.destination, otherMessage.destination) && Objects.equals(this.encryptionProviderName, otherMessage.encryptionProviderName) && Objects.equals(this.tableNames, otherMessage.tableNames) && Objects.equals(this.structureNames, otherMessage.structureNames) && this.snapshotTypeOrdinal == otherMessage.snapshotTypeOrdinal && this.timestampLong == otherMessage.timestampLong;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.snapshotTypeOrdinal, this.timestampLong, this.destination, this.encryptionProviderName, this.tableNames, this.structureNames);
        return result;
    }

    public CreateSnapshotMessageImpl clone() {
        try {
            return (CreateSnapshotMessageImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static CreateSnapshotMessageBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements CreateSnapshotMessageBuilder {
        private String destination;
        private String encryptionProviderName;
        private int snapshotTypeOrdinal;
        private Set<String> tableNames;
        private long timestampLong;
        private Set<String> structureNames;

        private Builder() {
        }

        @Override
        public CreateSnapshotMessageBuilder destination(String destination) {
            this.destination = destination;
            return this;
        }

        @Override
        public CreateSnapshotMessageBuilder encryptionProviderName(String encryptionProviderName) {
            this.encryptionProviderName = encryptionProviderName;
            return this;
        }

        @Override
        public CreateSnapshotMessageBuilder snapshotTypeOrdinal(int snapshotTypeOrdinal) {
            this.snapshotTypeOrdinal = snapshotTypeOrdinal;
            return this;
        }

        @Override
        public CreateSnapshotMessageBuilder tableNames(Set<String> tableNames) {
            Objects.requireNonNull(tableNames, "tableNames is not marked @Nullable");
            this.tableNames = tableNames;
            return this;
        }

        @Override
        public CreateSnapshotMessageBuilder timestampLong(long timestampLong) {
            this.timestampLong = timestampLong;
            return this;
        }

        @Override
        public CreateSnapshotMessageBuilder structureNames(Set<String> structureNames) {
            Objects.requireNonNull(structureNames, "structureNames is not marked @Nullable");
            this.structureNames = structureNames;
            return this;
        }

        @Override
        public String destination() {
            return this.destination;
        }

        @Override
        public String encryptionProviderName() {
            return this.encryptionProviderName;
        }

        @Override
        public int snapshotTypeOrdinal() {
            return this.snapshotTypeOrdinal;
        }

        @Override
        public Set<String> tableNames() {
            return this.tableNames;
        }

        @Override
        public long timestampLong() {
            return this.timestampLong;
        }

        @Override
        public Set<String> structureNames() {
            return this.structureNames;
        }

        @Override
        public CreateSnapshotMessage build() {
            return new CreateSnapshotMessageImpl(this.destination, this.encryptionProviderName, this.snapshotTypeOrdinal, Objects.requireNonNull(this.tableNames, "tableNames is not marked @Nullable"), this.timestampLong, Objects.requireNonNull(this.structureNames, "structureNames is not marked @Nullable"));
        }

        @Override
        public CreateSnapshotMessage buildDeserialized() {
            return new CreateSnapshotMessageImpl(this.destination, this.encryptionProviderName, this.snapshotTypeOrdinal, this.tableNames, this.timestampLong, this.structureNames);
        }
    }
}

