/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.snapshots.catalog;

import java.util.ArrayList;
import java.util.List;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.CatalogManager;
import org.apache.ignite.internal.catalog.UpdateContext;
import org.apache.ignite.internal.catalog.UpdateProducer;
import org.apache.ignite.internal.catalog.storage.UpdateEntry;

public class CommandState {
    private Catalog catalog;
    private final List<UpdateEntry> updateEntries = new ArrayList<UpdateEntry>();

    CommandState(Catalog catalog) {
        this.catalog = catalog;
    }

    public void applyCommand(UpdateProducer command) {
        this.applyCommand(command.get(new UpdateContext(this.catalog)));
    }

    public void applyCommand(List<UpdateEntry> commandEntries) {
        for (UpdateEntry entry : commandEntries) {
            this.catalog = entry.applyUpdate(this.catalog, CatalogManager.INITIAL_TIMESTAMP);
        }
        this.updateEntries.addAll(commandEntries);
    }

    public void applyCommand(UpdateEntry entry) {
        this.catalog = entry.applyUpdate(this.catalog, CatalogManager.INITIAL_TIMESTAMP);
        this.updateEntries.add(entry);
    }

    Catalog catalog() {
        return this.catalog;
    }

    List<UpdateEntry> updateEntries() {
        return this.updateEntries;
    }
}

