/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.snapshots;

import java.time.Instant;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.rest.api.snapshot.SnapshotListItem;
import org.apache.ignite.internal.rest.api.snapshot.SnapshotOperation;
import org.apache.ignite.internal.rest.api.snapshot.SnapshotType;
import org.apache.ignite.internal.wrapper.Wrapper;
import org.gridgain.internal.license.LicenseFeature;
import org.gridgain.internal.license.LicenseFeatureChecker;
import org.gridgain.internal.rbac.authorization.Authorizer;
import org.gridgain.internal.rbac.privileges.Action;
import org.gridgain.internal.snapshots.SnapshotFacade;
import org.jetbrains.annotations.Nullable;

public class SecuredSnapshotFacade
implements SnapshotFacade,
Wrapper {
    private final SnapshotFacade snapshotFacade;
    private final LicenseFeatureChecker licenseFeatureChecker;
    private final Authorizer authorizer;

    public SecuredSnapshotFacade(SnapshotFacade snapshotFacade, LicenseFeatureChecker licenseFeatureChecker, Authorizer authorizer) {
        this.snapshotFacade = snapshotFacade;
        this.licenseFeatureChecker = licenseFeatureChecker;
        this.authorizer = authorizer;
    }

    @Override
    public CompletableFuture<UUID> createSnapshot(SnapshotType snapshotType, Set<String> tableNames, Set<String> structureNames, @Nullable String destination, @Nullable Instant timestamp, @Nullable String encryptionProvider) {
        this.checkLicenseAllowsSnapshots();
        return this.authorizer.authorizeThenCompose(Action.CREATE_SNAPSHOT, () -> this.snapshotFacade.createSnapshot(snapshotType, tableNames, structureNames, destination, timestamp, encryptionProvider));
    }

    @Override
    public CompletableFuture<UUID> restoreSnapshot(UUID targetSnapshotId, Set<String> tableNames, Set<String> structureNames, @Nullable String source, @Nullable String decryptionProvider, boolean force) {
        this.checkLicenseAllowsSnapshots();
        return this.authorizer.authorizeThenCompose(Action.RESTORE_SNAPSHOT, () -> this.snapshotFacade.restoreSnapshot(targetSnapshotId, tableNames, structureNames, source, decryptionProvider, force));
    }

    @Override
    public CompletableFuture<UUID> deleteSnapshot(UUID targetSnapshotId) {
        this.checkLicenseAllowsSnapshots();
        return this.authorizer.authorizeThenCompose(Action.DELETE_SNAPSHOT, () -> this.snapshotFacade.deleteSnapshot(targetSnapshotId));
    }

    @Override
    public CompletableFuture<List<SnapshotOperation>> getSnapshotOperationsList() {
        this.checkLicenseAllowsSnapshots();
        return this.authorizer.authorizeThenCompose(Action.CHECK_SNAPSHOT, this.snapshotFacade::getSnapshotOperationsList);
    }

    @Override
    public CompletableFuture<List<SnapshotOperation>> getOperationById(UUID operationId, boolean allNodes) {
        this.checkLicenseAllowsSnapshots();
        return this.authorizer.authorizeThenCompose(Action.CHECK_SNAPSHOT, () -> this.snapshotFacade.getOperationById(operationId, allNodes));
    }

    @Override
    public CompletableFuture<List<SnapshotListItem>> getSnapshotsList(@Nullable String source, boolean showNodeNames, boolean showTableNames, boolean showSourceUri) {
        this.checkLicenseAllowsSnapshots();
        return this.authorizer.authorizeThenCompose(Action.CHECK_SNAPSHOT, () -> this.snapshotFacade.getSnapshotsList(source, showNodeNames, showTableNames, showSourceUri));
    }

    public <T> T unwrap(Class<T> classToUnwrap) {
        return classToUnwrap.cast(this.snapshotFacade);
    }

    private void checkLicenseAllowsSnapshots() {
        this.licenseFeatureChecker.checkFeature(LicenseFeature.SNAPSHOTS);
    }
}

