/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.snapshots.communication.messages;

import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Objects;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.marshal.MarshalledObject;
import org.apache.ignite.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;
import org.gridgain.internal.snapshots.communication.messages.ErrorResponseMessage;
import org.gridgain.internal.snapshots.communication.messages.ErrorResponseMessageBuilder;
import org.gridgain.internal.snapshots.communication.messages.ErrorResponseMessageSerializer;

public class ErrorResponseMessageImpl
implements ErrorResponseMessage,
Cloneable {
    public static final short GROUP_TYPE = 1000;
    public static final short TYPE = 3;
    @IgniteToStringInclude
    private Throwable error;
    private byte[] errorByteArray;

    private ErrorResponseMessageImpl(Throwable error, byte[] errorByteArray) {
        if (error == null && errorByteArray == null) {
            throw new NullPointerException("error is not marked @Nullable");
        }
        this.error = error;
        this.errorByteArray = errorByteArray;
    }

    byte[] errorByteArray() {
        return this.errorByteArray;
    }

    @Override
    public Throwable error() {
        return this.error;
    }

    public MessageSerializer serializer() {
        return ErrorResponseMessageSerializer.INSTANCE;
    }

    public short groupType() {
        return 1000;
    }

    public String toString() {
        return S.toString(ErrorResponseMessageImpl.class, (Object)this);
    }

    public short messageType() {
        return 3;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ErrorResponseMessageImpl otherMessage = (ErrorResponseMessageImpl)other;
        return Objects.equals(this.error, otherMessage.error);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.error);
        return result;
    }

    public ErrorResponseMessageImpl clone() {
        try {
            return (ErrorResponseMessageImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static ErrorResponseMessageBuilder builder() {
        return new Builder();
    }

    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        MarshalledObject errorByteArraymo = marshaller.marshal((Object)this.error);
        usedDescriptors.addAll((IntCollection)errorByteArraymo.usedDescriptorIds());
        this.errorByteArray = errorByteArraymo.bytes();
    }

    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        this.error = (Throwable)marshaller.unmarshal(this.errorByteArray, descriptorsObj);
        this.errorByteArray = null;
    }

    private static class Builder
    implements ErrorResponseMessageBuilder {
        private Throwable error;
        private byte[] errorByteArray;

        private Builder() {
        }

        @Override
        public ErrorResponseMessageBuilder error(Throwable error) {
            Objects.requireNonNull(error, "error is not marked @Nullable");
            this.error = error;
            return this;
        }

        @Override
        public ErrorResponseMessageBuilder errorByteArray(byte[] errorByteArray) {
            this.errorByteArray = errorByteArray;
            return this;
        }

        @Override
        public Throwable error() {
            return this.error;
        }

        @Override
        public byte[] errorByteArray() {
            return this.errorByteArray;
        }

        @Override
        public ErrorResponseMessage build() {
            return new ErrorResponseMessageImpl(this.error, this.errorByteArray);
        }

        @Override
        public ErrorResponseMessage buildDeserialized() {
            return new ErrorResponseMessageImpl(this.error, this.errorByteArray);
        }
    }
}

