/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.snapshots;

import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Flow;
import java.util.concurrent.SubmissionPublisher;
import org.apache.ignite.internal.storage.BinaryRowAndRowId;
import org.gridgain.internal.recovery.TableDataProvider;
import org.gridgain.internal.snapshots.PartitionSnapshotFileReader;
import org.gridgain.internal.snapshots.SnapshotException;
import org.gridgain.internal.snapshots.filesystem.SnapshotFileSystem;
import org.gridgain.internal.snapshots.filesystem.SnapshotPath;
import org.gridgain.internal.snapshots.meta.TableSnapshotMeta;

public class TableSnapshotReader
implements TableDataProvider {
    private final TableSnapshotMeta tableSnapshotMeta;
    private final SnapshotFileSystem snapshotFileSystem;
    private final int version;
    private final UUID operationId;
    private final int tableId;
    private final String tableName;
    private final int chunkSize;

    public TableSnapshotReader(TableSnapshotMeta tableSnapshotMeta, SnapshotFileSystem snapshotFileSystem, int version, UUID operationId, int tableId, String tableName, int chunkSize) {
        this.tableSnapshotMeta = tableSnapshotMeta;
        this.snapshotFileSystem = snapshotFileSystem;
        this.version = version;
        this.tableId = tableId;
        this.tableName = tableName;
        this.operationId = operationId;
        this.chunkSize = chunkSize;
    }

    public Flow.Publisher<BinaryRowAndRowId> partitionDataAsync(int partition, ExecutorService executorService) {
        SubmissionPublisher publisher = new SubmissionPublisher(executorService, Integer.MAX_VALUE);
        return subscriber -> {
            publisher.subscribe(subscriber);
            assert (publisher.hasSubscribers());
            this.submitRows(partition, publisher, executorService);
        };
    }

    private void submitRows(int partition, SubmissionPublisher<BinaryRowAndRowId> publisher, ExecutorService executorService) {
        SnapshotPath partitionFile = this.snapshotFileSystem.partitionFile(this.tableId, partition);
        ((CompletableFuture)partitionFile.readChannel().thenAcceptAsync(readChannel -> {
            int rowLength = this.tableSnapshotMeta.schema().tableDescriptor().columns().size();
            try (PartitionSnapshotFileReader reader = new PartitionSnapshotFileReader(partitionFile.uri(), (ReadableByteChannel)readChannel, this.version, partition, rowLength, this.chunkSize);){
                for (BinaryRowAndRowId row : reader) {
                    publisher.submit(row);
                }
            }
            catch (IOException e) {
                throw new SnapshotException("Can't close the PartitionSnapshotFileReader", e);
            }
        }, (Executor)executorService)).whenComplete((unused, throwable) -> {
            if (throwable == null) {
                publisher.close();
            } else {
                publisher.closeExceptionally((Throwable)((Object)new SnapshotException(String.format("Error restoring partition [operationId=%s, tableId=%d, tableName=%s, partitionId=%d]: %s", this.operationId, this.tableId, this.tableName, partition, throwable), (Throwable)throwable)));
            }
        });
    }
}

