/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.snapshots.filesystem;

import java.io.IOException;
import java.net.URI;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.gridgain.internal.snapshots.buffer.BufferedChannel;
import org.gridgain.internal.snapshots.buffer.ByteBufferPool;
import org.gridgain.internal.snapshots.buffer.ByteBufferPoolProvider;
import org.gridgain.internal.snapshots.buffer.DisposableByteBuffer;
import org.gridgain.internal.snapshots.filesystem.FsyncWritableByteChannel;
import org.gridgain.internal.snapshots.filesystem.SnapshotPath;

public class LocalSnapshotPath
implements SnapshotPath {
    private final Path path;
    private final ByteBufferPool bufferPool;

    LocalSnapshotPath(Path path, ByteBufferPoolProvider bufferPoolProvider) {
        this.path = path;
        this.bufferPool = bufferPoolProvider.flushToDiskPool();
    }

    @Override
    public CompletableFuture<ReadableByteChannel> readChannel() {
        try {
            return CompletableFuture.completedFuture(FileChannel.open(this.path, StandardOpenOption.READ));
        }
        catch (IOException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    @Override
    public CompletableFuture<WritableByteChannel> writeChannel() {
        return this.bufferPool.allocate(ByteOrder.BIG_ENDIAN).thenApply(buffer -> {
            try {
                Files.createDirectories(this.path.getParent(), new FileAttribute[0]);
                FileChannel channel = FileChannel.open(this.path, StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW);
                return new BufferedChannel(new FsyncWritableByteChannel(this.path, channel), (DisposableByteBuffer)buffer);
            }
            catch (IOException e) {
                throw new CompletionException(e);
            }
        });
    }

    @Override
    public URI uri() {
        return this.path.toUri();
    }
}

