/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.snapshots.communication.metastorage;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import org.apache.ignite.internal.lang.ByteArray;
import org.apache.ignite.internal.replicator.TablePartitionId;
import org.apache.ignite.internal.util.ByteUtils;

public class MetaStorageKeys {
    private static final ByteOrder BYTE_UTILS_BYTE_ORDER = ByteOrder.BIG_ENDIAN;
    private static final byte[] SNAPSHOT_COORDINATOR_TERM_PREFIX = "gridgain.snapshot.coordinator.".getBytes(StandardCharsets.UTF_8);
    private static final ByteArray CREATE_SNAPSHOT_GLOBAL_PREFIX = new ByteArray("gridgain.snapshot.create.global.");
    private static final byte[] CREATE_SNAPSHOT_LOCAL_PREFIX = "gridgain.snapshot.create.local.".getBytes(StandardCharsets.UTF_8);
    private static final ByteArray RESTORE_SNAPSHOT_GLOBAL_PREFIX = new ByteArray("gridgain.snapshot.restore.global.");
    private static final byte[] RESTORE_SNAPSHOT_LOCAL_PREFIX = "gridgain.snapshot.restore.local.".getBytes(StandardCharsets.UTF_8);
    private static final ByteArray RESTORE_SNAPSHOT_LOCK_KEY = new ByteArray("gridgain.snapshot.restore.lock");
    private static final ByteArray DELETE_SNAPSHOT_GLOBAL_PREFIX = new ByteArray("gridgain.snapshot.delete.global.");
    private static final byte[] DELETE_SNAPSHOT_LOCAL_PREFIX = "gridgain.snapshot.delete.local.".getBytes(StandardCharsets.UTF_8);
    private static final byte[] DELETE_SNAPSHOT_LOCK_PREFIX = "gridgain.snapshot.delete.lock.".getBytes(StandardCharsets.UTF_8);
    private static final byte[] PARTITION_PREFIX = "gridgain.snapshot.partition.".getBytes(StandardCharsets.UTF_8);
    private static final int OPERATION_ID_LENGTH_IN_BYTES = 16;
    private static final int TABLE_ID_LENGTH_IN_BYTES = 4;
    private static final int PARTITION_ID_LENGTH_IN_BYTES = 4;
    private static final int PARTITION_KEY_SIZE = PARTITION_PREFIX.length + 16 + 2 + 4 + 2 + 4;
    private static final int PARTITION_PREFIX_LENGTH_IN_BYTES = PARTITION_PREFIX.length + 16 + 2;

    public static ByteArray createSnapshotGlobalStatePrefix() {
        return CREATE_SNAPSHOT_GLOBAL_PREFIX;
    }

    public static ByteArray restoreSnapshotGlobalStatePrefix() {
        return RESTORE_SNAPSHOT_GLOBAL_PREFIX;
    }

    public static ByteArray deleteSnapshotGlobalStatePrefix() {
        return DELETE_SNAPSHOT_GLOBAL_PREFIX;
    }

    public static ByteArray createSnapshotGlobalStateKey(UUID snapshotId) {
        return MetaStorageKeys.buildKey(CREATE_SNAPSHOT_GLOBAL_PREFIX.bytes(), snapshotId);
    }

    public static ByteArray restoreSnapshotGlobalStateKey(UUID operationId) {
        return MetaStorageKeys.buildKey(RESTORE_SNAPSHOT_GLOBAL_PREFIX.bytes(), operationId);
    }

    public static ByteArray deleteSnapshotGlobalStateKey(UUID operationId) {
        return MetaStorageKeys.buildKey(DELETE_SNAPSHOT_GLOBAL_PREFIX.bytes(), operationId);
    }

    public static ByteArray coordinatorTermKey(UUID operationId) {
        return MetaStorageKeys.buildKey(SNAPSHOT_COORDINATOR_TERM_PREFIX, operationId);
    }

    public static ByteArray createSnapshotLocalStatePrefix(UUID snapshotId) {
        return MetaStorageKeys.buildKey(CREATE_SNAPSHOT_LOCAL_PREFIX, snapshotId);
    }

    public static ByteArray restoreSnapshotLocalStatePrefix(UUID operationId) {
        return MetaStorageKeys.buildKey(RESTORE_SNAPSHOT_LOCAL_PREFIX, operationId);
    }

    public static ByteArray deleteSnapshotLocalStatePrefix(UUID operationId) {
        return MetaStorageKeys.buildKey(DELETE_SNAPSHOT_LOCAL_PREFIX, operationId);
    }

    public static ByteArray createSnapshotLocalStateKey(UUID snapshotId, String nodeName) {
        return MetaStorageKeys.buildKey(CREATE_SNAPSHOT_LOCAL_PREFIX, snapshotId, nodeName);
    }

    public static ByteArray restoreSnapshotLocalStateKey(UUID operationId, String nodeName) {
        return MetaStorageKeys.buildKey(RESTORE_SNAPSHOT_LOCAL_PREFIX, operationId, nodeName);
    }

    public static ByteArray deleteSnapshotLocalStateKey(UUID operationId, String nodeName) {
        return MetaStorageKeys.buildKey(DELETE_SNAPSHOT_LOCAL_PREFIX, operationId, nodeName);
    }

    private static ByteArray buildKey(byte[] prefix, UUID id) {
        byte[] key = ByteBuffer.allocate(prefix.length + 16).order(BYTE_UTILS_BYTE_ORDER).put(prefix).put(ByteUtils.uuidToBytes((UUID)id)).array();
        return new ByteArray(key);
    }

    private static ByteArray buildKey(byte[] prefix, UUID id, String nodeName) {
        byte[] nodeNameBytes = nodeName.getBytes(StandardCharsets.UTF_8);
        int keyLength = prefix.length + 16 + 1 + nodeNameBytes.length;
        byte[] key = ByteBuffer.allocate(keyLength).order(BYTE_UTILS_BYTE_ORDER).put(prefix).put(ByteUtils.uuidToBytes((UUID)id)).put((byte)46).put(nodeNameBytes).array();
        return new ByteArray(key);
    }

    public static String nodeNameFromCreateLocalStateKey(byte[] localStateKey) {
        return MetaStorageKeys.nodeNameFromKey(CREATE_SNAPSHOT_LOCAL_PREFIX, localStateKey);
    }

    public static String nodeNameFromRestoreLocalStateKey(byte[] localStateKey) {
        return MetaStorageKeys.nodeNameFromKey(RESTORE_SNAPSHOT_LOCAL_PREFIX, localStateKey);
    }

    public static String nodeNameFromDeleteLocalStateKey(byte[] localStateKey) {
        return MetaStorageKeys.nodeNameFromKey(DELETE_SNAPSHOT_LOCAL_PREFIX, localStateKey);
    }

    private static String nodeNameFromKey(byte[] prefix, byte[] key) {
        int offset = prefix.length + 1 + 16;
        return new String(key, offset, key.length - offset, StandardCharsets.UTF_8);
    }

    public static ByteArray restoreSnapshotLockKey() {
        return RESTORE_SNAPSHOT_LOCK_KEY;
    }

    public static ByteArray deleteSnapshotLockKey(UUID snapshotId) {
        return MetaStorageKeys.buildKey(DELETE_SNAPSHOT_LOCK_PREFIX, snapshotId);
    }

    public static ByteArray partitionKey(UUID snapshotId, TablePartitionId partition) {
        byte[] key = ByteBuffer.allocate(PARTITION_KEY_SIZE).order(BYTE_UTILS_BYTE_ORDER).put(PARTITION_PREFIX).put(ByteUtils.uuidToBytes((UUID)snapshotId)).putChar('.').putInt(partition.tableId()).putChar('.').putInt(partition.partitionId()).array();
        return new ByteArray(key);
    }

    public static ByteArray snapshotPartitionPrefix(UUID snapshotId) {
        byte[] prefix = ByteBuffer.allocate(PARTITION_PREFIX_LENGTH_IN_BYTES).order(BYTE_UTILS_BYTE_ORDER).put(PARTITION_PREFIX).put(ByteUtils.uuidToBytes((UUID)snapshotId)).putChar('.').array();
        return new ByteArray(prefix);
    }
}

